"use strict";

var helpers = require("../../helpers/helpers");

exports["America/Cuiaba"] = {

	"guess:by:offset" : helpers.makeTestGuess("America/Cuiaba", { offset: true, expect: "America/Campo_Grande" }),

	"guess:by:abbr" : helpers.makeTestGuess("America/Cuiaba", { abbr: true, expect: "America/Campo_Grande" }),

	"1931" : helpers.makeTestYear("America/Cuiaba", [
		["1931-10-03T14:59:59+00:00", "10:59:59", "-04", 240],
		["1931-10-03T15:00:00+00:00", "12:00:00", "-03", 180]
	]),

	"1932" : helpers.makeTestYear("America/Cuiaba", [
		["1932-04-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1932-04-01T03:00:00+00:00", "23:00:00", "-04", 240],
		["1932-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["1932-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1933" : helpers.makeTestYear("America/Cuiaba", [
		["1933-04-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1933-04-01T03:00:00+00:00", "23:00:00", "-04", 240]
	]),

	"1949" : helpers.makeTestYear("America/Cuiaba", [
		["1949-12-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1949-12-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1950" : helpers.makeTestYear("America/Cuiaba", [
		["1950-04-16T03:59:59+00:00", "00:59:59", "-03", 180],
		["1950-04-16T04:00:00+00:00", "00:00:00", "-04", 240],
		["1950-12-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1950-12-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1951" : helpers.makeTestYear("America/Cuiaba", [
		["1951-04-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1951-04-01T03:00:00+00:00", "23:00:00", "-04", 240],
		["1951-12-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1951-12-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1952" : helpers.makeTestYear("America/Cuiaba", [
		["1952-04-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1952-04-01T03:00:00+00:00", "23:00:00", "-04", 240],
		["1952-12-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1952-12-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1953" : helpers.makeTestYear("America/Cuiaba", [
		["1953-03-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1953-03-01T03:00:00+00:00", "23:00:00", "-04", 240]
	]),

	"1963" : helpers.makeTestYear("America/Cuiaba", [
		["1963-12-09T03:59:59+00:00", "23:59:59", "-04", 240],
		["1963-12-09T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1964" : helpers.makeTestYear("America/Cuiaba", [
		["1964-03-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1964-03-01T03:00:00+00:00", "23:00:00", "-04", 240]
	]),

	"1965" : helpers.makeTestYear("America/Cuiaba", [
		["1965-01-31T03:59:59+00:00", "23:59:59", "-04", 240],
		["1965-01-31T04:00:00+00:00", "01:00:00", "-03", 180],
		["1965-03-31T02:59:59+00:00", "23:59:59", "-03", 180],
		["1965-03-31T03:00:00+00:00", "23:00:00", "-04", 240],
		["1965-12-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1965-12-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1966" : helpers.makeTestYear("America/Cuiaba", [
		["1966-03-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1966-03-01T03:00:00+00:00", "23:00:00", "-04", 240],
		["1966-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1966-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1967" : helpers.makeTestYear("America/Cuiaba", [
		["1967-03-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1967-03-01T03:00:00+00:00", "23:00:00", "-04", 240],
		["1967-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["1967-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1968" : helpers.makeTestYear("America/Cuiaba", [
		["1968-03-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1968-03-01T03:00:00+00:00", "23:00:00", "-04", 240]
	]),

	"1985" : helpers.makeTestYear("America/Cuiaba", [
		["1985-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["1985-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1986" : helpers.makeTestYear("America/Cuiaba", [
		["1986-03-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["1986-03-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["1986-10-25T03:59:59+00:00", "23:59:59", "-04", 240],
		["1986-10-25T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1987" : helpers.makeTestYear("America/Cuiaba", [
		["1987-02-14T02:59:59+00:00", "23:59:59", "-03", 180],
		["1987-02-14T03:00:00+00:00", "23:00:00", "-04", 240],
		["1987-10-25T03:59:59+00:00", "23:59:59", "-04", 240],
		["1987-10-25T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1988" : helpers.makeTestYear("America/Cuiaba", [
		["1988-02-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["1988-02-07T03:00:00+00:00", "23:00:00", "-04", 240],
		["1988-10-16T03:59:59+00:00", "23:59:59", "-04", 240],
		["1988-10-16T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1989" : helpers.makeTestYear("America/Cuiaba", [
		["1989-01-29T02:59:59+00:00", "23:59:59", "-03", 180],
		["1989-01-29T03:00:00+00:00", "23:00:00", "-04", 240],
		["1989-10-15T03:59:59+00:00", "23:59:59", "-04", 240],
		["1989-10-15T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1990" : helpers.makeTestYear("America/Cuiaba", [
		["1990-02-11T02:59:59+00:00", "23:59:59", "-03", 180],
		["1990-02-11T03:00:00+00:00", "23:00:00", "-04", 240],
		["1990-10-21T03:59:59+00:00", "23:59:59", "-04", 240],
		["1990-10-21T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1991" : helpers.makeTestYear("America/Cuiaba", [
		["1991-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["1991-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["1991-10-20T03:59:59+00:00", "23:59:59", "-04", 240],
		["1991-10-20T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1992" : helpers.makeTestYear("America/Cuiaba", [
		["1992-02-09T02:59:59+00:00", "23:59:59", "-03", 180],
		["1992-02-09T03:00:00+00:00", "23:00:00", "-04", 240],
		["1992-10-25T03:59:59+00:00", "23:59:59", "-04", 240],
		["1992-10-25T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1993" : helpers.makeTestYear("America/Cuiaba", [
		["1993-01-31T02:59:59+00:00", "23:59:59", "-03", 180],
		["1993-01-31T03:00:00+00:00", "23:00:00", "-04", 240],
		["1993-10-17T03:59:59+00:00", "23:59:59", "-04", 240],
		["1993-10-17T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1994" : helpers.makeTestYear("America/Cuiaba", [
		["1994-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["1994-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["1994-10-16T03:59:59+00:00", "23:59:59", "-04", 240],
		["1994-10-16T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1995" : helpers.makeTestYear("America/Cuiaba", [
		["1995-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["1995-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["1995-10-15T03:59:59+00:00", "23:59:59", "-04", 240],
		["1995-10-15T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1996" : helpers.makeTestYear("America/Cuiaba", [
		["1996-02-11T02:59:59+00:00", "23:59:59", "-03", 180],
		["1996-02-11T03:00:00+00:00", "23:00:00", "-04", 240],
		["1996-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["1996-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1997" : helpers.makeTestYear("America/Cuiaba", [
		["1997-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["1997-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["1997-10-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["1997-10-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1998" : helpers.makeTestYear("America/Cuiaba", [
		["1998-03-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1998-03-01T03:00:00+00:00", "23:00:00", "-04", 240],
		["1998-10-11T03:59:59+00:00", "23:59:59", "-04", 240],
		["1998-10-11T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"1999" : helpers.makeTestYear("America/Cuiaba", [
		["1999-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["1999-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["1999-10-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["1999-10-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2000" : helpers.makeTestYear("America/Cuiaba", [
		["2000-02-27T02:59:59+00:00", "23:59:59", "-03", 180],
		["2000-02-27T03:00:00+00:00", "23:00:00", "-04", 240],
		["2000-10-08T03:59:59+00:00", "23:59:59", "-04", 240],
		["2000-10-08T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2001" : helpers.makeTestYear("America/Cuiaba", [
		["2001-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2001-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2001-10-14T03:59:59+00:00", "23:59:59", "-04", 240],
		["2001-10-14T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2002" : helpers.makeTestYear("America/Cuiaba", [
		["2002-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2002-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2002-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2002-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2003" : helpers.makeTestYear("America/Cuiaba", [
		["2003-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2003-02-16T03:00:00+00:00", "23:00:00", "-04", 240]
	]),

	"2004" : helpers.makeTestYear("America/Cuiaba", [
		["2004-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2004-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2005" : helpers.makeTestYear("America/Cuiaba", [
		["2005-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2005-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2005-10-16T03:59:59+00:00", "23:59:59", "-04", 240],
		["2005-10-16T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2006" : helpers.makeTestYear("America/Cuiaba", [
		["2006-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2006-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2006-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2006-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2007" : helpers.makeTestYear("America/Cuiaba", [
		["2007-02-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["2007-02-25T03:00:00+00:00", "23:00:00", "-04", 240],
		["2007-10-14T03:59:59+00:00", "23:59:59", "-04", 240],
		["2007-10-14T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2008" : helpers.makeTestYear("America/Cuiaba", [
		["2008-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2008-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2008-10-19T03:59:59+00:00", "23:59:59", "-04", 240],
		["2008-10-19T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2009" : helpers.makeTestYear("America/Cuiaba", [
		["2009-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2009-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2009-10-18T03:59:59+00:00", "23:59:59", "-04", 240],
		["2009-10-18T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2010" : helpers.makeTestYear("America/Cuiaba", [
		["2010-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2010-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2010-10-17T03:59:59+00:00", "23:59:59", "-04", 240],
		["2010-10-17T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2011" : helpers.makeTestYear("America/Cuiaba", [
		["2011-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2011-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2011-10-16T03:59:59+00:00", "23:59:59", "-04", 240],
		["2011-10-16T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2012" : helpers.makeTestYear("America/Cuiaba", [
		["2012-02-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2012-02-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2012-10-21T03:59:59+00:00", "23:59:59", "-04", 240],
		["2012-10-21T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2013" : helpers.makeTestYear("America/Cuiaba", [
		["2013-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2013-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2013-10-20T03:59:59+00:00", "23:59:59", "-04", 240],
		["2013-10-20T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2014" : helpers.makeTestYear("America/Cuiaba", [
		["2014-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2014-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2014-10-19T03:59:59+00:00", "23:59:59", "-04", 240],
		["2014-10-19T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2015" : helpers.makeTestYear("America/Cuiaba", [
		["2015-02-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2015-02-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2015-10-18T03:59:59+00:00", "23:59:59", "-04", 240],
		["2015-10-18T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2016" : helpers.makeTestYear("America/Cuiaba", [
		["2016-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2016-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2016-10-16T03:59:59+00:00", "23:59:59", "-04", 240],
		["2016-10-16T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2017" : helpers.makeTestYear("America/Cuiaba", [
		["2017-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2017-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2017-10-15T03:59:59+00:00", "23:59:59", "-04", 240],
		["2017-10-15T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2018" : helpers.makeTestYear("America/Cuiaba", [
		["2018-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2018-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2018-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2018-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2019" : helpers.makeTestYear("America/Cuiaba", [
		["2019-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2019-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2019-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2019-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2020" : helpers.makeTestYear("America/Cuiaba", [
		["2020-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2020-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2020-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2020-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2021" : helpers.makeTestYear("America/Cuiaba", [
		["2021-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2021-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2021-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2021-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2022" : helpers.makeTestYear("America/Cuiaba", [
		["2022-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2022-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2022-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2022-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2023" : helpers.makeTestYear("America/Cuiaba", [
		["2023-02-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2023-02-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2023-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2023-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2024" : helpers.makeTestYear("America/Cuiaba", [
		["2024-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2024-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2024-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2024-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2025" : helpers.makeTestYear("America/Cuiaba", [
		["2025-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2025-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2025-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2025-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2026" : helpers.makeTestYear("America/Cuiaba", [
		["2026-02-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2026-02-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2026-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2026-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2027" : helpers.makeTestYear("America/Cuiaba", [
		["2027-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2027-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2027-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2027-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2028" : helpers.makeTestYear("America/Cuiaba", [
		["2028-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2028-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2028-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2028-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2029" : helpers.makeTestYear("America/Cuiaba", [
		["2029-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2029-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2029-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2029-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2030" : helpers.makeTestYear("America/Cuiaba", [
		["2030-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2030-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2030-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2030-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2031" : helpers.makeTestYear("America/Cuiaba", [
		["2031-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2031-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2031-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2031-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2032" : helpers.makeTestYear("America/Cuiaba", [
		["2032-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2032-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2032-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2032-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2033" : helpers.makeTestYear("America/Cuiaba", [
		["2033-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2033-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2033-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2033-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2034" : helpers.makeTestYear("America/Cuiaba", [
		["2034-02-26T02:59:59+00:00", "23:59:59", "-03", 180],
		["2034-02-26T03:00:00+00:00", "23:00:00", "-04", 240],
		["2034-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2034-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2035" : helpers.makeTestYear("America/Cuiaba", [
		["2035-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2035-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2035-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2035-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2036" : helpers.makeTestYear("America/Cuiaba", [
		["2036-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2036-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2036-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2036-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2037" : helpers.makeTestYear("America/Cuiaba", [
		["2037-02-22T02:59:59+00:00", "23:59:59", "-03", 180],
		["2037-02-22T03:00:00+00:00", "23:00:00", "-04", 240],
		["2037-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2037-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2038" : helpers.makeTestYear("America/Cuiaba", [
		["2038-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2038-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2038-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2038-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2039" : helpers.makeTestYear("America/Cuiaba", [
		["2039-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2039-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2039-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2039-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2040" : helpers.makeTestYear("America/Cuiaba", [
		["2040-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2040-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2040-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2040-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2041" : helpers.makeTestYear("America/Cuiaba", [
		["2041-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2041-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2041-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2041-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2042" : helpers.makeTestYear("America/Cuiaba", [
		["2042-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2042-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2042-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2042-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2043" : helpers.makeTestYear("America/Cuiaba", [
		["2043-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2043-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2043-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2043-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2044" : helpers.makeTestYear("America/Cuiaba", [
		["2044-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2044-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2044-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2044-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2045" : helpers.makeTestYear("America/Cuiaba", [
		["2045-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2045-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2045-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2045-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2046" : helpers.makeTestYear("America/Cuiaba", [
		["2046-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2046-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2046-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2046-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2047" : helpers.makeTestYear("America/Cuiaba", [
		["2047-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2047-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2047-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2047-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2048" : helpers.makeTestYear("America/Cuiaba", [
		["2048-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2048-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2048-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2048-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2049" : helpers.makeTestYear("America/Cuiaba", [
		["2049-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2049-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2049-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2049-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2050" : helpers.makeTestYear("America/Cuiaba", [
		["2050-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2050-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2050-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2050-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2051" : helpers.makeTestYear("America/Cuiaba", [
		["2051-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2051-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2051-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2051-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2052" : helpers.makeTestYear("America/Cuiaba", [
		["2052-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2052-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2052-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2052-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2053" : helpers.makeTestYear("America/Cuiaba", [
		["2053-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2053-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2053-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2053-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2054" : helpers.makeTestYear("America/Cuiaba", [
		["2054-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2054-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2054-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2054-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2055" : helpers.makeTestYear("America/Cuiaba", [
		["2055-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2055-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2055-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2055-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2056" : helpers.makeTestYear("America/Cuiaba", [
		["2056-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2056-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2056-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2056-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2057" : helpers.makeTestYear("America/Cuiaba", [
		["2057-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2057-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2057-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2057-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2058" : helpers.makeTestYear("America/Cuiaba", [
		["2058-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2058-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2058-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2058-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2059" : helpers.makeTestYear("America/Cuiaba", [
		["2059-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2059-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2059-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2059-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2060" : helpers.makeTestYear("America/Cuiaba", [
		["2060-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2060-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2060-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2060-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2061" : helpers.makeTestYear("America/Cuiaba", [
		["2061-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2061-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2061-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2061-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2062" : helpers.makeTestYear("America/Cuiaba", [
		["2062-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2062-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2062-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2062-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2063" : helpers.makeTestYear("America/Cuiaba", [
		["2063-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2063-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2063-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2063-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2064" : helpers.makeTestYear("America/Cuiaba", [
		["2064-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2064-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2064-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2064-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2065" : helpers.makeTestYear("America/Cuiaba", [
		["2065-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2065-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2065-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2065-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2066" : helpers.makeTestYear("America/Cuiaba", [
		["2066-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2066-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2066-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2066-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2067" : helpers.makeTestYear("America/Cuiaba", [
		["2067-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2067-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2067-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2067-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2068" : helpers.makeTestYear("America/Cuiaba", [
		["2068-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2068-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2068-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2068-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2069" : helpers.makeTestYear("America/Cuiaba", [
		["2069-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2069-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2069-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2069-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2070" : helpers.makeTestYear("America/Cuiaba", [
		["2070-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2070-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2070-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2070-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2071" : helpers.makeTestYear("America/Cuiaba", [
		["2071-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2071-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2071-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2071-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2072" : helpers.makeTestYear("America/Cuiaba", [
		["2072-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2072-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2072-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2072-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2073" : helpers.makeTestYear("America/Cuiaba", [
		["2073-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2073-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2073-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2073-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2074" : helpers.makeTestYear("America/Cuiaba", [
		["2074-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2074-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2074-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2074-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2075" : helpers.makeTestYear("America/Cuiaba", [
		["2075-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2075-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2075-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2075-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2076" : helpers.makeTestYear("America/Cuiaba", [
		["2076-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2076-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2076-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2076-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2077" : helpers.makeTestYear("America/Cuiaba", [
		["2077-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2077-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2077-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2077-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2078" : helpers.makeTestYear("America/Cuiaba", [
		["2078-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2078-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2078-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2078-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2079" : helpers.makeTestYear("America/Cuiaba", [
		["2079-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2079-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2079-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2079-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2080" : helpers.makeTestYear("America/Cuiaba", [
		["2080-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2080-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2080-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2080-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2081" : helpers.makeTestYear("America/Cuiaba", [
		["2081-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2081-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2081-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2081-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2082" : helpers.makeTestYear("America/Cuiaba", [
		["2082-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2082-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2082-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2082-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2083" : helpers.makeTestYear("America/Cuiaba", [
		["2083-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2083-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2083-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2083-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2084" : helpers.makeTestYear("America/Cuiaba", [
		["2084-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2084-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2084-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2084-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2085" : helpers.makeTestYear("America/Cuiaba", [
		["2085-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2085-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2085-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2085-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2086" : helpers.makeTestYear("America/Cuiaba", [
		["2086-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2086-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2086-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2086-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2087" : helpers.makeTestYear("America/Cuiaba", [
		["2087-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2087-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2087-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2087-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2088" : helpers.makeTestYear("America/Cuiaba", [
		["2088-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2088-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2088-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2088-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2089" : helpers.makeTestYear("America/Cuiaba", [
		["2089-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2089-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2089-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2089-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2090" : helpers.makeTestYear("America/Cuiaba", [
		["2090-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2090-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2090-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2090-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2091" : helpers.makeTestYear("America/Cuiaba", [
		["2091-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2091-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2091-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2091-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2092" : helpers.makeTestYear("America/Cuiaba", [
		["2092-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2092-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2092-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2092-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2093" : helpers.makeTestYear("America/Cuiaba", [
		["2093-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2093-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2093-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2093-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2094" : helpers.makeTestYear("America/Cuiaba", [
		["2094-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2094-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2094-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2094-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2095" : helpers.makeTestYear("America/Cuiaba", [
		["2095-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2095-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2095-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2095-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2096" : helpers.makeTestYear("America/Cuiaba", [
		["2096-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2096-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2096-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2096-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2097" : helpers.makeTestYear("America/Cuiaba", [
		["2097-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2097-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2097-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2097-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2098" : helpers.makeTestYear("America/Cuiaba", [
		["2098-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2098-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2098-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2098-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2099" : helpers.makeTestYear("America/Cuiaba", [
		["2099-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2099-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2099-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2099-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2100" : helpers.makeTestYear("America/Cuiaba", [
		["2100-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2100-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2100-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2100-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2101" : helpers.makeTestYear("America/Cuiaba", [
		["2101-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2101-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2101-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2101-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2102" : helpers.makeTestYear("America/Cuiaba", [
		["2102-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2102-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2102-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2102-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2103" : helpers.makeTestYear("America/Cuiaba", [
		["2103-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2103-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2103-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2103-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2104" : helpers.makeTestYear("America/Cuiaba", [
		["2104-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2104-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2104-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2104-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2105" : helpers.makeTestYear("America/Cuiaba", [
		["2105-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2105-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2105-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2105-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2106" : helpers.makeTestYear("America/Cuiaba", [
		["2106-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2106-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2106-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2106-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2107" : helpers.makeTestYear("America/Cuiaba", [
		["2107-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2107-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2107-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2107-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2108" : helpers.makeTestYear("America/Cuiaba", [
		["2108-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2108-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2108-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2108-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2109" : helpers.makeTestYear("America/Cuiaba", [
		["2109-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2109-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2109-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2109-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2110" : helpers.makeTestYear("America/Cuiaba", [
		["2110-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2110-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2110-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2110-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2111" : helpers.makeTestYear("America/Cuiaba", [
		["2111-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2111-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2111-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2111-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2112" : helpers.makeTestYear("America/Cuiaba", [
		["2112-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2112-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2112-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2112-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2113" : helpers.makeTestYear("America/Cuiaba", [
		["2113-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2113-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2113-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2113-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2114" : helpers.makeTestYear("America/Cuiaba", [
		["2114-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2114-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2114-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2114-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2115" : helpers.makeTestYear("America/Cuiaba", [
		["2115-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2115-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2115-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2115-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2116" : helpers.makeTestYear("America/Cuiaba", [
		["2116-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2116-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2116-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2116-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2117" : helpers.makeTestYear("America/Cuiaba", [
		["2117-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2117-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2117-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2117-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2118" : helpers.makeTestYear("America/Cuiaba", [
		["2118-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2118-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2118-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2118-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2119" : helpers.makeTestYear("America/Cuiaba", [
		["2119-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2119-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2119-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2119-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2120" : helpers.makeTestYear("America/Cuiaba", [
		["2120-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2120-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2120-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2120-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2121" : helpers.makeTestYear("America/Cuiaba", [
		["2121-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2121-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2121-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2121-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2122" : helpers.makeTestYear("America/Cuiaba", [
		["2122-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2122-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2122-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2122-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2123" : helpers.makeTestYear("America/Cuiaba", [
		["2123-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2123-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2123-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2123-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2124" : helpers.makeTestYear("America/Cuiaba", [
		["2124-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2124-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2124-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2124-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2125" : helpers.makeTestYear("America/Cuiaba", [
		["2125-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2125-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2125-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2125-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2126" : helpers.makeTestYear("America/Cuiaba", [
		["2126-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2126-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2126-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2126-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2127" : helpers.makeTestYear("America/Cuiaba", [
		["2127-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2127-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2127-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2127-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2128" : helpers.makeTestYear("America/Cuiaba", [
		["2128-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2128-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2128-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2128-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2129" : helpers.makeTestYear("America/Cuiaba", [
		["2129-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2129-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2129-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2129-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2130" : helpers.makeTestYear("America/Cuiaba", [
		["2130-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2130-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2130-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2130-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2131" : helpers.makeTestYear("America/Cuiaba", [
		["2131-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2131-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2131-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2131-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2132" : helpers.makeTestYear("America/Cuiaba", [
		["2132-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2132-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2132-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2132-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2133" : helpers.makeTestYear("America/Cuiaba", [
		["2133-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2133-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2133-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2133-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2134" : helpers.makeTestYear("America/Cuiaba", [
		["2134-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2134-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2134-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2134-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2135" : helpers.makeTestYear("America/Cuiaba", [
		["2135-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2135-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2135-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2135-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2136" : helpers.makeTestYear("America/Cuiaba", [
		["2136-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2136-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2136-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2136-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2137" : helpers.makeTestYear("America/Cuiaba", [
		["2137-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2137-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2137-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2137-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2138" : helpers.makeTestYear("America/Cuiaba", [
		["2138-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2138-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2138-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2138-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2139" : helpers.makeTestYear("America/Cuiaba", [
		["2139-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2139-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2139-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2139-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2140" : helpers.makeTestYear("America/Cuiaba", [
		["2140-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2140-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2140-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2140-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2141" : helpers.makeTestYear("America/Cuiaba", [
		["2141-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2141-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2141-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2141-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2142" : helpers.makeTestYear("America/Cuiaba", [
		["2142-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2142-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2142-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2142-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2143" : helpers.makeTestYear("America/Cuiaba", [
		["2143-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2143-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2143-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2143-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2144" : helpers.makeTestYear("America/Cuiaba", [
		["2144-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2144-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2144-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2144-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2145" : helpers.makeTestYear("America/Cuiaba", [
		["2145-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2145-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2145-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2145-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2146" : helpers.makeTestYear("America/Cuiaba", [
		["2146-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2146-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2146-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2146-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2147" : helpers.makeTestYear("America/Cuiaba", [
		["2147-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2147-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2147-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2147-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2148" : helpers.makeTestYear("America/Cuiaba", [
		["2148-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2148-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2148-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2148-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2149" : helpers.makeTestYear("America/Cuiaba", [
		["2149-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2149-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2149-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2149-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2150" : helpers.makeTestYear("America/Cuiaba", [
		["2150-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2150-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2150-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2150-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2151" : helpers.makeTestYear("America/Cuiaba", [
		["2151-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2151-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2151-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2151-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2152" : helpers.makeTestYear("America/Cuiaba", [
		["2152-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2152-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2152-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2152-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2153" : helpers.makeTestYear("America/Cuiaba", [
		["2153-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2153-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2153-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2153-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2154" : helpers.makeTestYear("America/Cuiaba", [
		["2154-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2154-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2154-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2154-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2155" : helpers.makeTestYear("America/Cuiaba", [
		["2155-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2155-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2155-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2155-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2156" : helpers.makeTestYear("America/Cuiaba", [
		["2156-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2156-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2156-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2156-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2157" : helpers.makeTestYear("America/Cuiaba", [
		["2157-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2157-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2157-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2157-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2158" : helpers.makeTestYear("America/Cuiaba", [
		["2158-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2158-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2158-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2158-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2159" : helpers.makeTestYear("America/Cuiaba", [
		["2159-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2159-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2159-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2159-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2160" : helpers.makeTestYear("America/Cuiaba", [
		["2160-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2160-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2160-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2160-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2161" : helpers.makeTestYear("America/Cuiaba", [
		["2161-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2161-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2161-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2161-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2162" : helpers.makeTestYear("America/Cuiaba", [
		["2162-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2162-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2162-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2162-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2163" : helpers.makeTestYear("America/Cuiaba", [
		["2163-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2163-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2163-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2163-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2164" : helpers.makeTestYear("America/Cuiaba", [
		["2164-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2164-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2164-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2164-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2165" : helpers.makeTestYear("America/Cuiaba", [
		["2165-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2165-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2165-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2165-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2166" : helpers.makeTestYear("America/Cuiaba", [
		["2166-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2166-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2166-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2166-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2167" : helpers.makeTestYear("America/Cuiaba", [
		["2167-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2167-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2167-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2167-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2168" : helpers.makeTestYear("America/Cuiaba", [
		["2168-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2168-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2168-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2168-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2169" : helpers.makeTestYear("America/Cuiaba", [
		["2169-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2169-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2169-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2169-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2170" : helpers.makeTestYear("America/Cuiaba", [
		["2170-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2170-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2170-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2170-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2171" : helpers.makeTestYear("America/Cuiaba", [
		["2171-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2171-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2171-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2171-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2172" : helpers.makeTestYear("America/Cuiaba", [
		["2172-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2172-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2172-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2172-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2173" : helpers.makeTestYear("America/Cuiaba", [
		["2173-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2173-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2173-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2173-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2174" : helpers.makeTestYear("America/Cuiaba", [
		["2174-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2174-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2174-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2174-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2175" : helpers.makeTestYear("America/Cuiaba", [
		["2175-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2175-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2175-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2175-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2176" : helpers.makeTestYear("America/Cuiaba", [
		["2176-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2176-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2176-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2176-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2177" : helpers.makeTestYear("America/Cuiaba", [
		["2177-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2177-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2177-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2177-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2178" : helpers.makeTestYear("America/Cuiaba", [
		["2178-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2178-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2178-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2178-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2179" : helpers.makeTestYear("America/Cuiaba", [
		["2179-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2179-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2179-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2179-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2180" : helpers.makeTestYear("America/Cuiaba", [
		["2180-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2180-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2180-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2180-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2181" : helpers.makeTestYear("America/Cuiaba", [
		["2181-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2181-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2181-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2181-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2182" : helpers.makeTestYear("America/Cuiaba", [
		["2182-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2182-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2182-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2182-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2183" : helpers.makeTestYear("America/Cuiaba", [
		["2183-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2183-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2183-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2183-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2184" : helpers.makeTestYear("America/Cuiaba", [
		["2184-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2184-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2184-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2184-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2185" : helpers.makeTestYear("America/Cuiaba", [
		["2185-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2185-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2185-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2185-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2186" : helpers.makeTestYear("America/Cuiaba", [
		["2186-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2186-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2186-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2186-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2187" : helpers.makeTestYear("America/Cuiaba", [
		["2187-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2187-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2187-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2187-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2188" : helpers.makeTestYear("America/Cuiaba", [
		["2188-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2188-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2188-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2188-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2189" : helpers.makeTestYear("America/Cuiaba", [
		["2189-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2189-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2189-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2189-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2190" : helpers.makeTestYear("America/Cuiaba", [
		["2190-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2190-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2190-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2190-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2191" : helpers.makeTestYear("America/Cuiaba", [
		["2191-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2191-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2191-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2191-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2192" : helpers.makeTestYear("America/Cuiaba", [
		["2192-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2192-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2192-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2192-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2193" : helpers.makeTestYear("America/Cuiaba", [
		["2193-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2193-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2193-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2193-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2194" : helpers.makeTestYear("America/Cuiaba", [
		["2194-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2194-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2194-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2194-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2195" : helpers.makeTestYear("America/Cuiaba", [
		["2195-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2195-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2195-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2195-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2196" : helpers.makeTestYear("America/Cuiaba", [
		["2196-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2196-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2196-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2196-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2197" : helpers.makeTestYear("America/Cuiaba", [
		["2197-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2197-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2197-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2197-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2198" : helpers.makeTestYear("America/Cuiaba", [
		["2198-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2198-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2198-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2198-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2199" : helpers.makeTestYear("America/Cuiaba", [
		["2199-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2199-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2199-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2199-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2200" : helpers.makeTestYear("America/Cuiaba", [
		["2200-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2200-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2200-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2200-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2201" : helpers.makeTestYear("America/Cuiaba", [
		["2201-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2201-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2201-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2201-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2202" : helpers.makeTestYear("America/Cuiaba", [
		["2202-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2202-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2202-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2202-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2203" : helpers.makeTestYear("America/Cuiaba", [
		["2203-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2203-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2203-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2203-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2204" : helpers.makeTestYear("America/Cuiaba", [
		["2204-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2204-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2204-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2204-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2205" : helpers.makeTestYear("America/Cuiaba", [
		["2205-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2205-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2205-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2205-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2206" : helpers.makeTestYear("America/Cuiaba", [
		["2206-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2206-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2206-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2206-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2207" : helpers.makeTestYear("America/Cuiaba", [
		["2207-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2207-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2207-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2207-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2208" : helpers.makeTestYear("America/Cuiaba", [
		["2208-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2208-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2208-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2208-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2209" : helpers.makeTestYear("America/Cuiaba", [
		["2209-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2209-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2209-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2209-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2210" : helpers.makeTestYear("America/Cuiaba", [
		["2210-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2210-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2210-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2210-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2211" : helpers.makeTestYear("America/Cuiaba", [
		["2211-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2211-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2211-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2211-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2212" : helpers.makeTestYear("America/Cuiaba", [
		["2212-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2212-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2212-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2212-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2213" : helpers.makeTestYear("America/Cuiaba", [
		["2213-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2213-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2213-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2213-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2214" : helpers.makeTestYear("America/Cuiaba", [
		["2214-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2214-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2214-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2214-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2215" : helpers.makeTestYear("America/Cuiaba", [
		["2215-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2215-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2215-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2215-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2216" : helpers.makeTestYear("America/Cuiaba", [
		["2216-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2216-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2216-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2216-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2217" : helpers.makeTestYear("America/Cuiaba", [
		["2217-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2217-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2217-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2217-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2218" : helpers.makeTestYear("America/Cuiaba", [
		["2218-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2218-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2218-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2218-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2219" : helpers.makeTestYear("America/Cuiaba", [
		["2219-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2219-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2219-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2219-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2220" : helpers.makeTestYear("America/Cuiaba", [
		["2220-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2220-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2220-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2220-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2221" : helpers.makeTestYear("America/Cuiaba", [
		["2221-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2221-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2221-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2221-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2222" : helpers.makeTestYear("America/Cuiaba", [
		["2222-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2222-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2222-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2222-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2223" : helpers.makeTestYear("America/Cuiaba", [
		["2223-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2223-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2223-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2223-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2224" : helpers.makeTestYear("America/Cuiaba", [
		["2224-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2224-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2224-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2224-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2225" : helpers.makeTestYear("America/Cuiaba", [
		["2225-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2225-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2225-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2225-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2226" : helpers.makeTestYear("America/Cuiaba", [
		["2226-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2226-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2226-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2226-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2227" : helpers.makeTestYear("America/Cuiaba", [
		["2227-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2227-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2227-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2227-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2228" : helpers.makeTestYear("America/Cuiaba", [
		["2228-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2228-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2228-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2228-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2229" : helpers.makeTestYear("America/Cuiaba", [
		["2229-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2229-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2229-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2229-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2230" : helpers.makeTestYear("America/Cuiaba", [
		["2230-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2230-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2230-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2230-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2231" : helpers.makeTestYear("America/Cuiaba", [
		["2231-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2231-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2231-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2231-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2232" : helpers.makeTestYear("America/Cuiaba", [
		["2232-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2232-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2232-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2232-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2233" : helpers.makeTestYear("America/Cuiaba", [
		["2233-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2233-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2233-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2233-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2234" : helpers.makeTestYear("America/Cuiaba", [
		["2234-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2234-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2234-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2234-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2235" : helpers.makeTestYear("America/Cuiaba", [
		["2235-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2235-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2235-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2235-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2236" : helpers.makeTestYear("America/Cuiaba", [
		["2236-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2236-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2236-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2236-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2237" : helpers.makeTestYear("America/Cuiaba", [
		["2237-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2237-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2237-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2237-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2238" : helpers.makeTestYear("America/Cuiaba", [
		["2238-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2238-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2238-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2238-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2239" : helpers.makeTestYear("America/Cuiaba", [
		["2239-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2239-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2239-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2239-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2240" : helpers.makeTestYear("America/Cuiaba", [
		["2240-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2240-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2240-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2240-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2241" : helpers.makeTestYear("America/Cuiaba", [
		["2241-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2241-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2241-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2241-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2242" : helpers.makeTestYear("America/Cuiaba", [
		["2242-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2242-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2242-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2242-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2243" : helpers.makeTestYear("America/Cuiaba", [
		["2243-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2243-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2243-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2243-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2244" : helpers.makeTestYear("America/Cuiaba", [
		["2244-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2244-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2244-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2244-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2245" : helpers.makeTestYear("America/Cuiaba", [
		["2245-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2245-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2245-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2245-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2246" : helpers.makeTestYear("America/Cuiaba", [
		["2246-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2246-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2246-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2246-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2247" : helpers.makeTestYear("America/Cuiaba", [
		["2247-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2247-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2247-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2247-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2248" : helpers.makeTestYear("America/Cuiaba", [
		["2248-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2248-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2248-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2248-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2249" : helpers.makeTestYear("America/Cuiaba", [
		["2249-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2249-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2249-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2249-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2250" : helpers.makeTestYear("America/Cuiaba", [
		["2250-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2250-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2250-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2250-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2251" : helpers.makeTestYear("America/Cuiaba", [
		["2251-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2251-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2251-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2251-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2252" : helpers.makeTestYear("America/Cuiaba", [
		["2252-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2252-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2252-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2252-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2253" : helpers.makeTestYear("America/Cuiaba", [
		["2253-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2253-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2253-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2253-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2254" : helpers.makeTestYear("America/Cuiaba", [
		["2254-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2254-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2254-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2254-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2255" : helpers.makeTestYear("America/Cuiaba", [
		["2255-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2255-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2255-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2255-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2256" : helpers.makeTestYear("America/Cuiaba", [
		["2256-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2256-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2256-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2256-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2257" : helpers.makeTestYear("America/Cuiaba", [
		["2257-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2257-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2257-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2257-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2258" : helpers.makeTestYear("America/Cuiaba", [
		["2258-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2258-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2258-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2258-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2259" : helpers.makeTestYear("America/Cuiaba", [
		["2259-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2259-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2259-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2259-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2260" : helpers.makeTestYear("America/Cuiaba", [
		["2260-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2260-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2260-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2260-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2261" : helpers.makeTestYear("America/Cuiaba", [
		["2261-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2261-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2261-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2261-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2262" : helpers.makeTestYear("America/Cuiaba", [
		["2262-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2262-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2262-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2262-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2263" : helpers.makeTestYear("America/Cuiaba", [
		["2263-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2263-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2263-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2263-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2264" : helpers.makeTestYear("America/Cuiaba", [
		["2264-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2264-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2264-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2264-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2265" : helpers.makeTestYear("America/Cuiaba", [
		["2265-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2265-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2265-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2265-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2266" : helpers.makeTestYear("America/Cuiaba", [
		["2266-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2266-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2266-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2266-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2267" : helpers.makeTestYear("America/Cuiaba", [
		["2267-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2267-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2267-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2267-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2268" : helpers.makeTestYear("America/Cuiaba", [
		["2268-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2268-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2268-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2268-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2269" : helpers.makeTestYear("America/Cuiaba", [
		["2269-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2269-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2269-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2269-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2270" : helpers.makeTestYear("America/Cuiaba", [
		["2270-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2270-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2270-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2270-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2271" : helpers.makeTestYear("America/Cuiaba", [
		["2271-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2271-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2271-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2271-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2272" : helpers.makeTestYear("America/Cuiaba", [
		["2272-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2272-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2272-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2272-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2273" : helpers.makeTestYear("America/Cuiaba", [
		["2273-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2273-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2273-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2273-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2274" : helpers.makeTestYear("America/Cuiaba", [
		["2274-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2274-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2274-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2274-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2275" : helpers.makeTestYear("America/Cuiaba", [
		["2275-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2275-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2275-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2275-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2276" : helpers.makeTestYear("America/Cuiaba", [
		["2276-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2276-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2276-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2276-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2277" : helpers.makeTestYear("America/Cuiaba", [
		["2277-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2277-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2277-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2277-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2278" : helpers.makeTestYear("America/Cuiaba", [
		["2278-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2278-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2278-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2278-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2279" : helpers.makeTestYear("America/Cuiaba", [
		["2279-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2279-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2279-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2279-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2280" : helpers.makeTestYear("America/Cuiaba", [
		["2280-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2280-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2280-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2280-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2281" : helpers.makeTestYear("America/Cuiaba", [
		["2281-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2281-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2281-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2281-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2282" : helpers.makeTestYear("America/Cuiaba", [
		["2282-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2282-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2282-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2282-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2283" : helpers.makeTestYear("America/Cuiaba", [
		["2283-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2283-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2283-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2283-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2284" : helpers.makeTestYear("America/Cuiaba", [
		["2284-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2284-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2284-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2284-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2285" : helpers.makeTestYear("America/Cuiaba", [
		["2285-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2285-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2285-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2285-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2286" : helpers.makeTestYear("America/Cuiaba", [
		["2286-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2286-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2286-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2286-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2287" : helpers.makeTestYear("America/Cuiaba", [
		["2287-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2287-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2287-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2287-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2288" : helpers.makeTestYear("America/Cuiaba", [
		["2288-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2288-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2288-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2288-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2289" : helpers.makeTestYear("America/Cuiaba", [
		["2289-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2289-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2289-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2289-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2290" : helpers.makeTestYear("America/Cuiaba", [
		["2290-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2290-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2290-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2290-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2291" : helpers.makeTestYear("America/Cuiaba", [
		["2291-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2291-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2291-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2291-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2292" : helpers.makeTestYear("America/Cuiaba", [
		["2292-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2292-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2292-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2292-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2293" : helpers.makeTestYear("America/Cuiaba", [
		["2293-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2293-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2293-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2293-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2294" : helpers.makeTestYear("America/Cuiaba", [
		["2294-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2294-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2294-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2294-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2295" : helpers.makeTestYear("America/Cuiaba", [
		["2295-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2295-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2295-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2295-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2296" : helpers.makeTestYear("America/Cuiaba", [
		["2296-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2296-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2296-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2296-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2297" : helpers.makeTestYear("America/Cuiaba", [
		["2297-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2297-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2297-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2297-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2298" : helpers.makeTestYear("America/Cuiaba", [
		["2298-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2298-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2298-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2298-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2299" : helpers.makeTestYear("America/Cuiaba", [
		["2299-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2299-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2299-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2299-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2300" : helpers.makeTestYear("America/Cuiaba", [
		["2300-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2300-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2300-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2300-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2301" : helpers.makeTestYear("America/Cuiaba", [
		["2301-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2301-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2301-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2301-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2302" : helpers.makeTestYear("America/Cuiaba", [
		["2302-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2302-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2302-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2302-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2303" : helpers.makeTestYear("America/Cuiaba", [
		["2303-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2303-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2303-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2303-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2304" : helpers.makeTestYear("America/Cuiaba", [
		["2304-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2304-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2304-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2304-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2305" : helpers.makeTestYear("America/Cuiaba", [
		["2305-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2305-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2305-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2305-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2306" : helpers.makeTestYear("America/Cuiaba", [
		["2306-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2306-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2306-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2306-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2307" : helpers.makeTestYear("America/Cuiaba", [
		["2307-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2307-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2307-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2307-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2308" : helpers.makeTestYear("America/Cuiaba", [
		["2308-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2308-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2308-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2308-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2309" : helpers.makeTestYear("America/Cuiaba", [
		["2309-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2309-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2309-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2309-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2310" : helpers.makeTestYear("America/Cuiaba", [
		["2310-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2310-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2310-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2310-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2311" : helpers.makeTestYear("America/Cuiaba", [
		["2311-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2311-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2311-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2311-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2312" : helpers.makeTestYear("America/Cuiaba", [
		["2312-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2312-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2312-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2312-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2313" : helpers.makeTestYear("America/Cuiaba", [
		["2313-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2313-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2313-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2313-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2314" : helpers.makeTestYear("America/Cuiaba", [
		["2314-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2314-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2314-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2314-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2315" : helpers.makeTestYear("America/Cuiaba", [
		["2315-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2315-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2315-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2315-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2316" : helpers.makeTestYear("America/Cuiaba", [
		["2316-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2316-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2316-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2316-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2317" : helpers.makeTestYear("America/Cuiaba", [
		["2317-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2317-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2317-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2317-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2318" : helpers.makeTestYear("America/Cuiaba", [
		["2318-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2318-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2318-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2318-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2319" : helpers.makeTestYear("America/Cuiaba", [
		["2319-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2319-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2319-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2319-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2320" : helpers.makeTestYear("America/Cuiaba", [
		["2320-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2320-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2320-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2320-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2321" : helpers.makeTestYear("America/Cuiaba", [
		["2321-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2321-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2321-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2321-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2322" : helpers.makeTestYear("America/Cuiaba", [
		["2322-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2322-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2322-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2322-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2323" : helpers.makeTestYear("America/Cuiaba", [
		["2323-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2323-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2323-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2323-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2324" : helpers.makeTestYear("America/Cuiaba", [
		["2324-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2324-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2324-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2324-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2325" : helpers.makeTestYear("America/Cuiaba", [
		["2325-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2325-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2325-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2325-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2326" : helpers.makeTestYear("America/Cuiaba", [
		["2326-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2326-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2326-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2326-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2327" : helpers.makeTestYear("America/Cuiaba", [
		["2327-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2327-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2327-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2327-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2328" : helpers.makeTestYear("America/Cuiaba", [
		["2328-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2328-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2328-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2328-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2329" : helpers.makeTestYear("America/Cuiaba", [
		["2329-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2329-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2329-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2329-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2330" : helpers.makeTestYear("America/Cuiaba", [
		["2330-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2330-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2330-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2330-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2331" : helpers.makeTestYear("America/Cuiaba", [
		["2331-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2331-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2331-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2331-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2332" : helpers.makeTestYear("America/Cuiaba", [
		["2332-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2332-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2332-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2332-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2333" : helpers.makeTestYear("America/Cuiaba", [
		["2333-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2333-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2333-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2333-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2334" : helpers.makeTestYear("America/Cuiaba", [
		["2334-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2334-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2334-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2334-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2335" : helpers.makeTestYear("America/Cuiaba", [
		["2335-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2335-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2335-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2335-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2336" : helpers.makeTestYear("America/Cuiaba", [
		["2336-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2336-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2336-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2336-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2337" : helpers.makeTestYear("America/Cuiaba", [
		["2337-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2337-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2337-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2337-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2338" : helpers.makeTestYear("America/Cuiaba", [
		["2338-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2338-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2338-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2338-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2339" : helpers.makeTestYear("America/Cuiaba", [
		["2339-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2339-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2339-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2339-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2340" : helpers.makeTestYear("America/Cuiaba", [
		["2340-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2340-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2340-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2340-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2341" : helpers.makeTestYear("America/Cuiaba", [
		["2341-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2341-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2341-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2341-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2342" : helpers.makeTestYear("America/Cuiaba", [
		["2342-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2342-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2342-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2342-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2343" : helpers.makeTestYear("America/Cuiaba", [
		["2343-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2343-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2343-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2343-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2344" : helpers.makeTestYear("America/Cuiaba", [
		["2344-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2344-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2344-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2344-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2345" : helpers.makeTestYear("America/Cuiaba", [
		["2345-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2345-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2345-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2345-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2346" : helpers.makeTestYear("America/Cuiaba", [
		["2346-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2346-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2346-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2346-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2347" : helpers.makeTestYear("America/Cuiaba", [
		["2347-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2347-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2347-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2347-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2348" : helpers.makeTestYear("America/Cuiaba", [
		["2348-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2348-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2348-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2348-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2349" : helpers.makeTestYear("America/Cuiaba", [
		["2349-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2349-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2349-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2349-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2350" : helpers.makeTestYear("America/Cuiaba", [
		["2350-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2350-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2350-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2350-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2351" : helpers.makeTestYear("America/Cuiaba", [
		["2351-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2351-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2351-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2351-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2352" : helpers.makeTestYear("America/Cuiaba", [
		["2352-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2352-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2352-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2352-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2353" : helpers.makeTestYear("America/Cuiaba", [
		["2353-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2353-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2353-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2353-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2354" : helpers.makeTestYear("America/Cuiaba", [
		["2354-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2354-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2354-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2354-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2355" : helpers.makeTestYear("America/Cuiaba", [
		["2355-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2355-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2355-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2355-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2356" : helpers.makeTestYear("America/Cuiaba", [
		["2356-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2356-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2356-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2356-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2357" : helpers.makeTestYear("America/Cuiaba", [
		["2357-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2357-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2357-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2357-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2358" : helpers.makeTestYear("America/Cuiaba", [
		["2358-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2358-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2358-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2358-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2359" : helpers.makeTestYear("America/Cuiaba", [
		["2359-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2359-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2359-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2359-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2360" : helpers.makeTestYear("America/Cuiaba", [
		["2360-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2360-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2360-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2360-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2361" : helpers.makeTestYear("America/Cuiaba", [
		["2361-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2361-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2361-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2361-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2362" : helpers.makeTestYear("America/Cuiaba", [
		["2362-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2362-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2362-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2362-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2363" : helpers.makeTestYear("America/Cuiaba", [
		["2363-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2363-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2363-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2363-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2364" : helpers.makeTestYear("America/Cuiaba", [
		["2364-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2364-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2364-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2364-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2365" : helpers.makeTestYear("America/Cuiaba", [
		["2365-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2365-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2365-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2365-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2366" : helpers.makeTestYear("America/Cuiaba", [
		["2366-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2366-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2366-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2366-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2367" : helpers.makeTestYear("America/Cuiaba", [
		["2367-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2367-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2367-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2367-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2368" : helpers.makeTestYear("America/Cuiaba", [
		["2368-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2368-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2368-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2368-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2369" : helpers.makeTestYear("America/Cuiaba", [
		["2369-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2369-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2369-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2369-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2370" : helpers.makeTestYear("America/Cuiaba", [
		["2370-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2370-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2370-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2370-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2371" : helpers.makeTestYear("America/Cuiaba", [
		["2371-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2371-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2371-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2371-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2372" : helpers.makeTestYear("America/Cuiaba", [
		["2372-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2372-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2372-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2372-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2373" : helpers.makeTestYear("America/Cuiaba", [
		["2373-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2373-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2373-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2373-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2374" : helpers.makeTestYear("America/Cuiaba", [
		["2374-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2374-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2374-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2374-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2375" : helpers.makeTestYear("America/Cuiaba", [
		["2375-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2375-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2375-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2375-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2376" : helpers.makeTestYear("America/Cuiaba", [
		["2376-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2376-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2376-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2376-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2377" : helpers.makeTestYear("America/Cuiaba", [
		["2377-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2377-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2377-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2377-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2378" : helpers.makeTestYear("America/Cuiaba", [
		["2378-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2378-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2378-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2378-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2379" : helpers.makeTestYear("America/Cuiaba", [
		["2379-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2379-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2379-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2379-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2380" : helpers.makeTestYear("America/Cuiaba", [
		["2380-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2380-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2380-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2380-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2381" : helpers.makeTestYear("America/Cuiaba", [
		["2381-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2381-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2381-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2381-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2382" : helpers.makeTestYear("America/Cuiaba", [
		["2382-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2382-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2382-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2382-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2383" : helpers.makeTestYear("America/Cuiaba", [
		["2383-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2383-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2383-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2383-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2384" : helpers.makeTestYear("America/Cuiaba", [
		["2384-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2384-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2384-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2384-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2385" : helpers.makeTestYear("America/Cuiaba", [
		["2385-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2385-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2385-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2385-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2386" : helpers.makeTestYear("America/Cuiaba", [
		["2386-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2386-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2386-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2386-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2387" : helpers.makeTestYear("America/Cuiaba", [
		["2387-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2387-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2387-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2387-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2388" : helpers.makeTestYear("America/Cuiaba", [
		["2388-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2388-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2388-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2388-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2389" : helpers.makeTestYear("America/Cuiaba", [
		["2389-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2389-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2389-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2389-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2390" : helpers.makeTestYear("America/Cuiaba", [
		["2390-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2390-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2390-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2390-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2391" : helpers.makeTestYear("America/Cuiaba", [
		["2391-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2391-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2391-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2391-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2392" : helpers.makeTestYear("America/Cuiaba", [
		["2392-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2392-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2392-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2392-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2393" : helpers.makeTestYear("America/Cuiaba", [
		["2393-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2393-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2393-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2393-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2394" : helpers.makeTestYear("America/Cuiaba", [
		["2394-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2394-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2394-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2394-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2395" : helpers.makeTestYear("America/Cuiaba", [
		["2395-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2395-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2395-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2395-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2396" : helpers.makeTestYear("America/Cuiaba", [
		["2396-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2396-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2396-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2396-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2397" : helpers.makeTestYear("America/Cuiaba", [
		["2397-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2397-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2397-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2397-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2398" : helpers.makeTestYear("America/Cuiaba", [
		["2398-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2398-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2398-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2398-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2399" : helpers.makeTestYear("America/Cuiaba", [
		["2399-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2399-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2399-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2399-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2400" : helpers.makeTestYear("America/Cuiaba", [
		["2400-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2400-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2400-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2400-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2401" : helpers.makeTestYear("America/Cuiaba", [
		["2401-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2401-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2401-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2401-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2402" : helpers.makeTestYear("America/Cuiaba", [
		["2402-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2402-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2402-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2402-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2403" : helpers.makeTestYear("America/Cuiaba", [
		["2403-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2403-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2403-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2403-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2404" : helpers.makeTestYear("America/Cuiaba", [
		["2404-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2404-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2404-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2404-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2405" : helpers.makeTestYear("America/Cuiaba", [
		["2405-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2405-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2405-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2405-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2406" : helpers.makeTestYear("America/Cuiaba", [
		["2406-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2406-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2406-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2406-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2407" : helpers.makeTestYear("America/Cuiaba", [
		["2407-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2407-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2407-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2407-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2408" : helpers.makeTestYear("America/Cuiaba", [
		["2408-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2408-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2408-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2408-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2409" : helpers.makeTestYear("America/Cuiaba", [
		["2409-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2409-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2409-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2409-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2410" : helpers.makeTestYear("America/Cuiaba", [
		["2410-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2410-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2410-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2410-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2411" : helpers.makeTestYear("America/Cuiaba", [
		["2411-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2411-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2411-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2411-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2412" : helpers.makeTestYear("America/Cuiaba", [
		["2412-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2412-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2412-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2412-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2413" : helpers.makeTestYear("America/Cuiaba", [
		["2413-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2413-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2413-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2413-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2414" : helpers.makeTestYear("America/Cuiaba", [
		["2414-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2414-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2414-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2414-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2415" : helpers.makeTestYear("America/Cuiaba", [
		["2415-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2415-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2415-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2415-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2416" : helpers.makeTestYear("America/Cuiaba", [
		["2416-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2416-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2416-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2416-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2417" : helpers.makeTestYear("America/Cuiaba", [
		["2417-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2417-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2417-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2417-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2418" : helpers.makeTestYear("America/Cuiaba", [
		["2418-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2418-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2418-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2418-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2419" : helpers.makeTestYear("America/Cuiaba", [
		["2419-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2419-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2419-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2419-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2420" : helpers.makeTestYear("America/Cuiaba", [
		["2420-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2420-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2420-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2420-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2421" : helpers.makeTestYear("America/Cuiaba", [
		["2421-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2421-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2421-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2421-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2422" : helpers.makeTestYear("America/Cuiaba", [
		["2422-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2422-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2422-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2422-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2423" : helpers.makeTestYear("America/Cuiaba", [
		["2423-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2423-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2423-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2423-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2424" : helpers.makeTestYear("America/Cuiaba", [
		["2424-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2424-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2424-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2424-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2425" : helpers.makeTestYear("America/Cuiaba", [
		["2425-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2425-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2425-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2425-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2426" : helpers.makeTestYear("America/Cuiaba", [
		["2426-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2426-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2426-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2426-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2427" : helpers.makeTestYear("America/Cuiaba", [
		["2427-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2427-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2427-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2427-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2428" : helpers.makeTestYear("America/Cuiaba", [
		["2428-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2428-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2428-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2428-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2429" : helpers.makeTestYear("America/Cuiaba", [
		["2429-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2429-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2429-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2429-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2430" : helpers.makeTestYear("America/Cuiaba", [
		["2430-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2430-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2430-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2430-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2431" : helpers.makeTestYear("America/Cuiaba", [
		["2431-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2431-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2431-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2431-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2432" : helpers.makeTestYear("America/Cuiaba", [
		["2432-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2432-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2432-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2432-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2433" : helpers.makeTestYear("America/Cuiaba", [
		["2433-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2433-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2433-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2433-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2434" : helpers.makeTestYear("America/Cuiaba", [
		["2434-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2434-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2434-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2434-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2435" : helpers.makeTestYear("America/Cuiaba", [
		["2435-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2435-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2435-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2435-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2436" : helpers.makeTestYear("America/Cuiaba", [
		["2436-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2436-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2436-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2436-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2437" : helpers.makeTestYear("America/Cuiaba", [
		["2437-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2437-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2437-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2437-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2438" : helpers.makeTestYear("America/Cuiaba", [
		["2438-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2438-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2438-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2438-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2439" : helpers.makeTestYear("America/Cuiaba", [
		["2439-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2439-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2439-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2439-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2440" : helpers.makeTestYear("America/Cuiaba", [
		["2440-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2440-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2440-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2440-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2441" : helpers.makeTestYear("America/Cuiaba", [
		["2441-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2441-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2441-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2441-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2442" : helpers.makeTestYear("America/Cuiaba", [
		["2442-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2442-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2442-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2442-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2443" : helpers.makeTestYear("America/Cuiaba", [
		["2443-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2443-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2443-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2443-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2444" : helpers.makeTestYear("America/Cuiaba", [
		["2444-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2444-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2444-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2444-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2445" : helpers.makeTestYear("America/Cuiaba", [
		["2445-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2445-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2445-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2445-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2446" : helpers.makeTestYear("America/Cuiaba", [
		["2446-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2446-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2446-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2446-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2447" : helpers.makeTestYear("America/Cuiaba", [
		["2447-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2447-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2447-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2447-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2448" : helpers.makeTestYear("America/Cuiaba", [
		["2448-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2448-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2448-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2448-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2449" : helpers.makeTestYear("America/Cuiaba", [
		["2449-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2449-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2449-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2449-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2450" : helpers.makeTestYear("America/Cuiaba", [
		["2450-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2450-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2450-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2450-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2451" : helpers.makeTestYear("America/Cuiaba", [
		["2451-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2451-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2451-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2451-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2452" : helpers.makeTestYear("America/Cuiaba", [
		["2452-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2452-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2452-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2452-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2453" : helpers.makeTestYear("America/Cuiaba", [
		["2453-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2453-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2453-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2453-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2454" : helpers.makeTestYear("America/Cuiaba", [
		["2454-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2454-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2454-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2454-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2455" : helpers.makeTestYear("America/Cuiaba", [
		["2455-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2455-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2455-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2455-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2456" : helpers.makeTestYear("America/Cuiaba", [
		["2456-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2456-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2456-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2456-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2457" : helpers.makeTestYear("America/Cuiaba", [
		["2457-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2457-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2457-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2457-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2458" : helpers.makeTestYear("America/Cuiaba", [
		["2458-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2458-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2458-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2458-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2459" : helpers.makeTestYear("America/Cuiaba", [
		["2459-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2459-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2459-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2459-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2460" : helpers.makeTestYear("America/Cuiaba", [
		["2460-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2460-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2460-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2460-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2461" : helpers.makeTestYear("America/Cuiaba", [
		["2461-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2461-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2461-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2461-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2462" : helpers.makeTestYear("America/Cuiaba", [
		["2462-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2462-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2462-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2462-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2463" : helpers.makeTestYear("America/Cuiaba", [
		["2463-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2463-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2463-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2463-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2464" : helpers.makeTestYear("America/Cuiaba", [
		["2464-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2464-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2464-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2464-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2465" : helpers.makeTestYear("America/Cuiaba", [
		["2465-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2465-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2465-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2465-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2466" : helpers.makeTestYear("America/Cuiaba", [
		["2466-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2466-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2466-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2466-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2467" : helpers.makeTestYear("America/Cuiaba", [
		["2467-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2467-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2467-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2467-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2468" : helpers.makeTestYear("America/Cuiaba", [
		["2468-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2468-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2468-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2468-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2469" : helpers.makeTestYear("America/Cuiaba", [
		["2469-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2469-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2469-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2469-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2470" : helpers.makeTestYear("America/Cuiaba", [
		["2470-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2470-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2470-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2470-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2471" : helpers.makeTestYear("America/Cuiaba", [
		["2471-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2471-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2471-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2471-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2472" : helpers.makeTestYear("America/Cuiaba", [
		["2472-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2472-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2472-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2472-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2473" : helpers.makeTestYear("America/Cuiaba", [
		["2473-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2473-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2473-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2473-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2474" : helpers.makeTestYear("America/Cuiaba", [
		["2474-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2474-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2474-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2474-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2475" : helpers.makeTestYear("America/Cuiaba", [
		["2475-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2475-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2475-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2475-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2476" : helpers.makeTestYear("America/Cuiaba", [
		["2476-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2476-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2476-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2476-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2477" : helpers.makeTestYear("America/Cuiaba", [
		["2477-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2477-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2477-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2477-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2478" : helpers.makeTestYear("America/Cuiaba", [
		["2478-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2478-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2478-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2478-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2479" : helpers.makeTestYear("America/Cuiaba", [
		["2479-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2479-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2479-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2479-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2480" : helpers.makeTestYear("America/Cuiaba", [
		["2480-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2480-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2480-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2480-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2481" : helpers.makeTestYear("America/Cuiaba", [
		["2481-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2481-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2481-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2481-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2482" : helpers.makeTestYear("America/Cuiaba", [
		["2482-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2482-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2482-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2482-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2483" : helpers.makeTestYear("America/Cuiaba", [
		["2483-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2483-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2483-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2483-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2484" : helpers.makeTestYear("America/Cuiaba", [
		["2484-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2484-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2484-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2484-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2485" : helpers.makeTestYear("America/Cuiaba", [
		["2485-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2485-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2485-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2485-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2486" : helpers.makeTestYear("America/Cuiaba", [
		["2486-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2486-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2486-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2486-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2487" : helpers.makeTestYear("America/Cuiaba", [
		["2487-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2487-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2487-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2487-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2488" : helpers.makeTestYear("America/Cuiaba", [
		["2488-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2488-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2488-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2488-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2489" : helpers.makeTestYear("America/Cuiaba", [
		["2489-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2489-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2489-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2489-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2490" : helpers.makeTestYear("America/Cuiaba", [
		["2490-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2490-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2490-11-05T03:59:59+00:00", "23:59:59", "-04", 240],
		["2490-11-05T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2491" : helpers.makeTestYear("America/Cuiaba", [
		["2491-02-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2491-02-18T03:00:00+00:00", "23:00:00", "-04", 240],
		["2491-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2491-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2492" : helpers.makeTestYear("America/Cuiaba", [
		["2492-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2492-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2492-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2492-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2493" : helpers.makeTestYear("America/Cuiaba", [
		["2493-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2493-02-15T03:00:00+00:00", "23:00:00", "-04", 240],
		["2493-11-01T03:59:59+00:00", "23:59:59", "-04", 240],
		["2493-11-01T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2494" : helpers.makeTestYear("America/Cuiaba", [
		["2494-02-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2494-02-21T03:00:00+00:00", "23:00:00", "-04", 240],
		["2494-11-07T03:59:59+00:00", "23:59:59", "-04", 240],
		["2494-11-07T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2495" : helpers.makeTestYear("America/Cuiaba", [
		["2495-02-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2495-02-20T03:00:00+00:00", "23:00:00", "-04", 240],
		["2495-11-06T03:59:59+00:00", "23:59:59", "-04", 240],
		["2495-11-06T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2496" : helpers.makeTestYear("America/Cuiaba", [
		["2496-02-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2496-02-19T03:00:00+00:00", "23:00:00", "-04", 240],
		["2496-11-04T03:59:59+00:00", "23:59:59", "-04", 240],
		["2496-11-04T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2497" : helpers.makeTestYear("America/Cuiaba", [
		["2497-02-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2497-02-17T03:00:00+00:00", "23:00:00", "-04", 240],
		["2497-11-03T03:59:59+00:00", "23:59:59", "-04", 240],
		["2497-11-03T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2498" : helpers.makeTestYear("America/Cuiaba", [
		["2498-02-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2498-02-16T03:00:00+00:00", "23:00:00", "-04", 240],
		["2498-11-02T03:59:59+00:00", "23:59:59", "-04", 240],
		["2498-11-02T04:00:00+00:00", "01:00:00", "-03", 180]
	]),

	"2499" : helpers.makeTestYear("America/Cuiaba", [
		["2499-02-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2499-02-15T03:00:00+00:00", "23:00:00", "-04", 240]
	])
};