//
// Created by dtx on 2022/3/23.
//

#ifndef UOS_RECOVERY_MAKESQUASHFSTASKTEST_H
#define UOS_RECOVERY_MAKESQUASHFSTASKTEST_H

#include "utils/SquashfsTask.h"
#include <gtest/gtest.h>
#include <QTimer>
#include <QObject>
#include <QEventLoop>

class MakeSquashfsTaskTestHandle : public QObject
{
Q_OBJECT
public:
    explicit MakeSquashfsTaskTestHandle(QEventLoop *eventLoop);
    ~MakeSquashfsTaskTestHandle();
    bool doMakeSquashfs(const QString &srcdir, const QString &destfile);

signals:
    void error();
    void finished();

private:
    SquashfsTask *m_squashfsTask = nullptr;
    QEventLoop *m_eventLoop;
};

class MakeSquashfsTaskTest  : public testing::Test
{
public:
    void SetUp() override
    {
        m_loop = new QEventLoop;
        m_squashfsTaskTestHandle = new MakeSquashfsTaskTestHandle(m_loop);
    }

    void TearDown() override
    {
        if (m_squashfsTaskTestHandle != nullptr) {
            delete m_squashfsTaskTestHandle;
            m_squashfsTaskTestHandle = nullptr;
        }
        if (m_loop != nullptr) {
            delete m_loop;
            m_loop = nullptr;
        }
    }

public:
    MakeSquashfsTaskTestHandle *m_squashfsTaskTestHandle = nullptr;
    QEventLoop *m_loop = nullptr;
};


#endif //UOS_RECOVERY_MAKESQUASHFSTASKTEST_H
