//
// Created by 张雪明 <zhangxueming@uniontech.com> on 2023/10/17.
//

#ifndef UOS_RECOVERY_SYS_BACKUP_WIDGET_V20_H
#define UOS_RECOVERY_SYS_BACKUP_WIDGET_V20_H

#include <QWidget>
#include <dfilechooseredit.h>
#include <DTipLabel>
#include <QAbstractButton>
#include "utils/Utils.h"
#include "utils/global.h"

DWIDGET_USE_NAMESPACE

class QLabel;
class QPushButton;
class QDBusPendingCallWatcher;
class RadioItem;
class BaseTableTreeView;
class TreeViewModel;

class SysBackupWidgetV20 : public QWidget {
    Q_OBJECT
public:
    explicit SysBackupWidgetV20(QWidget* parent = nullptr);
    void initUI();

    void setTipsVisible(const bool &visible);
    void setFileDialog(QFileDialog *fileDialog);
    void resizeEvent(QResizeEvent *event) override;
    void doSuccess();
    void doError(int errCode);
    void cancelBackupSuccess();
    void setEnableInHighSysLevelMode(bool enable);
    void setTipsLabelText(const QString &msg);

Q_SIGNALS:
    void requestSetManualBackupDirectory(const QString& path);
    void requestSetSystemBackupDirectory(const QString& path);
    void requestTreeViewListItem(TreeViewModel* model);
    void cancelBackup();
    void requestReboot();

public Q_SLOTS:
    void onBackupButtonVisibleChanged(bool value);
    void onManualBackupErrorTypeChanged(ErrorType type);
    void onCancelBackup();

private Q_SLOTS:
    /**
    * @brief ManualBackup::onChoose 槽函数，接收DFileChooserEdit::dialogClosed信号
    * @param code DFileChooserEdit中文件选择对话框的返回值，即QFileDialog::exec返回值
    * @return void
    */
    void onChoose(const int &code);
    void backup();
    void onBackupTypeButtonGroupToggled(QAbstractButton *button, bool checked);

protected:
    void setColumnWidth();
    void processTreeViewListItem(TreeViewModel *model);

private:
    enum class ActionType{
        ManualBackup,
        SystemBackup
    };

    ActionType m_actionType;
    Utils::BackupType m_backupType;

    DFileChooserEdit* m_directoryChooseWidget;
    DTipLabel* m_tipsLabel;
    QPushButton* m_backupBtn;
    QWidget* m_loadingWidget;
    RadioItem* m_sysBackupItem;
    RadioItem* m_fullBackupItem;
    RadioItem* m_addBackupItem;
    RadioItem* m_coverBackupItem;
    BaseTableTreeView* m_treeView;
    TreeViewModel* m_treeViewModel;
    QWidget *m_defaultWidget = nullptr;
    QWidget* bgWidget = nullptr;
};

#endif //UOS_RECOVERY_SYS_BACKUP_WIDGET_V20_H
