/*
* Copyright (C) 2019 ~ 2019 Uniontech Technology Co., Ltd.
*
* Author:     liaojiayun <liaojiayun@uniontech.com>
*
* Maintainer: liaojiayun <liaojiayun@uniontech.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "radioitem.h"

#include <QVBoxLayout>
#include <QStackedLayout>
#include <QRadioButton>
#include <QLabel>
#include <QPalette>
#include <DPaletteHelper>
#include <DGuiApplicationHelper>
#include <DTipLabel>

DWIDGET_USE_NAMESPACE

RadioItem::RadioItem(QWidget *parent)
    : SettingsItem(parent)
    , m_layout(new QVBoxLayout)
    , m_radioBtn(new QRadioButton)
    , m_content(nullptr)
    , m_tips(new DTipLabel)
    , m_vLayout(new QVBoxLayout(this))
    , m_radioWidget(new QWidget)
{
    m_radioBtn->setCheckable(true);
    m_radioBtn->setMinimumSize(24, 24);

    QVBoxLayout* vlayout = new QVBoxLayout(m_radioWidget);
    vlayout->addWidget(m_radioBtn, 0, Qt::AlignVCenter);
    vlayout->addLayout(m_layout);
    vlayout->setContentsMargins(0,0,0,0);
    m_radioWidget->setLayout(vlayout);

    m_vLayout->addWidget(m_radioWidget);
    m_vLayout->addWidget(m_tips);

    auto pa = DPaletteHelper::instance()->palette(m_tips);
    pa.setBrush(DPalette::TextTips, Qt::red);
    DPaletteHelper::instance()->setPalette(m_tips, pa);
    m_tips->hide();
    m_tips->setWordWrap(true);
    m_tips->setAlignment(Qt::AlignLeft);

    setLayout(m_vLayout);
}

QRadioButton *RadioItem::radioButton() const {
    return m_radioBtn;
}

void RadioItem::setContent(QWidget *content) {
    if (m_content) {
        m_layout->removeWidget(m_content);
        m_content->hide();
        m_content->setParent(nullptr);
        disconnect(m_radioBtn, &QRadioButton::toggled, m_content, &QWidget::setEnabled);
    }

    m_content = content;
    connect(m_radioBtn, &QRadioButton::toggled, m_content, &QWidget::setEnabled);
    content->setEnabled(m_radioBtn->isChecked());

    m_layout->addWidget(m_content);
}

void RadioItem::setTitle(const QString &title) {
    m_radioBtn->setText(title);
}

void RadioItem::setRadioButtonAccessibleName(const QString &name)
{
    m_radioBtn->setAccessibleName(name);
}

bool RadioItem::checked() const {
    return m_radioBtn->isChecked();
}

void RadioItem::setChecked(bool check) {
    m_radioBtn->setChecked(check);
    m_content->setEnabled(check);
}

void RadioItem::setRadioVisible(bool visible)
{
    m_radioWidget->setVisible(visible);
    m_tips->setVisible(!visible);
}

void RadioItem::setRadioButtonToolTip(const QString& text)
{
    m_radioBtn->setToolTip(text);
}

void RadioItem::setTipText(const QString& text)
{
    m_tips->setText(text);
}

QWidget *RadioItem::getContent() const
{
    return m_content;
}
