/*
* Copyright (C) 2019 ~ 2019 Uniontech Technology Co., Ltd.
*
* Author:     liaojiayun <liaojiayun@uniontech.com>
*
* Maintainer: liaojiayun <liaojiayun@uniontech.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef RESTOREITEM_H
#define RESTOREITEM_H

#include "settingsitem.h"

class QVBoxLayout;
class QRadioButton;
class QLabel;
class QStackedLayout;
DWIDGET_BEGIN_NAMESPACE
class DTipLabel;
DWIDGET_END_NAMESPACE

class RadioItem : public SettingsItem {
    Q_OBJECT
public:
    explicit RadioItem(QWidget* parent = nullptr);

    QRadioButton* radioButton() const;

    void setContent(QWidget* content);

    void setTitle(const QString& title);

    bool checked() const;

    void setChecked(bool check);

    void setRadioVisible(bool visible);
    void setRadioButtonToolTip(const QString& text);
    void setTipText(const QString& text);

    QWidget* getContent() const;
    void setRadioButtonAccessibleName(const QString &name);

private:
    QVBoxLayout* m_layout;
    QRadioButton* m_radioBtn;
    QWidget* m_content;
    Dtk::Widget::DTipLabel* m_tips;
    QVBoxLayout* m_vLayout;
    QWidget* m_radioWidget;
};

#endif // RESTOREITEM_H
