#ifndef UOS_RECOVERY_OSTREE_TASK_H
#define UOS_RECOVERY_OSTREE_TASK_H

#include "AsyncTask.h"
#include <QTimer>
#include <QTime>

class OSTreeTask : public AsyncTask
{
    Q_OBJECT
public:
    OSTreeTask();
    virtual ~OSTreeTask();

    virtual void readStandardOutput() override;
    virtual void readAllStandardError() override;
    virtual bool buildArgumentsForBackup() override;
    virtual bool buildArgumentsForRestore(const QString &) override;
    virtual void doResult() override;

    void init();
    void startTimer();
    void stopTimer();

Q_SIGNALS:
    void progressChanged(const QJsonObject &progress);

private Q_SLOTS:
    void onTimeOut();

private:
    void reportProgress(int progress, int remainSecond);
    void estimateRemainTime();

protected:
    QTimer m_timer;
    QTime m_startTime;
    int m_progress = 0;
    int m_remainSecond = 0;
    bool m_isBegin = false;
};

#endif
