/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.str;

import java.util.function.IntPredicate;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.str.EmptyUnicodeString;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.z.IntIterator;

public class Slice24
extends UnicodeString {
    private final byte[] bytes;
    private final int start;
    private final int end;
    private int cachedHash;

    public Slice24(byte[] bytes, int start, int end) {
        this.bytes = bytes;
        this.start = start;
        this.end = end;
    }

    @Override
    public long length() {
        return this.end - this.start;
    }

    @Override
    public int getWidth() {
        return 24;
    }

    @Override
    public long indexOf(int codePoint, long from) {
        byte b0 = (byte)(codePoint >> 16 & 0xFF);
        byte b1 = (byte)(codePoint >> 8 & 0xFF);
        byte b2 = (byte)(codePoint & 0xFF);
        for (int i = (this.start + Math.max(Slice24.requireInt(from), 0)) * 3; i < this.end * 3; i += 3) {
            if (this.bytes[i + 2] != b2 || this.bytes[i + 1] != b1 || this.bytes[i] != b0) continue;
            return i / 3 - this.start;
        }
        return -1L;
    }

    @Override
    public long indexWhere(IntPredicate predicate, long from) {
        for (int i = (this.start + Slice24.requireInt(from)) * 3; i < this.end * 3; i += 3) {
            int cp = (this.bytes[i] << 16 | (this.bytes[i + 1] & 0xFF) << 8 | this.bytes[i + 2] & 0xFF) & 0xFFFFFF;
            if (!predicate.test(cp)) continue;
            return i / 3 - this.start;
        }
        return -1L;
    }

    @Override
    public int codePointAt(long index) {
        int index32 = Slice24.requireInt(index);
        if (index32 < 0 || index32 >= this.length32()) {
            throw new IndexOutOfBoundsException();
        }
        int offset = (this.start + index32) * 3;
        return (this.bytes[offset] << 16 | (this.bytes[offset + 1] & 0xFF) << 8 | this.bytes[offset + 2] & 0xFF) & 0xFFFFFF;
    }

    @Override
    public UnicodeString substring(long start, long end) {
        this.checkSubstringBounds(start, end);
        if (end == start) {
            return EmptyUnicodeString.getInstance();
        }
        return new Slice24(this.bytes, Slice24.requireInt(start) + this.start, Slice24.requireInt(end) + this.start);
    }

    @Override
    void copy24bit(byte[] target, int offset) {
        System.arraycopy(this.bytes, this.start * 3, target, offset, (this.end - this.start) * 3);
    }

    @Override
    public IntIterator codePoints() {
        return new IntIterator(){
            int i;
            int j;
            {
                this.i = Slice24.this.start * 3;
                this.j = Slice24.this.end * 3;
            }

            @Override
            public boolean hasNext() {
                return this.i < this.j;
            }

            @Override
            public int next() {
                int result = (Slice24.this.bytes[this.i] & 0xFF) << 16 | (Slice24.this.bytes[this.i + 1] & 0xFF) << 8 | Slice24.this.bytes[this.i + 2] & 0xFF;
                this.i += 3;
                return result;
            }
        };
    }

    @Override
    public int hashCode() {
        if (this.cachedHash != 0) {
            return this.cachedHash;
        }
        int h2 = 0;
        for (int i = this.start * 3; i < this.end * 3; i += 3) {
            int cp = (this.bytes[i] << 16 | (this.bytes[i + 1] & 0xFF) << 8 | this.bytes[i + 2] & 0xFF) & 0xFFFFFF;
            if ((cp & 0xFF0000) != 0) {
                h2 = 31 * h2 + UTF16CharacterSet.highSurrogate(cp);
                h2 = 31 * h2 + UTF16CharacterSet.lowSurrogate(cp);
                continue;
            }
            h2 = 31 * h2 + cp;
        }
        this.cachedHash = h2;
        return this.cachedHash;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.length32());
        IntIterator iter = this.codePoints();
        while (iter.hasNext()) {
            int x = iter.next();
            sb.appendCodePoint(x);
        }
        return sb.toString();
    }
}

