/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import java.util.Arrays;
import java.util.List;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.functions.Reverse;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.tree.iter.ReversibleIterator;
import net.sf.saxon.value.SequenceExtent;

public abstract class ArrayIterator
implements SequenceIterator,
LastPositionFinder,
LookaheadIterator,
GroundedIterator,
ReversibleIterator {
    protected int index;
    protected int start;
    protected int end;

    public abstract SequenceIterator makeSliceIterator(int var1, int var2);

    @Override
    public boolean isActuallyGrounded() {
        return true;
    }

    @Override
    public boolean supportsHasNext() {
        return true;
    }

    public static class OfNodes<N extends NodeInfo>
    extends Of<N>
    implements AxisIterator {
        public OfNodes(N[] nodes) {
            super(nodes);
        }

        @Override
        public NodeInfo next() {
            return (NodeInfo)super.next();
        }
    }

    public static class Of<T extends Item>
    extends ArrayIterator {
        protected T[] items;

        public Of(T[] items) {
            this.items = items;
            this.start = 0;
            this.end = items.length;
            this.index = 0;
        }

        public Of(T[] items, int start, int end) {
            this.items = items;
            this.end = end;
            this.start = start;
            this.index = start;
        }

        @Override
        public SequenceIterator makeSliceIterator(int min2, int max) {
            int newEnd;
            int newStart;
            Item[] items = this.getArray();
            int currentStart = this.getStartPosition();
            int currentEnd = this.getEndPosition();
            if (min2 < 1) {
                min2 = 1;
            }
            if ((newStart = currentStart + (min2 - 1)) < currentStart) {
                newStart = currentStart;
            }
            int n = newEnd = max == Integer.MAX_VALUE ? currentEnd : newStart + max - min2 + 1;
            if (newEnd > currentEnd) {
                newEnd = currentEnd;
            }
            if (newEnd <= newStart) {
                return EmptyIterator.emptyIterator();
            }
            return new Of(items, newStart, newEnd);
        }

        @Override
        public boolean hasNext() {
            return this.index < this.end;
        }

        @Override
        public Item next() {
            if (this.index >= this.end) {
                this.index = this.end + 1;
                return null;
            }
            return this.items[this.index++];
        }

        @Override
        public boolean supportsGetLength() {
            return true;
        }

        @Override
        public int getLength() {
            return this.end - this.start;
        }

        public T[] getArray() {
            return this.items;
        }

        public int getStartPosition() {
            return this.start;
        }

        public int getEndPosition() {
            return this.end;
        }

        @Override
        public GroundedValue materialize() {
            SequenceExtent.Of<T> seq;
            if (this.start == 0 && this.end == this.items.length) {
                seq = new SequenceExtent.Of<T>(this.items);
            } else {
                List<T> sublist = Arrays.asList(this.items).subList(this.start, this.end);
                seq = new SequenceExtent.Of<T>(sublist);
            }
            return seq.reduce();
        }

        @Override
        public GroundedValue getResidue() {
            SequenceExtent.Of<T> seq;
            if (this.start == 0 && this.index == 0 && this.end == this.items.length) {
                seq = new SequenceExtent.Of<T>(this.items);
            } else {
                List<T> sublist = Arrays.asList(this.items).subList(this.start + this.index, this.end);
                seq = new SequenceExtent.Of<T>(sublist);
            }
            return seq.reduce();
        }

        @Override
        public SequenceIterator getReverseIterator() {
            if (this.start == 0 && this.end == this.items.length) {
                return Reverse.reverseIterator(Arrays.asList(this.items));
            }
            List<T> sublist = Arrays.asList(this.items).subList(this.start, this.end);
            return Reverse.reverseIterator(sublist);
        }
    }
}

