## Usage

```js
var filter = require('{%= name %}');

filter(['a', {a: 'b'}, 1, 'b', 2, {c: 'd'}, 'c'], function (ele) {
  return typeof ele === 'string';
});
//=> ['a', 'b', 'c']
```

## Why another array filter?

[array-filter](https://github.com/juliangruber/array-filter) is pretty popular, but it's tuned to be used in older browsers and it falls back on native `.filter()` when available, which is much slower. See [jsperf results](http://jsperf.com/array-filter-while-vs-for/2). The functions used in the benchmarks are the top performers from a dozen or so other functions.

