// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{Justification, TextDirection, TextIter, WrapMode};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem::transmute};

glib::wrapper! {
    #[doc(alias = "GtkTextTag")]
    pub struct TextTag(Object<ffi::GtkTextTag, ffi::GtkTextTagClass>);

    match fn {
        type_ => || ffi::gtk_text_tag_get_type(),
    }
}

impl TextTag {
    pub const NONE: Option<&'static TextTag> = None;

    #[doc(alias = "gtk_text_tag_new")]
    pub fn new(name: Option<&str>) -> TextTag {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gtk_text_tag_new(name.to_glib_none().0)) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`TextTag`] objects.
    ///
    /// This method returns an instance of [`TextTagBuilder`](crate::builders::TextTagBuilder) which can be used to create [`TextTag`] objects.
    pub fn builder() -> TextTagBuilder {
        TextTagBuilder::new()
    }
}

impl Default for TextTag {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`TextTag`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct TextTagBuilder {
    builder: glib::object::ObjectBuilder<'static, TextTag>,
}

impl TextTagBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn accumulative_margin(self, accumulative_margin: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("accumulative-margin", accumulative_margin),
        }
    }

    pub fn background(self, background: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("background", background.into()),
        }
    }

    pub fn background_full_height(self, background_full_height: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("background-full-height", background_full_height),
        }
    }

    pub fn background_full_height_set(self, background_full_height_set: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("background-full-height-set", background_full_height_set),
        }
    }

    pub fn background_rgba(self, background_rgba: &gdk::RGBA) -> Self {
        Self {
            builder: self.builder.property("background-rgba", background_rgba),
        }
    }

    pub fn background_set(self, background_set: bool) -> Self {
        Self {
            builder: self.builder.property("background-set", background_set),
        }
    }

    pub fn direction(self, direction: TextDirection) -> Self {
        Self {
            builder: self.builder.property("direction", direction),
        }
    }

    pub fn editable(self, editable: bool) -> Self {
        Self {
            builder: self.builder.property("editable", editable),
        }
    }

    pub fn editable_set(self, editable_set: bool) -> Self {
        Self {
            builder: self.builder.property("editable-set", editable_set),
        }
    }

    pub fn fallback(self, fallback: bool) -> Self {
        Self {
            builder: self.builder.property("fallback", fallback),
        }
    }

    pub fn fallback_set(self, fallback_set: bool) -> Self {
        Self {
            builder: self.builder.property("fallback-set", fallback_set),
        }
    }

    pub fn family(self, family: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("family", family.into()),
        }
    }

    pub fn family_set(self, family_set: bool) -> Self {
        Self {
            builder: self.builder.property("family-set", family_set),
        }
    }

    pub fn font(self, font: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("font", font.into()),
        }
    }

    pub fn font_desc(self, font_desc: &pango::FontDescription) -> Self {
        Self {
            builder: self.builder.property("font-desc", font_desc),
        }
    }

    pub fn font_features(self, font_features: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("font-features", font_features.into()),
        }
    }

    pub fn font_features_set(self, font_features_set: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("font-features-set", font_features_set),
        }
    }

    pub fn foreground(self, foreground: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("foreground", foreground.into()),
        }
    }

    pub fn foreground_rgba(self, foreground_rgba: &gdk::RGBA) -> Self {
        Self {
            builder: self.builder.property("foreground-rgba", foreground_rgba),
        }
    }

    pub fn foreground_set(self, foreground_set: bool) -> Self {
        Self {
            builder: self.builder.property("foreground-set", foreground_set),
        }
    }

    pub fn indent(self, indent: i32) -> Self {
        Self {
            builder: self.builder.property("indent", indent),
        }
    }

    pub fn indent_set(self, indent_set: bool) -> Self {
        Self {
            builder: self.builder.property("indent-set", indent_set),
        }
    }

    pub fn invisible(self, invisible: bool) -> Self {
        Self {
            builder: self.builder.property("invisible", invisible),
        }
    }

    pub fn invisible_set(self, invisible_set: bool) -> Self {
        Self {
            builder: self.builder.property("invisible-set", invisible_set),
        }
    }

    pub fn justification(self, justification: Justification) -> Self {
        Self {
            builder: self.builder.property("justification", justification),
        }
    }

    pub fn justification_set(self, justification_set: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("justification-set", justification_set),
        }
    }

    pub fn language(self, language: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("language", language.into()),
        }
    }

    pub fn language_set(self, language_set: bool) -> Self {
        Self {
            builder: self.builder.property("language-set", language_set),
        }
    }

    pub fn left_margin(self, left_margin: i32) -> Self {
        Self {
            builder: self.builder.property("left-margin", left_margin),
        }
    }

    pub fn left_margin_set(self, left_margin_set: bool) -> Self {
        Self {
            builder: self.builder.property("left-margin-set", left_margin_set),
        }
    }

    pub fn letter_spacing(self, letter_spacing: i32) -> Self {
        Self {
            builder: self.builder.property("letter-spacing", letter_spacing),
        }
    }

    pub fn letter_spacing_set(self, letter_spacing_set: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("letter-spacing-set", letter_spacing_set),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn paragraph_background(self, paragraph_background: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("paragraph-background", paragraph_background.into()),
        }
    }

    pub fn paragraph_background_rgba(self, paragraph_background_rgba: &gdk::RGBA) -> Self {
        Self {
            builder: self
                .builder
                .property("paragraph-background-rgba", paragraph_background_rgba),
        }
    }

    pub fn paragraph_background_set(self, paragraph_background_set: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("paragraph-background-set", paragraph_background_set),
        }
    }

    pub fn pixels_above_lines(self, pixels_above_lines: i32) -> Self {
        Self {
            builder: self
                .builder
                .property("pixels-above-lines", pixels_above_lines),
        }
    }

    pub fn pixels_above_lines_set(self, pixels_above_lines_set: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("pixels-above-lines-set", pixels_above_lines_set),
        }
    }

    pub fn pixels_below_lines(self, pixels_below_lines: i32) -> Self {
        Self {
            builder: self
                .builder
                .property("pixels-below-lines", pixels_below_lines),
        }
    }

    pub fn pixels_below_lines_set(self, pixels_below_lines_set: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("pixels-below-lines-set", pixels_below_lines_set),
        }
    }

    pub fn pixels_inside_wrap(self, pixels_inside_wrap: i32) -> Self {
        Self {
            builder: self
                .builder
                .property("pixels-inside-wrap", pixels_inside_wrap),
        }
    }

    pub fn pixels_inside_wrap_set(self, pixels_inside_wrap_set: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("pixels-inside-wrap-set", pixels_inside_wrap_set),
        }
    }

    pub fn right_margin(self, right_margin: i32) -> Self {
        Self {
            builder: self.builder.property("right-margin", right_margin),
        }
    }

    pub fn right_margin_set(self, right_margin_set: bool) -> Self {
        Self {
            builder: self.builder.property("right-margin-set", right_margin_set),
        }
    }

    pub fn rise(self, rise: i32) -> Self {
        Self {
            builder: self.builder.property("rise", rise),
        }
    }

    pub fn rise_set(self, rise_set: bool) -> Self {
        Self {
            builder: self.builder.property("rise-set", rise_set),
        }
    }

    pub fn scale(self, scale: f64) -> Self {
        Self {
            builder: self.builder.property("scale", scale),
        }
    }

    pub fn scale_set(self, scale_set: bool) -> Self {
        Self {
            builder: self.builder.property("scale-set", scale_set),
        }
    }

    pub fn size(self, size: i32) -> Self {
        Self {
            builder: self.builder.property("size", size),
        }
    }

    pub fn size_points(self, size_points: f64) -> Self {
        Self {
            builder: self.builder.property("size-points", size_points),
        }
    }

    pub fn size_set(self, size_set: bool) -> Self {
        Self {
            builder: self.builder.property("size-set", size_set),
        }
    }

    pub fn stretch(self, stretch: pango::Stretch) -> Self {
        Self {
            builder: self.builder.property("stretch", stretch),
        }
    }

    pub fn stretch_set(self, stretch_set: bool) -> Self {
        Self {
            builder: self.builder.property("stretch-set", stretch_set),
        }
    }

    pub fn strikethrough(self, strikethrough: bool) -> Self {
        Self {
            builder: self.builder.property("strikethrough", strikethrough),
        }
    }

    pub fn strikethrough_rgba(self, strikethrough_rgba: &gdk::RGBA) -> Self {
        Self {
            builder: self
                .builder
                .property("strikethrough-rgba", strikethrough_rgba),
        }
    }

    pub fn strikethrough_rgba_set(self, strikethrough_rgba_set: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("strikethrough-rgba-set", strikethrough_rgba_set),
        }
    }

    pub fn strikethrough_set(self, strikethrough_set: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("strikethrough-set", strikethrough_set),
        }
    }

    pub fn style(self, style: pango::Style) -> Self {
        Self {
            builder: self.builder.property("style", style),
        }
    }

    pub fn style_set(self, style_set: bool) -> Self {
        Self {
            builder: self.builder.property("style-set", style_set),
        }
    }

    pub fn tabs(self, tabs: &pango::TabArray) -> Self {
        Self {
            builder: self.builder.property("tabs", tabs),
        }
    }

    pub fn tabs_set(self, tabs_set: bool) -> Self {
        Self {
            builder: self.builder.property("tabs-set", tabs_set),
        }
    }

    pub fn underline(self, underline: pango::Underline) -> Self {
        Self {
            builder: self.builder.property("underline", underline),
        }
    }

    pub fn underline_rgba(self, underline_rgba: &gdk::RGBA) -> Self {
        Self {
            builder: self.builder.property("underline-rgba", underline_rgba),
        }
    }

    pub fn underline_rgba_set(self, underline_rgba_set: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("underline-rgba-set", underline_rgba_set),
        }
    }

    pub fn underline_set(self, underline_set: bool) -> Self {
        Self {
            builder: self.builder.property("underline-set", underline_set),
        }
    }

    pub fn variant(self, variant: pango::Variant) -> Self {
        Self {
            builder: self.builder.property("variant", variant),
        }
    }

    pub fn variant_set(self, variant_set: bool) -> Self {
        Self {
            builder: self.builder.property("variant-set", variant_set),
        }
    }

    pub fn weight(self, weight: i32) -> Self {
        Self {
            builder: self.builder.property("weight", weight),
        }
    }

    pub fn weight_set(self, weight_set: bool) -> Self {
        Self {
            builder: self.builder.property("weight-set", weight_set),
        }
    }

    pub fn wrap_mode(self, wrap_mode: WrapMode) -> Self {
        Self {
            builder: self.builder.property("wrap-mode", wrap_mode),
        }
    }

    pub fn wrap_mode_set(self, wrap_mode_set: bool) -> Self {
        Self {
            builder: self.builder.property("wrap-mode-set", wrap_mode_set),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`TextTag`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> TextTag {
        self.builder.build()
    }
}

pub trait TextTagExt: 'static {
    #[doc(alias = "gtk_text_tag_changed")]
    fn changed(&self, size_changed: bool);

    #[doc(alias = "gtk_text_tag_event")]
    fn event(
        &self,
        event_object: &impl IsA<glib::Object>,
        event: &gdk::Event,
        iter: &TextIter,
    ) -> bool;

    #[doc(alias = "gtk_text_tag_get_priority")]
    #[doc(alias = "get_priority")]
    fn priority(&self) -> i32;

    #[doc(alias = "gtk_text_tag_set_priority")]
    fn set_priority(&self, priority: i32);

    #[doc(alias = "accumulative-margin")]
    fn is_accumulative_margin(&self) -> bool;

    #[doc(alias = "accumulative-margin")]
    fn set_accumulative_margin(&self, accumulative_margin: bool);

    fn set_background(&self, background: Option<&str>);

    #[doc(alias = "background-full-height")]
    fn is_background_full_height(&self) -> bool;

    #[doc(alias = "background-full-height")]
    fn set_background_full_height(&self, background_full_height: bool);

    #[doc(alias = "background-full-height-set")]
    fn is_background_full_height_set(&self) -> bool;

    #[doc(alias = "background-full-height-set")]
    fn set_background_full_height_set(&self, background_full_height_set: bool);

    #[doc(alias = "background-rgba")]
    fn background_rgba(&self) -> Option<gdk::RGBA>;

    #[doc(alias = "background-rgba")]
    fn set_background_rgba(&self, background_rgba: Option<&gdk::RGBA>);

    #[doc(alias = "background-set")]
    fn is_background_set(&self) -> bool;

    #[doc(alias = "background-set")]
    fn set_background_set(&self, background_set: bool);

    fn direction(&self) -> TextDirection;

    fn set_direction(&self, direction: TextDirection);

    fn is_editable(&self) -> bool;

    fn set_editable(&self, editable: bool);

    #[doc(alias = "editable-set")]
    fn is_editable_set(&self) -> bool;

    #[doc(alias = "editable-set")]
    fn set_editable_set(&self, editable_set: bool);

    fn is_fallback(&self) -> bool;

    fn set_fallback(&self, fallback: bool);

    #[doc(alias = "fallback-set")]
    fn is_fallback_set(&self) -> bool;

    #[doc(alias = "fallback-set")]
    fn set_fallback_set(&self, fallback_set: bool);

    fn family(&self) -> Option<glib::GString>;

    fn set_family(&self, family: Option<&str>);

    #[doc(alias = "family-set")]
    fn is_family_set(&self) -> bool;

    #[doc(alias = "family-set")]
    fn set_family_set(&self, family_set: bool);

    fn font(&self) -> Option<glib::GString>;

    fn set_font(&self, font: Option<&str>);

    #[doc(alias = "font-desc")]
    fn font_desc(&self) -> Option<pango::FontDescription>;

    #[doc(alias = "font-desc")]
    fn set_font_desc(&self, font_desc: Option<&pango::FontDescription>);

    #[doc(alias = "font-features")]
    fn font_features(&self) -> Option<glib::GString>;

    #[doc(alias = "font-features")]
    fn set_font_features(&self, font_features: Option<&str>);

    #[doc(alias = "font-features-set")]
    fn is_font_features_set(&self) -> bool;

    #[doc(alias = "font-features-set")]
    fn set_font_features_set(&self, font_features_set: bool);

    fn set_foreground(&self, foreground: Option<&str>);

    #[doc(alias = "foreground-rgba")]
    fn foreground_rgba(&self) -> Option<gdk::RGBA>;

    #[doc(alias = "foreground-rgba")]
    fn set_foreground_rgba(&self, foreground_rgba: Option<&gdk::RGBA>);

    #[doc(alias = "foreground-set")]
    fn is_foreground_set(&self) -> bool;

    #[doc(alias = "foreground-set")]
    fn set_foreground_set(&self, foreground_set: bool);

    fn indent(&self) -> i32;

    fn set_indent(&self, indent: i32);

    #[doc(alias = "indent-set")]
    fn is_indent_set(&self) -> bool;

    #[doc(alias = "indent-set")]
    fn set_indent_set(&self, indent_set: bool);

    fn is_invisible(&self) -> bool;

    fn set_invisible(&self, invisible: bool);

    #[doc(alias = "invisible-set")]
    fn is_invisible_set(&self) -> bool;

    #[doc(alias = "invisible-set")]
    fn set_invisible_set(&self, invisible_set: bool);

    fn justification(&self) -> Justification;

    fn set_justification(&self, justification: Justification);

    #[doc(alias = "justification-set")]
    fn is_justification_set(&self) -> bool;

    #[doc(alias = "justification-set")]
    fn set_justification_set(&self, justification_set: bool);

    fn language(&self) -> Option<glib::GString>;

    fn set_language(&self, language: Option<&str>);

    #[doc(alias = "language-set")]
    fn is_language_set(&self) -> bool;

    #[doc(alias = "language-set")]
    fn set_language_set(&self, language_set: bool);

    #[doc(alias = "left-margin")]
    fn left_margin(&self) -> i32;

    #[doc(alias = "left-margin")]
    fn set_left_margin(&self, left_margin: i32);

    #[doc(alias = "left-margin-set")]
    fn is_left_margin_set(&self) -> bool;

    #[doc(alias = "left-margin-set")]
    fn set_left_margin_set(&self, left_margin_set: bool);

    #[doc(alias = "letter-spacing")]
    fn letter_spacing(&self) -> i32;

    #[doc(alias = "letter-spacing")]
    fn set_letter_spacing(&self, letter_spacing: i32);

    #[doc(alias = "letter-spacing-set")]
    fn is_letter_spacing_set(&self) -> bool;

    #[doc(alias = "letter-spacing-set")]
    fn set_letter_spacing_set(&self, letter_spacing_set: bool);

    fn name(&self) -> Option<glib::GString>;

    #[doc(alias = "paragraph-background")]
    fn set_paragraph_background(&self, paragraph_background: Option<&str>);

    #[doc(alias = "paragraph-background-rgba")]
    fn paragraph_background_rgba(&self) -> Option<gdk::RGBA>;

    #[doc(alias = "paragraph-background-rgba")]
    fn set_paragraph_background_rgba(&self, paragraph_background_rgba: Option<&gdk::RGBA>);

    #[doc(alias = "paragraph-background-set")]
    fn is_paragraph_background_set(&self) -> bool;

    #[doc(alias = "paragraph-background-set")]
    fn set_paragraph_background_set(&self, paragraph_background_set: bool);

    #[doc(alias = "pixels-above-lines")]
    fn pixels_above_lines(&self) -> i32;

    #[doc(alias = "pixels-above-lines")]
    fn set_pixels_above_lines(&self, pixels_above_lines: i32);

    #[doc(alias = "pixels-above-lines-set")]
    fn is_pixels_above_lines_set(&self) -> bool;

    #[doc(alias = "pixels-above-lines-set")]
    fn set_pixels_above_lines_set(&self, pixels_above_lines_set: bool);

    #[doc(alias = "pixels-below-lines")]
    fn pixels_below_lines(&self) -> i32;

    #[doc(alias = "pixels-below-lines")]
    fn set_pixels_below_lines(&self, pixels_below_lines: i32);

    #[doc(alias = "pixels-below-lines-set")]
    fn is_pixels_below_lines_set(&self) -> bool;

    #[doc(alias = "pixels-below-lines-set")]
    fn set_pixels_below_lines_set(&self, pixels_below_lines_set: bool);

    #[doc(alias = "pixels-inside-wrap")]
    fn pixels_inside_wrap(&self) -> i32;

    #[doc(alias = "pixels-inside-wrap")]
    fn set_pixels_inside_wrap(&self, pixels_inside_wrap: i32);

    #[doc(alias = "pixels-inside-wrap-set")]
    fn is_pixels_inside_wrap_set(&self) -> bool;

    #[doc(alias = "pixels-inside-wrap-set")]
    fn set_pixels_inside_wrap_set(&self, pixels_inside_wrap_set: bool);

    #[doc(alias = "right-margin")]
    fn right_margin(&self) -> i32;

    #[doc(alias = "right-margin")]
    fn set_right_margin(&self, right_margin: i32);

    #[doc(alias = "right-margin-set")]
    fn is_right_margin_set(&self) -> bool;

    #[doc(alias = "right-margin-set")]
    fn set_right_margin_set(&self, right_margin_set: bool);

    fn rise(&self) -> i32;

    fn set_rise(&self, rise: i32);

    #[doc(alias = "rise-set")]
    fn is_rise_set(&self) -> bool;

    #[doc(alias = "rise-set")]
    fn set_rise_set(&self, rise_set: bool);

    fn scale(&self) -> f64;

    fn set_scale(&self, scale: f64);

    #[doc(alias = "scale-set")]
    fn is_scale_set(&self) -> bool;

    #[doc(alias = "scale-set")]
    fn set_scale_set(&self, scale_set: bool);

    fn size(&self) -> i32;

    fn set_size(&self, size: i32);

    #[doc(alias = "size-points")]
    fn size_points(&self) -> f64;

    #[doc(alias = "size-points")]
    fn set_size_points(&self, size_points: f64);

    #[doc(alias = "size-set")]
    fn is_size_set(&self) -> bool;

    #[doc(alias = "size-set")]
    fn set_size_set(&self, size_set: bool);

    fn stretch(&self) -> pango::Stretch;

    fn set_stretch(&self, stretch: pango::Stretch);

    #[doc(alias = "stretch-set")]
    fn is_stretch_set(&self) -> bool;

    #[doc(alias = "stretch-set")]
    fn set_stretch_set(&self, stretch_set: bool);

    fn is_strikethrough(&self) -> bool;

    fn set_strikethrough(&self, strikethrough: bool);

    #[doc(alias = "strikethrough-rgba")]
    fn strikethrough_rgba(&self) -> Option<gdk::RGBA>;

    #[doc(alias = "strikethrough-rgba")]
    fn set_strikethrough_rgba(&self, strikethrough_rgba: Option<&gdk::RGBA>);

    #[doc(alias = "strikethrough-rgba-set")]
    fn is_strikethrough_rgba_set(&self) -> bool;

    #[doc(alias = "strikethrough-rgba-set")]
    fn set_strikethrough_rgba_set(&self, strikethrough_rgba_set: bool);

    #[doc(alias = "strikethrough-set")]
    fn is_strikethrough_set(&self) -> bool;

    #[doc(alias = "strikethrough-set")]
    fn set_strikethrough_set(&self, strikethrough_set: bool);

    fn style(&self) -> pango::Style;

    fn set_style(&self, style: pango::Style);

    #[doc(alias = "style-set")]
    fn is_style_set(&self) -> bool;

    #[doc(alias = "style-set")]
    fn set_style_set(&self, style_set: bool);

    fn tabs(&self) -> Option<pango::TabArray>;

    fn set_tabs(&self, tabs: Option<&pango::TabArray>);

    #[doc(alias = "tabs-set")]
    fn is_tabs_set(&self) -> bool;

    #[doc(alias = "tabs-set")]
    fn set_tabs_set(&self, tabs_set: bool);

    fn underline(&self) -> pango::Underline;

    fn set_underline(&self, underline: pango::Underline);

    #[doc(alias = "underline-rgba")]
    fn underline_rgba(&self) -> Option<gdk::RGBA>;

    #[doc(alias = "underline-rgba")]
    fn set_underline_rgba(&self, underline_rgba: Option<&gdk::RGBA>);

    #[doc(alias = "underline-rgba-set")]
    fn is_underline_rgba_set(&self) -> bool;

    #[doc(alias = "underline-rgba-set")]
    fn set_underline_rgba_set(&self, underline_rgba_set: bool);

    #[doc(alias = "underline-set")]
    fn is_underline_set(&self) -> bool;

    #[doc(alias = "underline-set")]
    fn set_underline_set(&self, underline_set: bool);

    fn variant(&self) -> pango::Variant;

    fn set_variant(&self, variant: pango::Variant);

    #[doc(alias = "variant-set")]
    fn is_variant_set(&self) -> bool;

    #[doc(alias = "variant-set")]
    fn set_variant_set(&self, variant_set: bool);

    fn weight(&self) -> i32;

    fn set_weight(&self, weight: i32);

    #[doc(alias = "weight-set")]
    fn is_weight_set(&self) -> bool;

    #[doc(alias = "weight-set")]
    fn set_weight_set(&self, weight_set: bool);

    #[doc(alias = "wrap-mode")]
    fn wrap_mode(&self) -> WrapMode;

    #[doc(alias = "wrap-mode")]
    fn set_wrap_mode(&self, wrap_mode: WrapMode);

    #[doc(alias = "wrap-mode-set")]
    fn wraps_mode_set(&self) -> bool;

    #[doc(alias = "wrap-mode-set")]
    fn set_wrap_mode_set(&self, wrap_mode_set: bool);

    #[doc(alias = "event")]
    fn connect_event<
        F: Fn(&Self, &glib::Object, &gdk::Event, &TextIter) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "accumulative-margin")]
    fn connect_accumulative_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "background")]
    fn connect_background_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "background-full-height")]
    fn connect_background_full_height_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "background-full-height-set")]
    fn connect_background_full_height_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "background-rgba")]
    fn connect_background_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "background-set")]
    fn connect_background_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "direction")]
    fn connect_direction_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "editable")]
    fn connect_editable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "editable-set")]
    fn connect_editable_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "fallback")]
    fn connect_fallback_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "fallback-set")]
    fn connect_fallback_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "family")]
    fn connect_family_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "family-set")]
    fn connect_family_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "font")]
    fn connect_font_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "font-desc")]
    fn connect_font_desc_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "font-features")]
    fn connect_font_features_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "font-features-set")]
    fn connect_font_features_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "foreground")]
    fn connect_foreground_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "foreground-rgba")]
    fn connect_foreground_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "foreground-set")]
    fn connect_foreground_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "indent")]
    fn connect_indent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "indent-set")]
    fn connect_indent_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "invisible")]
    fn connect_invisible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "invisible-set")]
    fn connect_invisible_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "justification")]
    fn connect_justification_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "justification-set")]
    fn connect_justification_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "language")]
    fn connect_language_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "language-set")]
    fn connect_language_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "left-margin")]
    fn connect_left_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "left-margin-set")]
    fn connect_left_margin_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "letter-spacing")]
    fn connect_letter_spacing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "letter-spacing-set")]
    fn connect_letter_spacing_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "paragraph-background")]
    fn connect_paragraph_background_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "paragraph-background-rgba")]
    fn connect_paragraph_background_rgba_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "paragraph-background-set")]
    fn connect_paragraph_background_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "pixels-above-lines")]
    fn connect_pixels_above_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "pixels-above-lines-set")]
    fn connect_pixels_above_lines_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "pixels-below-lines")]
    fn connect_pixels_below_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "pixels-below-lines-set")]
    fn connect_pixels_below_lines_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "pixels-inside-wrap")]
    fn connect_pixels_inside_wrap_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "pixels-inside-wrap-set")]
    fn connect_pixels_inside_wrap_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "right-margin")]
    fn connect_right_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "right-margin-set")]
    fn connect_right_margin_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "rise")]
    fn connect_rise_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "rise-set")]
    fn connect_rise_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "scale")]
    fn connect_scale_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "scale-set")]
    fn connect_scale_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "size")]
    fn connect_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "size-points")]
    fn connect_size_points_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "size-set")]
    fn connect_size_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "stretch")]
    fn connect_stretch_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "stretch-set")]
    fn connect_stretch_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "strikethrough")]
    fn connect_strikethrough_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "strikethrough-rgba")]
    fn connect_strikethrough_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "strikethrough-rgba-set")]
    fn connect_strikethrough_rgba_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "strikethrough-set")]
    fn connect_strikethrough_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "style")]
    fn connect_style_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "style-set")]
    fn connect_style_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "tabs")]
    fn connect_tabs_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "tabs-set")]
    fn connect_tabs_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "underline")]
    fn connect_underline_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "underline-rgba")]
    fn connect_underline_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "underline-rgba-set")]
    fn connect_underline_rgba_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "underline-set")]
    fn connect_underline_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "variant")]
    fn connect_variant_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "variant-set")]
    fn connect_variant_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "weight")]
    fn connect_weight_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "weight-set")]
    fn connect_weight_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "wrap-mode")]
    fn connect_wrap_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "wrap-mode-set")]
    fn connect_wrap_mode_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<TextTag>> TextTagExt for O {
    fn changed(&self, size_changed: bool) {
        unsafe {
            ffi::gtk_text_tag_changed(self.as_ref().to_glib_none().0, size_changed.into_glib());
        }
    }

    fn event(
        &self,
        event_object: &impl IsA<glib::Object>,
        event: &gdk::Event,
        iter: &TextIter,
    ) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_tag_event(
                self.as_ref().to_glib_none().0,
                event_object.as_ref().to_glib_none().0,
                mut_override(event.to_glib_none().0),
                iter.to_glib_none().0,
            ))
        }
    }

    fn priority(&self) -> i32 {
        unsafe { ffi::gtk_text_tag_get_priority(self.as_ref().to_glib_none().0) }
    }

    fn set_priority(&self, priority: i32) {
        unsafe {
            ffi::gtk_text_tag_set_priority(self.as_ref().to_glib_none().0, priority);
        }
    }

    fn is_accumulative_margin(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "accumulative-margin")
    }

    fn set_accumulative_margin(&self, accumulative_margin: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "accumulative-margin", accumulative_margin)
    }

    fn set_background(&self, background: Option<&str>) {
        glib::ObjectExt::set_property(self.as_ref(), "background", background)
    }

    fn is_background_full_height(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "background-full-height")
    }

    fn set_background_full_height(&self, background_full_height: bool) {
        glib::ObjectExt::set_property(
            self.as_ref(),
            "background-full-height",
            background_full_height,
        )
    }

    fn is_background_full_height_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "background-full-height-set")
    }

    fn set_background_full_height_set(&self, background_full_height_set: bool) {
        glib::ObjectExt::set_property(
            self.as_ref(),
            "background-full-height-set",
            background_full_height_set,
        )
    }

    fn background_rgba(&self) -> Option<gdk::RGBA> {
        glib::ObjectExt::property(self.as_ref(), "background-rgba")
    }

    fn set_background_rgba(&self, background_rgba: Option<&gdk::RGBA>) {
        glib::ObjectExt::set_property(self.as_ref(), "background-rgba", background_rgba)
    }

    fn is_background_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "background-set")
    }

    fn set_background_set(&self, background_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "background-set", background_set)
    }

    fn direction(&self) -> TextDirection {
        glib::ObjectExt::property(self.as_ref(), "direction")
    }

    fn set_direction(&self, direction: TextDirection) {
        glib::ObjectExt::set_property(self.as_ref(), "direction", direction)
    }

    fn is_editable(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "editable")
    }

    fn set_editable(&self, editable: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "editable", editable)
    }

    fn is_editable_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "editable-set")
    }

    fn set_editable_set(&self, editable_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "editable-set", editable_set)
    }

    fn is_fallback(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "fallback")
    }

    fn set_fallback(&self, fallback: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "fallback", fallback)
    }

    fn is_fallback_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "fallback-set")
    }

    fn set_fallback_set(&self, fallback_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "fallback-set", fallback_set)
    }

    fn family(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self.as_ref(), "family")
    }

    fn set_family(&self, family: Option<&str>) {
        glib::ObjectExt::set_property(self.as_ref(), "family", family)
    }

    fn is_family_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "family-set")
    }

    fn set_family_set(&self, family_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "family-set", family_set)
    }

    fn font(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self.as_ref(), "font")
    }

    fn set_font(&self, font: Option<&str>) {
        glib::ObjectExt::set_property(self.as_ref(), "font", font)
    }

    fn font_desc(&self) -> Option<pango::FontDescription> {
        glib::ObjectExt::property(self.as_ref(), "font-desc")
    }

    fn set_font_desc(&self, font_desc: Option<&pango::FontDescription>) {
        glib::ObjectExt::set_property(self.as_ref(), "font-desc", font_desc)
    }

    fn font_features(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self.as_ref(), "font-features")
    }

    fn set_font_features(&self, font_features: Option<&str>) {
        glib::ObjectExt::set_property(self.as_ref(), "font-features", font_features)
    }

    fn is_font_features_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "font-features-set")
    }

    fn set_font_features_set(&self, font_features_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "font-features-set", font_features_set)
    }

    fn set_foreground(&self, foreground: Option<&str>) {
        glib::ObjectExt::set_property(self.as_ref(), "foreground", foreground)
    }

    fn foreground_rgba(&self) -> Option<gdk::RGBA> {
        glib::ObjectExt::property(self.as_ref(), "foreground-rgba")
    }

    fn set_foreground_rgba(&self, foreground_rgba: Option<&gdk::RGBA>) {
        glib::ObjectExt::set_property(self.as_ref(), "foreground-rgba", foreground_rgba)
    }

    fn is_foreground_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "foreground-set")
    }

    fn set_foreground_set(&self, foreground_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "foreground-set", foreground_set)
    }

    fn indent(&self) -> i32 {
        glib::ObjectExt::property(self.as_ref(), "indent")
    }

    fn set_indent(&self, indent: i32) {
        glib::ObjectExt::set_property(self.as_ref(), "indent", indent)
    }

    fn is_indent_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "indent-set")
    }

    fn set_indent_set(&self, indent_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "indent-set", indent_set)
    }

    fn is_invisible(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "invisible")
    }

    fn set_invisible(&self, invisible: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "invisible", invisible)
    }

    fn is_invisible_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "invisible-set")
    }

    fn set_invisible_set(&self, invisible_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "invisible-set", invisible_set)
    }

    fn justification(&self) -> Justification {
        glib::ObjectExt::property(self.as_ref(), "justification")
    }

    fn set_justification(&self, justification: Justification) {
        glib::ObjectExt::set_property(self.as_ref(), "justification", justification)
    }

    fn is_justification_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "justification-set")
    }

    fn set_justification_set(&self, justification_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "justification-set", justification_set)
    }

    fn language(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self.as_ref(), "language")
    }

    fn set_language(&self, language: Option<&str>) {
        glib::ObjectExt::set_property(self.as_ref(), "language", language)
    }

    fn is_language_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "language-set")
    }

    fn set_language_set(&self, language_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "language-set", language_set)
    }

    fn left_margin(&self) -> i32 {
        glib::ObjectExt::property(self.as_ref(), "left-margin")
    }

    fn set_left_margin(&self, left_margin: i32) {
        glib::ObjectExt::set_property(self.as_ref(), "left-margin", left_margin)
    }

    fn is_left_margin_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "left-margin-set")
    }

    fn set_left_margin_set(&self, left_margin_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "left-margin-set", left_margin_set)
    }

    fn letter_spacing(&self) -> i32 {
        glib::ObjectExt::property(self.as_ref(), "letter-spacing")
    }

    fn set_letter_spacing(&self, letter_spacing: i32) {
        glib::ObjectExt::set_property(self.as_ref(), "letter-spacing", letter_spacing)
    }

    fn is_letter_spacing_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "letter-spacing-set")
    }

    fn set_letter_spacing_set(&self, letter_spacing_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "letter-spacing-set", letter_spacing_set)
    }

    fn name(&self) -> Option<glib::GString> {
        glib::ObjectExt::property(self.as_ref(), "name")
    }

    fn set_paragraph_background(&self, paragraph_background: Option<&str>) {
        glib::ObjectExt::set_property(self.as_ref(), "paragraph-background", paragraph_background)
    }

    fn paragraph_background_rgba(&self) -> Option<gdk::RGBA> {
        glib::ObjectExt::property(self.as_ref(), "paragraph-background-rgba")
    }

    fn set_paragraph_background_rgba(&self, paragraph_background_rgba: Option<&gdk::RGBA>) {
        glib::ObjectExt::set_property(
            self.as_ref(),
            "paragraph-background-rgba",
            paragraph_background_rgba,
        )
    }

    fn is_paragraph_background_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "paragraph-background-set")
    }

    fn set_paragraph_background_set(&self, paragraph_background_set: bool) {
        glib::ObjectExt::set_property(
            self.as_ref(),
            "paragraph-background-set",
            paragraph_background_set,
        )
    }

    fn pixels_above_lines(&self) -> i32 {
        glib::ObjectExt::property(self.as_ref(), "pixels-above-lines")
    }

    fn set_pixels_above_lines(&self, pixels_above_lines: i32) {
        glib::ObjectExt::set_property(self.as_ref(), "pixels-above-lines", pixels_above_lines)
    }

    fn is_pixels_above_lines_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "pixels-above-lines-set")
    }

    fn set_pixels_above_lines_set(&self, pixels_above_lines_set: bool) {
        glib::ObjectExt::set_property(
            self.as_ref(),
            "pixels-above-lines-set",
            pixels_above_lines_set,
        )
    }

    fn pixels_below_lines(&self) -> i32 {
        glib::ObjectExt::property(self.as_ref(), "pixels-below-lines")
    }

    fn set_pixels_below_lines(&self, pixels_below_lines: i32) {
        glib::ObjectExt::set_property(self.as_ref(), "pixels-below-lines", pixels_below_lines)
    }

    fn is_pixels_below_lines_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "pixels-below-lines-set")
    }

    fn set_pixels_below_lines_set(&self, pixels_below_lines_set: bool) {
        glib::ObjectExt::set_property(
            self.as_ref(),
            "pixels-below-lines-set",
            pixels_below_lines_set,
        )
    }

    fn pixels_inside_wrap(&self) -> i32 {
        glib::ObjectExt::property(self.as_ref(), "pixels-inside-wrap")
    }

    fn set_pixels_inside_wrap(&self, pixels_inside_wrap: i32) {
        glib::ObjectExt::set_property(self.as_ref(), "pixels-inside-wrap", pixels_inside_wrap)
    }

    fn is_pixels_inside_wrap_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "pixels-inside-wrap-set")
    }

    fn set_pixels_inside_wrap_set(&self, pixels_inside_wrap_set: bool) {
        glib::ObjectExt::set_property(
            self.as_ref(),
            "pixels-inside-wrap-set",
            pixels_inside_wrap_set,
        )
    }

    fn right_margin(&self) -> i32 {
        glib::ObjectExt::property(self.as_ref(), "right-margin")
    }

    fn set_right_margin(&self, right_margin: i32) {
        glib::ObjectExt::set_property(self.as_ref(), "right-margin", right_margin)
    }

    fn is_right_margin_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "right-margin-set")
    }

    fn set_right_margin_set(&self, right_margin_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "right-margin-set", right_margin_set)
    }

    fn rise(&self) -> i32 {
        glib::ObjectExt::property(self.as_ref(), "rise")
    }

    fn set_rise(&self, rise: i32) {
        glib::ObjectExt::set_property(self.as_ref(), "rise", rise)
    }

    fn is_rise_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "rise-set")
    }

    fn set_rise_set(&self, rise_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "rise-set", rise_set)
    }

    fn scale(&self) -> f64 {
        glib::ObjectExt::property(self.as_ref(), "scale")
    }

    fn set_scale(&self, scale: f64) {
        glib::ObjectExt::set_property(self.as_ref(), "scale", scale)
    }

    fn is_scale_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "scale-set")
    }

    fn set_scale_set(&self, scale_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "scale-set", scale_set)
    }

    fn size(&self) -> i32 {
        glib::ObjectExt::property(self.as_ref(), "size")
    }

    fn set_size(&self, size: i32) {
        glib::ObjectExt::set_property(self.as_ref(), "size", size)
    }

    fn size_points(&self) -> f64 {
        glib::ObjectExt::property(self.as_ref(), "size-points")
    }

    fn set_size_points(&self, size_points: f64) {
        glib::ObjectExt::set_property(self.as_ref(), "size-points", size_points)
    }

    fn is_size_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "size-set")
    }

    fn set_size_set(&self, size_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "size-set", size_set)
    }

    fn stretch(&self) -> pango::Stretch {
        glib::ObjectExt::property(self.as_ref(), "stretch")
    }

    fn set_stretch(&self, stretch: pango::Stretch) {
        glib::ObjectExt::set_property(self.as_ref(), "stretch", stretch)
    }

    fn is_stretch_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "stretch-set")
    }

    fn set_stretch_set(&self, stretch_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "stretch-set", stretch_set)
    }

    fn is_strikethrough(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "strikethrough")
    }

    fn set_strikethrough(&self, strikethrough: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "strikethrough", strikethrough)
    }

    fn strikethrough_rgba(&self) -> Option<gdk::RGBA> {
        glib::ObjectExt::property(self.as_ref(), "strikethrough-rgba")
    }

    fn set_strikethrough_rgba(&self, strikethrough_rgba: Option<&gdk::RGBA>) {
        glib::ObjectExt::set_property(self.as_ref(), "strikethrough-rgba", strikethrough_rgba)
    }

    fn is_strikethrough_rgba_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "strikethrough-rgba-set")
    }

    fn set_strikethrough_rgba_set(&self, strikethrough_rgba_set: bool) {
        glib::ObjectExt::set_property(
            self.as_ref(),
            "strikethrough-rgba-set",
            strikethrough_rgba_set,
        )
    }

    fn is_strikethrough_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "strikethrough-set")
    }

    fn set_strikethrough_set(&self, strikethrough_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "strikethrough-set", strikethrough_set)
    }

    fn style(&self) -> pango::Style {
        glib::ObjectExt::property(self.as_ref(), "style")
    }

    fn set_style(&self, style: pango::Style) {
        glib::ObjectExt::set_property(self.as_ref(), "style", style)
    }

    fn is_style_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "style-set")
    }

    fn set_style_set(&self, style_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "style-set", style_set)
    }

    fn tabs(&self) -> Option<pango::TabArray> {
        glib::ObjectExt::property(self.as_ref(), "tabs")
    }

    fn set_tabs(&self, tabs: Option<&pango::TabArray>) {
        glib::ObjectExt::set_property(self.as_ref(), "tabs", tabs)
    }

    fn is_tabs_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "tabs-set")
    }

    fn set_tabs_set(&self, tabs_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "tabs-set", tabs_set)
    }

    fn underline(&self) -> pango::Underline {
        glib::ObjectExt::property(self.as_ref(), "underline")
    }

    fn set_underline(&self, underline: pango::Underline) {
        glib::ObjectExt::set_property(self.as_ref(), "underline", underline)
    }

    fn underline_rgba(&self) -> Option<gdk::RGBA> {
        glib::ObjectExt::property(self.as_ref(), "underline-rgba")
    }

    fn set_underline_rgba(&self, underline_rgba: Option<&gdk::RGBA>) {
        glib::ObjectExt::set_property(self.as_ref(), "underline-rgba", underline_rgba)
    }

    fn is_underline_rgba_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "underline-rgba-set")
    }

    fn set_underline_rgba_set(&self, underline_rgba_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "underline-rgba-set", underline_rgba_set)
    }

    fn is_underline_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "underline-set")
    }

    fn set_underline_set(&self, underline_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "underline-set", underline_set)
    }

    fn variant(&self) -> pango::Variant {
        glib::ObjectExt::property(self.as_ref(), "variant")
    }

    fn set_variant(&self, variant: pango::Variant) {
        glib::ObjectExt::set_property(self.as_ref(), "variant", variant)
    }

    fn is_variant_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "variant-set")
    }

    fn set_variant_set(&self, variant_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "variant-set", variant_set)
    }

    fn weight(&self) -> i32 {
        glib::ObjectExt::property(self.as_ref(), "weight")
    }

    fn set_weight(&self, weight: i32) {
        glib::ObjectExt::set_property(self.as_ref(), "weight", weight)
    }

    fn is_weight_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "weight-set")
    }

    fn set_weight_set(&self, weight_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "weight-set", weight_set)
    }

    fn wrap_mode(&self) -> WrapMode {
        glib::ObjectExt::property(self.as_ref(), "wrap-mode")
    }

    fn set_wrap_mode(&self, wrap_mode: WrapMode) {
        glib::ObjectExt::set_property(self.as_ref(), "wrap-mode", wrap_mode)
    }

    fn wraps_mode_set(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "wrap-mode-set")
    }

    fn set_wrap_mode_set(&self, wrap_mode_set: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "wrap-mode-set", wrap_mode_set)
    }

    fn connect_event<
        F: Fn(&Self, &glib::Object, &gdk::Event, &TextIter) -> glib::signal::Inhibit + 'static,
    >(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn event_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P, &glib::Object, &gdk::Event, &TextIter) -> glib::signal::Inhibit + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            object: *mut glib::gobject_ffi::GObject,
            event: *mut gdk::ffi::GdkEvent,
            iter: *mut ffi::GtkTextIter,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(
                TextTag::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(object),
                &from_glib_none(event),
                &from_glib_borrow(iter),
            )
            .into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"event\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    event_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_accumulative_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_accumulative_margin_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::accumulative-margin\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_accumulative_margin_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_background_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_background_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::background\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_background_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_background_full_height_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_background_full_height_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::background-full-height\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_background_full_height_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_background_full_height_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_background_full_height_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::background-full-height-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_background_full_height_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_background_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_background_rgba_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::background-rgba\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_background_rgba_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_background_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_background_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::background-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_background_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_direction_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_direction_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::direction\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_direction_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_editable_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_editable_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::editable\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_editable_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_editable_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_editable_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::editable-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_editable_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_fallback_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_fallback_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::fallback\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_fallback_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_fallback_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_fallback_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::fallback-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_fallback_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_family_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_family_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::family\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_family_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_family_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_family_set_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::family-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_family_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_font_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_font_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::font\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_font_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_font_desc_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_font_desc_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::font-desc\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_font_desc_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_font_features_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_font_features_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::font-features\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_font_features_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_font_features_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_font_features_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::font-features-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_font_features_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_foreground_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_foreground_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::foreground\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_foreground_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_foreground_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_foreground_rgba_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::foreground-rgba\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_foreground_rgba_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_foreground_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_foreground_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::foreground-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_foreground_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_indent_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_indent_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::indent\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_indent_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_indent_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_indent_set_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::indent-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_indent_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_invisible_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_invisible_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::invisible\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_invisible_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_invisible_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_invisible_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::invisible-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_invisible_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_justification_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_justification_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::justification\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_justification_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_justification_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_justification_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::justification-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_justification_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_language_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_language_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::language\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_language_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_language_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_language_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::language-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_language_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_left_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_left_margin_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::left-margin\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_left_margin_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_left_margin_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_left_margin_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::left-margin-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_left_margin_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_letter_spacing_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_letter_spacing_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::letter-spacing\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_letter_spacing_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_letter_spacing_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_letter_spacing_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::letter-spacing-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_letter_spacing_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_paragraph_background_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_paragraph_background_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::paragraph-background\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_paragraph_background_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_paragraph_background_rgba_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_paragraph_background_rgba_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::paragraph-background-rgba\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_paragraph_background_rgba_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_paragraph_background_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_paragraph_background_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::paragraph-background-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_paragraph_background_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_pixels_above_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_pixels_above_lines_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pixels-above-lines\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pixels_above_lines_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_pixels_above_lines_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_pixels_above_lines_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pixels-above-lines-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pixels_above_lines_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_pixels_below_lines_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_pixels_below_lines_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pixels-below-lines\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pixels_below_lines_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_pixels_below_lines_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_pixels_below_lines_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pixels-below-lines-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pixels_below_lines_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_pixels_inside_wrap_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_pixels_inside_wrap_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pixels-inside-wrap\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pixels_inside_wrap_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_pixels_inside_wrap_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_pixels_inside_wrap_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::pixels-inside-wrap-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_pixels_inside_wrap_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_right_margin_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_right_margin_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::right-margin\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_right_margin_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_right_margin_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_right_margin_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::right-margin-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_right_margin_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_rise_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_rise_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::rise\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_rise_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_rise_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_rise_set_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::rise-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_rise_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_scale_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scale_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::scale\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_scale_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_scale_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scale_set_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::scale-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_scale_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_size_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::size\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_size_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_size_points_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_size_points_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::size-points\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_size_points_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_size_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_size_set_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::size-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_size_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_stretch_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_stretch_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::stretch\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_stretch_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_stretch_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_stretch_set_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::stretch-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_stretch_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_strikethrough_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_strikethrough_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::strikethrough\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_strikethrough_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_strikethrough_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_strikethrough_rgba_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::strikethrough-rgba\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_strikethrough_rgba_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_strikethrough_rgba_set_notify<F: Fn(&Self) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn notify_strikethrough_rgba_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::strikethrough-rgba-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_strikethrough_rgba_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_strikethrough_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_strikethrough_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::strikethrough-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_strikethrough_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_style_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_style_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::style\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_style_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_style_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_style_set_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::style-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_style_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_tabs_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tabs_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tabs\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tabs_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_tabs_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tabs_set_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tabs-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tabs_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_underline_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_underline_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::underline\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_underline_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_underline_rgba_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_underline_rgba_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::underline-rgba\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_underline_rgba_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_underline_rgba_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_underline_rgba_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::underline-rgba-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_underline_rgba_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_underline_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_underline_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::underline-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_underline_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_variant_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_variant_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::variant\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_variant_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_variant_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_variant_set_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::variant-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_variant_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_weight_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_weight_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::weight\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_weight_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_weight_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_weight_set_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::weight-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_weight_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_wrap_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_wrap_mode_trampoline<P: IsA<TextTag>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::wrap-mode\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_wrap_mode_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_wrap_mode_set_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_wrap_mode_set_trampoline<
            P: IsA<TextTag>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextTag,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextTag::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::wrap-mode-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_wrap_mode_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for TextTag {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("TextTag")
    }
}
