# E.1 What are the root causes of our ecological problems?

The dangers associated with environmental damage have become better known over
the last few decades. In fact, awareness of the crisis we face has entered
into the mainstream of politics. Those who assert that environmental problems
are minor or non-existent have, thankfully, become marginalised (effectively,
a few cranks and so-called "scientists" funded by corporations and right-wing
think tanks). Both politicians and corporations have been keen to announce
their "green" credentials. Which is ironic, as anarchists would argue that
both the state and capitalism are key causes for the environmental problems we
are facing.

In other words, anarchists argue that pollution and the other environmental
problems we face are symptoms. The disease itself is deeply imbedded in the
system we live under and need to be addressed alongside treating the more
obvious results of that deeper cause. Otherwise, to try and eliminate the
symptoms **by themselves** can be little more than a minor palliative and,
fundamentally, pointless as they will simply keep reappearing until their root
causes are eliminated.

For anarchists, as we noted in [section A.3.3](secA3.md#seca33), the root
causes for our ecological problems lie in social problems. Bookchin uses the
terms _"first nature"_ and _"second nature"_ to express this idea. First
nature is the environment while second nature is humanity. The latter can
shape and influence the former, for the worse or for the better. How it does
so depends on how it treats itself. A decent, sane and egalitarian society
will treat the environment it inhabits in a decent, sane and respective way. A
society marked by inequality, hierarchies and exploitation will trend its
environment as its members treat each other. Thus _"all our notions of
dominating nature stem from the very real domination of human by human."_ The
_"domination of human by human **preceded** the notion of dominating nature.
Indeed, human domination of human gave rise to the very **idea** of dominating
nature."_ This means, obviously, that _"it is not until we eliminate
domination in all its forms . . . that we will really create a rational,
ecological society."_ [**Remaking Society**, p. 44]

By degrading ourselves, we create the potential for degrading our environment.
This means that anarchists _"emphasise that ecological degradation is, in
great part, a product of the degradation of human beings by hunger, material
insecurity, class rule, hierarchical domination, patriarchy, ethnic
discrimination, and competition."_ [Bookchin, _"The Future of the Ecology
Movement,"_ pp. 1-20, **Which Way for the Ecology Movement?**, p. 17] This is
unsurprising, for _"nature, as every materialist knows, is not something
merely external to humanity. We are a part of nature. Consequently, in
dominating nature we not only dominate an 'external world' -- we also dominate
ourselves."_ [John Clark, **The Anarchist Moment**, p. 114]

We cannot stress how important this analysis is. We cannot ignore _"the deep-
seated division in society that came into existence with hierarchies and
classes."_ To do so means placing _"young people and old, women and men, poor
and rich, exploited and exploiters, people of colour and whites **all** on a
par that stands completely at odds with social reality. Everyone, in turn,
despite the different burdens he or she is obliged to bear, is given the same
responsibility for the ills of our planet. Be they starving Ethiopian children
or corporate barons, all people are held to be equally culpable in producing
present ecological problems."_ These become _"**de-socialised**"_ and so this
perspective _"side-step[s] the profoundly social roots of present-day
ecological dislocations"_ and _"**deflects** innumerable people from engaging
in a practice that could yield effective social change."_ It _"easily plays
into the hands of a privileged stratum who are only too eager to blame all the
human victims of an exploitative society for the social and ecological ills of
our time."_ [**The Ecology of Freedom**, p. 33]

Thus, for eco-anarchists, hierarchy is the fundamental root cause of our
ecological problems. Hierarchy, notes Bookchin includes economic class _"and
even gives rise to class society historically"_ but it _"goes beyond this
limited meaning imputed to a largely economic form of stratification."_ It
refers to a system of _"command and obedience in which elites enjoy varying
degrees of control over their subordinates without necessarily exploiting
them."_ [**Ecology of Freedom**, p. 68] Anarchism, he stressed, _"anchored
ecological problems for the first time in hierarchy, not simply in economic
classes."_ [**Remaking Society**, p. 155]

Needless to say, the forms of hierarchy have changed and evolved over the
years. The anarchist analysis of hierarchies goes _"well beyond economic forms
of exploitation into cultural forms of domination that exist in the family,
between generations and sexes, among ethnic groups, in institutions of
political, economic, and social management, and very significantly, in the way
we experience reality as a whole, including nature and non-human life-forms."_
[**Op. Cit.**, p. 46] This means that anarchists recognise that ecological
destruction has existed in most human societies and is not limited just to
capitalism. It existed, to some degree, in all hierarchical pre-capitalist
societies and, of course, in any hierarchical post-capitalist ones as well.
However, as most of us live under capitalism today, anarchists concentrate our
analysis to that system and seek to change it. Anarchists stress the need to
end capitalism simply because of its inherently anti-ecological nature (_"The
history of 'civilisation' has been a steady process of estrangement from
nature that has increasingly developed into outright antagonism."_). Our
society faces _"a breakdown not only of its values and institutions, but also
of its natural environment. This problem is not unique to our times"_ but
previous environmental destruction _"pales before the massive destruction of
the environment that has occurred since the days of the Industrial Revolution,
and especially since the end of the Second World War. The damage inflicted on
the environment by contemporary society encompasses the entire world . . . The
exploitation and pollution of the earth has damaged not only the integrity of
the atmosphere, climate, water resources, soil, flora and fauna of specific
regions, but also the basic natural cycles on which all living things
depend."_ [Bookchin, **Ecology of Freedom**, p. 411 and p. 83]

This has its roots in the "grow-or-die" nature of capitalism we discussed in
[section D.4](secD4.md). An ever-expanding capitalism must inevitably come
into collision with a finite planet and its fragile ecology. Firms whose aim
is to maximise their profits in order to grow will happily exploit whoever and
whatever they can to do so. As capitalism is based on exploiting people, can
we doubt that it will also exploit nature? It is unsurprising, therefore, that
this system results in the exploitation of the real sources of wealth, namely
nature and people. It is as much about robbing nature as it is about robbing
the worker. To quote Murray Bookchin:

> _ "Any attempt to solve the ecological crisis within a bourgeois framework
must be dismissed as chimerical. Capitalism is inherently anti-ecological.
Competition and accumulation constitute its very law of life, a law . . .
summarised in the phrase, 'production for the sake of production.' Anything,
however hallowed or rare, 'has its price' and is fair game for the
marketplace. In a society of this kind, nature is necessarily treated as a
mere resource to be plundered and exploited. The destruction of the natural
world, far being the result of mere hubristic blunders, follows inexorably
from the very logic of capitalist production."_ [**Post-Scarcity Anarchism**,
pp. viii-ix]

So, in a large part, environmental problems derive from the fact that
capitalism is a competitive economy, guided by the maxim "grow or die." This
is its very law of life for unless a firm expands, it will be driven out of
business or taken over by a competitor. Hence the capitalist economy is based
on a process of growth and production for their own sake. _"No amount of
moralising or pietising,"_ stresses Bookchin, _"can alter the fact that
rivalry at the most molecular base of society is a bourgeois law of life . . .
Accumulation to undermine, buy out, or otherwise absorb or outwit a competitor
**is a condition for existence in a capitalist economic order.**"_ This means
_"a capitalistic society based on competition and growth for its own sake must
ultimately devour the natural world, just like an untreated cancer must
ultimately devour its host. Personal intentions, be they good or bad, have
little to do with this unrelenting process. An economy that is structured
around the maxim, 'Grow or Die,' must **necessarily** pit itself against the
natural world and leave ecological ruin in its wake as its works it way
through the biosphere."_ [**Remaking Society**, p. 93 and p. 15]

This means that good intentions and ideals have no bearing on the survival of
a capitalist enterprise. There is a very simple way to be "moral" in the
capitalist economy: namely, to commit economic suicide. This helps explain
another key anti-ecological tendency within capitalism, namely the drive to
externalise costs of production (i.e., pass them on to the community at large)
in order to minimise private costs and so maximise profits and so growth. As
we will discuss in more detail in [section E.3](secE3.md), capitalism has an
in-built tendency to externalise costs in the form of pollution as it rewards
the kind of short-term perspective that pollutes the planet in order to
maximise the profits of the capitalist. This is also driven by the fact that
capitalism's need to expand also reduces decision making from the quantitative
to the qualitative. In other words, whether something produces a short-term
profit is the guiding maxim of decision making and the price mechanism itself
suppresses the kind of information required to make ecologically informed
decisions.

As Bookchin summarises, capitalism _"has made social evolution hopelessly
incompatible with ecological evolution."_ [**Ecology of Freedom**, p. 14] It
lacks a sustainable relation to nature not due to chance, ignorance or bad
intentions but due to its very nature and workings.

Fortunately, as we discussed in [section D.1](secD1.md), capitalism has
rarely been allowed to operate for long entirely on its own logic. When it
does, counter-tendencies develop to stop society being destroyed by market
forces and the need to accumulate money. Opposition forces always emerge,
whether these are in the form of state intervention or in social movements
aiming for reforms or more radical social change (the former tends to be the
result of the latter, but not always). Both force capitalism to moderate its
worst tendencies.

However, state intervention is, at best, a short-term. This is because the
state is just as much a system of social domination, oppression and
exploitation as capitalism. Which brings us to the next key institution which
anarchists argue needs to be eliminated in order to create an ecological
society: the state. If, as anarchists argue, the oppression of people is the
fundamental reason for our ecological problems then it logically follows that
the state **cannot** be used to either create and manage an ecological
society. It is a hierarchical, centralised, top-down organisation based on the
use of coercion to maintain elite rule. It is, as we stressed in [section
B.2](secB2.md), premised on the monopolisation of power in the hands of a
few. In other words, it is the opposite of commonly agreed ecological
principles such as freedom to develop, decentralisation and diversity.

As Bookchin put it, the _"notion that human freedom can be achieved, much less
perpetuated, through a state of **any** kind is monstrously oxymoronic -- a
contradiction in terms."_ This is because _"statist forms"_ are based on
_"centralisation, bureaucratisation, and the professionalisation of power in
the hands of elite bodies."_ This flows from its nature for one of its
_"**essential functions is to confine, restrict, and essentially suppress
local democratic institutions and initiatives.**"_ It has been organised to
reduce public participation and control, even scrutiny. [_"The Ecological
Crisis, Socialism, and the need to remake society,"_ pp. 1-10, **Society and
Nature**, vol. 2, no. 3, p. 8 and p. 9] If the creation of an ecological
society requires individual freedom and social participation (and it does)
then the state by its very nature and function excludes both.

The state's centralised nature is such that it cannot handle the complexities
and diversity of life. _"No administrative system is capable of representing"_
a community or, for that matter, an eco-system argues James C. Scott _"except
through a heroic and greatly schematised process of abstraction and
simplification. It is not simply a question of capacity . . . It is also a
question of purpose. State agents have no interest -- nor should they -- in
describing an entire social reality . . . Their abstractions and
simplifications are disciplined by a small number of objectives."_ This means
that the state is unable to effectively handle the needs of ecological
systems, including human ones. Scott analyses various large-scale state
schemes aiming at social improvement and indicates their utter failure. This
failure was rooted in the nature of centralised systems. He urges us _"to
consider the kind of human subject for whom all these benefits were being
provided. This subject was singularly abstract."_ The state was planning _"for
generic subjects who needed so many square feet of housing space, acres of
farmland, litres of clean water, and units of transportation and so much food,
fresh air, and recreational space. Standardised citizens were uniform in their
needs and even interchangeable. What is striking, of course, is that such
subjects . . . have, for purposes of the planning exercise, no gender; no
tastes; no history; no values; no opinions or original ideas, no traditions,
and no distinctive personalities to contribute to the enterprise . . . The
lack of context and particularity is not an oversight; it is the necessary
first premise of any large-scale planning exercise. To the degree that the
subjects can be treated as standardised units, the power of resolution in the
planning exercise is enhanced . . . The same logic applies to the
transformation of the natural world."_ [**Seeing like a State**, pp. 22-3 and
p. 346]

A central power reduces the participation and diversity required to create an
ecological society and tailor humanity's interaction with the environment in a
way which respects local conditions and eco-systems. In fact, it helps creates
ecological problems by centralising power at the top of society, limiting and
repressing the freedom of individuals communities and peoples as well as
standardising and so degrading complex societies and eco-systems. As such, the
state is just as anti-ecological as capitalism is as it shares many of the
same features. As Scott stresses, capitalism _"is just as much an agency of
homogenisation, uniformity, grids, and heroic simplification as the state is,
with the difference being that, for capitalists, simplification must pay. A
market necessarily reduces quality to quantity via the price mechanism and
promotes standardisation; in markets, money talks, not people . . . the
conclusions that can be drawn from the failures of modern projects of social
engineering are as applicable to market-driven standardisation as they are to
bureaucratic homogeneity."_ [**Op. Cit.**, p. 8]

In the short term, the state may be able to restrict some of the worse
excesses of capitalism (this can be seen from the desire of capitalists to
fund parties which promise to deregulate an economy, regardless of the social
and environmental impact of so doing). However, the interactions between these
two anti-ecological institutions are unlikely to produce long term
environmental solutions. This is because while state intervention can result
in beneficial constraints on the anti-ecological and anti-social dynamics of
capitalism, it is always limited by the nature of the state itself. As we
noted in [section B.2.1](secB2.md#secb21), the state is an instrument of
class rule and, consequently, extremely unlikely to impose changes that may
harm or destroy the system itself. This means that any reform movement will
have to fight hard for even the most basic and common-sense changes while
constantly having to stop capitalists ignoring or undermining any reforms
actually passed which threaten their profits and the accumulation of capital
as a whole. This means that counterforces are always set into motion by ruling
class and even sensible reforms (such as anti-pollution laws) will be
overturned in the name of "deregulation" and profits.

Unsurprisingly, eco-anarchists, like all anarchists, reject appeals to state
power as this _"invariably legitimates and strengthens the State, with the
result that it disempowers the people."_ They note that ecology movements
_"that enter into parliamentary activities not only legitimate State power at
the expense of popular power,"_ they also are _"obligated to function
**within** the State"_ and _"must 'play the game,' which means that they must
shape their priorities according to predetermined rules over which they have
no control."_ This results in _"an ongoing **process** of degeneration, a
steady devolution of ideals, practices, and party structures"_ in order to
achieve _"very little"_ in _"arrest[ing] environmental decay."_ [**Remaking
Society**, p. 161, p. 162 and p. 163] The fate of numerous green parties
across the world supports that analysis.

That is why anarchists stress the importance of creating social movements
based on direct action and solidarity as the means of enacting reforms under a
hierarchical society. Only when we take a keen interest and act to create and
enforce reforms will they stand any chance of being applied successfully. If
such social pressure does not exist, then any reform will remain a dead-letter
and ignored by those seeking to maximise their profits at the expense of both
people and planet. As we discuss in [section J](secJcon.md), this involves
creating alternative forms of organisation like federations of community
assemblies (see [section J.5.1](secJ5.md#secj51)) and industrial unions (see
[section J.5.2](secJ5.md#secj52)). Given the nature of both a capitalist
economy and the state, this makes perfect sense.

In summary, the root cause of our ecological problems likes in hierarchy
within humanity, particularly in the form of the state and capitalism.
Capitalism is a "grow-or-die" system which cannot help destroy the environment
while the state is a centralised system which destroys the freedom and
participation required to interact with eco-systems. Based on this analysis,
anarchists reject the notion that all we need do is get the state to regulate
the economy as the state is part of the problem as well as being an instrument
of minority rule. Instead, we aim to create an ecological society and end
capitalism, the state and other forms of hierarchy. This is done by
encouraging social movements which fight for improvements in the short term by
means direct action, solidarity and the creation of popular libertarian
organisations.

## E.1.1 Is industry the cause of environmental problems?

Some environmentalists argue that the root cause of our ecological crisis lies
in industry and technology. This leads them to stress that "industrialism" is
the problem and that needs to be eliminated. An extreme example of this is
primitivism (see [section A.3.9](secA3.md#seca39)), although it does appear
in the works of "deep ecologists" and liberal greens. However, most anarchists
are unconvinced and agree with Bookchin when he noted that "cries against
'technology' and 'industrial society' [are] two very safe, socially natural
targets against which even the bourgeoisie can inveigh in Earth Day
celebrations, as long as minimal attention is paid to the social relations in
which the mechanisation of society is rooted." Instead, ecology needs _"a
confrontational stance toward capitalism and hierarchical society"_ in order
to be effective and fix the root causes of our problems. [**The Ecology of
Freedom**, p. 54]

Claiming that "industrialism" rather than "capitalism" is the cause of our
ecological problems allowed greens to point to both the west and the so-called
"socialist" countries and draw out what was common to both (i.e. terrible
environmental records and a growth mentality). In addition, it allowed green
parties and thinkers to portray themselves as being "above" the "old"
conflicts between socialism and capitalism (hence the slogan _"Neither Right
nor Left, but in front"_). Yet this position rarely convinced anyone as any
serious green thinker soon notes that the social roots of our environmental
problems need to be addressed and that brings green ideas into conflict with
the status quo (it is no coincidence that many on the right dismiss green
issues as nothing more than a form of socialism or, in America, "liberalism").
However, by refusing to clearly indicate opposition to capitalism this
position allowed many reactionary ideas (and people!) to be smuggled into the
green movement (the population myth being a prime example). As for
"industrialism" exposing the similarities between capitalism and Stalinism, it
would have been far better to do as anarchists had done since 1918 and call
the USSR and related regimes what they actually were, namely "state
capitalism."

Some greens (like many defenders of capitalism) point to the terrible
ecological legacy of the Stalinist countries of Eastern Europe and elsewhere.
For supporters of capitalism, this was due to the lack of private property in
these systems while, for greens, it showed that environmental concerns where
above both capitalism and "socialism." Needless to say, by "capitalism"
anarchists mean both private and state forms of that system. As we argued in
[section B.3.5](secB3.md#secb35), under Stalinism the state bureaucracy
controlled and so effectively owned the means of production. As under private
capitalism, an elite monopolised decision making and aimed to maximise their
income by oppressing and exploiting the working class. Unsurprisingly, they
had as little consideration "first nature" (the environment) as they had for
"second nature" (humanity) and dominated, oppressed and exploited both (just
as private capitalism does).

As Bookchin emphasised the ecological crisis stems not only from private
property but from the principle of domination itself -- a principle embodied
in institutional hierarchies and relations of command and obedience which
pervade society at many different levels. Thus, _"[w]ithout changing the most
molecular relationships in society -- notably, those between men and women,
adults and children, whites and other ethnic groups, heterosexuals and gays
(the list, in fact, is considerable) -- society will be riddled by domination
even in a socialistic 'classless' and 'non-exploitative' form. It would be
infused by hierarchy even as it celebrated the dubious virtues of 'people's
democracies,' 'socialism' and the 'public ownership' of 'natural resources,'
And as long as hierarchy persists, as long as domination organises humanity
around a system of elites, the project of dominating nature will continue to
exist and inevitably lead our planet to ecological extinction."_ [**Toward an
Ecological Society**, p. 76]

Given this, the real reasons for why the environmental record of Stalinist
regimes were worse that private capitalism can easily be found. Firstly, any
opposition was more easily silenced by the police state and so the ruling
bureaucrats had far more lee-way to pollute than in most western countries. In
other words, a sound environment requires freedom, the freedom of people to
participate and protest. Secondly, such dictatorships can implement
centralised, top-down planning which renders their ecological impact more
systematic and widespread (James C. Scott explores this at great length in his
excellent book **Seeing like a State**).

Fundamentally, though, there is no real difference between private and state
capitalism. That this is the case can be seen from the willingness of
capitalist firms to invest in, say, China in order to take advantage of their
weaker environmental laws and regulations plus the lack of opposition. It can
also be seen from the gutting of environmental laws and regulation in the west
in order to gain competitive advantages. Unsurprisingly, laws to restrict
protest have been increasingly passed in many countries as they have embraced
the neo-liberal agenda with the Thatcher regime in the UK and its successors
trail-blazing this process. The centralisation of power which accompanies such
neo-liberal experiments reduces social pressures on the state and ensures that
business interests take precedence.

As we argued in [section D.10](secD10.md), the way that technology is used
and evolves will reflect the power relations within society. Given a
hierarchical society, we would expect a given technology to be used in
repressive ways regardless of the nature of that technology itself. Bookchin
points to the difference between the Iroquois and the Inca. Both societies
used the same forms of technology, but the former was a fairly democratic and
egalitarian federation while the latter was a highly despotic empire. As such,
technology _"does not fully or even adequately account for the institutional
differences"_ between societies. [**The Ecology of Freedom**, p. 331] This
means that technology does not explain the causes for ecological harm and it
is possible to have an anti-ecological system based on small-scale
technologies:

> _ "Some of the most dehumanising and centralised social systems were
fashioned out of very 'small' technologies; but bureaucracies, monarchies, and
military forces turned these systems into brutalising cudgels to subdue
humankind and, later, to try to subdue nature. To be sure, a large-scale
technics will foster the development of an oppressively large-scale society;
but every warped society follows the dialectic of its own pathology of
domination, irrespective of the scale of its technics. It can organise the
'small' into the repellent as surely as it can imprint an arrogant sneer on
the faces of the elites who administer it . . . Unfortunately, a preoccupation
with technical size, scale, and even artistry deflects our attention away from
the most significant problems of technics -- notably, its ties with the ideals
and social structures of freedom."_ [Bookchin, **Op. Cit.**, pp. 325-6]

In other words, "small-scale" technology will not transform an authoritarian
society into an ecological one. Nor will applying ecologically friendly
technology to capitalism reduce its drive to grow at the expense of the planet
and the people who inhabit it. This means that technology is an aspect of a
wider society rather than a socially neutral instrument which will **always**
have the same (usually negative) results. As Bookchin stressed, a _"liberatory
technology presupposes liberatory institutions; a liberatory sensibility
requires a liberatory society. By the same token, artistic crafts are
difficult to conceive without an artistically crafted society, and the
'inversion of tools' is impossible with a radical inversion of all social and
productive relationships."_ [**Op. Cit.**, pp. 328-9]

Finally, it should be stressed that attempts to blame technology or industry
for our ecological problems have another negative effect than just obscuring
the real causes of those problems and turning attention away from the elites
who implement specific forms of technology to further their aims. It also
means denying that technology can be transformed and new forms created which
can help produce an ecologically balanced society:

> _ "The knowledge and physical instruments for promoting a harmonisation of
humanity with nature and of human with human are largely at hand or could
easily be devised. Many of the physical principles used to construct such
patently harmful facilities as conventional power plants, energy-consuming
vehicles, surface-mining equipment and the like could be directed to the
construction of small-scale solar and wind energy devices, efficient means of
transportation, and energy-saving shelters."_ [Bookchin, **Op. Cit.**, p. 83]

We must understand that _"the very **idea** of dominating first nature has its
origins in the domination of human by human"_ otherwise _"we will lose what
little understanding we have of the social origin of our most serious
ecological problems."_ It this happens then we cannot solve these problems, as
it _"will grossly distort humanity's potentialities to play a creative role in
non-human as well as human development."_ For _"the human capacity to reason
conceptually, to fashion tools and devise extraordinary technologies"_ can all
_"be used for the good of the biosphere, not simply for harming it. What is of
**pivotal** importance in determining whether human beings will creatively
foster the evolution of first nature or whether they will be highly
destructive to non-human and human beings alike is precisely the kind of
**society** we establish, not only the kind of sensibility we develop."_
[**Op. Cit.**, p. 34]

## E.1.2 What is the difference between environmentalism and ecology?

As we noted in [section A.3.3](secA3.md#seca33), eco-anarchists contrast
ecology with environmentalism. The difference is important as it suggests both
a different analysis of where our ecological problems come from and the best
way to solve them. As Bookchin put it:

> _ "By 'environmentalism' I propose to designate a mechanistic, instrumental
outlook that sees nature as a passive habitat composed of 'objects' such as
animals, plants, minerals, and the like that must merely be rendered more
serviceable for human use . . . Within this context, very little of a social
nature is spared from the environmentalist's vocabulary: cities become 'urban
resources' and their inhabitants 'human resources' . . . Environmentalism . .
. tends to view the ecological project for attaining a harmonious relationship
between humanity and nature as a truce rather than a lasting equilibrium. The
'harmony' of the environmentalist centres around the development of new
techniques for plundering the natural world with minimal disruption of the
human 'habitat.' Environmentalism does not question the most basic premise of
the present society, notably, that humanity must dominant nature; rather, it
seeks to **facilitate** than notion by developing techniques for diminishing
the hazards caused by the reckless despoliation of the environment."_ [**The
Ecology of Freedom**, p. 86]

So eco-anarchists call the position of those who seek to reform capitalism and
make it more green "environmentalism" rather than ecology. The reasons are
obvious, as environmentalists _"focus on specific issues like air and water
pollution"_ while ignoring the social roots of the problems they are trying to
solve. In other words, their outlook _"rest[s] on an instrumental, almost
engineering approach to solving ecological dislocations. To all appearances,
they wanted to adapt the natural world to the needs of the existing society
and its exploitative, capitalist imperatives by way of reforms that minimise
harm to human health and well-being. The much-needed goals of formulating a
project for radical social change and for cultivating a new sensibility toward
the natural world tended to fall outside the orbit of their practical
concerns."_ Eco-anarchists, while supporting such partial structures, stress
that _"these problems originate in a hierarchical, class, and today,
competitive capitalist system that nourishes a view of the natural world as a
mere agglomeration of 'resources' for human production and consumption."_
[**Op. Cit.**, pp. 15-6]

This is the key. As environmentalism does not bring into question the
underlying notion of the present society that man must dominate nature it
cannot present anything other than short-term solutions for the various
symptoms of the underlying problem. Moreover, as it does not question
hierarchy, it simply adjusts itself to the status quo. Thus liberal
environmentalism is so _"hopelessly ineffectual"_ because _"it takes the
present social order for granted"_ and is mired in _"the paralysing belief
that a market society, privately owned property, and the present-day
bureaucratic nation-state cannot be changed in any basic sense. Thus, it is
the prevailing order that sets the terms of any 'compromise' or 'trade-off'"_
and so _"the natural world, including oppressed people, always loses something
piece by piece, until everything is lost in the end. As long as liberal
environmentalism is structured around the social status quo, property rights
always prevail over public rights and power always prevails over
powerlessness. Be it a forest, wetlands, or good agricultural soil, a
'developer' who owns any of these 'resources' usually sets the terms on which
every negotiation occurs and ultimately succeeds in achieving the triumph of
wealth over ecological considerations."_ [Bookchin, **Remaking Society**, p.
15]

This means that a truly ecological perspective seeks to end the situation
where a few govern the many, not to make the few nicer. As Chomsky once noted
on the issue of _"corporate social responsibility"_, he could not discuss the
issue as such because he did _"not accept some of its presuppositions,
specifically with regard to the legitimacy of corporate power"_ as he did not
see any _"justification for concentration of private power"_ than _"in the
political domain."_ Both would _"act in a socially responsible way -- as
benevolent despots -- when social strife, disorder, protest, etc., induce them
to do so for their own benefit."_ He stressed that in a capitalist society
_"socially responsible behaviour would be penalised quickly in that
competitors, lacking such social responsibility, would supplant anyone so
misguided as to be concerned with something other than private benefit."_ This
explains why real capitalist systems have always _"been required to safeguard
social existence in the face of the destructive forces of private capitalism"_
by means of _"substantial state control."_ However, the _"central questions .
. . are not addressed, but rather begged"_ when discussing corporate social
responsibility. [**Language and Politics**, p. 275]

Ultimately, the key problem with liberal environmentalism (as with liberalism
in general) is that it tends, by definition, to ignore class and hierarchy.
The "we are all in this together" kind of message ignores that most of
decisions that got us into our current ecological and social mess were made by
the rich as they have control over resources and power structures (both
private and public). It also suggests that getting us out of the mess must
involve taking power and wealth back from the elite -- if for no other reason
because working class people do not, by themselves, have the resources to
solve the problem.

Moreover, the fact is the ruling class do **not** inhabit quite the same
polluted planet as everyone else. Their wealth protects them, to a large
degree, to the problems that they themselves have created and which, in fact,
they owe so much of that wealth to (little wonder, then, they deny there is a
serious problem). They have access to a better quality of life, food and local
environment (no toxic dumps and motorways are near their homes or holiday
retreats). Of course, this is a short term protection but the fate of the
planet is a long-term abstraction when compared to the immediate returns on
one's investments. So it is not true to say that **all** parts of the ruling
class are in denial about the ecological problems. A few are aware but many
more show utter hatred towards those who think the planet is more important
than profits.

This means that such key environmentalist activities such as education and
lobbying are unlikely to have much effect. While these may produce **some**
improvements in terms of our environmental impact, it cannot stop the long-
term destruction of our planet as the ecological crisis is _"**systemic** \--
and not a matter of misinformation, spiritual insensitivity, or lack of moral
integrity. The present social illness lies not only in the outlook that
pervades the present society; it lies above all in the very **structure** and
**law of life** in the system itself, in its imperative, which no entrepreneur
or corporation can ignore without facing destruction: growth, more growth, and
still more growth."_ [Murray Bookchin, _"The Ecological Crisis, Socialism, and
the need to remake society,"_ pp. 1-10, **Society and Nature**, vol. 2, no. 3,
pp. 2-3] This can only be ended by ending capitalism, not by appeals to
consumers to buy eco-friendly products or to capitalists to provide them:

> _ "Accumulation is determined not by the good or bad intentions of the
individual bourgeois, but by the commodity relationship itself . . . It is not
the perversity of the bourgeois that creates production for the sake of
production, but the very market nexus over which he presides and to which he
succumbs. . . . It requires a grotesque self-deception, or worse, an act of
ideological social deception, to foster the belief that this society can undo
its very law of life in response to ethical arguments or intellectual
persuasion."_ [**Toward an Ecological Society**, p. 66]

Sadly, much of what passes for the green movement is based on this kind of
perspective. At worse, many environmentalists place their hopes on green
consumerism and education. At best, they seek to create green parties to work
within the state to pass appropriate regulations and laws. Neither option gets
to the core of the problem, namely a system in which there are _"oppressive
human beings who literally own society and others who are owned by it. Until
society can be reclaimed by an undivided humanity that will use its collective
wisdom, cultural achievements, technological innovations, scientific
knowledge, and innate creativity for its own benefit and for that of the
natural world, all ecological problems will have their roots in social
problems."_ [Bookchin, **Remaking Society**, p. 39]

[‹ E.0 Section E Introduction](secEint.md "Go to previous page" )
[up](secEcon.md "Go to parent page" ) [E.2 What do eco-anarchists propose
instead of capitalism? ›](secE2.md "Go to next page" )

