{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetCenter: TVector3;
    procedure SetCenter(const Value: TVector3);
    function GetNameField: string;
    procedure SetNameField(const Value: string);
    function GetRotation: TVector4;
    procedure SetRotation(const Value: TVector4);
    function GetScale: TVector3;
    procedure SetScale(const Value: TVector3);
    function GetScaleOrientation: TVector4;
    procedure SetScaleOrientation(const Value: TVector4);
    function GetSkinNormal: TAbstractNormalNode;
    procedure SetSkinNormal(const Value: TAbstractNormalNode);
    function GetTranslation: TVector3;
    procedure SetTranslation(const Value: TVector3);
    function GetVersion: string;
    procedure SetVersion(const Value: string);
    function GetBboxCenter: TVector3;
    procedure SetBboxCenter(const Value: TVector3);
    function GetBboxSize: TVector3;
    procedure SetBboxSize(const Value: TVector3);
  public
    property Center: TVector3 read GetCenter write SetCenter;
    procedure SetInfo(const Value: array of string);
    procedure SetInfo(const Value: TCastleStringList);
    procedure SetJoints(const Value: array of THAnimJointNode);
    property NameField: string read GetNameField write SetNameField;
    property Rotation: TVector4 read GetRotation write SetRotation;
    property Scale: TVector3 read GetScale write SetScale;
    property ScaleOrientation: TVector4 read GetScaleOrientation write SetScaleOrientation;
    procedure SetSegments(const Value: array of THAnimSegmentNode);
    procedure SetSites(const Value: array of THAnimSiteNode);
    procedure SetSkin(const Value: array of TAbstractChildNode);
    property SkinNormal: TAbstractNormalNode read GetSkinNormal write SetSkinNormal;
    property Translation: TVector3 read GetTranslation write SetTranslation;
    property Version: string read GetVersion write SetVersion;
    procedure SetViewpoints(const Value: array of THAnimSiteNode);
    property BboxCenter: TVector3 read GetBboxCenter write SetBboxCenter;
    property BboxSize: TVector3 read GetBboxSize write SetBboxSize;

{$endif read_interface}

{$ifdef read_implementation}

{ THAnimHumanoidNode ----------------------------------------------- }

function THAnimHumanoidNode.GetCenter: TVector3;
begin
  Result := FdCenter.Value;
end;

procedure THAnimHumanoidNode.SetCenter(const Value: TVector3);
begin
  FdCenter.Send(Value);
end;

procedure THAnimHumanoidNode.SetInfo(const Value: array of string);
begin
  FdInfo.Send(Value);
end;

procedure THAnimHumanoidNode.SetInfo(const Value: TCastleStringList);
begin
  FdInfo.Send(Value);
end;

procedure THAnimHumanoidNode.SetJoints(const Value: array of THAnimJointNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(THAnimJointNode));
  FdJoints.Send(A);
end;

function THAnimHumanoidNode.GetNameField: string;
begin
  Result := FdName.Value;
end;

procedure THAnimHumanoidNode.SetNameField(const Value: string);
begin
  FdName.Send(Value);
end;

function THAnimHumanoidNode.GetRotation: TVector4;
begin
  Result := FdRotation.Value;
end;

procedure THAnimHumanoidNode.SetRotation(const Value: TVector4);
begin
  FdRotation.Send(Value);
end;

function THAnimHumanoidNode.GetScale: TVector3;
begin
  Result := FdScale.Value;
end;

procedure THAnimHumanoidNode.SetScale(const Value: TVector3);
begin
  FdScale.Send(Value);
end;

function THAnimHumanoidNode.GetScaleOrientation: TVector4;
begin
  Result := FdScaleOrientation.Value;
end;

procedure THAnimHumanoidNode.SetScaleOrientation(const Value: TVector4);
begin
  FdScaleOrientation.Send(Value);
end;

procedure THAnimHumanoidNode.SetSegments(const Value: array of THAnimSegmentNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(THAnimSegmentNode));
  FdSegments.Send(A);
end;

procedure THAnimHumanoidNode.SetSites(const Value: array of THAnimSiteNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(THAnimSiteNode));
  FdSites.Send(A);
end;

procedure THAnimHumanoidNode.SetSkin(const Value: array of TAbstractChildNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(TAbstractChildNode));
  FdSkin.Send(A);
end;

function THAnimHumanoidNode.GetSkinNormal: TAbstractNormalNode;
begin
  if FdSkinNormal.Value is TAbstractNormalNode then
    Result := TAbstractNormalNode(FdSkinNormal.Value)
  else
    Result := nil;
end;

procedure THAnimHumanoidNode.SetSkinNormal(const Value: TAbstractNormalNode);
begin
  FdSkinNormal.Send(Value);
end;

function THAnimHumanoidNode.GetTranslation: TVector3;
begin
  Result := FdTranslation.Value;
end;

procedure THAnimHumanoidNode.SetTranslation(const Value: TVector3);
begin
  FdTranslation.Send(Value);
end;

function THAnimHumanoidNode.GetVersion: string;
begin
  Result := FdVersion.Value;
end;

procedure THAnimHumanoidNode.SetVersion(const Value: string);
begin
  FdVersion.Send(Value);
end;

procedure THAnimHumanoidNode.SetViewpoints(const Value: array of THAnimSiteNode);
var
  L: Integer;
  A: array of TX3DNode;
begin
  L := High(Value) + 1;
  SetLength(A, L);
  if L > 0 then
    Move(Value[0], A[0], L * SizeOf(THAnimSiteNode));
  FdViewpoints.Send(A);
end;

function THAnimHumanoidNode.GetBboxCenter: TVector3;
begin
  Result := FdBboxCenter.Value;
end;

procedure THAnimHumanoidNode.SetBboxCenter(const Value: TVector3);
begin
  FdBboxCenter.Send(Value);
end;

function THAnimHumanoidNode.GetBboxSize: TVector3;
begin
  Result := FdBboxSize.Value;
end;

procedure THAnimHumanoidNode.SetBboxSize(const Value: TVector3);
begin
  FdBboxSize.Send(Value);
end;

{$endif read_implementation}
