/*
* Copyright (C) 2019 ~ 2020 Uniontech Software Technology Co.,Ltd.
*
* Author:     suyihang <suyihang@uniontech.com>
*
* Maintainer: suyihang <suyihang@uniontech.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef MODETOGGLEBUTTON_H
#define MODETOGGLEBUTTON_H

#include <DToolButton>
#include <DGuiApplicationHelper>

DWIDGET_USE_NAMESPACE
DGUI_USE_NAMESPACE

class ModeToggleButton : public DToolButton
{
    Q_OBJECT

public:
    explicit ModeToggleButton(QWidget *parent = nullptr);
    void setHovered(bool hover);

protected:
    void paintEvent(QPaintEvent *event) override;
    void enterEvent(QEvent *event) override;
    void leaveEvent(QEvent *event) override;

private slots:
    void resetStyle();

private:
    bool m_hover = false;
    QColor m_colorHover;
};

#endif
