/* $Id$ 
 *
 * WakeOn: Tell the scheduler to wake the current process on a signal event.
 *         (intermediate opcode)
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __WAKE_ON_HPP_INCLUDED
#define __WAKE_ON_HPP_INCLUDED

#include <cassert>

namespace intermediate {

//! register a signal to the scheduler on which to wake the current process.
/** This class represents the wake_on opcode.
 *  The currently running process should be made runnable again, if the signal
 *  registered via WakeOn showed activity.
 *  Issueing more than one WakeOn statement will add to the schedulers 
 *  internal sensitivity set. The set will only be cleared after the
 *  process was resumed from a suspend statement.
 *
 *  read operands: src
 *  write operands: None, implicit sensitivity set of scheduler.
 *  Operation: sched->addSensitivity(src);
 */
class WakeOn : public OpCode {
public:
	//! c'tor
	/** @param source pointer to a signal.
	 */
	WakeOn(
		Operand *source
		) : 	src(source) {

		assert(source->type == OP_TYPE_POINTER);
	}

	//! Accept a Visitor.
 	/** All intermediate code nodes need to implement this method.
         *
         *  @param v the Visitor that can visit this node.
         */
	virtual void accept(Visitor& v) {
		v.visit(*this);
	}

	//! source of the instruction
	Operand *src;

protected:
	virtual ~WakeOn() {
		util::MiscUtil::terminate(this->src);
	}
}; 

}; /* namespace intermediate */

#endif /* __WAKE_ON_HPP_INCLUDED */
