/*
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>

#include "config.h"

#include "glue-gui.h"

#include "chassis_at_gui.h"

#ifdef HAVE_GTK
#include "chassis_at_gui_gtk.h"
#endif

void *
chassis_at_gui_create(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_boolean *port_mech_reset_button,
	struct sig_std_logic *port_n_reset_button,
	struct sig_std_logic_conn *port_power_led,
	struct sig_boolean *port_opt_power_led,
	struct sig_sound *port_speaker,
	struct sig_sound *port_audio_speaker
)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		return chassis_at_gui_gtk_create(page, name,
				port_manage,
				port_mech_reset_button,
				port_n_reset_button,
				port_power_led,
				port_opt_power_led,
				port_speaker,
				port_audio_speaker);
		break;
#endif
	case GUI_NULL:
		return (void *) 1;
	default:
		assert(0);
	}
}

void
chassis_at_gui_destroy(void *_cpssp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		chassis_at_gui_gtk_destroy(_cpssp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
chassis_at_gui_suspend(void *_cpssp, FILE *fComp)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		chassis_at_gui_gtk_suspend(_cpssp, fComp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}

void
chassis_at_gui_resume(void *_cpssp, FILE *fComp)
{
	switch(selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		chassis_at_gui_gtk_resume(_cpssp, fComp);
		break;
#endif
	case GUI_NULL:
		break;
	default:
		assert(0);
	}
}
