/*
 * Copyright (C) 2016 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>
#include "glue.h"
#include "glue-gui-gtk.h"
#include "glue-gui-gtk-plus-minus-button.h"
#include "glue-gui-gtk-button.h"
#include "sig_integer.h"
#include "sig_manage.h"
#include "sig_std_logic.h"

typedef struct {
	GtkVBoxClass parent_class;
	void (*plus_button_click)(GuiGtkPlusMinusButton *plus_minus_button);
	void (*minus_button_click)(GuiGtkPlusMinusButton *plus_minus_button);

} GuiGtkPlusMinusButtonClass;

enum{
	VALUE_CHANGED_GUI,
	PLUS_BUTTON_CLICKED,
	MINUS_BUTTON_CLICKED,
	VALUE_CHANGED_SIM,
	GUI_GTK_PLUS_MINUS_BUTTON_LAST_SIGNAL
};

static guint gui_gtk_plus_minus_button_signals[GUI_GTK_PLUS_MINUS_BUTTON_LAST_SIGNAL] = { 0 , 0, 0, 0};

static void
gui_gtk_plus_minus_button_class_init(GuiGtkPlusMinusButtonClass *class)
{	
    gui_gtk_plus_minus_button_signals[VALUE_CHANGED_GUI] =
	g_signal_new("value-changed-gui",
		     G_TYPE_FROM_CLASS(class),
		     G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION, /* FIXME */
		     0, NULL, NULL,
		     g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);

    gui_gtk_plus_minus_button_signals[PLUS_BUTTON_CLICKED] =
	g_signal_new("plus-button-pressed",
		     G_TYPE_FROM_CLASS(class),
		     G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION, /* FIXME */
		     0, NULL, NULL,
		     g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);

    gui_gtk_plus_minus_button_signals[MINUS_BUTTON_CLICKED] =
	g_signal_new("minus-button-pressed",
		     G_TYPE_FROM_CLASS(class),
		     G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION, /* FIXME */
		     0, NULL, NULL,
		     g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);

    gui_gtk_plus_minus_button_signals[MINUS_BUTTON_CLICKED] =
	g_signal_new("value-changed-sim",
		     G_TYPE_FROM_CLASS(class),
		     G_SIGNAL_RUN_FIRST | G_SIGNAL_ACTION, /* FIXME */
		     0, NULL, NULL,
		     g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void
gui_gtk_plus_minus_button_init(GuiGtkPlusMinusButton *plus_minus_button)
{
}

static gboolean
gui_gtk_plus_minus_button_minus_button_press_event(
		GtkWidget *w,
		GdkEventButton *event,
 		gpointer _plusminusbutton)
{
	GuiGtkPlusMinusButton *button = 
		(GuiGtkPlusMinusButton *) _plusminusbutton;
	if (0 < button->current_item){
		button->current_item--;
		
		g_signal_emit(G_OBJECT(button), 
			gui_gtk_plus_minus_button_signals[VALUE_CHANGED_GUI], 
			0);
		gtk_label_set_text((GtkLabel*)button->value_label,
				button->items[button->current_item]);
			
	}
	return FALSE;
}

static gboolean
gui_gtk_plus_minus_button_plus_button_press_event
(
 GtkWidget *w,
 GdkEventButton *event,
 gpointer _plusminusbutton
 )
{
	GuiGtkPlusMinusButton *button = 
		(GuiGtkPlusMinusButton *) _plusminusbutton;
	if (button->current_item < button->number_items - 1){
		button->current_item++;
			
		
		g_signal_emit(G_OBJECT(button), 
			gui_gtk_plus_minus_button_signals[VALUE_CHANGED_GUI], 
			0);
		gtk_label_set_text((GtkLabel*)button->value_label,
				button->items[button->current_item]);
			

	}
	/*
	g_signal_emit(G_OBJECT(button), 
		gui_gtk_plus_minus_button_signals[VALUE_CHANGED_GUI], 
		0);
	char value_text[5];
	sprintf(value_text, "%d", button->offset);
	fprintf(stderr, "offset val %s\n", value_text);
	gtk_label_set_text(button->value_label, value_text);
	*/
    	return FALSE;
}



GType
gui_gtk_plus_minus_button_get_type(void)
{
	static GType ttt_type = 0;

	if (! ttt_type) {
		static const GTypeInfo ttt_info = {
			sizeof(GuiGtkPlusMinusButtonClass),
			NULL,	/* base_init */
			NULL,	/* base_finalize */
			(GClassInitFunc) gui_gtk_plus_minus_button_class_init,
			NULL,	/* class_finalize */
			NULL,	/* class_data */
			sizeof(GuiGtkPlusMinusButton),
			0,	/* n_preallocs */
			(GInstanceInitFunc) gui_gtk_plus_minus_button_init,
		};

		ttt_type = g_type_register_static (GTK_TYPE_HBOX,
				"PlusMinusButton", &ttt_info, 0);
	}

	return ttt_type;
}

#define GUIGTKPLUSMINUSBUTTON_TYPE gui_gtk_plus_minus_button_get_type()

GtkWidget *
gui_gtk_plus_minus_button_new(const char *desc, int number_items, const char **items)
{
	GtkWidget *vbox;
	GtkWidget *hbox;
	GuiGtkPlusMinusButton *plus_minus_button;
	int i;
	

	plus_minus_button = GUI_GTK_PLUS_MINUS_BUTTON(g_object_new(GUIGTKPLUSMINUSBUTTON_TYPE, NULL));
	/* plus_minus_button->pixel_step = pixel_step;*/
	
	plus_minus_button->number_items = number_items;
	plus_minus_button->items = malloc(number_items * sizeof(char*));
	for (i = 0; i < number_items; i++){
		plus_minus_button->items[i] = strdup(items[i]);

	}	
	vbox = gtk_vbox_new(FALSE, 1);
	hbox = gtk_hbox_new(TRUE, 1);
	
	plus_minus_button->title_label = gtk_label_new(desc);
	plus_minus_button->value_label = gtk_label_new("");
	plus_minus_button->plus_button = gui_gtk_button_new("+");
	plus_minus_button->minus_button = gui_gtk_button_new(" - ");
    	g_signal_connect(
			G_OBJECT(plus_minus_button->plus_button), "button-press-event",
		     	G_CALLBACK(gui_gtk_plus_minus_button_plus_button_press_event),
		     	plus_minus_button);
	
    	g_signal_connect(
			G_OBJECT(plus_minus_button->minus_button), "button-press-event",
		     	G_CALLBACK(gui_gtk_plus_minus_button_minus_button_press_event),
		     	plus_minus_button);

	gtk_box_pack_start(GTK_BOX(hbox), plus_minus_button->plus_button, FALSE, FALSE, 1);
	gtk_box_pack_start(GTK_BOX(hbox), plus_minus_button->minus_button, FALSE, FALSE, 1);

	gtk_box_pack_start(GTK_BOX(vbox), plus_minus_button->title_label, FALSE, FALSE, 1);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 1);
	gtk_box_pack_start(GTK_BOX(vbox), plus_minus_button->value_label, FALSE, FALSE, 1);
	
	gtk_box_pack_start(GTK_BOX(plus_minus_button), vbox, FALSE, FALSE, 1);
	gtk_widget_show(plus_minus_button->title_label);
	gtk_widget_show(plus_minus_button->value_label);
	gtk_widget_show(plus_minus_button->plus_button);
	gtk_widget_show(plus_minus_button->minus_button);
	gtk_widget_show(hbox);
	gtk_widget_show(vbox);
	gtk_widget_show(GTK_WIDGET(plus_minus_button));	
	g_signal_emit(G_OBJECT(plus_minus_button), 
			gui_gtk_plus_minus_button_signals[VALUE_CHANGED_GUI], 
			0);
	return GTK_WIDGET(plus_minus_button);
}
void
gui_gtk_plus_minus_button_set_value(gpointer _plus_minus_button, 
				char *value_string)
{
	GuiGtkPlusMinusButton *plus_minus_button;
	int item;

	plus_minus_button = _plus_minus_button;
	for (item = 0; item < plus_minus_button->number_items ; item++){
		if (strcmp(plus_minus_button->items[item], value_string) == 0){
			plus_minus_button->current_item = item;
			gtk_label_set_text((GtkLabel*)plus_minus_button->value_label, 
				plus_minus_button->items[item]);	
			
			break;
		}
	}


}

void
gui_gtk_plus_minus_button_destroy(gpointer _plusminusbutton)
{
	GuiGtkPlusMinusButton *button = 
		(GuiGtkPlusMinusButton *) _plusminusbutton;
	int i;
	for (i = 0; i < button->number_items; i++){
		free(button->items[i]);
	}	 
	
}
