/*
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __KBD_H_INCLUDED
#define __KBD_H_INCLUDED

#include "build_config.h"

/* ==================== RUNTIME_RM || INIT_RM ==================== */
#if defined(RUNTIME_RM) || defined(INIT_RM)

#include "ptrace.h"

static inline unsigned short  __attribute__((__always_inline__))
key_get(void)
{
	uint16_t ret;

	asm volatile (
	"	movb $0x00, %%ah\n"
	"	int $0x16\n"
	: "=a" (ret)
	);

	return ret;
}

static inline int __attribute__((__always_inline__))
key_available(void)
{
	uint8_t ret;

	asm volatile (
	"	movb $0x01, %%ah\n"
	"	int $0x16\n"
	"	jne 0f\n"
	"	movb $0, %%al\n"
	"	jmp 1f\n"
	"0:	\n"
	"	movb $1, %%al\n"
	"1:	\n"
	: "=a" (ret)
	);

	return ret;
}

extern void
bios_09(void);

extern void
kbd_system_reset(void);

#endif /* RUNTIME_RM || INIT_RM */
/* =================== REAL-MODE INIT ========================= */
#ifdef INIT_RM

extern void
kbd_init(void);

#endif /* INIT_RM */

#endif /* __KBD_H_INCLUDED */
