#ifndef HOTSWAPFORM_H
#define HOTSWAPFORM_H

/*
   hotswapform.h - Interface of the HotswapForm class

   Copyright (C) 2003 Tim Stadelmann

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <kmainwindow.h>
#include <ksystemtray.h>

class Device;
class KAction;
class KConfig;
class KPopupMenu;
class KSystemTray;
class QLabel;
class QPushButton;


/** CLASSES **/

/* KSystemTray declares contextMenu () as protected.  */

class HotswapSystemTray: public KSystemTray
{
 public:
  HotswapSystemTray (QWidget *parent): KSystemTray (parent) {}
  KPopupMenu *get_context_menu () const
    {
      return contextMenu ();
    }
};

class HotswapForm: public KMainWindow
{
  Q_OBJECT
 public:
  HotswapForm (QWidget *parent,
	       const unsigned int ide_controller,
	       QString hotswap_path);
  ~HotswapForm ();
  bool systray;
 private:
  KPopupMenu *device_menu;
  KPopupMenu *help_menu;
  KAction *swap_action;
  KAction *remove_action;
  KAction *insert_action;
  KAction *quit_action;
  QLabel *device_icon;
  QLabel *device_text;
  QPushButton *swap_button;
  QPushButton *remove_button;
  QPushButton *insert_button;
  HotswapSystemTray *systray_icon;
  Device *device;
  void update ();
 private slots:
  void swap ();
  void remove ();
  void insert ();
  void quit ();
 protected:
  virtual void saveProperties (KConfig *config);
  virtual void readProperties (KConfig *config);
};

#endif /* HOTSWAPFORM_H */
