# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class JobStepOutput(Model):
    """The output configuration of a job step.

    All required parameters must be populated in order to send to Azure.

    :param type: The output destination type. Possible values include:
     'SqlDatabase'. Default value: "SqlDatabase" .
    :type type: str or ~azure.mgmt.sql.models.JobStepOutputType
    :param subscription_id: The output destination subscription id.
    :type subscription_id: str
    :param resource_group_name: The output destination resource group.
    :type resource_group_name: str
    :param server_name: Required. The output destination server name.
    :type server_name: str
    :param database_name: Required. The output destination database.
    :type database_name: str
    :param schema_name: The output destination schema. Default value: "dbo" .
    :type schema_name: str
    :param table_name: Required. The output destination table.
    :type table_name: str
    :param credential: Required. The resource ID of the credential to use to
     connect to the output destination.
    :type credential: str
    """

    _validation = {
        'server_name': {'required': True},
        'database_name': {'required': True},
        'table_name': {'required': True},
        'credential': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group_name': {'key': 'resourceGroupName', 'type': 'str'},
        'server_name': {'key': 'serverName', 'type': 'str'},
        'database_name': {'key': 'databaseName', 'type': 'str'},
        'schema_name': {'key': 'schemaName', 'type': 'str'},
        'table_name': {'key': 'tableName', 'type': 'str'},
        'credential': {'key': 'credential', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(JobStepOutput, self).__init__(**kwargs)
        self.type = kwargs.get('type', "SqlDatabase")
        self.subscription_id = kwargs.get('subscription_id', None)
        self.resource_group_name = kwargs.get('resource_group_name', None)
        self.server_name = kwargs.get('server_name', None)
        self.database_name = kwargs.get('database_name', None)
        self.schema_name = kwargs.get('schema_name', "dbo")
        self.table_name = kwargs.get('table_name', None)
        self.credential = kwargs.get('credential', None)
