/* ====================================================================
 * Copyright (c) 2006-2008  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_BOOKMARKVIEW_H
#define _SC_BOOKMARKVIEW_H

// sc
#include "util/Id.h"
class Bookmark;
class ActionStorage;
class BookmarkViewModel;
class BookmarkViewItemModel;
class BookmarkViewProxyModel;

// qt
#include <QtCore/QTime>
#include <QtGui/QTreeView>
class Q3PopupMenu;

class BookmarkView : public QTreeView
{
  typedef QTreeView super;
  Q_OBJECT

public:
  BookmarkView( BookmarkViewModel*, ActionStorage*, QWidget* parent );
  ~BookmarkView();

public slots:
  void renameBookmark( Bookmark* );
  void currentBookmark( Bookmark* );
  void modifiedBookmark( Bookmark* );

  void mousePressEvent( QMouseEvent* e );
  void mouseMoveEvent( QMouseEvent* e );
  void contextMenuEvent( QContextMenuEvent* e );
  void selectionChanged( const QItemSelection& selected, const QItemSelection& deselected );
  void entered( const QModelIndex& index );
  void dataChanged( const QModelIndex& topLeft, const QModelIndex& bottomRight );

  void dragEnterEvent( QDragEnterEvent* e );
  void dragMoveEvent( QDragMoveEvent* e );
  void dragLeaveEvent( QDragLeaveEvent* e );
  void dropEvent( QDropEvent* e );
  void timerEvent( QTimerEvent* e );

  /** control "running" animation. */
  void activeTimer();

  void drawRow( QPainter* painter, const QStyleOptionViewItem& option, const QModelIndex& index ) const;

signals:
  void onItem( const QString& );
  void bookmarkSelected( Bookmark* );

private:
  /** get bookmark from @a QModelIndex. */
  Bookmark* getBookmark( const QModelIndex& );
  void handleDropOnBookmark( Bookmark*, const QStringList& );

  void animateActive( const QModelIndex& );

  BookmarkViewModel*      _model;
  ActionStorage*          _actions;
  BookmarkViewItemModel*  _itemModel;
  BookmarkViewProxyModel* _proxyModel;

  Q3PopupMenu*            _prjMenu;
  Q3PopupMenu*            _wcMenu;
  Q3PopupMenu*            _rpMenu;
  Q3PopupMenu*            _prjDropMenu;

  QPoint                  _dragPosMouseLeft;  ///< position of last left mouse button press.
  int                     _dragTimerId;       ///< drag & drop timer for auto scroll & expand,
                                              ///< 0 if no timer is running.
  
  QPoint                  _lastPosMouse;      ///< last mouse position.
  QTime                   _lastPosTime;       ///< last mouse position time.

  QTimer*                 _activeTimer;
};


#endif // _SC_BOOKMARKVIEW_H
