/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "MoveDialog.h"
#include "RevisionWidget.h"
#include "ExternProvider.h"
#include "sublib/ExternButton.h"
#include "util/String.h"

// qt
#include <QtGui/QLayout>
#include <QtGui/QGroupBox>
#include <QtGui/QPushButton>
#include <QtGui/QLabel>
#include <QtGui/QComboBox>
#include <QtGui/QFileDialog>
#include <QtGui/QToolTip>
#include <QtGui/QCheckBox>



MoveDialog::MoveDialog( ExternProvider* p, QWidget *parent, const char *name )
: super( parent, name, true, Qt::WStyle_Customize | Qt::WStyle_Dialog |
  Qt::WStyle_NormalBorder | Qt::WStyle_Title | Qt::WStyle_SysMenu ), _p(p)
{
  setCaption( _q("subcommander:move") );

  QVBoxLayout *vbl = new QVBoxLayout(this,5,8);
  vbl->setSpacing(10);
  {
    QGroupBox* gb = new QGroupBox(1,Qt::Vertical,this);
    gb->setTitle( _q("move options: ") );
    gb->setInsideMargin(0);
    gb->setFlat(true);
    vbl->addWidget(gb);

    QGridLayout* gl = new QGridLayout(vbl,2,3);
    gl->setMargin(0);
    gl->setRowStretch( 1, 1 );
    {
#if 0
      {
        QLabel* l = new QLabel(this);
        _rep      = new QComboBox(this);
        _repEx    = new ExternButton(this);

        l->setBuddy(_rep);
        l->setText( "&repository url:" );
        _rep->setEditable(true);
        _rep->setAutoCompletion(true);

        gl->addWidget(l,0,0);
        gl->addWidget(_rep,0,1); 
        gl->addWidget(_repEx,0,2); 

        connect( _rep, SIGNAL(activated(const QString&)), SLOT(checkOk(const QString&)) );
        connect( _rep, SIGNAL(highlighted(const QString&)), SLOT(checkOk(const QString&)) );
        connect( _rep, SIGNAL(textChanged(const QString&)), SLOT(checkOk(const QString&)) );
        connect( _repEx, SIGNAL(clicked()), SLOT(repExtern()) );

        QToolTip::add( _rep, "the repository folder you want to checkout" );
      }
#endif
      {
        QLabel* l = new QLabel(this);
        _wc       = new QComboBox(this);
        _wcEx     = new ExternButton(this);

        l->setBuddy(_wcEx);
        l->setText( _q("&working copy target path:") );
        l->setFixedWidth( l->sizeHint().width() );
        _wc->setEditable(true);
        _wc->setAutoCompletion(true);

        gl->addWidget(l,1,0);
        gl->addWidget(_wc,1,1); 
        gl->addWidget(_wcEx,1,2); 

        connect( _wc, SIGNAL(activated(const QString&)), SLOT(checkOk(const QString&)) );
        connect( _wc, SIGNAL(highlighted(const QString&)), SLOT(checkOk(const QString&)) );
        connect( _wc, SIGNAL(textChanged(const QString&)), SLOT(checkOk(const QString&)) );

        connect( _wcEx, SIGNAL(clicked()), SLOT(selectWcPath()) );

        QToolTip::add( _wc, _q("the local folder where you want to move the selection") );
      }
    }

    QHBoxLayout* h1 = new QHBoxLayout;
    vbl->addLayout(h1);
    {
      _force = new QCheckBox( _q("&force"), this );
      _force->setChecked(false);
      h1->addWidget(_force);

      _rw = new RevisionWidget(true,"NSD","H",0,this);
      h1->addWidget( _rw );
    }

    QHBoxLayout* hu = new QHBoxLayout;
    vbl->addLayout(hu);
    {
      // eats extra space, so the buttons keep their size
      hu->addStretch(1); 

      _ok = new QPushButton(this);
      _ok->setEnabled(false);
      _ok->setText( _q("&Ok") );
      _ok->setDefault(true);
      hu->addWidget(_ok);
      QPushButton* ca = new QPushButton(this);
      ca->setText( _q("&Cancel") );
      hu->addWidget(ca);

      connect( _ok, SIGNAL(clicked()), SLOT(accept()) );
      connect( ca, SIGNAL(clicked()), SLOT(reject()) );
    }
  }

  // don't resize vertically.
  setMaximumHeight( sizeHint().height() );
}

MoveDialog::~MoveDialog()
{
}

void MoveDialog::selectWcPath()
{
  sc::String res;

  if( _p->selectPath( this, sc::String(_wc->currentText().utf8()), res, ExternProvider::Dir ) )
  {
    _wc->insertItem( QString::fromUtf8(res), 0 );
  }
}

#if 0
void MoveDialog::setRepositoryUrl( QString& url )
{
  _rep->insertItem( url, 0 );
}

QString MoveDialog::getRepositoryUrl()
{
  return _rep->currentText();
}
#endif

QString MoveDialog::getWcTargetPath()
{
  return _wc->currentText();
}

void MoveDialog::setWcTargetPath( QString& path )
{
  _wc->insertItem( path, 0 );
}

svn::Revision* MoveDialog::getRevision()
{
  return _rw->getRevision();
}

bool MoveDialog::isForce()
{
  return _force->isChecked();
}

#if 0
void MoveDialog::enableRepositoryUrl( bool enable )
{
  _rep->setEnabled(enable);
}
#endif

#if 0
void MoveDialog::enableWorkingCopyPath( bool enable )
{
  _wc->setEnabled(enable);
  _wcEx->setEnabled(enable);
}
#endif

void MoveDialog::checkOk( const QString& text )
{
  //QString rep = _rep->currentText();
  QString wc  = _wc->currentText();

  if( /*! rep.isEmpty() &&*/ ! wc.isEmpty()  )
  {
    _ok->setEnabled(true);
  }
  else
  {
    _ok->setEnabled(false);
  }

#if 0
  if( ! rep.isEmpty() && _rep->isEnabled() )
  {
    _repEx->setEnabled(true);
  }
  else
  {
    _repEx->setEnabled(false);
  }
#endif
}

void MoveDialog::repExtern()
{
  //handleExtern(_rep);
}

void MoveDialog::handleExtern( QComboBox* e )
{
  sc::String res;

  if( _p->selectUrl( this, sc::String(e->currentText().utf8()), res ) )
  {
    e->insertItem( QString::fromUtf8(res) );
  }
}
