/* ====================================================================
 * Copyright (c) 2007,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_IGNORECMD_H
#define _SC_IGNORECMD_H

// sc
#include "ScCmd.h"
class IgnoreParam;
class CmdResultCallback;


/**
 * Command for adding files to its parent svn:ignore property.
 */
class IgnoreCmd : public ScCmd
{
public:
  /**
   * Construct an IgnoreCmd.
   *
   * \param param the parameters for the command.
   * \param cb the callback that gets called when the command has finished.
   * The command takes ownership the callback.
   */
  IgnoreCmd( IgnoreParam* param, CmdResultCallback* cb );
  ~IgnoreCmd();

  void run();

private:
  // in
  IgnoreParam*       _param;

  // out
  CmdResultCallback* _cb;
};

#endif // _SC_IGNORECMD_H
