/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.appenders.reportlogview;

import java.util.Collection;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.IMarkerSourceListener;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.IViewerRefresh;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewHelper;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewPlugin;

abstract class AbstractMarkerViewContentProvider
implements ITreeContentProvider,
IMarkerSourceListener {
    protected final MarkerViewHelper helper;
    protected IViewerRefresh viewerRefresh;
    protected TreeViewer viewer;
    protected Object input;
    protected final Object[] noChildren = new Object[0];

    public AbstractMarkerViewContentProvider(TreeViewer viewer, MarkerViewHelper helper, IViewerRefresh viewerRefresh) {
        this.helper = helper;
        this.viewer = viewer;
        this.setViewerRefresh(viewerRefresh);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.input = newInput;
    }

    public void setViewerRefresh(IViewerRefresh refresh) {
        this.viewerRefresh = refresh != null ? refresh : new NullViewerRefresh();
    }

    public IViewerRefresh getViewerRefresh() {
        if (this.viewerRefresh instanceof NullViewerRefresh) {
            return null;
        }
        return this.viewerRefresh;
    }

    public void clear() {
        for (IMarker marker : this.helper.findMarkers((IResource)this.viewer.getInput())) {
            try {
                marker.delete();
            }
            catch (CoreException e) {
                MarkerViewPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.common.tools.report.appenders.reportlogview", e.getLocalizedMessage(), (Throwable)e));
            }
        }
        this.viewerRefresh.refresh();
    }

    protected Collection<IMarker> findMarkers() {
        IResource markerResource = null;
        if (this.input instanceof IResource) {
            markerResource = (IResource)this.viewer.getInput();
        }
        return this.helper.findMarkers(markerResource, null);
    }

    @Override
    public void markerChanged(IMarkerDelta marker) {
    }

    public void dispose() {
    }

    private class NullViewerRefresh
    implements IViewerRefresh {
        private NullViewerRefresh() {
        }

        @Override
        public void refresh() {
        }
    }
}

