/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.appenders.reportlogview;

import org.apache.log4j.Level;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.graphics.Image;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewPlugin;

public enum SeverityLevel {
    DEBUG("Debug", MarkerViewPlugin.getDefault().getImage("debug.gif")),
    INFO("Info", MarkerViewPlugin.getDefault().getImage("inform.gif")),
    WARNING("Warning", MarkerViewPlugin.getDefault().getImage("warn.gif")),
    ERROR("Error", MarkerViewPlugin.getDefault().getImage("error.gif")),
    FATAL("Fatal", MarkerViewPlugin.getDefault().getImage("fatal.gif"));

    private Image image;
    private String representation;

    private SeverityLevel(String representation, Image image) {
        this.representation = representation;
        this.image = image;
    }

    protected static SeverityLevel getLevel(IMarker marker) {
        Object severity;
        SeverityLevel result;
        block11: {
            result = null;
            severity = marker.getAttribute("severity");
            if (severity != null) break block11;
            return null;
        }
        try {
            if (severity instanceof Integer) {
                switch ((Integer)severity) {
                    case 2: {
                        result = ERROR;
                        break;
                    }
                    case 1: {
                        result = WARNING;
                        break;
                    }
                    case 0: {
                        result = INFO;
                    }
                }
            } else if (severity instanceof Level) {
                result = SeverityLevel.getLevel((Level)severity);
            }
        }
        catch (CoreException exception) {
            exception.printStackTrace();
        }
        return result;
    }

    protected static SeverityLevel getLevel(Level level) {
        SeverityLevel result = null;
        if (level.equals((Object)Level.DEBUG)) {
            result = DEBUG;
        } else if (level.equals((Object)Level.INFO)) {
            result = INFO;
        } else if (level.equals((Object)Level.WARN)) {
            result = WARNING;
        } else if (level.equals((Object)Level.ERROR)) {
            result = ERROR;
        } else if (level.equals((Object)Level.FATAL)) {
            result = FATAL;
        }
        return result;
    }

    public String toString() {
        return this.representation;
    }

    public Image getImage() {
        return this.image;
    }
}

