/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.validation.connection;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class ComponentExchangeFEAllocation
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof ComponentExchange) {
            ArrayList<IStatus> statuses = new ArrayList<IStatus>();
            ComponentExchange componentExchange = (ComponentExchange)eObj;
            EList allocatedExchanges = componentExchange.getAllocatedFunctionalExchanges();
            if (allocatedExchanges.size() < 1) {
                return ctx.createSuccessStatus();
            }
            List availableExhcnage = ComponentExchangeExt.getValidFEAvailableForAllocation((ComponentExchange)componentExchange);
            if (availableExhcnage != null && allocatedExchanges != null) {
                for (FunctionalExchange allocatedExchange : allocatedExchanges) {
                    if (availableExhcnage.contains(allocatedExchange)) continue;
                    statuses.add(ctx.createFailureStatus(new Object[]{String.valueOf(componentExchange.getName()) + " (" + componentExchange.eClass().getName() + ") should not allocate " + allocatedExchange.getName() + " (" + allocatedExchange.eClass().getName() + ") regarding ports directions."}));
                }
            }
            if (statuses.size() > 0) {
                return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
            }
        }
        return ctx.createSuccessStatus();
    }
}

