/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ef;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.polarsys.capella.common.ef.ExecutionManager;

public class ExecutionManagerRegistry {
    private static ExecutionManagerRegistry __uniqueInstance;
    private Map<TransactionalEditingDomain, ExecutionManager> _managers = new HashMap<TransactionalEditingDomain, ExecutionManager>(0);

    private ExecutionManagerRegistry() {
    }

    public void dispose() {
        this._managers.clear();
    }

    public static ExecutionManagerRegistry getInstance() {
        if (__uniqueInstance == null) {
            __uniqueInstance = new ExecutionManagerRegistry();
        }
        return __uniqueInstance;
    }

    public ExecutionManager addNewManager() {
        ExecutionManager executionManager = new ExecutionManager();
        this._managers.put(executionManager.getEditingDomain(), executionManager);
        return executionManager;
    }

    public void removeManager(ExecutionManager executionManager) {
        if (executionManager != null && executionManager.getEditingDomain() != null) {
            this._managers.remove(executionManager.getEditingDomain());
        }
    }

    public ExecutionManager getExecutionManager(EditingDomain editingDomain) {
        return this._managers.get(editingDomain);
    }

    public Collection<TransactionalEditingDomain> getAllEditingDomains() {
        return this._managers.keySet();
    }
}

