/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.platform.eclipse.tools.report.ui.pref;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.polarsys.capella.common.tools.report.ReportManagerActivator;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.common.tools.report.ui.pref.CreateBaseComponentTable;
import org.polarsys.capella.common.tools.report.ui.pref.IReportManagerPrefPage;
import org.polarsys.capella.common.tools.report.util.IReportManagerDefaultComponents;

public class ReportManagerPrefPage
extends PreferencePage
implements IWorkbenchPreferencePage,
IReportManagerPrefPage {
    private Combo componentCombo;
    public static Properties preferenceStore = new Properties();
    public static Properties tempStore = new Properties();
    public static Map<String, String> comboItems = new HashMap<String, String>();
    private static final String[] levelsName = new String[]{"DEBUG", "INFO", "WARN", "ERROR", "FATAL"};
    private ReportManagerRegistry registry = ReportManagerRegistry.getInstance();
    private CreateBaseComponentTable componentTable;

    protected void performDefaults() {
        super.performDefaults();
        this.componentTable.defaultValues();
    }

    public Control createContents(Composite parent) {
        Composite root = new Composite(parent, 0);
        root.setLayout((Layout)new GridLayout(1, false));
        Label comboLabel = new Label(root, 0);
        comboLabel.setText("Select Category :");
        this.componentCombo = this.createComponentCombo(root);
        this.componentTable = new CreateBaseComponentTable(root, 0, this.registry, (IReportManagerPrefPage)this, levelsName);
        this.componentCombo.notifyListeners(13, null);
        return root;
    }

    public void init(IWorkbench workbench) {
    }

    public Combo createComponentCombo(Composite parent) {
        Field[] fields;
        Field[] fieldArray = fields = IReportManagerDefaultComponents.class.getDeclaredFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            try {
                String componentName = (String)f.get(null);
                this.registry.subscribe(componentName);
            }
            catch (Exception exception) {
                ReportManagerActivator.getDefault().getLog().log((IStatus)new Status(4, ReportManagerActivator.getDefault().getBundle().getSymbolicName(), exception.getMessage(), (Throwable)exception));
            }
            ++n2;
        }
        Combo combo = new Combo(parent, 8);
        Object[] componentList = this.registry.getComponentsList();
        String[] items = new String[componentList.length];
        int i = 0;
        while (i < componentList.length) {
            items[i] = componentList[i].toString();
            ++i;
        }
        Arrays.sort(items, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if ("Default".equals(o1)) {
                    return -1;
                }
                if ("Default".equals(o2)) {
                    return 1;
                }
                return o1.compareTo(o2);
            }
        });
        if (items.length == 0) {
            combo.setEnabled(false);
            this.setErrorMessage("No Application Component available.");
        } else {
            if (!combo.isEnabled()) {
                combo.setEnabled(true);
            }
            combo.setItems(items);
            combo.select(0);
        }
        SelectionAdapter componentHandler = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (event.widget instanceof Combo) {
                    Combo comboWidget = (Combo)event.widget;
                    ReportManagerPrefPage.this.componentTable.selectPage(comboWidget.getText());
                }
            }
        };
        combo.addSelectionListener((SelectionListener)componentHandler);
        return combo;
    }

    public boolean performOk() {
        this.componentTable.updateConfigurationHashMap(this.registry.getConfigurations());
        this.registry.saveConfiguration();
        return super.performOk();
    }

    public Properties get_preferenceStore() {
        return preferenceStore;
    }
}

