/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.cs.validation.component;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentRealization;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class ComponentRealization_Consistency
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        HashMap<EClass, EClass> validTarget = new HashMap<EClass, EClass>();
        validTarget.put(CtxPackage.Literals.SYSTEM_COMPONENT, OaPackage.Literals.ENTITY);
        validTarget.put(LaPackage.Literals.LOGICAL_COMPONENT, CtxPackage.Literals.SYSTEM_COMPONENT);
        validTarget.put(PaPackage.Literals.PHYSICAL_COMPONENT, LaPackage.Literals.LOGICAL_COMPONENT);
        HashMap<EClass, EClass> validSource = new HashMap<EClass, EClass>();
        validSource.put(OaPackage.Literals.ENTITY, CtxPackage.Literals.SYSTEM_COMPONENT);
        validSource.put(CtxPackage.Literals.SYSTEM_COMPONENT, LaPackage.Literals.LOGICAL_COMPONENT);
        validSource.put(LaPackage.Literals.LOGICAL_COMPONENT, PaPackage.Literals.PHYSICAL_COMPONENT);
        if (eType == EMFEventType.NULL && eObj instanceof Component) {
            ArrayList<IStatus> statuses = new ArrayList<IStatus>();
            Component actor = (Component)eObj;
            if (!BlockArchitectureExt.isRootComponent((Component)actor)) {
                EList traces = actor.getOutgoingTraces();
                if (traces.size() < 1) {
                    return ctx.createSuccessStatus();
                }
                for (AbstractTrace next : traces) {
                    if (!(next instanceof ComponentRealization)) continue;
                    TraceableElement source = next.getSourceElement();
                    TraceableElement target = next.getTargetElement();
                    String actorInfo = CapellaElementExt.getValidationRuleMessagePrefix((AbstractNamedElement)actor);
                    if (source == null) {
                        statuses.add(ctx.createFailureStatus(new Object[]{String.valueOf(actorInfo) + " contain realization with inconsistent Source (it should be not empty)"}));
                        continue;
                    }
                    if (target == null) {
                        statuses.add(ctx.createFailureStatus(new Object[]{String.valueOf(actorInfo) + " contain realization with inconsistent Target (it should be not empty)"}));
                        continue;
                    }
                    if (validTarget.containsKey(source.eClass()) && !((EClass)validTarget.get(source.eClass())).isInstance((Object)target)) {
                        statuses.add(ctx.createFailureStatus(new Object[]{String.valueOf(actorInfo) + " contain realization with inconsistent Target (it should be instance of " + ((EClass)validTarget.get(source.eClass())).getName() + ")"}));
                    }
                    if (!validSource.containsKey(target.eClass()) || ((EClass)validSource.get(target.eClass())).isInstance((Object)source)) continue;
                    statuses.add(ctx.createFailureStatus(new Object[]{String.valueOf(actorInfo) + " contain realization with inconsistent Source (it should be instance of " + ((EClass)validSource.get(target.eClass())).getName() + ")"}));
                }
            }
            if (statuses.size() > 0) {
                return ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
            }
        }
        return ctx.createSuccessStatus();
    }
}

