/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.cs.validation.physicalPath;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.cs.PhysicalPath;
import org.polarsys.capella.core.data.cs.PhysicalPathInvolvement;
import org.polarsys.capella.core.data.cs.validation.physicalPath.Messages;
import org.polarsys.capella.core.model.helpers.PhysicalPathExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class MDCHK_PhysicalPath_InvolvedLinks
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof PhysicalPath) {
            PhysicalPath chain = (PhysicalPath)eObj;
            if (chain.getOwnedPhysicalPathInvolvements().isEmpty()) {
                return ctx.createFailureStatus(new Object[]{chain.getName(), Messages.MDCHK_PhysicalPath_InvolvedLinks_IsEmpty});
            }
            String involvedElements = "";
            ArrayList<PhysicalPathInvolvement> invsNoValid = new ArrayList<PhysicalPathInvolvement>();
            for (PhysicalPathInvolvement inv : chain.getOwnedPhysicalPathInvolvements()) {
                IStatus status = PhysicalPathExt.isPhysicalPathInvolvementValidWithStatus((PhysicalPathInvolvement)inv);
                if (status.isOK()) continue;
                involvedElements = String.valueOf(involvedElements) + EObjectLabelProviderHelper.getText((Object)inv);
                involvedElements = String.valueOf(involvedElements) + ' ';
                involvedElements = String.valueOf(involvedElements) + '(';
                involvedElements = String.valueOf(involvedElements) + status.getMessage();
                involvedElements = String.valueOf(involvedElements) + ')';
                involvedElements = String.valueOf(involvedElements) + '\n';
                invsNoValid.add(inv);
            }
            if (!invsNoValid.isEmpty()) {
                return ctx.createFailureStatus(new Object[]{chain.getName(), NLS.bind((String)Messages.MDCHK_PhysicalPath_InvolvedLinks_InvolvementInvalid, (Object)String.valueOf(invsNoValid.size()), (Object)involvedElements)});
            }
            if (!PhysicalPathExt.isPhysicalPathWellFormed((PhysicalPath)chain)) {
                return ctx.createFailureStatus(new Object[]{chain.getName(), Messages.MDCHK_PhysicalPath_InvolvedLinks_NotWellFormed});
            }
            EList sources = chain.getFirstPhysicalPathInvolvements();
            if (sources.isEmpty()) {
                return ctx.createFailureStatus(new Object[]{chain.getName(), Messages.MDCHK_PhysicalPath_InvolvedLinks_NoSource});
            }
            for (PhysicalPathInvolvement source : sources) {
                if (!PhysicalPathExt.containsACycle((PhysicalPathInvolvement)source, new HashSet())) continue;
                return ctx.createFailureStatus(new Object[]{chain.getName(), Messages.MDCHK_PhysicalPath_InvolvedLinks_ContainsACycle});
            }
        }
        return ctx.createSuccessStatus();
    }
}

