/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.handlers.transformation;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.core.transition.common.constants.Messages;
import org.polarsys.capella.core.transition.common.handlers.attachment.AttachmentHelper;
import org.polarsys.capella.core.transition.common.handlers.log.LogHelper;
import org.polarsys.capella.core.transition.common.handlers.scope.ScopeHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.selection.EClassSelectionContext;
import org.polarsys.capella.core.transition.common.handlers.selection.ISelectionContext;
import org.polarsys.capella.core.transition.common.handlers.selection.SelectionContextHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.traceability.ITraceabilityHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.TraceabilityHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.transformation.ITransformationHandler;
import org.polarsys.capella.core.transition.common.handlers.transformation.TransformationHandlerHelper;
import org.polarsys.capella.core.transition.common.rules.IRuleTransformation;
import org.polarsys.kitalpha.transposer.rules.handler.api.IRulesHandler;
import org.polarsys.kitalpha.transposer.rules.handler.exceptions.possibilities.MappingPossibilityResolutionException;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IRule;
import org.polarsys.kitalpha.transposer.rules.handler.rules.common.MappingPossibility;

public class DefaultTransformationHandler
implements ITransformationHandler {
    @Override
    public IStatus isOrWillBeTransformed(EObject source, IContext context) {
        IRulesHandler ruleHandler = (IRulesHandler)context.get((Object)"_R_H");
        ITraceabilityHandler handler = (ITraceabilityHandler)context.get((Object)"TTrH");
        boolean result = handler.isTraced(source, context);
        if (!result && ScopeHandlerHelper.getInstance(context).isInScope(source, context)) {
            try {
                IRule rule;
                MappingPossibility mapping = ruleHandler.getApplicablePossibility((Object)source);
                if (mapping != null && (rule = ruleHandler.getApplicablePossibility((Object)source).getCompleteRule()) != null && rule instanceof IRuleTransformation) {
                    IRuleTransformation deeperRule = (IRuleTransformation)rule;
                    result = deeperRule.applyRequired(source, context).isOK() && deeperRule.transformRequired(source, context).isOK();
                }
            }
            catch (MappingPossibilityResolutionException mappingPossibilityResolutionException) {
                // empty catch block
            }
        }
        if (result) {
            return Status.OK_STATUS;
        }
        return new Status(2, Messages.Activity_Transformation, NLS.bind((String)"Element ''{0}'' will not be transitioned.", (Object)LogHelper.getInstance().getText(source)));
    }

    @Override
    public IStatus init(IContext context) {
        return Status.OK_STATUS;
    }

    @Override
    public IStatus dispose(IContext context) {
        return Status.OK_STATUS;
    }

    @Override
    public EObject getLevelElement(EObject source, IContext context) {
        return source.eContainer();
    }

    @Override
    public EObject getBestTracedElement(EObject source, IContext context, ISelectionContext sContext) {
        for (EObject target : TraceabilityHandlerHelper.getInstance(context).retrieveTracedElements(source, context)) {
            if (sContext != null && !sContext.match(source, target, context)) continue;
            return target;
        }
        return null;
    }

    @Override
    public EClass getTargetType(EObject source, IContext context) {
        IRulesHandler ruleHandler = (IRulesHandler)context.get((Object)"_R_H");
        try {
            IRule rule;
            MappingPossibility mapping = ruleHandler.getApplicablePossibility((Object)source);
            if (mapping != null && (rule = ruleHandler.getApplicablePossibility((Object)source).getCompleteRule()) != null && rule instanceof IRuleTransformation) {
                IRuleTransformation deeperRule = (IRuleTransformation)rule;
                return deeperRule.getTargetType(source, context);
            }
        }
        catch (MappingPossibilityResolutionException mappingPossibilityResolutionException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public IStatus checkTransformRequired(EObject source, IContext context, EObject sourceElement) {
        IStatus result = Status.OK_STATUS;
        if (sourceElement != null) {
            if (!TransformationHandlerHelper.getInstance(context).isOrWillBeTransformed(sourceElement, context).isOK()) {
                result = new Status(2, Messages.Activity_Transformation, NLS.bind((String)"{1} ''{0}'' is linked to an element which is not transitioned.", (Object)LogHelper.getInstance().getText(source), (Object)LogHelper.getInstance().getText(source.eClass())));
            }
        } else {
            result = new Status(2, Messages.Activity_Transformation, NLS.bind((String)"{1} ''{0}'' is linked to an null element.", (Object)LogHelper.getInstance().getText(source), (Object)LogHelper.getInstance().getText(source.eClass())));
        }
        return result;
    }

    @Override
    public IStatus checkTransformRequired(EObject source, IContext context, EObject sourceElement, EObject targetElement) {
        IStatus result = Status.OK_STATUS;
        if (sourceElement != null && targetElement != null) {
            if (!TransformationHandlerHelper.getInstance(context).isOrWillBeTransformed(sourceElement, context).isOK() || !TransformationHandlerHelper.getInstance(context).isOrWillBeTransformed(targetElement, context).isOK()) {
                result = new Status(2, Messages.Activity_Transformation, NLS.bind((String)"{1} ''{0}'' is linked to an element which is not transitioned.", (Object)LogHelper.getInstance().getText(source), (Object)LogHelper.getInstance().getText(source.eClass())));
            }
        } else {
            result = new Status(2, Messages.Activity_Transformation, NLS.bind((String)"{1} ''{0}'' is linked to an null element.", (Object)LogHelper.getInstance().getText(source), (Object)LogHelper.getInstance().getText(source.eClass())));
        }
        return result;
    }

    @Override
    public EObject getBestTracedElement(EObject root, IContext context, EClass eClass) {
        ISelectionContext sContext = SelectionContextHandlerHelper.getHandler(context).getSelectionContext(context, "SC__T");
        EClassSelectionContext classContext = new EClassSelectionContext(sContext, eClass);
        return this.getBestTracedElement(root, context, classContext);
    }

    @Override
    public EObject getBestTracedElement(EObject root, IContext context, EClass eClass, EObject element, EObject result) {
        ISelectionContext sContext = SelectionContextHandlerHelper.getHandler(context).getSelectionContext(context, "SC__T", element, result);
        EClassSelectionContext classContext = new EClassSelectionContext(sContext, eClass);
        return this.getBestTracedElement(root, context, classContext);
    }

    @Override
    public void postTransformElement(EObject element, EObject result, IContext context) {
        AttachmentHelper.getInstance(context).createdElement(element, result, context);
    }
}

