/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.doc.gen.business.ecore.task;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.core.domain.TargetPlatformResourceSet;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.egf.ftask.producer.invocation.ITaskProduction;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.pattern.TypePatternSubstitution;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.polarsys.kitalpha.doc.gen.business.core.ui.helper.InvokeActivityHelper;
import org.polarsys.kitalpha.doc.gen.business.ecore.actions.GenDocCommand;
import org.polarsys.kitalpha.doc.gen.business.ecore.helpers.ResourceHelper;

public class EcoreDocGenLauncherTask
implements ITaskProduction {
    private String ecoreFilePath;
    private String outputDirectoryPath;
    private TypePatternSubstitution patternSub;
    private static final URI DEFAULT_ECORE_LAUNCHER_URI = URI.createURI((String)"platform:/plugin/org.polarsys.kitalpha.doc.gen.business.ecore/egf/EcoreDocGenLauncher.fcore#_oW26AYaqEeCqVPyWxeH-sg");
    private String copyright;
    private String logoPath;
    private String logoAlt;

    public void preExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        this.ecoreFilePath = (String)productionContext.getInputValue((Object)"ecoreFilePath", String.class);
        this.outputDirectoryPath = (String)productionContext.getInputValue((Object)"outputDirectoryPath", String.class);
        this.patternSub = (TypePatternSubstitution)productionContext.getInputValue((Object)"pattern.substitutions", TypePatternSubstitution.class);
        this.copyright = (String)productionContext.getInputValue((Object)"copyright", String.class);
        this.logoPath = (String)productionContext.getInputValue((Object)"logo.path", String.class);
        this.logoAlt = (String)productionContext.getInputValue((Object)"logo.alt", String.class);
    }

    public void doExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        URI ecoreURI = root.getFile((IPath)new Path(this.ecoreFilePath)).exists() ? URI.createPlatformResourceURI((String)this.ecoreFilePath, (boolean)false) : URI.createPlatformPluginURI((String)this.ecoreFilePath, (boolean)false);
        ResourceHelper.checkResource(this.outputDirectoryPath);
        IPath outputLocation = root.getFolder((IPath)new Path(this.outputDirectoryPath)).getLocation();
        ResourceHelper.makeFolderWritable(root.getFolder(outputLocation));
        TargetPlatformResourceSet resourceSet = new TargetPlatformResourceSet();
        Resource semanticResource = resourceSet.getResource(ecoreURI, true);
        Activity launcher = InvokeActivityHelper.getActivity((URI)DEFAULT_ECORE_LAUNCHER_URI);
        GenDocCommand command = new GenDocCommand(launcher, this.outputDirectoryPath, semanticResource, this.patternSub, monitor);
        command.setCopyright(this.copyright);
        command.setLogoAlt(this.logoAlt);
        command.setLogoPath(this.logoPath);
        command.execute(monitor);
    }

    public void postExecute(ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
    }
}

