/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.flexibility.wizards.renderer;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IServiceLocator;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IRestraintProperty;
import org.polarsys.capella.common.flexibility.wizards.renderer.AbstractRenderer;
import org.polarsys.capella.common.flexibility.wizards.schema.IRendererContext;
import org.polarsys.capella.common.flexibility.wizards.ui.DefaultLabelProvider;
import org.polarsys.capella.common.flexibility.wizards.ui.FlexibilityColors;
import org.polarsys.capella.common.flexibility.wizards.ui.util.ToolbarPopulator;
import org.polarsys.capella.common.ui.toolkit.viewers.TreeAndListViewer;
import org.polarsys.capella.common.ui.toolkit.viewers.data.AbstractData;
import org.polarsys.capella.common.ui.toolkit.viewers.data.DataContentProvider;
import org.polarsys.capella.common.ui.toolkit.viewers.data.DataViewerLabelProvider;
import org.polarsys.capella.common.ui.toolkit.viewers.data.ListData;
import org.polarsys.capella.common.ui.toolkit.viewers.data.TreeData;
import org.polarsys.capella.common.ui.toolkit.widgets.filter.CapellaFilteredTree;

public class SelectListRenderer
extends AbstractRenderer {
    private TreeAndListViewer viewer;
    protected ToolBarManager toolbarManager;
    private ToolbarPopulator toolbarPopulator = null;
    private ToolbarPopulator popupPopulator = null;
    protected MenuManager popupManager;
    protected IStructuredSelection selection;
    private ILabelProvider labelProvider;
    private DataViewerLabelProvider dataLabelProvider;

    protected TreeAndListViewer getViewer() {
        return this.viewer;
    }

    @Override
    public void performRender(Composite parent, IRendererContext rendererContext) {
        this.labelProvider = this.createLabelProvider(rendererContext);
        Composite prt = new Composite(parent, 0);
        prt.setLayout(this.createMainLayout());
        prt.setLayoutData(this.createMainLayoutData());
        this.createTreeViewer(prt, rendererContext);
        IEclipseContext context = (IEclipseContext)PlatformUI.getWorkbench().getService(IEclipseContext.class);
        if (!this.getToolbarLocation().isEmpty()) {
            this.toolbarPopulator = new ToolbarPopulator((ContributionManager)this.toolbarManager, this.getToolbarLocation(), rendererContext, this, (ISelectionProvider)this.getViewer().getClientViewer(), (IServiceLocator)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            ContextInjectionFactory.inject((Object)this.toolbarPopulator, (IEclipseContext)context);
            this.toolbarPopulator.populate();
        }
        if (this.dataLabelProvider != null) {
            this.dataLabelProvider.setViewer(this.getViewer().getClientViewer());
        }
    }

    protected void initializeControls(Composite parent, IRendererContext context) {
        if (!this.getToolbarLocation().isEmpty()) {
            ToolBar toolbar = new ToolBar(parent, 512);
            toolbar.setLayout(this.createLayout());
            toolbar.setLayoutData(this.createToolbarLayoutData());
            this.toolbarManager = new ToolBarManager(toolbar);
        }
        if (!this.getPopupLocation().isEmpty()) {
            this.popupManager = new MenuManager();
        }
    }

    protected String getPopupLocation() {
        return "popup";
    }

    protected String getToolbarLocation() {
        return "";
    }

    protected ILabelProvider createLabelProvider(final IRendererContext rendererContext) {
        this.dataLabelProvider = new DataViewerLabelProvider(rendererContext.getLabelProvider()){

            protected boolean isValid(Object element) {
                return super.isValid(element) && SelectListRenderer.this.isValidElement(element, rendererContext);
            }
        };
        return new DefaultLabelProvider((ILabelProvider)this.dataLabelProvider){

            @Override
            public Color getBackground(Object element) {
                IStatus status = SelectListRenderer.this.getStatus(element, rendererContext);
                if (status == null || status.isOK()) {
                    return null;
                }
                ColorRegistry colors = FlexibilityColors.getColorRegistry();
                if (status.matches(1)) {
                    return colors.get("infoStatusBgColor");
                }
                if (status.matches(2)) {
                    return colors.get("warningStatusBgColor");
                }
                if (status.matches(4)) {
                    return colors.get("errorStatusBgColor");
                }
                return null;
            }
        };
    }

    protected boolean isValidElement(Object element, IRendererContext rendererContext) {
        return true;
    }

    protected IStatus getStatus(Object element, IRendererContext rendererContext) {
        return Status.OK_STATUS;
    }

    protected boolean isFilterBar() {
        return true;
    }

    protected boolean isMultipleSelection() {
        return true;
    }

    protected void createTreeViewer(Composite parent, final IRendererContext context) {
        int style = 0;
        this.viewer = new TreeAndListViewer(parent, this.isMultipleSelection(), style){

            public String getContextMenuLocation() {
                return SelectListRenderer.this.getPopupLocation();
            }

            protected TreeViewer doClientViewer(Composite parent) {
                CapellaFilteredTree filteredTree = new CapellaFilteredTree(parent, this.getTreeStyle(), this.getFilter()){

                    protected void createControl(Composite parent, int treeStyle) {
                        GridLayout layout = new GridLayout(2, false);
                        layout.marginHeight = 0;
                        layout.marginWidth = 0;
                        this.setLayout((Layout)layout);
                        this.setLayoutData(new GridData(4, 4, true, true));
                        Composite filteredTreeComposite = new Composite((Composite)this, 0);
                        filteredTreeComposite.setLayout((Layout)new GridLayout());
                        filteredTreeComposite.setLayoutData((Object)new GridData(4, 4, true, true));
                        if (this.showFilterControls) {
                            this.filterComposite = new Composite(filteredTreeComposite, 2048);
                            this.filterComposite.setBackground(this.getDisplay().getSystemColor(25));
                            GridLayout filterLayout = new GridLayout(2, false);
                            filterLayout.marginHeight = 0;
                            filterLayout.marginWidth = 0;
                            this.filterComposite.setLayout((Layout)filterLayout);
                            this.filterComposite.setFont(parent.getFont());
                            this.createFilterControls(this.filterComposite);
                            this.filterComposite.setLayoutData((Object)new GridData(4, 1, true, false));
                        }
                        this.treeComposite = new Composite(filteredTreeComposite, 0);
                        GridLayout treeCompositeLayout = new GridLayout();
                        treeCompositeLayout.marginHeight = 0;
                        treeCompositeLayout.marginWidth = 0;
                        this.treeComposite.setLayout((Layout)treeCompositeLayout);
                        GridData data = new GridData(4, 4, true, true);
                        this.treeComposite.setLayoutData((Object)data);
                        this.createTreeControl(this.treeComposite, treeStyle);
                        SelectListRenderer.this.initializeControls((Composite)this, context);
                    }
                };
                TreeViewer viewer = filteredTree.getViewer();
                this.setExpandLevel(viewer);
                return viewer;
            }

            protected void setExpandLevel(TreeViewer viewer) {
                viewer.setAutoExpandLevel(SelectListRenderer.this.getExpandLevel());
            }
        };
        this.viewer.getControl().setLayout(this.createLayout());
        this.viewer.getControl().setLayoutData(this.createLayoutData());
        TreeViewer clientViewer = this.viewer.getClientViewer();
        ISelectionChangedListener viewerSelectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SelectListRenderer.this.selection = (IStructuredSelection)event.getSelection();
                SelectListRenderer.this.selectionChange(SelectListRenderer.this.selection, context);
            }
        };
        clientViewer.addSelectionChangedListener(viewerSelectionChangedListener);
        IDoubleClickListener viewerDoubleClickListener = new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (SelectListRenderer.this.isValidDoubleClick(event, selection, context)) {
                    SelectListRenderer.this.doubleClicked(selection, context);
                }
            }
        };
        clientViewer.addDoubleClickListener(viewerDoubleClickListener);
        clientViewer.setContentProvider(this.createContentProvider(context));
        clientViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
    }

    protected ISelection getInitialSelection(IRendererContext context) {
        return new StructuredSelection();
    }

    protected int getExpandLevel() {
        return 2;
    }

    protected Object createToolbarLayoutData() {
        GridData layoutData = new GridData(1, 4, false, true);
        return layoutData;
    }

    protected Object createLayoutData() {
        GridData layoutData = new GridData(4, 4, true, true);
        return layoutData;
    }

    protected Layout createMainLayout() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        return layout;
    }

    protected Object createMainLayoutData() {
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.minimumHeight = 300;
        return layoutData;
    }

    protected Layout createLayout() {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        return layout;
    }

    protected void reloadInput(IProperty property, IRendererContext propertyContext) {
        Object input = this.createInput(property, propertyContext);
        if (this.viewer != null && this.viewer.getClientViewer().getContentProvider() != null && this.reloadInputRequired(input, this.viewer.getClientViewer().getInput())) {
            this.setInput(input, propertyContext);
        }
    }

    private void setInput(Object input, IRendererContext propertyContext) {
        this.viewer.setInput(input);
        IContentProvider provider = this.viewer.getClientViewer().getContentProvider();
        if (provider != null) {
            provider.inputChanged((Viewer)this.viewer.getClientViewer(), null, input);
        }
    }

    public boolean reloadInputRequired(Object input, Object input2) {
        return true;
    }

    protected void searchClicked(String pattern, IRendererContext context) {
        IProperty property = context.getProperty(this);
        this.reloadInput(property, context);
    }

    protected boolean isValidDoubleClick(DoubleClickEvent event, ISelection selection, IRendererContext context) {
        if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection sel = (IStructuredSelection)selection;
        List<Object> value = this.isMultipleSelection() ? sel.toList() : Collections.singletonList(sel.getFirstElement());
        for (Object e : value) {
            Object input = event.getViewer().getInput();
            if (!(input instanceof AbstractData) || ((AbstractData)input).isValid(e)) continue;
            return false;
        }
        return true;
    }

    protected void doubleClicked(ISelection doubleClickedElement, IRendererContext context) {
    }

    protected IContentProvider createContentProvider(IRendererContext rendererContext) {
        return new DataContentProvider();
    }

    protected Object createInput(IProperty property, IRendererContext context) {
        Collection value;
        if (property instanceof IRestraintProperty && (value = ((IRestraintProperty)property).getChoiceValues(context.getPropertyContext())) != null) {
            Collection dataa = value;
            TreeData data = new TreeData(dataa, null);
            return data;
        }
        return new ListData(Collections.emptyList(), null);
    }

    @Override
    public void initialize(IProperty property, IRendererContext propertyContext) {
        Object value = propertyContext.getPropertyContext().getDefaultValue(property);
        this.updatedValue(property, propertyContext, value);
        this.reloadInput(property, propertyContext);
        this.selectionChange((IStructuredSelection)new StructuredSelection(), propertyContext);
    }

    public void selectionChange(IStructuredSelection selection, IRendererContext context) {
        Object value = this.isMultipleSelection() ? selection.toList() : selection.getFirstElement();
        this.changeValue(context.getProperty(this), context, value);
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    @Override
    public void updatedValue(IProperty property, IRendererContext propertyContext, Object newValue) {
    }

    @Override
    public void dispose(IRendererContext context) {
        super.dispose(context);
        if (this.toolbarPopulator != null) {
            this.toolbarPopulator.dispose();
            this.toolbarPopulator = null;
        }
        if (this.popupPopulator != null) {
            this.popupPopulator.dispose();
            this.popupPopulator = null;
        }
        if (this.popupManager != null) {
            this.popupManager.dispose();
            this.popupManager = null;
        }
    }
}

