/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.gen.template.scripts.imports.services;

import org.eclipse.sirius.query.legacy.ecore.factories.FactoryException;
import org.eclipse.sirius.query.legacy.gen.template.TemplateSyntaxException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENode;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeCastException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeException;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeIterator;
import org.eclipse.sirius.query.legacy.gen.template.eval.ENodeList;
import org.eclipse.sirius.query.legacy.gen.template.eval.LaunchManager;
import org.eclipse.sirius.query.legacy.gen.template.expressions.TemplateExpression;
import org.eclipse.sirius.query.legacy.gen.template.scripts.IScript;
import org.eclipse.sirius.query.legacy.tools.strings.Int2;

public class RequestServices {
    protected IScript script;

    public RequestServices(IScript script) {
        this.script = script;
    }

    @Deprecated
    public ENode select(ENode current, String call) throws FactoryException, ENodeCastException, TemplateSyntaxException {
        return this.select(current, call, new ENode(true, current));
    }

    @Deprecated
    public ENode select(ENode current, String call, ENode value) throws FactoryException, ENodeCastException, TemplateSyntaxException {
        int pos = this.getBegin();
        call = call.replaceAll("'", "\\\"");
        TemplateExpression expression = TemplateExpression.fromString(this.computeCall(pos, call), new Int2(pos, pos + call.length()), this.script);
        return this.select(current, expression, value);
    }

    private ENode select(ENode current, TemplateExpression call, ENode value) throws FactoryException, ENodeCastException {
        if (current.isList()) {
            ENodeList list = current.getList();
            ENodeList res = new ENodeList();
            ENodeIterator it = list.iterator();
            while (it.hasNext()) {
                res.add(this.select(it.next(), call, value));
            }
            return new ENode(res, current);
        }
        try {
            ENode result = call.evaluate(current, this.script, LaunchManager.create("run", true));
            if (result.equals(value)) {
                return current;
            }
            return new ENode(ENode.EMPTY, current);
        }
        catch (ENodeException eNodeException) {
            return new ENode(ENode.EMPTY, current);
        }
    }

    @Deprecated
    public ENode delete(ENode current, String call) throws FactoryException, ENodeCastException, TemplateSyntaxException {
        return this.delete(current, call, new ENode(true, current));
    }

    @Deprecated
    public ENode delete(ENode current, String call, ENode value) throws FactoryException, ENodeCastException, TemplateSyntaxException {
        int pos = this.getBegin();
        call = call.replaceAll("'", "\\\"");
        TemplateExpression expression = TemplateExpression.fromString(this.computeCall(pos, call), new Int2(pos, pos + call.length()), this.script);
        return this.delete(current, expression, value);
    }

    private ENode delete(ENode current, TemplateExpression call, ENode value) throws FactoryException, ENodeCastException {
        if (current.isList()) {
            ENodeList list = current.getList();
            ENodeList res = new ENodeList();
            ENodeIterator it = list.iterator();
            while (it.hasNext()) {
                res.add(this.delete(it.next(), call, value));
            }
            return new ENode(res, current);
        }
        try {
            ENode result = call.evaluate(current, this.script, LaunchManager.create("run", true));
            if (!result.equals(value)) {
                return current;
            }
            return new ENode(ENode.EMPTY, current);
        }
        catch (ENodeException eNodeException) {
            return new ENode(ENode.EMPTY, current);
        }
    }

    public ENode evaluate(ENode current, String call) throws TemplateSyntaxException, FactoryException {
        int pos = this.getBegin();
        call = call.replaceAll("'", "\\\"");
        TemplateExpression expression = TemplateExpression.fromString(this.computeCall(pos, call), new Int2(pos, pos + call.length()), this.script);
        try {
            return expression.evaluate(current, this.script, LaunchManager.create("run", true));
        }
        catch (ENodeException eNodeException) {
            return new ENode(ENode.EMPTY, current);
        }
    }

    private int getBegin() {
        Int2 pos = (Int2)this.script.contextPeek(IScript.ARGUMENT_POSITION);
        if (pos != null) {
            return pos.b();
        }
        return 0;
    }

    private String computeCall(int begin, String call) {
        if (begin > 0) {
            StringBuffer result = new StringBuffer("");
            int i = 0;
            while (i < begin) {
                result.append(' ');
                ++i;
            }
            result.append(call);
            return result.toString();
        }
        return call;
    }
}

