/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.diagrams.misc;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstance;
import org.eclipse.emf.diffmerge.patterns.core.util.LocationsUtil;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternData;
import org.eclipse.emf.diffmerge.structures.common.FOrderedSet;
import org.eclipse.emf.diffmerge.util.ModelsUtil;
import org.eclipse.emf.ecore.EObject;

public class InstanceBasedFilter
implements ModelsUtil.IElementFilter {
    private final Collection<IPatternInstance> _instances;
    private Collection<EObject> _instanceElements;

    public InstanceBasedFilter(IPatternInstance instance_p) {
        this(Collections.singleton(instance_p));
    }

    public InstanceBasedFilter(Collection<? extends IPatternInstance> instances_p) {
        this._instances = Collections.unmodifiableCollection(new FOrderedSet(instances_p));
        this._instanceElements = null;
    }

    public boolean accepts(EObject element_p) {
        if (this._instanceElements == null) {
            this.initialize();
        }
        return this._instanceElements.contains(element_p);
    }

    private void initialize() {
        this._instanceElements = new FOrderedSet();
        for (IPatternInstance instance : this._instances) {
            if (instance.getPatternData() instanceof TemplatePatternData) {
                TemplatePatternData data = (TemplatePatternData)instance.getPatternData();
                this._instanceElements.addAll((Collection<EObject>)data.getInstanceElements());
                continue;
            }
            this._instanceElements.addAll(LocationsUtil.getMergeTargets((IPatternApplication)instance));
        }
    }
}

