/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.EdgeStyle;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.MappingWithInterpreterHelper;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.style.EdgeStyleDescription;
import org.eclipse.sirius.diagram.model.business.internal.operations.DDiagramSpecOperations;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.RGBValues;
import org.eclipse.swt.graphics.RGB;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.helpers.SimpleOrientedGraph;
import org.polarsys.capella.core.business.queries.IBusinessQuery;
import org.polarsys.capella.core.business.queries.capellacore.BusinessQueriesProvider;
import org.polarsys.capella.core.commands.preferences.service.ScopedCapellaPreferencesStore;
import org.polarsys.capella.core.commands.preferences.util.PreferencesHelper;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.cs.AbstractDeploymentLink;
import org.polarsys.capella.core.data.cs.AbstractPhysicalLinkEnd;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.DeployableElement;
import org.polarsys.capella.core.data.cs.DeploymentTarget;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalLinkEnd;
import org.polarsys.capella.core.data.cs.PhysicalPath;
import org.polarsys.capella.core.data.cs.PhysicalPathInvolvement;
import org.polarsys.capella.core.data.cs.PhysicalPathReference;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.ComponentPortAllocation;
import org.polarsys.capella.core.data.helpers.cache.ModelCache;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.pa.PaFactory;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.data.pa.PhysicalComponentPkg;
import org.polarsys.capella.core.data.pa.deployment.DeploymentFactory;
import org.polarsys.capella.core.data.pa.deployment.PartDeploymentLink;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.ComponentPkgExt;
import org.polarsys.capella.core.model.helpers.PartExt;
import org.polarsys.capella.core.model.helpers.PhysicalComponentExt;
import org.polarsys.capella.core.model.helpers.PhysicalLinkExt;
import org.polarsys.capella.core.model.helpers.PhysicalPathExt;
import org.polarsys.capella.core.model.helpers.graph.PhysicalPathInternalLinksGraph;
import org.polarsys.capella.core.model.helpers.graph.PhysicalPathInvolvementGraph;
import org.polarsys.capella.core.model.preferences.CapellaModelPreferencesPlugin;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.ColorManager;
import org.polarsys.capella.core.sirius.analysis.CsServices;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.FaServices;
import org.polarsys.capella.core.sirius.analysis.ShapeUtil;
import org.polarsys.capella.core.sirius.analysis.cache.DEdgeIconCache;
import org.polarsys.capella.core.sirius.analysis.cache.PhysicalPathCache;
import org.polarsys.capella.core.sirius.analysis.constants.MappingConstantsHelper;
import org.polarsys.capella.core.sirius.analysis.tool.HashMapSet;

public class PhysicalServices {
    private static PhysicalServices __service = null;
    private static final Integer THICK_EDGE_PHYSICAL_PATH = 4;
    private static final String INCOMPLETE_PHYSICAL_PATH_LABEL = "incomplete";
    private static final String INVALID_PHYSICAL_PATH_LABEL = "invalid";

    public static PhysicalServices getService() {
        if (__service == null) {
            __service = new PhysicalServices();
        }
        return __service;
    }

    public boolean isMultipleDeploymentAllowed() {
        return CapellaModelPreferencesPlugin.getDefault().isMultipleDeploymentAllowed();
    }

    public Collection<EObject> getPhysicalPathSources(PhysicalPath path) {
        HashSet<EObject> result = new HashSet<EObject>();
        for (PhysicalPathInvolvement anInvolvement : PhysicalPathExt.getFlatInvolvementsOf((PhysicalPath)path, (EClass)CsPackage.Literals.PHYSICAL_LINK)) {
            PhysicalLink currentExchange = (PhysicalLink)anInvolvement.getInvolved();
            if (currentExchange == null || currentExchange.eIsProxy()) continue;
            Port source = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getSourcePort((PhysicalLink)currentExchange);
            result.add((EObject)source);
            Port target = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetPort((PhysicalLink)currentExchange);
            result.add((EObject)target);
        }
        return result;
    }

    public Collection<EObject> getPhysicalPathTargets(PhysicalPath path) {
        return this.getPhysicalPathSources(path);
    }

    public List<EObject> getAvailableComponentsToDeploy(PhysicalComponent context) {
        IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(PaPackage.Literals.PHYSICAL_COMPONENT, (EStructuralFeature)CsPackage.Literals.ABSTRACT_DEPLOYMENT_LINK__DEPLOYED_ELEMENT);
        return query.getAvailableElements((EObject)context);
    }

    public List<EObject> getAvailableComponentsToDeploy(Part context) {
        IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(CsPackage.Literals.PART, (EStructuralFeature)CsPackage.Literals.ABSTRACT_DEPLOYMENT_LINK__DEPLOYED_ELEMENT);
        List availableElements = query.getAvailableElements((EObject)context);
        return availableElements;
    }

    public List<EObject> getDeployedComponents(EObject context) {
        if (context instanceof PhysicalComponent) {
            IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(PaPackage.Literals.PHYSICAL_COMPONENT, (EStructuralFeature)CsPackage.Literals.ABSTRACT_DEPLOYMENT_LINK__DEPLOYED_ELEMENT);
            return query.getCurrentElements(context, false);
        }
        if (context instanceof Part) {
            IBusinessQuery query = BusinessQueriesProvider.getInstance().getContribution(CsPackage.Literals.PART, (EStructuralFeature)CsPackage.Literals.ABSTRACT_DEPLOYMENT_LINK__DEPLOYED_ELEMENT);
            return query.getCurrentElements(context, false);
        }
        return Collections.emptyList();
    }

    public List<Part> getAvailableComponentsToDeploy(Part part, boolean behaviour) {
        ArrayList<Part> returnedList = new ArrayList<Part>();
        for (EObject anElement : this.getAvailableComponentsToDeploy(part)) {
            if (!(anElement instanceof Part)) continue;
            Part aPart = (Part)anElement;
            if ((!behaviour || !this.isBehaviour(aPart)) && (behaviour || !this.isNode(aPart))) continue;
            returnedList.add(aPart);
        }
        return returnedList;
    }

    public List<Part> getDeployedComponents(Part part, boolean behaviour) {
        ArrayList<Part> returnedList = new ArrayList<Part>();
        for (EObject anElement : this.getDeployedComponents((EObject)part)) {
            if (!(anElement instanceof Part)) continue;
            Part aPart = (Part)anElement;
            if ((!behaviour || !this.isBehaviour(aPart)) && (behaviour || !this.isNode(aPart))) continue;
            returnedList.add(aPart);
        }
        return returnedList;
    }

    public boolean isValidPPDInvolveComponent(DSemanticDecorator context) {
        return context instanceof DDiagram;
    }

    public boolean isValidPPDInvolvePart(DSemanticDecorator context) {
        return context instanceof DDiagram;
    }

    public boolean isValidPPDInvolvePhysicalPath(DSemanticDecorator context) {
        return context instanceof DDiagram;
    }

    public boolean isValidPPDInvolvePhysicalLink(EObject context, PhysicalPathInvolvement source, PhysicalPathInvolvement target) {
        return this.isAnEdgeInvolvementAvailableInPPD(context, source, target);
    }

    public boolean isValidPPDInvolvePhysicalLinkAndComponent(DSemanticDecorator context) {
        return true;
    }

    public boolean isValidPPDInvolvePhysicalLinkAndPhysicalPath(DSemanticDecorator context) {
        return context instanceof AbstractDNode;
    }

    public boolean isValidPPDInvolvePhysicalLinkAndPart(DSemanticDecorator context) {
        return true;
    }

    public Collection<PhysicalPath> getPPDInvolvePhysicalPathScope(DSemanticDecorator diagram) {
        EObject chain = diagram.getTarget();
        if (!(chain instanceof PhysicalPath)) {
            return Collections.emptyList();
        }
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)chain);
        List chains = PhysicalPathExt.getAllPhysicalPaths((BlockArchitecture)architecture);
        LinkedList<PhysicalPath> result = new LinkedList<PhysicalPath>();
        for (PhysicalPath definedChain : chains) {
            boolean toAdd = true;
            if (definedChain.equals(chain)) {
                toAdd = false;
            }
            if (toAdd) {
                for (PhysicalPathInvolvement involvement : PhysicalPathExt.getFlatInvolvementsOf((PhysicalPath)definedChain, (EClass)CsPackage.Literals.PHYSICAL_PATH)) {
                    if (!chain.equals(involvement.getInvolved())) continue;
                    toAdd = false;
                    break;
                }
            }
            if (!toAdd) continue;
            result.add(definedChain);
        }
        return result;
    }

    public Collection<Part> getPPDInvolvePartScope(DSemanticDecorator context) {
        EObject target = context.getTarget();
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)target);
        HashSet<Part> parts = new HashSet<Part>();
        for (Part part : PartExt.getAllPartsFromPhysicalArchitecture((PhysicalArchitecture)((PhysicalArchitecture)architecture))) {
            if (!(part.getAbstractType() instanceof PhysicalComponent) || !PhysicalComponentNature.NODE.equals((Object)((PhysicalComponent)part.getAbstractType()).getNature())) continue;
            parts.add(part);
        }
        return parts;
    }

    public Collection<Component> getPPDInvolveComponentScope(DSemanticDecorator context) {
        EObject target = context.getTarget();
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)target);
        HashSet<Component> parts = new HashSet<Component>();
        for (Part part : PartExt.getAllPartsFromBlockArch((BlockArchitecture)architecture)) {
            Component component = (Component)part.getAbstractType();
            if (component == null || PhysicalComponentExt.isPhysicalComponentRoot((EObject)component)) continue;
            parts.add(component);
        }
        return parts;
    }

    public List<PhysicalLink> getDisplayedPhysicalLinks(DNodeContainer selectedElement) {
        ArrayList<PhysicalLink> returnedList = new ArrayList<PhysicalLink>();
        ArrayList<DEdge> incomingOutgoingEdges = new ArrayList<DEdge>();
        for (DNode aNode : selectedElement.getOwnedBorderedNodes()) {
            if (!(aNode.getTarget() instanceof PhysicalPort)) continue;
            incomingOutgoingEdges.addAll(CapellaServices.getService().getIncomingEdges((EdgeTarget)aNode));
            incomingOutgoingEdges.addAll(CapellaServices.getService().getOutgoingEdges((EdgeTarget)aNode));
        }
        for (DEdge anEdge : incomingOutgoingEdges) {
            String edgeMappingName = anEdge.getMapping().getName();
            if (!(anEdge.getTarget() instanceof PhysicalLink) || edgeMappingName.equals("PAB_ComputedPhysicalLink") || edgeMappingName.equals("LAB_ComputedPhysicalLink")) continue;
            returnedList.add((PhysicalLink)anEdge.getTarget());
        }
        return returnedList;
    }

    public List<PhysicalLink> getAvailablePhysicalLinksToInsert(DNodeContainer context, DDiagram diagram) {
        ArrayList<PhysicalLink> returnedList = new ArrayList<PhysicalLink>();
        ArrayList allPhysicalLinks = new ArrayList();
        ArrayList<PhysicalLink> existingExchangesInDiagram = new ArrayList<PhysicalLink>();
        for (DEdge anEdge : CapellaServices.getService().getDiagramContainer((EObject)context).getEdges()) {
            if (!(anEdge.getTarget() instanceof PhysicalLink)) continue;
            existingExchangesInDiagram.add((PhysicalLink)anEdge.getTarget());
        }
        Component currentComponent = null;
        EObject target = context.getTarget();
        if (target instanceof Component) {
            currentComponent = (Component)CsServices.getService().getComponentType((Component)target);
        } else if (target instanceof Part) {
            currentComponent = (Component)CsServices.getService().getComponentType((Part)target);
        }
        for (PhysicalPort aPort : ComponentExt.getOwnedPhysicalPort(currentComponent)) {
            allPhysicalLinks.addAll(aPort.getInvolvedLinks());
        }
        for (PhysicalLink aPhysicalLink : allPhysicalLinks) {
            if (existingExchangesInDiagram.contains(aPhysicalLink)) continue;
            returnedList.add(aPhysicalLink);
        }
        return returnedList;
    }

    public List<PhysicalLink> getAvailablePhysicalLinksToInsertOld(DNodeContainer context) {
        ArrayList<PhysicalLink> returnedList = new ArrayList<PhysicalLink>();
        ArrayList allPhysicalLinks = new ArrayList();
        ArrayList<PhysicalLink> existingExchangesInDiagram = new ArrayList<PhysicalLink>();
        for (DEdge anEdge : CapellaServices.getService().getDiagramContainer((EObject)context).getEdges()) {
            if (!(anEdge.getTarget() instanceof PhysicalLink)) continue;
            existingExchangesInDiagram.add((PhysicalLink)anEdge.getTarget());
        }
        Component currentComponent = null;
        EObject target = context.getTarget();
        if (target instanceof Component) {
            currentComponent = (Component)CsServices.getService().getComponentType((Component)target);
        } else if (target instanceof Part) {
            currentComponent = (Component)CsServices.getService().getComponentType((Part)target);
        }
        for (PhysicalPort aPort : ComponentExt.getOwnedPhysicalPort(currentComponent)) {
            allPhysicalLinks.addAll(aPort.getInvolvedLinks());
        }
        for (PhysicalLink aPhysicalLink : allPhysicalLinks) {
            if (existingExchangesInDiagram.contains(aPhysicalLink)) continue;
            returnedList.add(aPhysicalLink);
        }
        return returnedList;
    }

    public List<PhysicalPath> getAllPhysicalPaths(EObject context) {
        return PhysicalPathExt.getAllPhysicalPaths((BlockArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)context));
    }

    public EObject createABPhysicalLink(EObject context, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        PhysicalLinkEnd end;
        EObject sourceTarget = sourceView.getTarget();
        EObject targetTarget = targetView.getTarget();
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)sourceView);
        InformationsExchanger sourceRelatedPart = CsServices.getService().getRelatedPart(sourceView);
        InformationsExchanger targetRelatedPart = CsServices.getService().getRelatedPart(targetView);
        Part sourcePart = null;
        Part targetPart = null;
        if (sourceRelatedPart instanceof Part) {
            sourcePart = (Part)sourceRelatedPart;
        }
        if (targetRelatedPart instanceof Part) {
            targetPart = (Part)targetRelatedPart;
        }
        EdgeTarget nodeSource = null;
        EdgeTarget nodeTarget = null;
        PhysicalPort sourcePort = null;
        if (sourceTarget instanceof PhysicalPort) {
            sourcePort = (PhysicalPort)sourceTarget;
            nodeSource = (EdgeTarget)sourceView;
        } else if (sourcePart != null) {
            sourcePort = CsFactory.eINSTANCE.createPhysicalPort();
            ((Component)sourcePart.getType()).getOwnedFeatures().add((Object)sourcePort);
            CapellaServices.getService().creationService((EObject)sourcePort);
            nodeSource = (EdgeTarget)CsServices.getService().createViewOrGetPhysicalPort((DNodeContainer)sourceView, (Port)sourcePort).getKey();
        }
        PhysicalPort targetPort = null;
        if (targetTarget instanceof PhysicalPort) {
            targetPort = (PhysicalPort)targetTarget;
            nodeTarget = (EdgeTarget)targetView;
        } else if (targetPart != null) {
            targetPort = CsFactory.eINSTANCE.createPhysicalPort();
            ((Component)targetPart.getType()).getOwnedFeatures().add((Object)targetPort);
            CapellaServices.getService().creationService((EObject)targetPort);
            nodeTarget = (EdgeTarget)CsServices.getService().createViewOrGetPhysicalPort((DNodeContainer)targetView, (Port)targetPort).getKey();
        }
        PhysicalLink exchange = CsFactory.eINSTANCE.createPhysicalLink();
        if (CsServices.getService().isMultipartMode((ModelElement)sourceTarget)) {
            end = CsFactory.eINSTANCE.createPhysicalLinkEnd();
            end.setPart(sourcePart);
            end.setPort(sourcePort);
            exchange.getLinkEnds().add((Object)end);
            exchange.getOwnedPhysicalLinkEnds().add((Object)end);
            CapellaServices.getService().creationService((EObject)end);
        } else {
            exchange.getLinkEnds().add((Object)sourcePort);
        }
        if (CsServices.getService().isMultipartMode((ModelElement)sourceTarget)) {
            end = CsFactory.eINSTANCE.createPhysicalLinkEnd();
            end.setPart(targetPart);
            end.setPort(targetPort);
            exchange.getLinkEnds().add((Object)end);
            exchange.getOwnedPhysicalLinkEnds().add((Object)end);
            CapellaServices.getService().creationService((EObject)end);
        } else {
            exchange.getLinkEnds().add((Object)targetPort);
        }
        PhysicalLinkExt.attachToDefaultContainer((PhysicalLink)exchange);
        CapellaServices.getService().creationService((EObject)exchange);
        DiagramServices.getDiagramServices().createEdge(FaServices.getFaServices().getMappingABPhysicalLink(diagram), nodeSource, nodeTarget, (EObject)exchange);
        CsServices.getService().setInterpreterVariable(context, "result", (EObject)exchange);
        return context;
    }

    public EObject createPhysicalPath(EObject context, List<EObject> views, EObject source) {
        if (!views.isEmpty() && source != null) {
            ArrayList<PhysicalLink> newList = new ArrayList<PhysicalLink>();
            for (EObject aSelectedElement : views) {
                if (!(aSelectedElement instanceof DEdge) || ((DEdge)aSelectedElement).getTarget() == null || !(((DEdge)aSelectedElement).getTarget() instanceof PhysicalLink)) continue;
                newList.add((PhysicalLink)((DEdge)aSelectedElement).getTarget());
            }
            Part sourcePath = this.canBeInvolvedInPhysicalPath(source) ? (Part)((Component)source).getRepresentingParts().get(0) : (Part)source;
            EObject ancestor = EcoreUtil2.getCommonAncestor(newList);
            Component container = CapellaServices.getService().getComponentContainer(ancestor);
            if (container == null) {
                EObject target = ((DSemanticDiagram)CapellaServices.getService().getDiagramContainer(views.get(0))).getTarget();
                container = CapellaServices.getService().getComponentContainer(target);
            }
            return PhysicalPathExt.createPhysicalPath((Component)container, newList, (Part)sourcePath);
        }
        return null;
    }

    public boolean canBeInvolvedInPhysicalPath(EObject source) {
        return this.canHavePhysicalPort(source);
    }

    public boolean canHavePhysicalPort(EObject source) {
        if (source instanceof LogicalComponent) {
            LogicalComponent container = (LogicalComponent)ComponentExt.getParentRootComponent((EObject)source);
            BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)source);
            LogicalComponent system = (LogicalComponent)architecture.getSystem();
            return source.equals(system) || container != null && !container.equals(system);
        }
        return source instanceof SystemComponent || source instanceof PhysicalComponent;
    }

    public List<EObject> getAvailableSourcesOfPhysicalPath(EObject context, List<EObject> views) {
        HashMap<Part, Integer> parts = new HashMap<Part, Integer>();
        ArrayList<EObject> result = new ArrayList<EObject>();
        for (EObject eObject : views) {
            if (!(eObject instanceof DEdge) || ((DEdge)eObject).getTarget() == null || !(((DEdge)eObject).getTarget() instanceof PhysicalLink)) continue;
            PhysicalLink currentLink = (PhysicalLink)((DEdge)eObject).getTarget();
            Part sourcePart = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getSourcePart((PhysicalLink)currentLink);
            Part targetPart = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetPart((PhysicalLink)currentLink);
            int i = 1;
            if (parts.containsKey(sourcePart)) {
                i = (Integer)parts.get(sourcePart) + 1;
            }
            parts.put(sourcePart, i);
            i = 1;
            if (parts.containsKey(targetPart)) {
                i = (Integer)parts.get(targetPart) + 1;
            }
            parts.put(targetPart, i);
        }
        for (Map.Entry entry : parts.entrySet()) {
            if ((Integer)entry.getValue() != 1) continue;
            if (CsServices.getService().isMultipartMode((ModelElement)entry.getKey())) {
                result.add((EObject)entry.getKey());
                continue;
            }
            result.add((EObject)((Part)entry.getKey()).getType());
        }
        return result;
    }

    public EObject getPhysicalPathSource(EObject context, List<EObject> views) {
        return this.getAvailableSourcesOfPhysicalPath(context, views).get(0);
    }

    public boolean isValidPhysicalPort(EObject context, EObject container) {
        if (container instanceof Part) {
            return this.canHavePhysicalPort((EObject)((Part)container).getAbstractType());
        }
        return false;
    }

    public boolean canBeInvolvedInPhysicalLink(EObject context) {
        if (context instanceof Part) {
            return this.canHavePhysicalPort((EObject)((Part)context).getAbstractType());
        }
        return context instanceof PhysicalPort;
    }

    public boolean isValidCreationPhysicalLink(EObject source, EObject target) {
        if (source instanceof PhysicalPort && source.equals(target)) {
            return false;
        }
        return this.canBeInvolvedInPhysicalLink(source) && this.canBeInvolvedInPhysicalLink(target);
    }

    public boolean isValidPhysicalPathSelection(EObject context, List<EObject> views) {
        SimpleOrientedGraph graph = new SimpleOrientedGraph();
        if (!views.isEmpty()) {
            for (EObject aSelectedElement : views) {
                if (!(aSelectedElement instanceof DEdge) || ((DEdge)aSelectedElement).getTarget() == null || !(((DEdge)aSelectedElement).getTarget() instanceof PhysicalLink)) continue;
                PhysicalLink aSelectedExchange = (PhysicalLink)((DEdge)aSelectedElement).getTarget();
                Part sourcePart = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getSourcePart((PhysicalLink)aSelectedExchange);
                Part targetPart = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetPart((PhysicalLink)aSelectedExchange);
                graph.addNode((Object)sourcePart, (Object)targetPart);
            }
            if (!graph.isEmpty()) {
                for (Part aPart : graph.getGraph().keySet()) {
                    if (graph.getNotOrientedNeighbours((Object)aPart).size() <= 2) continue;
                    return false;
                }
                return graph.isValid() && !this.getAvailableSourcesOfPhysicalPath(context, views).isEmpty();
            }
            return false;
        }
        return false;
    }

    public EObject showHidePhysicalPaths(EObject context, List<PhysicalPath> selectedPaths, DDiagram diagram) {
        HashMap<PhysicalPath, DNode> displayedPaths = new HashMap<PhysicalPath, DNode>();
        for (DNode aNode : diagram.getNodes()) {
            if (!(aNode.getTarget() instanceof PhysicalPath)) continue;
            displayedPaths.put((PhysicalPath)aNode.getTarget(), aNode);
        }
        NodeMapping physicalPathMapping = DiagramServices.getDiagramServices().getNodeMapping(diagram, MappingConstantsHelper.getMappingPhysicalPath(diagram));
        for (PhysicalPath physicalPath : selectedPaths) {
            if (displayedPaths.containsKey(physicalPath)) continue;
            DiagramServices.getDiagramServices().createNode(physicalPathMapping, (EObject)physicalPath, (DragAndDropTarget)diagram, diagram);
        }
        for (Map.Entry entry : displayedPaths.entrySet()) {
            if (selectedPaths.contains(entry.getKey())) continue;
            DiagramServices.getDiagramServices().removeNodeView((DNode)entry.getValue());
        }
        return context;
    }

    public List<PhysicalPath> getAvailablePhysicalPathsToInsert(EObject element, DSemanticDiagram diagram) {
        HashSet<EObject> viewTargets = new HashSet<EObject>();
        for (DEdge anEdge : diagram.getEdges()) {
            if (!(anEdge.getTarget() instanceof PhysicalLink)) continue;
            viewTargets.add(anEdge.getTarget());
        }
        ArrayList<PhysicalPath> result = new ArrayList<PhysicalPath>();
        block1: for (PhysicalPath aPath : this.getAllPhysicalPaths(diagram.getTarget())) {
            Collection involvedLinks = PhysicalPathExt.getFlatPhysicalLinks((PhysicalPath)aPath);
            if (result.contains(aPath)) continue;
            for (EObject link : involvedLinks) {
                if (!viewTargets.contains(link)) continue;
                result.add(aPath);
                continue block1;
            }
        }
        return result;
    }

    public PhysicalPort getRelatedPort(AbstractPhysicalLinkEnd end) {
        return org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getRelatedPort((AbstractPhysicalLinkEnd)end);
    }

    public List<PhysicalPath> getDisplayedPhysicalPaths(DDiagram diagram) {
        ArrayList<PhysicalPath> returnedList = new ArrayList<PhysicalPath>();
        for (DNode aNode : diagram.getNodes()) {
            if (!(aNode.getTarget() instanceof PhysicalPath)) continue;
            returnedList.add((PhysicalPath)aNode.getTarget());
        }
        return returnedList;
    }

    public EObject reconnectPhysicalLink(PhysicalLink link, AbstractPhysicalLinkEnd source, AbstractPhysicalLinkEnd target) {
        int index = link.getLinkEnds().indexOf((Object)source);
        link.getLinkEnds().add(index, (Object)target);
        link.getLinkEnds().remove((Object)source);
        return link;
    }

    public EObject manageComponentDeployments(DNodeContainer view, List<DeployableElement> selectedElements, boolean isBehaviour) {
        Part currentPart = (Part)view.getTarget();
        DDiagram currentDiagram = CapellaServices.getService().getDiagramContainer((EObject)view);
        HashMap<Part, DNodeContainer> displayedDeployments = new HashMap<Part, DNodeContainer>();
        ContainerMapping deploymentMapping = this.getDeploymentMapping(currentDiagram);
        for (DDiagramElement aDiagramElement : view.getOwnedDiagramElements()) {
            if (!aDiagramElement.getMapping().equals(deploymentMapping)) continue;
            displayedDeployments.put((Part)aDiagramElement.getTarget(), (DNodeContainer)aDiagramElement);
        }
        ArrayList<AbstractDeploymentLink> linksToRemove = new ArrayList<AbstractDeploymentLink>(1);
        for (AbstractDeploymentLink aLink : currentPart.getOwnedDeploymentLinks()) {
            if (selectedElements.contains(aLink.getDeployedElement()) || !(aLink.getDeployedElement() instanceof Part)) continue;
            Part aDeployedPart = (Part)aLink.getDeployedElement();
            if ((!isBehaviour || !this.isBehaviour(aDeployedPart)) && (isBehaviour || !this.isNode(aDeployedPart))) continue;
            if (displayedDeployments.containsKey(aDeployedPart)) {
                DiagramServices.getDiagramServices().removeContainerView((EObject)displayedDeployments.get(aDeployedPart));
            }
            linksToRemove.add(aLink);
        }
        CapellaServices.getService().removeElements(linksToRemove);
        List<Part> deployedComponents = this.getDeployedComponents(currentPart, isBehaviour);
        for (DeployableElement aSelectedElement : selectedElements) {
            if (deployedComponents.contains(aSelectedElement)) continue;
            PartDeploymentLink newLink = DeploymentFactory.eINSTANCE.createPartDeploymentLink();
            currentPart.getOwnedDeploymentLinks().add((Object)newLink);
            newLink.setLocation((DeploymentTarget)currentPart);
            newLink.setDeployedElement(aSelectedElement);
            DiagramServices.getDiagramServices().createContainer(deploymentMapping, (EObject)aSelectedElement, (DragAndDropTarget)view, currentDiagram);
        }
        return view;
    }

    public ContainerMapping getDeploymentMapping(DDiagram diagram) {
        return DiagramServices.getDiagramServices().getContainerMapping(diagram, MappingConstantsHelper.getMappingABDeployedElement(diagram));
    }

    public boolean isBehaviour(Part part) {
        AbstractType componentType = CsServices.getService().getComponentType(part);
        PhysicalComponent comp = null;
        if (componentType instanceof PhysicalComponent) {
            comp = (PhysicalComponent)componentType;
            return PhysicalComponentNature.BEHAVIOR.equals((Object)comp.getNature());
        }
        return false;
    }

    public boolean isNode(Part part) {
        AbstractType componentType = CsServices.getService().getComponentType(part);
        PhysicalComponent comp = null;
        if (componentType instanceof PhysicalComponent) {
            comp = (PhysicalComponent)componentType;
            return PhysicalComponentNature.NODE.equals((Object)comp.getNature());
        }
        return false;
    }

    public boolean isPhysicalActor(Part part) {
        AbstractType componentType = CsServices.getService().getComponentType(part);
        return ComponentExt.isActor((EObject)componentType);
    }

    public void updateInternalPhysicalPaths(DDiagram diagram) {
        HashMap<PhysicalPath, DNode> displayedPaths = this.computePhysicalPathToNodeMap(diagram);
        HashMap<PhysicalPath, Set<DEdge>> physicalPathToVisibleInternalEdges = this.computePhysicalPathToEdgesMap(diagram);
        for (Map.Entry<PhysicalPath, Set<DEdge>> entry : physicalPathToVisibleInternalEdges.entrySet()) {
            PhysicalPath physicalPath = entry.getKey();
            if (displayedPaths.containsKey(physicalPath)) continue;
            Set<DEdge> physicalPathEdges = entry.getValue();
            for (DEdge edge : physicalPathEdges) {
                edge.getSemanticElements().remove((Object)physicalPath);
                if (!edge.getSemanticElements().isEmpty()) continue;
                diagram.getOwnedDiagramElements().remove((Object)edge);
            }
        }
        for (Map.Entry<PhysicalPath, Set<DEdge>> entry : physicalPathToVisibleInternalEdges.entrySet()) {
            Set<DEdge> edges = entry.getValue();
            for (DEdge edge : edges) {
                if (this.isValidInternalLinkEdge(entry.getKey(), edge.getSourceNode(), edge.getTargetNode()) || !entry.getKey().equals(edge.getTarget())) continue;
                edge.getSemanticElements().remove((Object)entry.getKey());
                if (!edge.getSemanticElements().isEmpty()) continue;
                DiagramServices.getDiagramServices().removeEdgeView(edge);
            }
        }
    }

    public Collection<EObject> getPPInternalLinkSemanticElements(DEdge view) {
        List<PhysicalPath> displayedPaths = this.getDisplayedPhysicalPaths(view.getParentDiagram());
        return view.getSemanticElements().stream().filter(x -> displayedPaths.contains(x)).collect(Collectors.toList());
    }

    public void updatePhysicalPathStyles(DDiagram diagram) {
        HashMap<PhysicalPath, DNode> displayedPaths = this.computePhysicalPathToNodeMap(diagram);
        HashMapSet<DSemanticDecorator, RGBValues> viewColors = new HashMapSet<DSemanticDecorator, RGBValues>();
        HashMap<PhysicalLink, DEdge> displayedPhysicalLinks = this.computePhysicalLinkToEdgeMap(diagram);
        HashMap<DEdge, Set<PhysicalPath>> coloredLinks = this.computeEdgeToPhysicalPathsMap(displayedPaths, displayedPhysicalLinks);
        ArrayList<DEdge> displayedLinks = new ArrayList<DEdge>();
        for (Map.Entry<PhysicalPath, DNode> entry : displayedPaths.entrySet()) {
            DNode node = entry.getValue();
            PhysicalPath path = entry.getKey();
            this.updatePhysicalPathNodeColor(node, displayedPaths.values());
            RGBValues color = ShapeUtil.getNodeColorStyle(node);
            PhysicalPathInvolvementGraph graph = PhysicalPathCache.getInstance().getInvolvementGraph(path);
            for (PhysicalPathInvolvementGraph.InvolvementEdge edge : graph.getEdges().values()) {
                PhysicalLink involvedPL = graph.getInvolvedPhysicalLink(edge);
                if (involvedPL == null) continue;
                for (DSemanticDecorator view : DiagramServices.getDiagramServices().getDiagramElements((DRepresentation)diagram, (EObject)involvedPL)) {
                    viewColors.put(view, color);
                    if (!(view instanceof DEdge)) continue;
                    Set paths = coloredLinks.computeIfAbsent((DEdge)view, k -> new HashSet());
                    paths.add(path);
                }
            }
            PhysicalPathInternalLinksGraph linksGraph = PhysicalPathCache.getInstance().getInternalLinksGraph(graph);
            for (PhysicalPathInternalLinksGraph.InternalLinkEdge edge : linksGraph.getEdges().values()) {
                PhysicalPort source = (PhysicalPort)((PhysicalPathInternalLinksGraph.InternalLinkNode)edge.getSource()).getSemantic();
                PhysicalPort target = (PhysicalPort)((PhysicalPathInternalLinksGraph.InternalLinkNode)edge.getTarget()).getSemantic();
                Collection<DSemanticDecorator> sourceNodes = DiagramServices.getDiagramServices().getDiagramElements((DRepresentation)diagram, (EObject)source);
                Collection<DSemanticDecorator> targetNodes = DiagramServices.getDiagramServices().getDiagramElements((DRepresentation)diagram, (EObject)target);
                for (DSemanticDecorator sourceNode : sourceNodes) {
                    for (DSemanticDecorator targetNode : targetNodes) {
                        DEdge link = this.createInternalLink((DNode)sourceNode, (DNode)targetNode, path);
                        if (link == null) continue;
                        displayedLinks.add(link);
                    }
                }
            }
        }
        for (DEdge link : displayedLinks) {
            ArrayList<RGBValues> pathColors = new ArrayList<RGBValues>();
            for (EObject pp : link.getSemanticElements()) {
                if (!displayedPaths.containsKey(pp)) continue;
                RGBValues color = ShapeUtil.getNodeColorStyle(displayedPaths.get(pp));
                pathColors.add(color);
            }
            this.customizeInternalLinksEdgeStyle(link, pathColors.size() == 1 ? (RGBValues)pathColors.get(0) : ShapeUtil.getBlackColor());
        }
        this.customizePhysicalLinkEdgeLabels(coloredLinks, displayedPaths);
        for (DEdge view : diagram.getEdges()) {
            EObject target = view.getTarget();
            if (!(target instanceof PhysicalLink)) continue;
            if (viewColors.containsKey(view)) {
                this.customizePhysicalLinkEdgeStyle(view, ShapeUtil.getColor((Collection<RGBValues>)viewColors.get(view)));
                continue;
            }
            this.resetPhysicalLinkStyle(view);
            this.resetPhysicalLinkEdgeLabels(view);
        }
    }

    public void resetPhysicalLinkEdgeLabels(DEdge aPL) {
        DEdgeIconCache.getInstance().removeIcon(aPL);
        DEdgeIconCache.getInstance().setLabel(aPL, "");
        DiagramServices.getDiagramServices().refreshBeginEndLabels(aPL);
        CapellaServices.getService().refreshElement((DRepresentationElement)aPL);
    }

    public void customizePhysicalLinkEdgeLabels(Map<DEdge, Set<PhysicalPath>> coloredLinks, Map<PhysicalPath, DNode> displayedPaths) {
        for (Map.Entry<DEdge, Set<PhysicalPath>> entry : coloredLinks.entrySet()) {
            DEdge edge = entry.getKey();
            Set<PhysicalPath> paths = entry.getValue();
            List<RGBValues> pathColors = paths.stream().map(displayedPaths::get).map(ShapeUtil::getNodeColorStyle).collect(Collectors.toList());
            if (pathColors.size() > 1) {
                DEdgeIconCache.getInstance().setIcon(edge, pathColors);
                DEdgeIconCache.getInstance().setLabel(edge, DiagramServices.getDiagramServices().getOverlappedLabels(paths.stream().map(AbstractNamedElement::getName).collect(Collectors.toList())));
            } else {
                DEdgeIconCache.getInstance().removeIcon(edge);
                DEdgeIconCache.getInstance().setLabel(edge, "");
            }
            DiagramServices.getDiagramServices().refreshBeginEndLabels(edge);
            CapellaServices.getService().refreshElement((DRepresentationElement)edge);
        }
    }

    private HashMap<DEdge, Set<PhysicalPath>> computeEdgeToPhysicalPathsMap(HashMap<PhysicalPath, DNode> displayedPaths, HashMap<PhysicalLink, DEdge> displayedPhysicalLinks) {
        HashMap<DEdge, Set<PhysicalPath>> coloredLinks = new HashMap<DEdge, Set<PhysicalPath>>();
        for (Map.Entry<PhysicalPath, DNode> me : displayedPaths.entrySet()) {
            for (PhysicalLink link : PhysicalPathExt.getFlatPhysicalLinks((PhysicalPath)me.getKey())) {
                if (!displayedPhysicalLinks.containsKey(link)) continue;
                DEdge linkEdge = displayedPhysicalLinks.get(link);
                if (!coloredLinks.containsKey(linkEdge)) {
                    HashSet<PhysicalPath> newSet = new HashSet<PhysicalPath>();
                    newSet.add(me.getKey());
                    coloredLinks.put(linkEdge, newSet);
                    continue;
                }
                coloredLinks.get(linkEdge).add(me.getKey());
            }
        }
        return coloredLinks;
    }

    private HashMap<PhysicalPath, Set<DEdge>> computePhysicalPathToEdgesMap(DDiagram diagram) {
        HashMap<PhysicalPath, Set<DEdge>> displayedIL = new HashMap<PhysicalPath, Set<DEdge>>();
        for (DEdge anEdge : DDiagramSpecOperations.getEdgesFromMapping((DDiagram)diagram, (EdgeMapping)this.getPhysicalPathInternLinkEdgeMapping(diagram))) {
            for (EObject semantic : anEdge.getSemanticElements()) {
                if (!(semantic instanceof PhysicalPath)) continue;
                displayedIL.computeIfAbsent((PhysicalPath)semantic, x -> new HashSet()).add(anEdge);
            }
        }
        return displayedIL;
    }

    private HashMap<PhysicalLink, DEdge> computePhysicalLinkToEdgeMap(DDiagram diagram) {
        HashMap<PhysicalLink, DEdge> displayedPhysicalLinks = new HashMap<PhysicalLink, DEdge>();
        for (DEdge anEdge : diagram.getEdges()) {
            if (!(anEdge.getTarget() instanceof PhysicalLink)) continue;
            displayedPhysicalLinks.put((PhysicalLink)anEdge.getTarget(), anEdge);
        }
        return displayedPhysicalLinks;
    }

    private HashMap<PhysicalPath, DNode> computePhysicalPathToNodeMap(DDiagram diagram) {
        HashMap<PhysicalPath, DNode> displayedPaths = new HashMap<PhysicalPath, DNode>();
        for (DDiagramElement aNode : diagram.getOwnedDiagramElements()) {
            if (!(aNode instanceof DNode) || !(aNode.getTarget() instanceof PhysicalPath)) continue;
            displayedPaths.put((PhysicalPath)aNode.getTarget(), (DNode)aNode);
        }
        return displayedPaths;
    }

    protected Collection<PhysicalLink> getFlatPreviousPhysicalLinks(PhysicalPathInvolvement physicalPathInvolvement) {
        HashSet<PhysicalLink> result = new HashSet<PhysicalLink>();
        for (PhysicalPathInvolvement involvment : PhysicalPathExt.getFlatPreviousLinkInvolvements((PhysicalPathInvolvement)physicalPathInvolvement)) {
            if (!(involvment.getInvolved() instanceof PhysicalLink)) continue;
            result.add((PhysicalLink)involvment.getInvolved());
        }
        return result;
    }

    protected Collection<PhysicalLink> getFlatNextPhysicalLinks(PhysicalPathInvolvement physicalPathInvolvement) {
        HashSet<PhysicalLink> result = new HashSet<PhysicalLink>();
        for (PhysicalPathInvolvement involvment : PhysicalPathExt.getFlatNextExchangeInvolvements((PhysicalPathInvolvement)physicalPathInvolvement)) {
            if (!(involvment.getInvolved() instanceof PhysicalLink)) continue;
            result.add((PhysicalLink)involvment.getInvolved());
        }
        return result;
    }

    public boolean isValidInternalLinkEdge(PhysicalPath path, EdgeTarget currentSourceNode, EdgeTarget currentTargetNode) {
        if (currentSourceNode == null) {
            return false;
        }
        if (currentTargetNode == null) {
            return false;
        }
        List<DEdge> edgesRelatedToSource = this.getRelatedEdges(currentSourceNode);
        if (!this.hasAtLeastOneVisibleEdgeNotPhysicalPath(edgesRelatedToSource)) {
            return false;
        }
        List<DEdge> edgesRelatedToTarget = this.getRelatedEdges(currentTargetNode);
        if (!this.hasAtLeastOneVisibleEdgeNotPhysicalPath(edgesRelatedToTarget)) {
            return false;
        }
        EObject sourceParent = currentSourceNode.eContainer();
        EObject targetParent = currentTargetNode.eContainer();
        if (sourceParent == null || targetParent == null || !sourceParent.equals(targetParent)) {
            return false;
        }
        DDiagram diagram = ((DDiagramElement)currentSourceNode).getParentDiagram();
        DEdge anotherEdge = DiagramServices.getDiagramServices().findInternalLinkEdge(diagram, currentSourceNode, currentTargetNode, this.getPhysicalPathInternLinkEdgeMapping(diagram));
        boolean hasAnotherEdge = anotherEdge != null && !path.equals(anotherEdge.getTarget());
        return !hasAnotherEdge;
    }

    private boolean hasAtLeastOneVisibleEdgeNotPhysicalPath(List<DEdge> edgesRelatedToSource) {
        boolean sourceHasAtLeastOneVisibleEdgeNotPhysicalPath = false;
        for (DEdge dEdge : edgesRelatedToSource) {
            if (dEdge.getTarget() instanceof PhysicalPath || DiagramServices.getDiagramServices().isHidden((DDiagramElement)dEdge)) continue;
            sourceHasAtLeastOneVisibleEdgeNotPhysicalPath = true;
            break;
        }
        return sourceHasAtLeastOneVisibleEdgeNotPhysicalPath;
    }

    private List<DEdge> getRelatedEdges(EdgeTarget currentSourceNode) {
        ArrayList<DEdge> edgesRelatedToSource = new ArrayList<DEdge>();
        for (DEdge dEdge : currentSourceNode.getIncomingEdges()) {
            edgesRelatedToSource.add(dEdge);
        }
        for (DEdge dEdge : currentSourceNode.getOutgoingEdges()) {
            edgesRelatedToSource.add(dEdge);
        }
        return edgesRelatedToSource;
    }

    public DEdge createInternalLink(DNode sourceNode, DNode targetNode, PhysicalPath physicalPath) {
        if (sourceNode == targetNode) {
            return null;
        }
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)sourceNode);
        EdgeMapping mapping = this.getPhysicalPathInternLinkEdgeMapping(diagram);
        DEdge newEdge = DiagramServices.getDiagramServices().findInternalLinkEdge(diagram, (EdgeTarget)sourceNode, (EdgeTarget)targetNode, mapping);
        if (newEdge == null && this.isValidInternalLinkEdge(physicalPath, (EdgeTarget)sourceNode, (EdgeTarget)targetNode)) {
            newEdge = DiagramServices.getDiagramServices().createEdge(mapping, (EdgeTarget)sourceNode, (EdgeTarget)targetNode, (EObject)physicalPath);
        }
        if (newEdge != null && !newEdge.getSemanticElements().contains((Object)physicalPath)) {
            newEdge.getSemanticElements().add((Object)physicalPath);
        }
        return newEdge;
    }

    public void customizeInternalLinksEdgeStyle(DEdge edge, RGBValues color) {
        RGB rgbColor = new RGB(color.getRed(), color.getGreen(), color.getBlue());
        ShapeUtil.setEdgeColorStyle(edge, rgbColor);
        ShapeUtil.setEdgeThickStyle(edge, THICK_EDGE_PHYSICAL_PATH);
    }

    public void customizePhysicalLinkEdgeStyle(DEdge edge, RGBValues color) {
        String defaultSize;
        EdgeStyleDescription desc;
        EdgeStyle edgeStyle = edge.getOwnedStyle();
        Integer currentSize = edgeStyle.getSize();
        DiagramElementMapping mapping = DiagramServices.getDiagramServices().getEdgeMapping(edge);
        if (mapping != null && (desc = (EdgeStyleDescription)this.getMappingHelper((DSemanticDecorator)edge).getBestStyleDescription(mapping, edge.getTarget(), (EObject)edge, edge.eContainer(), CapellaServices.getService().getDiagramContainer((EObject)edge))) != null && (defaultSize = desc.getSizeComputationExpression()) != null && currentSize != null && (currentSize.equals(Integer.valueOf(defaultSize)) || currentSize.equals(THICK_EDGE_PHYSICAL_PATH))) {
            RGB rgbColor = new RGB(color.getRed(), color.getGreen(), color.getBlue());
            ShapeUtil.setEdgeColorStyle(edge, rgbColor);
            ShapeUtil.setEdgeThickStyle(edge, THICK_EDGE_PHYSICAL_PATH);
        }
    }

    public boolean isCompletePhysicalPath(PhysicalPath path, DDiagram diagram) {
        Collection physicalLinksOnThePath = PhysicalPathExt.getFlatPhysicalLinks((PhysicalPath)path);
        int numberOfVisibleRelatedPLEdges = 0;
        for (DEdge anEdge : diagram.getEdges()) {
            EObject edgeTarget;
            if (!anEdge.isVisible() || !((edgeTarget = anEdge.getTarget()) instanceof PhysicalLink) || !physicalLinksOnThePath.contains(edgeTarget)) continue;
            ++numberOfVisibleRelatedPLEdges;
        }
        return numberOfVisibleRelatedPLEdges == physicalLinksOnThePath.size();
    }

    public String getPhysicalPathLabel(PhysicalPath path, DDiagram diagram) {
        boolean displayInvalidLabel;
        String label = EObjectExt.getText((EObject)path);
        boolean isComplete = this.isCompletePhysicalPath(path, diagram);
        IProject project = PreferencesHelper.getProject((EObject)path);
        boolean displayIncompleteLabel = !isComplete && ScopedCapellaPreferencesStore.getBoolean((String)"org.polarsys.capella.core.sirius.analysis.preferences.diagrams.physicalpath.label.incomplete", (IProject)project);
        boolean isValid = PhysicalPathExt.isPhysicalPathValid((PhysicalPath)path);
        boolean bl = displayInvalidLabel = !isValid && ScopedCapellaPreferencesStore.getBoolean((String)"org.polarsys.capella.core.sirius.analysis.preferences.diagrams.physicalpath.label.invalid", (IProject)project);
        if (displayIncompleteLabel || displayInvalidLabel) {
            label = String.valueOf(label) + " (";
        }
        if (displayIncompleteLabel) {
            label = String.valueOf(label) + INCOMPLETE_PHYSICAL_PATH_LABEL;
        }
        if (displayIncompleteLabel && displayInvalidLabel) {
            label = String.valueOf(label) + ", ";
        }
        if (displayInvalidLabel) {
            label = String.valueOf(label) + INVALID_PHYSICAL_PATH_LABEL;
        }
        if (displayIncompleteLabel || displayInvalidLabel) {
            label = String.valueOf(label) + ")";
        }
        return label;
    }

    public void updatePhysicalPathNodeColor(DNode pathNode, Collection<DNode> visiblePhysicalPaths) {
        RGBValues color = ShapeUtil.getNodeColorStyle(pathNode);
        ColorManager colorManager = ColorManager.getInstance();
        boolean changeColor = false;
        List<RGB> colorList = colorManager.getColorList();
        if (ShapeUtil.isSameColor(color, colorManager.getGrayColor())) {
            changeColor = true;
        }
        for (DNode aPhysicalPath : visiblePhysicalPaths) {
            if (aPhysicalPath.equals(pathNode)) continue;
            RGBValues nodeColor = ShapeUtil.getNodeColorStyle(aPhysicalPath);
            if (ShapeUtil.isSameColor(nodeColor, color)) {
                changeColor = true;
            }
            ShapeUtil.removeColorFromList(nodeColor, colorList);
        }
        if (!changeColor) {
            return;
        }
        if (!colorList.isEmpty()) {
            ShapeUtil.setColorStyle(pathNode, colorList.get(0));
        }
    }

    public void resetPhysicalLinkStyle(DEdge aEdge) {
        DiagramElementMapping mapping = DiagramServices.getDiagramServices().getEdgeMapping(aEdge);
        if (mapping != null) {
            EdgeStyleDescription desc = (EdgeStyleDescription)this.getMappingHelper((DSemanticDecorator)aEdge).getBestStyleDescription(mapping, aEdge.getTarget(), (EObject)aEdge, aEdge.eContainer(), CapellaServices.getService().getDiagramContainer((EObject)aEdge));
            String defaultStyleSize = desc.getSizeComputationExpression();
            EdgeStyle edgeStyle = aEdge.getOwnedStyle();
            Integer currentSize = edgeStyle.getSize();
            if (currentSize != null && defaultStyleSize != null && (currentSize.equals(THICK_EDGE_PHYSICAL_PATH) || currentSize.equals(defaultStyleSize)) && ShapeUtil.resetEdgeThickStyle(aEdge, Integer.valueOf(defaultStyleSize))) {
                ShapeUtil.resetEdgeColorStyle(aEdge, ShapeUtil.getDefaultColor((DSemanticDecorator)aEdge, (EObject)desc, desc.getStrokeColor()));
            }
        }
    }

    public EdgeMapping getPhysicalPathInternLinkEdgeMapping(DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingPhysicalPathInternLink(diagram);
        return DiagramServices.getDiagramServices().getEdgeMapping(diagram, mappingName);
    }

    public List<PhysicalPathInvolvement> getPreviousPhysicalPathInvolvements(PhysicalPathInvolvement involvement) {
        return involvement.getPreviousInvolvements();
    }

    public Collection<? extends CapellaElement> getAllComponentsFromPhysicalArchitecture(PhysicalArchitecture arch) {
        return BlockArchitectureExt.getAllComponents((BlockArchitecture)arch);
    }

    public boolean isAnEdgeInvolvementAvailableInPPD(EObject context, PhysicalPathInvolvement source, PhysicalPathInvolvement target) {
        boolean result;
        Collection<PhysicalLink> commonExchanges = this.getPPDCommonPhysicalLinks(source, target);
        boolean bl = result = !commonExchanges.isEmpty();
        return result && !this.findInvolvementInNext(target, source, new HashSet<PhysicalPathInvolvement>());
    }

    public boolean findInvolvementInNext(PhysicalPathInvolvement currentInvolvement, PhysicalPathInvolvement involvementToFind, Set<PhysicalPathInvolvement> visitedInvolvements) {
        if (visitedInvolvements.contains(currentInvolvement)) {
            return false;
        }
        if (currentInvolvement.equals(involvementToFind)) {
            return true;
        }
        HashSet<PhysicalPathInvolvement> involvements = new HashSet<PhysicalPathInvolvement>(visitedInvolvements);
        involvements.add(currentInvolvement);
        for (PhysicalPathInvolvement aNext : currentInvolvement.getNextInvolvements()) {
            if (!this.findInvolvementInNext(aNext, involvementToFind, involvements)) continue;
            return true;
        }
        return false;
    }

    public List<PhysicalLink> getAvailablePhysicaLinks(PhysicalPath path, Part source, Part target) {
        ArrayList<PhysicalLink> returnedPhysicalLinks = new ArrayList<PhysicalLink>();
        Collection incoming = (Collection)ModelCache.getCache(org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt::getAllRelatedPhysicalLinks, (Object)target);
        Collection outgoing = (Collection)ModelCache.getCache(org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt::getAllRelatedPhysicalLinks, (Object)source);
        List involvedElements = PhysicalPathExt.getInvolvedElements((PhysicalPath)path);
        for (PhysicalLink aPhysicalLink : incoming) {
            if (!outgoing.contains(aPhysicalLink) || involvedElements.contains(aPhysicalLink)) continue;
            returnedPhysicalLinks.add(aPhysicalLink);
        }
        return returnedPhysicalLinks;
    }

    public List<PhysicalLink> getPPDInvolvePhysicalLinkAndComponentScope(DNode node) {
        ArrayList<PhysicalLink> returnedList = new ArrayList<PhysicalLink>();
        List<PhysicalLink> existingInvolvedFE = this.getOutgoingIncomingEdgePhysicalLinks(node);
        PhysicalPathInvolvement selectedInvolvement = (PhysicalPathInvolvement)node.getTarget();
        if (selectedInvolvement.getInvolved() instanceof PhysicalPath) {
            existingInvolvedFE.addAll(PhysicalPathExt.getFlatPhysicalLinks((PhysicalPath)((PhysicalPath)selectedInvolvement.getInvolved())));
        }
        for (PhysicalLink aFE : PhysicalPathExt.getFlatOutgoingIncomingLinks((PhysicalPathInvolvement)selectedInvolvement)) {
            if (existingInvolvedFE.contains(aFE)) continue;
            returnedList.add(aFE);
        }
        return returnedList;
    }

    public List<PhysicalLink> getPPDInvolvePhysicalLinkAndPartScope(DNode node) {
        ArrayList<PhysicalLink> returnedList = new ArrayList<PhysicalLink>();
        List<PhysicalLink> existingInvolvedFE = this.getOutgoingIncomingEdgePhysicalLinks(node);
        PhysicalPathInvolvement selectedInvolvement = (PhysicalPathInvolvement)node.getTarget();
        if (selectedInvolvement.getInvolved() instanceof PhysicalPath) {
            existingInvolvedFE.addAll(PhysicalPathExt.getFlatPhysicalLinks((PhysicalPath)((PhysicalPath)selectedInvolvement.getInvolved())));
        }
        for (PhysicalLink aFE : PhysicalPathExt.getFlatOutgoingIncomingLinks((PhysicalPathInvolvement)selectedInvolvement)) {
            if (existingInvolvedFE.contains(aFE)) continue;
            returnedList.add(aFE);
        }
        return returnedList;
    }

    public List<PhysicalLink> getAvailablePhysicalLinkToInsertInPPD(DNode node) {
        ArrayList<PhysicalLink> returnedList = new ArrayList<PhysicalLink>();
        ArrayList<PhysicalLink> existingInvolvedLinks = new ArrayList<PhysicalLink>();
        for (DEdge anEdge : DiagramServices.getDiagramServices().getOutgoingEdges((EdgeTarget)node)) {
            PhysicalPathInvolvement currentInv;
            if (!(anEdge.getTarget() instanceof PhysicalPathInvolvement) || !((currentInv = (PhysicalPathInvolvement)anEdge.getTarget()).getInvolvedElement() instanceof PhysicalLink)) continue;
            existingInvolvedLinks.add((PhysicalLink)currentInv.getInvolvedElement());
        }
        PhysicalPathInvolvement selectedInvolvement = (PhysicalPathInvolvement)node.getTarget();
        List involvedElements = PhysicalPathExt.getInvolvedElements((PhysicalPath)((PhysicalPath)selectedInvolvement.eContainer()));
        for (PhysicalLink aLink : (Collection)ModelCache.getCache(org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt::getAllRelatedPhysicalLinks, (Object)((Part)selectedInvolvement.getInvolvedElement()))) {
            if (existingInvolvedLinks.contains(aLink) || involvedElements.contains(aLink)) continue;
            returnedList.add(aLink);
        }
        return returnedList;
    }

    public Part getOppositePart(PhysicalLink link, EObject involvedElement) {
        Part sourcePart = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getSourcePart((PhysicalLink)link);
        if (involvedElement.equals(sourcePart)) {
            return org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetPart((PhysicalLink)link);
        }
        if (involvedElement instanceof PhysicalPath) {
            for (PhysicalPathInvolvement involvment : PhysicalPathExt.getFlatLastPhysicalPathInvolvments((PhysicalPath)((PhysicalPath)involvedElement))) {
                if (!sourcePart.equals(involvment.getInvolvedElement())) continue;
                return org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetPart((PhysicalLink)link);
            }
        }
        return sourcePart;
    }

    @Deprecated
    public boolean isPhysicalPathEnd(PhysicalPathInvolvement inv) {
        return false;
    }

    private MappingWithInterpreterHelper getMappingHelper(DSemanticDecorator semanticDecorator) {
        return new MappingWithInterpreterHelper(SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(semanticDecorator.getTarget()));
    }

    public Collection<PhysicalLink> getPPDInvolvePhysicalLinkScope(EObject context, EObject source, EObject target) {
        PhysicalPathInvolvement sourceInvolvment = (PhysicalPathInvolvement)source;
        PhysicalPathInvolvement targetInvolvment = (PhysicalPathInvolvement)target;
        if (sourceInvolvment.getInvolved() != null && sourceInvolvment.getInvolved().equals(targetInvolvment.getInvolved())) {
            return Collections.emptyList();
        }
        Collection<PhysicalLink> commonExchanges = this.getPPDCommonPhysicalLinks(sourceInvolvment, targetInvolvment);
        if (sourceInvolvment.getInvolved() instanceof PhysicalPath) {
            commonExchanges.removeAll(PhysicalPathExt.getFlatPhysicalLinks((PhysicalPath)((PhysicalPathReference)sourceInvolvment).getReferencedPhysicalPath()));
        }
        if (targetInvolvment.getInvolved() instanceof PhysicalPath) {
            commonExchanges.removeAll(PhysicalPathExt.getFlatPhysicalLinks((PhysicalPath)((PhysicalPathReference)targetInvolvment).getReferencedPhysicalPath()));
        }
        return commonExchanges;
    }

    private Collection<PhysicalLink> getPPDCommonPhysicalLinks(PhysicalPathInvolvement source, PhysicalPathInvolvement target) {
        return PhysicalPathExt.getFlatCommonPhysicalLinks((PhysicalPathInvolvement)source, (PhysicalPathInvolvement)target);
    }

    public HashMapSet<PhysicalLink, PhysicalPath> getPPDInvolvePhysicalLinkAndPhysicalPathScope(DNode node) {
        HashMapSet<PhysicalLink, PhysicalPath> set = new HashMapSet<PhysicalLink, PhysicalPath>();
        if (node == null || node.getTarget() == null || node.getTarget().eIsProxy()) {
            return set;
        }
        EObject target = node.getTarget();
        if (!(target instanceof PhysicalPathInvolvement)) {
            return set;
        }
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)node);
        if (!(diagram instanceof DSemanticDecorator)) {
            return set;
        }
        List<PhysicalLink> existingInvolvedFE = this.getOutgoingIncomingEdgePhysicalLinks(node);
        PhysicalPathInvolvement involvement = (PhysicalPathInvolvement)target;
        Collection outgoing = PhysicalPathExt.getFlatOutgoingIncomingLinks((PhysicalPathInvolvement)involvement);
        HashSet<Part> sourceParts = new HashSet<Part>();
        if (involvement.getInvolved() instanceof PhysicalPath) {
            PhysicalPath path = (PhysicalPath)involvement.getInvolved();
            outgoing.removeAll(PhysicalPathExt.getFlatPhysicalLinks((PhysicalPath)path));
            sourceParts.addAll(PhysicalPathExt.getFlatPhysicalPathFirstParts((PhysicalPath)path));
            sourceParts.addAll(PhysicalPathExt.getFlatPhysicalPathLastParts((PhysicalPath)path));
        } else if (involvement.getInvolved() instanceof Part) {
            sourceParts.add((Part)involvement.getInvolved());
        }
        Collection<PhysicalPath> paths = this.getPPDInvolvePhysicalPathScope((DSemanticDecorator)diagram);
        for (PhysicalPath path : paths) {
            if (path.equals(involvement.getInvolved())) continue;
            Collection incoming = PhysicalPathExt.getFlatOutgoingIncomingLinks((PhysicalPath)path);
            incoming.retainAll(outgoing);
            incoming.removeAll(PhysicalPathExt.getFlatPhysicalLinks((PhysicalPath)path));
            LinkedHashSet targetParts = new LinkedHashSet();
            targetParts.addAll(PhysicalPathExt.getFlatPhysicalPathFirstParts((PhysicalPath)path));
            targetParts.addAll(PhysicalPathExt.getFlatPhysicalPathLastParts((PhysicalPath)path));
            for (PhysicalLink exchange : incoming) {
                if (existingInvolvedFE.contains(exchange)) continue;
                HashSet parts = new HashSet();
                parts.addAll(org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getSourceParts((PhysicalLink)exchange));
                parts.addAll(org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetParts((PhysicalLink)exchange));
                parts.removeAll(sourceParts);
                parts.retainAll(targetParts);
                if (parts.isEmpty()) continue;
                set.put(exchange, path);
            }
        }
        return set;
    }

    private List<PhysicalLink> getOutgoingIncomingEdgePhysicalLinks(DNode node) {
        PhysicalPathInvolvement currentInv;
        ArrayList<PhysicalLink> existingInvolvedFE = new ArrayList<PhysicalLink>();
        for (DEdge anEdge : DiagramServices.getDiagramServices().getOutgoingEdges((EdgeTarget)node)) {
            if (!(anEdge.getTarget() instanceof PhysicalPathInvolvement) || !((currentInv = (PhysicalPathInvolvement)anEdge.getTarget()).getInvolvedElement() instanceof PhysicalLink)) continue;
            existingInvolvedFE.add((PhysicalLink)currentInv.getInvolvedElement());
        }
        for (DEdge anEdge : DiagramServices.getDiagramServices().getIncomingEdges((EdgeTarget)node)) {
            if (!(anEdge.getTarget() instanceof PhysicalPathInvolvement) || !((currentInv = (PhysicalPathInvolvement)anEdge.getTarget()).getInvolvedElement() instanceof PhysicalLink)) continue;
            existingInvolvedFE.add((PhysicalLink)currentInv.getInvolvedElement());
        }
        return existingInvolvedFE;
    }

    public HashMapSet<PhysicalLink, PhysicalPath> getInvolvePhysicalLinkAndPhysicalPathInitialSelection(AbstractDNode context) {
        return new HashMapSet<PhysicalLink, PhysicalPath>();
    }

    public void involvedPPDPhysicalLinkPhysicalPath(AbstractDNode context, HashMapSet<PhysicalLink, PhysicalPath> scope, HashMapSet<PhysicalLink, PhysicalPath> initialSelection, HashMapSet<PhysicalLink, PhysicalPath> selection) {
        if (context == null) {
            return;
        }
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)context);
        if (!(diagram instanceof DSemanticDecorator)) {
            return;
        }
        PhysicalPath sourceFC = (PhysicalPath)((DSemanticDecorator)diagram).getTarget();
        EObject target = context.getTarget();
        if (target == null || target.eIsProxy() || !(target instanceof PhysicalPathInvolvement)) {
            return;
        }
        PhysicalPathInvolvement iSource = (PhysicalPathInvolvement)context.getTarget();
        for (PhysicalLink link : selection.keySet()) {
            Iterator iterator = selection.get(link).iterator();
            while (iterator.hasNext()) {
                PhysicalPath chain = (PhysicalPath)iterator.next();
                PhysicalPathInvolvement iExchange = CsFactory.eINSTANCE.createPhysicalPathInvolvement();
                iExchange.setInvolved((InvolvedElement)link);
                sourceFC.getOwnedPhysicalPathInvolvements().add((Object)iExchange);
                iSource.getNextInvolvements().add((Object)iExchange);
                PhysicalPathReference iChain = CsFactory.eINSTANCE.createPhysicalPathReference();
                iChain.setInvolved((InvolvedElement)chain);
                sourceFC.getOwnedPhysicalPathInvolvements().add((Object)iChain);
                iExchange.getNextInvolvements().add((Object)iChain);
                AbstractNodeMapping nodeMapping = DiagramServices.getDiagramServices().getAbstractNodeMapping(diagram, "PPD_PhysicalPath");
                if (nodeMapping == null) {
                    return;
                }
                AbstractDNode node = DiagramServices.getDiagramServices().createAbstractDNode(nodeMapping, (EObject)iChain, (DragAndDropTarget)diagram, diagram);
                if (node == null) {
                    return;
                }
                EdgeMapping edgeMapping = DiagramServices.getDiagramServices().getEdgeMapping(diagram, "PPD_PhysicalLink");
                if (edgeMapping == null) {
                    return;
                }
                DiagramServices.getDiagramServices().createEdge(edgeMapping, (EdgeTarget)context, (EdgeTarget)node, (EObject)iExchange);
            }
        }
    }

    public PhysicalComponent createPhysicalComponent(EObject container) {
        PhysicalComponent component = PaFactory.eINSTANCE.createPhysicalComponent();
        if (component != null) {
            if (container instanceof PhysicalComponent) {
                PhysicalComponent componentContainer = (PhysicalComponent)container;
                componentContainer.getOwnedPhysicalComponents().add((Object)component);
            }
            CapellaServices.getService().creationService((EObject)component);
        }
        return component;
    }

    public List<ComponentPortAllocation> getDisplayedComponentPortAllocations(DNodeContainer selectedElement) {
        ArrayList<ComponentPortAllocation> result = new ArrayList<ComponentPortAllocation>();
        List<ComponentPortAllocation> allAllocations = this.getAllComponentPortAllocationAvailable(selectedElement);
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)selectedElement);
        for (ComponentPortAllocation portAllocation : allAllocations) {
            if (DiagramServices.getDiagramServices().getDiagramElement(diagram, (EObject)portAllocation) == null) continue;
            result.add(portAllocation);
        }
        return result;
    }

    public List<ComponentPortAllocation> getAllComponentPortAllocationAvailable(DNodeContainer selectedElement) {
        ArrayList<ComponentPortAllocation> result = new ArrayList<ComponentPortAllocation>();
        for (DNode dNode : selectedElement.getNodes()) {
            EObject target;
            if (dNode.getTarget() instanceof PhysicalPort) {
                target = dNode.getTarget();
                for (AbstractTrace trace : ((PhysicalPort)target).getOutgoingTraces()) {
                    if (!(trace instanceof ComponentPortAllocation)) continue;
                    result.add((ComponentPortAllocation)trace);
                }
                continue;
            }
            if (!(dNode.getTarget() instanceof ComponentPort)) continue;
            target = dNode.getTarget();
            for (AbstractTrace trace : ((ComponentPort)target).getIncomingTraces()) {
                if (!(trace instanceof ComponentPortAllocation)) continue;
                result.add((ComponentPortAllocation)trace);
            }
        }
        return result;
    }

    public List<ComponentPortAllocation> getAvailableComponentPortAllocationToInsert(DNodeContainer selectedElement, DDiagram diagram) {
        List<ComponentPortAllocation> allAllocations = this.getAllComponentPortAllocationAvailable(selectedElement);
        List<ComponentPortAllocation> existingAllocations = this.getDisplayedComponentPortAllocations(selectedElement);
        allAllocations.removeAll(existingAllocations);
        return allAllocations;
    }

    public PhysicalComponentNature getComponentNature(DSemanticDecorator decorator) {
        EObject target = decorator.getTarget();
        if (target instanceof PhysicalComponentPkg) {
            Component parentComponent = ComponentPkgExt.getParentComponent((ComponentPkg)((ComponentPkg)target));
            if (parentComponent instanceof PhysicalComponent) {
                return ((PhysicalComponent)parentComponent).getNature();
            }
        } else {
            Component component;
            if (target instanceof PhysicalComponent) {
                return ((PhysicalComponent)target).getNature();
            }
            if (target instanceof Part && (component = PartExt.getComponentOfPart((Part)((Part)target))) instanceof PhysicalComponent) {
                return ((PhysicalComponent)component).getNature();
            }
        }
        return PhysicalComponentNature.UNSET;
    }
}

