/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.actions.extensions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.actions.extensions.AbstractExternalJavaAction;
import org.polarsys.capella.core.sirius.analysis.showhide.ShowHideMCComponent;
import org.polarsys.capella.core.sirius.analysis.showhide.ShowHideService;

public class ShowHideMCComponents
extends AbstractExternalJavaAction {
    public static final String ELEMENT_VIEW = "view";
    public static final String SELECTED_COMPONENTS = "selected components";
    public static final String VISIBLE_COMPONENTS = "visible components";
    public static final String VISIBLE_COMPONENT_VIEWS = "visible component views";

    public void execute(Collection<? extends EObject> selections, Map<String, Object> parameters) {
        DSemanticDecorator view = (DSemanticDecorator)parameters.get(ELEMENT_VIEW);
        ArrayList<EObject> selectedActors = (ArrayList<EObject>)parameters.get(SELECTED_COMPONENTS);
        ArrayList visibleActors = (ArrayList)parameters.get(VISIBLE_COMPONENTS);
        ArrayList<DDiagramElement> visibleActorViews = (ArrayList<DDiagramElement>)parameters.get(VISIBLE_COMPONENT_VIEWS);
        if (selectedActors == null) {
            selectedActors = new ArrayList<EObject>();
        }
        if (visibleActors == null) {
            visibleActors = new ArrayList();
        }
        if (visibleActorViews == null) {
            visibleActorViews = new ArrayList<DDiagramElement>();
        }
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)view);
        DDiagramContents content = new DDiagramContents(diagram);
        ShowHideService.getService().applyShowHide(view, selectedActors, visibleActorViews, new ShowHideMCComponent(content));
    }
}

