/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.refresh.extension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.helpers.cache.ModelCache;
import org.polarsys.capella.core.diagram.helpers.ContextualDiagramHelper;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.model.helpers.PartExt;
import org.polarsys.capella.core.sirius.analysis.ABServices;
import org.polarsys.capella.core.sirius.analysis.CsServices;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.FaServices;
import org.polarsys.capella.core.sirius.analysis.FunctionalChainServices;
import org.polarsys.capella.core.sirius.analysis.PhysicalServices;
import org.polarsys.capella.core.sirius.analysis.cache.DEdgeIconCache;
import org.polarsys.capella.core.sirius.analysis.cache.FunctionalChainCache;
import org.polarsys.capella.core.sirius.analysis.cache.PhysicalPathCache;
import org.polarsys.capella.core.sirius.analysis.constants.MappingConstantsHelper;
import org.polarsys.capella.core.sirius.analysis.helpers.FilterHelper;
import org.polarsys.capella.core.sirius.analysis.refresh.extension.AbstractCacheAwareRefreshExtension;
import org.polarsys.capella.core.sirius.analysis.refresh.extension.Messages;
import org.polarsys.capella.core.sirius.analysis.tool.HashMapSet;

public class ComponentArchitectureBlankRefreshExtension
extends AbstractCacheAwareRefreshExtension {
    private final List<String> monitoredFilters = Arrays.asList("hide.simplified.diagram.based.component.exchanges.filter", "hide.simplified.group.of.component.exchanges.filter", "hide.simplified.oriented.grouped.component.exchanges.filter", "hide.computed.component.exchanges.filter", "hide.computed.physical.links.filter");

    @Override
    public void beforeRefresh(DDiagram diagram) {
        NodeMapping mapping;
        super.beforeRefresh(diagram);
        FunctionalChainCache.getInstance().reset();
        PhysicalPathCache.getInstance().reset();
        DDiagram openingDiagram = DiagramServices.getDiagramServices().getOpeningDiagram();
        if (openingDiagram == null || openingDiagram == diagram) {
            DEdgeIconCache.getInstance().reset();
        }
        DRepresentationDescriptor descriptor = RepresentationHelper.getRepresentationDescriptor((DRepresentation)diagram);
        FilterHelper.monitorDesactivation(this.monitoredFilters, descriptor);
        this.updateTargetDiagram(diagram, descriptor);
        String mappingName = MappingConstantsHelper.getMappingFunction(diagram);
        if (mappingName != null && (mapping = DiagramServices.getDiagramServices().getNodeMapping(diagram, mappingName)) != null) {
            Collection nodes = diagram.getOwnedDiagramElements().stream().filter(AbstractDNode.class::isInstance).filter(d -> d.getTarget() instanceof AbstractFunction).filter(d -> mapping.equals(d.getDiagramElementMapping())).collect(Collectors.toList());
            nodes.stream().forEach(d -> DiagramServices.getDiagramServices().removeContainerView((EObject)d));
        }
        DDiagramContents context = FaServices.getFaServices().getDDiagramContents(diagram);
        List contextualElements = ContextualDiagramHelper.getService().getContextualElements(descriptor);
        try {
            CsServices.getService().showABContextualElements(context, contextualElements);
        }
        catch (Exception e) {
            Logger.getLogger((String)"Diagrams Management").error((Object)Messages.RefreshExtension_ErrorOnContextualElements, (Throwable)e);
        }
        try {
            this.reorderElements(diagram);
        }
        catch (Exception e) {
            Logger.getLogger((String)"Diagrams Management").error((Object)Messages.RefreshExtension_ErrorOnReordering, (Throwable)e);
        }
        try {
            this.updateComponentCategories(context);
        }
        catch (Exception e) {
            Logger.getLogger((String)"Diagrams Management").error((Object)Messages.RefreshExtension_ErrorOnUpdateComponentCategories, (Throwable)e);
        }
        try {
            this.updatePhysicalCategories(context);
        }
        catch (Exception e) {
            Logger.getLogger((String)"Diagrams Management").error((Object)Messages.RefreshExtension_ErrorOnUpdatePhysicalCategories, (Throwable)e);
        }
        try {
            this.updateFunctionalExchangeCategories(context);
        }
        catch (Exception e) {
            Logger.getLogger((String)"Diagrams Management").error((Object)Messages.RefreshExtension_ErrorOnUpdateFECategories, (Throwable)e);
        }
        try {
            context.commitDeferredActions();
        }
        catch (Exception e) {
            Logger.getLogger((String)"Diagrams Management").error((Object)Messages.RefreshExtension_ErrorOnCommitDeferredActions, (Throwable)e);
        }
    }

    protected void updateTargetDiagram(DDiagram diagram, DRepresentationDescriptor descriptor) {
        if (diagram instanceof DSemanticDiagram) {
            DSemanticDiagram semanticDiagram = (DSemanticDiagram)diagram;
            EObject target = semanticDiagram.getTarget();
            if (target instanceof Component) {
                CsServices.getService().createRepresentingPartIfNone((Component)target);
            } else if (target instanceof Part) {
                AbstractType type;
                Part part = (Part)target;
                if (!CsServices.getService().isMultipartMode((ModelElement)part) && (type = CsServices.getService().getComponentType(part)) instanceof Component) {
                    RepresentationHelper.setTarget((DRepresentationDescriptor)descriptor, (DRepresentation)semanticDiagram, (EObject)type);
                }
            }
        }
    }

    protected void updateComponentCategories(DDiagramContents context) {
        DDiagram diagram = context.getDDiagram();
        Collection categories = (Collection)ModelCache.getCache(ABServices::getComponentExchangeCategories, (Object)diagram);
        if (!categories.isEmpty()) {
            if (diagram.isSynchronized()) {
                ABServices.getService().switchABComponentCategories(context, (DSemanticDecorator)context.getDDiagram(), (Collection<EObject>)categories, false);
            } else {
                ABServices.getService().updateABComponentCategories(context);
            }
        }
    }

    protected void updateFunctionalExchangeCategories(DDiagramContents diagramContents) {
        DDiagram diagram = diagramContents.getDDiagram();
        Collection categories = (Collection)ModelCache.getCache(ABServices::getExchangeCategories, (Object)diagram);
        if (!categories.isEmpty() && diagram.isSynchronized()) {
            FaServices.getFaServices().switchFECategories(diagramContents, (DSemanticDecorator)diagram, categories, false);
        }
        ABServices.getService().updateABFunctionalCategories(diagramContents);
    }

    protected void updatePhysicalCategories(DDiagramContents context) {
        DDiagram diagram = context.getDDiagram();
        Collection categories = (Collection)ModelCache.getCache(ABServices::getPhysicalLinkCategory, (Object)diagram);
        if (!categories.isEmpty()) {
            if (diagram.isSynchronized()) {
                ABServices.getService().switchABPhysicalCategories(context, (DSemanticDecorator)context.getDDiagram(), (Collection<EObject>)categories, false);
            } else {
                ABServices.getService().updateABPhysicalCategories(context);
            }
        }
    }

    @Override
    public void reorderElements(DDiagram diagram) {
        Part currentPart;
        DDiagramContents content = new DDiagramContents(diagram){

            @Override
            public Collection<EObject> getParents(EObject object, EObject context) {
                LinkedList<EObject> parents = new LinkedList<EObject>();
                if (object instanceof Part && context instanceof DNodeContainer) {
                    EObject contextPart = ((DNodeContainer)context).getTarget();
                    if (CsServices.getService().isDeployed((DNodeContainer)context)) {
                        parents.addAll((Collection)ModelCache.getCache(PartExt::getDeployingElements, (Object)((Part)object)));
                    } else {
                        parents.add(CsServices.getService().getParentContainer(object));
                    }
                    parents.remove(contextPart);
                }
                return parents;
            }
        };
        HashMapSet<AbstractType, DNodeContainer> typeViews = new HashMapSet<AbstractType, DNodeContainer>();
        HashMapSet<Part, DNodeContainer> partViews = new HashMapSet<Part, DNodeContainer>();
        HashSet<DNodeContainer> toBeMoved = new HashSet<DNodeContainer>();
        List<AbstractNodeMapping> mappingsToMove = this.getListOfMappingsToMove(diagram);
        for (AbstractDNode abstractDNode : diagram.getContainers()) {
            if (!(abstractDNode instanceof DNodeContainer) || !(abstractDNode.getTarget() instanceof Part) || !this.isReorderable((DDiagramElement)abstractDNode) || !mappingsToMove.contains(abstractDNode.getDiagramElementMapping())) continue;
            currentPart = (Part)abstractDNode.getTarget();
            AbstractType currentType = CsServices.getService().getComponentType(currentPart);
            typeViews.put(currentType, (DNodeContainer)abstractDNode);
            partViews.put(currentPart, (DNodeContainer)abstractDNode);
        }
        block1: for (Map.Entry entry : typeViews.entrySet()) {
            Collection views = entry.getValue();
            for (DNodeContainer anElement : views) {
                Part currentPart2 = (Part)anElement.getTarget();
                boolean willBeMoved = false;
                if (anElement.eContainer() instanceof DSemanticDecorator) {
                    DSemanticDecorator containerView = (DSemanticDecorator)anElement.eContainer();
                    EObject actualContainer = containerView.getTarget();
                    EObject actualComponentContainer = CsServices.getService().getComponentType(containerView);
                    if (actualContainer == null) {
                        willBeMoved = true;
                    } else if (containerView instanceof DDiagram && actualComponentContainer != null && actualComponentContainer instanceof Component && !typeViews.get(actualComponentContainer).isEmpty()) {
                        willBeMoved = true;
                    } else {
                        willBeMoved = true;
                        for (EObject currentParent : content.getParents((EObject)currentPart2, (EObject)anElement)) {
                            if (currentParent == null || !currentParent.equals(actualContainer) && !currentParent.equals(actualComponentContainer)) continue;
                            willBeMoved = false;
                            break;
                        }
                    }
                    if (willBeMoved) {
                        toBeMoved.add(anElement);
                        continue block1;
                    }
                }
                if (willBeMoved) continue block1;
            }
        }
        for (DNodeContainer dNodeContainer : toBeMoved) {
            currentPart = (Part)dNodeContainer.getTarget();
            LinkedList<EObject> parents = new LinkedList<EObject>();
            HashSet<EObject> visitedParents = new HashSet<EObject>();
            boolean toBeDeleted = false;
            boolean isAdded = false;
            parents.addAll(content.getParents((EObject)currentPart, (EObject)dNodeContainer));
            while (!(isAdded || toBeDeleted || parents.isEmpty())) {
                DNodeContainer container;
                Iterator iterator;
                Component parentElement;
                EObject parent = (EObject)parents.removeFirst();
                if (visitedParents.contains(parent)) continue;
                visitedParents.add(parent);
                if (parent instanceof Component) {
                    parentElement = (Component)parent;
                    if (typeViews.get(parentElement).size() == 1) {
                        iterator = typeViews.get(parentElement).iterator();
                        while (iterator.hasNext()) {
                            container = (DNodeContainer)iterator.next();
                            if (!container.getOwnedDiagramElements().contains((Object)dNodeContainer) && dNodeContainer != container.eContainer()) {
                                container.getOwnedDiagramElements().add((Object)dNodeContainer);
                            }
                            isAdded = true;
                        }
                    } else if (typeViews.get(parentElement).size() > 1) {
                        toBeDeleted = true;
                    }
                    if (isAdded || toBeDeleted) continue;
                    for (Part part : parentElement.getRepresentingParts()) {
                        parents.addAll(content.getParents((EObject)part, (EObject)dNodeContainer));
                    }
                    continue;
                }
                if (!(parent instanceof Part)) continue;
                parentElement = (Part)parent;
                if (partViews.get(parentElement).size() == 1) {
                    iterator = partViews.get(parentElement).iterator();
                    while (iterator.hasNext()) {
                        container = (DNodeContainer)iterator.next();
                        if (!container.getOwnedDiagramElements().contains((Object)dNodeContainer)) {
                            container.getOwnedDiagramElements().add((Object)dNodeContainer);
                        }
                        isAdded = true;
                    }
                } else if (partViews.get(parentElement).size() > 1) {
                    toBeDeleted = true;
                }
                if (isAdded || toBeDeleted) continue;
                parents.addAll(content.getParents(parent, (EObject)dNodeContainer));
            }
            if (!(isAdded || toBeDeleted || diagram.getOwnedDiagramElements().contains((Object)dNodeContainer))) {
                diagram.getOwnedDiagramElements().add((Object)dNodeContainer);
            }
            if (!toBeDeleted) continue;
            DiagramServices.getDiagramServices().removeContainerView((EObject)dNodeContainer);
        }
    }

    @Override
    protected List<AbstractNodeMapping> getListOfMappingsToMove(DDiagram diagram) {
        ArrayList<AbstractNodeMapping> returnedList = new ArrayList<AbstractNodeMapping>();
        returnedList.add((AbstractNodeMapping)DiagramServices.getDiagramServices().getContainerMapping(diagram, "System Actors"));
        returnedList.add((AbstractNodeMapping)DiagramServices.getDiagramServices().getContainerMapping(diagram, "System System"));
        returnedList.add((AbstractNodeMapping)DiagramServices.getDiagramServices().getContainerMapping(diagram, "LAB Logical Component"));
        returnedList.add((AbstractNodeMapping)DiagramServices.getDiagramServices().getContainerMapping(diagram, "PAB_Deployment"));
        returnedList.add((AbstractNodeMapping)DiagramServices.getDiagramServices().getContainerMapping(diagram, "PAB_PC"));
        returnedList.add((AbstractNodeMapping)DiagramServices.getDiagramServices().getContainerMapping(diagram, "CI container mapping"));
        return returnedList;
    }

    @Override
    public void postRefresh(DDiagram diagram) {
        try {
            FunctionalChainServices.getFunctionalChainServices().updateFunctionalChainStyles(diagram);
        }
        catch (Exception e) {
            Logger.getLogger((String)"Diagrams Management").error((Object)Messages.RefreshExtension_ErrorOnUpdateFunctionalChainStyle, (Throwable)e);
        }
        try {
            List<String> physicalPathSupportingDiagrams = Arrays.asList("Physical Architecture Blank", "System Architecture Blank", "Logical Architecture Blank");
            if (physicalPathSupportingDiagrams.contains(diagram.getDescription().getName())) {
                PhysicalServices.getService().updateInternalPhysicalPaths(diagram);
                PhysicalServices.getService().updatePhysicalPathStyles(diagram);
            }
        }
        catch (Exception e) {
            Logger.getLogger((String)"Diagrams Management").error((Object)Messages.RefreshExtension_ErrorOnUpdatePhysicalPathStyle, (Throwable)e);
        }
        FunctionalChainCache.getInstance().reset();
        PhysicalPathCache.getInstance().reset();
        super.postRefresh(diagram);
    }

    @Deprecated
    public ContainerMapping getComponentMapping(DDiagram diagram) {
        if (diagram.getDescription().getName().equals("System Architecture Blank")) {
            return DiagramServices.getDiagramServices().getContainerMapping(diagram, "System Actors");
        }
        if (diagram.getDescription().getName().equals("Logical Architecture Blank")) {
            return DiagramServices.getDiagramServices().getContainerMapping(diagram, "LAB Logical Component");
        }
        if (diagram.getDescription().getName().equals("EPBS Architecture Blank")) {
            return DiagramServices.getDiagramServices().getContainerMapping(diagram, "LAB Logical Component");
        }
        return DiagramServices.getDiagramServices().getContainerMapping(diagram, "PAB_PC");
    }
}

