/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.refresh.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.EntityOperationalCapabilityInvolvement;
import org.polarsys.capella.core.data.oa.OperationalCapability;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.refresh.extension.AbstractCacheAwareRefreshExtension;

public class ContextualOCRefreshExtension
extends AbstractCacheAwareRefreshExtension {
    @Override
    protected List<AbstractNodeMapping> getListOfMappingsToMove(DDiagram diagram) {
        ArrayList<AbstractNodeMapping> returnedList = new ArrayList<AbstractNodeMapping>();
        returnedList.add(DiagramServices.getDiagramServices().getAbstractNodeMapping(diagram, "COC2_Entities"));
        return returnedList;
    }

    @Override
    public void beforeRefresh(DDiagram diagram) {
        super.beforeRefresh(diagram);
        EObject diagramTarget = ((DSemanticDecorator)diagram).getTarget();
        if (diagramTarget instanceof OperationalCapability) {
            OperationalCapability capa = (OperationalCapability)diagramTarget;
            LinkedList<Entity> entities = new LinkedList<Entity>();
            HashSet<OperationalCapability> ocs = new HashSet<OperationalCapability>();
            AbstractNodeMapping entityMapping = DiagramServices.getDiagramServices().getAbstractNodeMapping(diagram, "COC2_Entities");
            AbstractNodeMapping oCMapping = DiagramServices.getDiagramServices().getAbstractNodeMapping(diagram, "COC2_OperationalCapabilities");
            EList ownedEntityOperationalCapabilityInvolvements = capa.getOwnedEntityOperationalCapabilityInvolvements();
            for (EntityOperationalCapabilityInvolvement entityOperationalCapabilityInvolvement : ownedEntityOperationalCapabilityInvolvements) {
                Entity entity = entityOperationalCapabilityInvolvement.getEntity();
                if (entity == null) continue;
                entities.add(entity);
            }
            ocs.add(capa);
            ocs.addAll((Collection<OperationalCapability>)capa.getSuper());
            ocs.addAll((Collection<OperationalCapability>)capa.getSub());
            ocs.addAll((Collection<OperationalCapability>)capa.getExtendedAbstractCapabilities());
            ocs.addAll((Collection<OperationalCapability>)capa.getIncludedAbstractCapabilities());
            for (Entity entity : entities) {
                if (DiagramServices.getDiagramServices().isOnDiagram(diagram, (EObject)entity)) continue;
                DiagramServices.getDiagramServices().createAbstractDNode(entityMapping, (EObject)entity, (DragAndDropTarget)diagram, diagram);
            }
            for (AbstractCapability abstractCapability : ocs) {
                if (DiagramServices.getDiagramServices().isOnDiagram(diagram, (EObject)abstractCapability)) continue;
                DiagramServices.getDiagramServices().createAbstractDNode(oCMapping, (EObject)abstractCapability, (DragAndDropTarget)diagram, diagram);
            }
            this.reorderElements(diagram);
        }
    }
}

