/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.listener;

import com.google.common.base.Predicate;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.sirius.business.api.session.ModelChangeTrigger;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.business.internal.session.SessionEventBrokerImpl;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.polarsys.capella.core.sirius.ui.listener.DAnnotationChangeTrigger;

public class DAnnotationPrecommitListener
implements SessionManagerListener {
    private DAnnotationChangeTrigger dAnnotationChangeTrigger;
    public Predicate<Notification> considerDAnnotationForAutomaticRefreshPredicate = notification -> {
        if (notification != null) {
            if (this.isChangeOnFilters((Notification)notification)) {
                return false;
            }
            if (notification.getNotifier() instanceof DAnnotation) {
                return true;
            }
            if ((notification.getNotifier() instanceof DRepresentation || notification.getNotifier() instanceof DRepresentationDescriptor) && (notification.getOldValue() instanceof DAnnotation || notification.getNewValue() instanceof DAnnotation)) {
                return true;
            }
        }
        return false;
    };

    private boolean isChangeOnFilters(Notification notification) {
        DAnnotation annotation = null;
        if (notification.getNotifier() instanceof DAnnotation) {
            annotation = (DAnnotation)notification.getNotifier();
        } else if (notification.getOldValue() instanceof DAnnotation) {
            annotation = (DAnnotation)notification.getOldValue();
        } else if (notification.getNewValue() instanceof DAnnotation) {
            annotation = (DAnnotation)notification.getNewValue();
        }
        return annotation != null && "https://www.polarsys.org/capella/dannotation/DesactivatedFilters".equals(annotation.getSource());
    }

    public void notifyAddSession(Session newSession) {
        this.dAnnotationChangeTrigger = new DAnnotationChangeTrigger(newSession);
        newSession.getEventBroker().addLocalTrigger(SessionEventBrokerImpl.asFilter(this.considerDAnnotationForAutomaticRefreshPredicate), (ModelChangeTrigger)this.dAnnotationChangeTrigger);
    }

    public void notifyRemoveSession(Session removedSession) {
        removedSession.getEventBroker().removeLocalTrigger((ModelChangeTrigger)this.dAnnotationChangeTrigger);
    }

    public void viewpointSelected(Viewpoint selectedSirius) {
    }

    public void viewpointDeselected(Viewpoint deselectedSirius) {
    }

    public void notify(Session updated, int notification) {
    }
}

