/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.ad.viewpoint.dsl.generation.ui.util;

import org.eclipse.emf.common.util.EList;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Aspect;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpui.UI;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpui.UIContainer;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpui.UIDescription;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpui.UIField;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpui.UI_Field_Type;

public final class VPUIHelper {
    public static boolean generateRichTextForUI(Viewpoint vp) {
        UIDescription ui = VPUIHelper.getUIDescription(vp);
        if (ui != null) {
            EList userIs = ui.getUIs();
            return VPUIHelper.generateRichTextForUI((EList<UI>)userIs);
        }
        return false;
    }

    public static boolean generateRichTextForUI(EList<UI> userIntfs) {
        boolean result = false;
        for (UI ui : userIntfs) {
            EList uiContainers = ui.getUI_Containers();
            result = VPUIHelper.generateRichTextForUI_Containers((EList<UIContainer>)uiContainers);
            if (result) break;
        }
        return result;
    }

    public static boolean generateRichTextForUI_Containers(EList<UIContainer> uiContainers) {
        boolean result = false;
        for (UIContainer uiContainer : uiContainers) {
            result = VPUIHelper.generateRichTextForUI_Container(uiContainer);
            if (result) break;
        }
        return result;
    }

    public static boolean generateRichTextForUI_Container(UIContainer uiContainer) {
        boolean result = false;
        EList uiFields = uiContainer.getUI_fields();
        result = VPUIHelper.generateRichTextForUI_Fields((EList<UIField>)uiFields);
        if (!result) {
            result = VPUIHelper.generateRichTextForUI_Containers((EList<UIContainer>)uiContainer.getSubContainers());
        }
        return result;
    }

    public static boolean generateRichTextForUI_Fields(EList<UIField> uiFields) {
        boolean result = false;
        for (UIField uiField : uiFields) {
            result = VPUIHelper.generateRichTextForUI_Field(uiField);
            if (result) break;
        }
        return result;
    }

    public static boolean generateRichTextForUI_Field(UIField uiField) {
        return uiField.getType().equals((Object)UI_Field_Type.RICHTEXT);
    }

    private static UIDescription getUIDescription(Viewpoint vp) {
        EList vpAspects = vp.getVP_Aspects();
        for (Aspect aspect : vpAspects) {
            if (!(aspect instanceof UIDescription)) continue;
            return (UIDescription)aspect;
        }
        return null;
    }

    private VPUIHelper() {
    }
}

