/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hideshow.command;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.command.AbstractContextFreeCommand;
import org.eclipse.nebula.widgets.nattable.util.ArrayUtil;

public class MultiRowShowCommand
extends AbstractContextFreeCommand {
    private final int[] rowIndexes;

    public MultiRowShowCommand(Collection<Integer> rowIndexes) {
        this.rowIndexes = rowIndexes.stream().mapToInt(Integer::intValue).toArray();
    }

    public MultiRowShowCommand(int ... rowIndexes) {
        this.rowIndexes = rowIndexes;
    }

    public Collection<Integer> getRowIndexes() {
        return ArrayUtil.asIntegerList(this.rowIndexes);
    }

    public int[] getRowIndexesArray() {
        return this.rowIndexes;
    }

    @Override
    public MultiRowShowCommand cloneCommand() {
        return new MultiRowShowCommand(Arrays.copyOf(this.rowIndexes, this.rowIndexes.length));
    }
}

