/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.commands;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.platform.sirius.ui.commands.AbstractFixCommand;
import org.polarsys.capella.core.platform.sirius.ui.commands.Messages;

public class ComponentExchangeThroughDelegationsCommand
extends AbstractFixCommand {
    public String getName() {
        return Messages.ComponentExchangeThroughDelegations;
    }

    public ComponentExchangeThroughDelegationsCommand(Collection<ModelElement> selection) {
        this(selection, (IProgressMonitor)new NullProgressMonitor());
    }

    public ComponentExchangeThroughDelegationsCommand(Collection<ModelElement> selection, IProgressMonitor progressMonitor) {
        super(selection, progressMonitor);
    }

    @Override
    protected Collection<ModelElement> retrieveModelElements(ModelElement modelElement) {
        return Collections.singleton(modelElement);
    }

    @Override
    protected void process(ModelElement element) {
        if (element instanceof ComponentExchange) {
            ComponentExchange exchange = (ComponentExchange)element;
            Part sourcePart = ComponentExchangeExt.getSourcePart((ComponentExchange)exchange);
            Port sourcePort = ComponentExchangeExt.getSourcePort((ComponentExchange)exchange);
            Part targetPart = ComponentExchangeExt.getTargetPart((ComponentExchange)exchange);
            Port targetPort = ComponentExchangeExt.getTargetPort((ComponentExchange)exchange);
            if (sourcePart == null) {
                Component sourceComponent = ComponentExchangeExt.getSourceComponent((ComponentExchange)exchange);
                sourcePart = (Part)sourceComponent.getRepresentingParts().get(0);
            }
            if (targetPart == null) {
                Component targetComponent = ComponentExchangeExt.getTargetComponent((ComponentExchange)exchange);
                targetPart = (Part)targetComponent.getRepresentingParts().get(0);
            }
            if (!(sourcePort != null && !(sourcePort instanceof ComponentPort) || targetPort != null && !(targetPort instanceof ComponentPort) || sourcePart == null || targetPart == null || ComponentExt.isBrothers((Part)sourcePart, (Part)targetPart) || ComponentExt.isComponentExchangeThroughDelegationsExists((Part)sourcePart, (Part)targetPart, (Port)sourcePort, (Port)targetPort))) {
                ComponentExt.createComponentExchangeThroughDelegations((Part)sourcePart, (ComponentPort)((ComponentPort)sourcePort), (Part)targetPart, (ComponentPort)((ComponentPort)targetPort));
            }
        }
    }
}

