/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.queries.interpretor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.IQuery;
import org.polarsys.capella.common.queries.debug.FormatedLogger;
import org.polarsys.capella.common.queries.debug.Log;
import org.polarsys.capella.common.queries.exceptions.NonExistingQuery;
import org.polarsys.capella.common.queries.filters.IQueryFilter;
import org.polarsys.capella.common.queries.internal.IPrivateQueryContext;
import org.polarsys.capella.common.queries.internal.NoneValue;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.common.queries.queryContext.QueryContext;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;

public class QueryInterpretor {
    private static final Logger logger = ReportManagerRegistry.getInstance().subscribe("Model Management");
    private static final NoneValue NONE_VALUE = new NoneValue();
    private static int queryIdCounter = 0;
    private static Hashtable<IQuery, Integer> queryToId = new Hashtable();
    private static Hashtable<String, IConfigurationElement> identifier2QueryDef = null;
    private static Hashtable<String, Set<IQueryFilter>> identifier2QueryFilters = null;
    private static Hashtable<String, IQuery> identifier2Query = null;
    private static Hashtable<String, String> queryIdentifier2ExtendedQueryIdentifier = null;

    public static <T> List<T> executeQuery(String queryIdentifier, Object semanticsObject, IQueryContext context, Set<IQueryFilter> filters) {
        IPrivateQueryContext theContext;
        if (context == null) {
            throw new IllegalArgumentException("the context shall not be null");
        }
        Object semanticsObj = semanticsObject;
        if (semanticsObj == null) {
            semanticsObj = NONE_VALUE;
        }
        if ((theContext = (IPrivateQueryContext)context).getExecutionLevel() == 0) {
            FormatedLogger.addTextLn("QUERY CALL : " + queryIdentifier, Log.QUERY_INTERPRETOR);
        }
        FormatedLogger.addTextLn("QueryInterpretor.executeQuery(" + queryIdentifier + ", " + semanticsObj + ")", Log.QUERY_INTERPRETOR);
        FormatedLogger.addTextLn("{", Log.QUERY_INTERPRETOR);
        FormatedLogger.incIndent(Log.QUERY_INTERPRETOR);
        LinkedHashSet<Object> subResult = new LinkedHashSet<Object>();
        Set<IQuery> queries = QueryInterpretor.getQuerySetForQueryIdentifier(queryIdentifier);
        for (IQuery query : queries) {
            Integer queryId = queryToId.get(query);
            List<Object> res = theContext.getResultFromCache(queryId, semanticsObj);
            if (res == null) {
                FormatedLogger.addTextLn("execute " + query.getIdentifier() + " {", Log.QUERY_INTERPRETOR);
                FormatedLogger.incIndent(Log.QUERY_INTERPRETOR);
                theContext.incCallLevel();
                res = query.execute(semanticsObj, theContext);
                theContext.decCallLevel();
                theContext.addInCache(queryId, semanticsObj, res);
                FormatedLogger.decIndent(Log.QUERY_INTERPRETOR);
                FormatedLogger.addTextLn("}", Log.QUERY_INTERPRETOR);
            } else {
                FormatedLogger.addTextLn("retrieve from cache for " + query.getIdentifier() + "[" + queryId + "]" + " " + semanticsObj, Log.QUERY_INTERPRETOR);
            }
            if (res == null || res.isEmpty()) continue;
            subResult.addAll(res);
        }
        FormatedLogger.decIndent(Log.QUERY_INTERPRETOR);
        FormatedLogger.addTextLn("}", Log.QUERY_INTERPRETOR);
        List result = new ArrayList(subResult);
        if (theContext.getExecutionLevel() == 0) {
            theContext.overwriteValue("queryInputElement", semanticsObject);
            for (IQueryFilter filter : filters) {
                result = QueryInterpretor.executeFilter(result, filter, context);
            }
            FormatedLogger.addTextLn("Filtering ...", Log.QUERY_INTERPRETOR);
        }
        return result;
    }

    public static <T> List<T> executeQuery(String queryIdentifier, Object semanticsObject, IQueryContext context, IQueryFilter filter) {
        Set<IQueryFilter> filters = QueryInterpretor.getFilters(queryIdentifier);
        if (filter != null) {
            filters.add(filter);
        }
        return QueryInterpretor.executeQuery(queryIdentifier, semanticsObject, context, filters);
    }

    public static <T> List<T> executeQuery(String queryIdentifier, Object semanticsObject, IQueryContext context) {
        return QueryInterpretor.executeQuery(queryIdentifier, semanticsObject, context, QueryInterpretor.getFilters(queryIdentifier));
    }

    public static <T> List<T> executeQuery(String queryIdentifier, Object semanticsObject) {
        return QueryInterpretor.executeQuery(queryIdentifier, semanticsObject, new QueryContext());
    }

    public static <T> List<T> executeQuery(String queryIdentifier, IQueryContext context) {
        return QueryInterpretor.executeQuery(queryIdentifier, (Object)NONE_VALUE, context, QueryInterpretor.getFilters(queryIdentifier));
    }

    public static <T> List<T> executeQuery(String queryIdentifier, IQueryContext context, IQueryFilter filter) {
        Set<IQueryFilter> filters = QueryInterpretor.getFilters(queryIdentifier);
        if (filter != null) {
            filters.add(filter);
        }
        return QueryInterpretor.executeQuery(queryIdentifier, (Object)NONE_VALUE, context, filters);
    }

    public static Set<IQueryFilter> getFilters(String queryIdentifier) {
        if (identifier2QueryFilters == null) {
            QueryInterpretor.loadQueries();
        }
        HashSet<IQueryFilter> result = new HashSet<IQueryFilter>();
        for (IQuery query : QueryInterpretor.getQuerySetForQueryIdentifier(queryIdentifier)) {
            Set<IQueryFilter> filters = identifier2QueryFilters.get(query.getIdentifier());
            if (filters == null) continue;
            result.addAll(filters);
        }
        return result;
    }

    public static <T> List<T> executeFilter(List<T> elements, IQueryFilter filter, IQueryContext context) {
        ArrayList<T> filteredResult = new ArrayList<T>();
        for (T obj : elements) {
            if (!filter.keepElement(obj, context)) continue;
            filteredResult.add(obj);
        }
        return filteredResult;
    }

    public static <T> List<T> executeFilter(List<T> elements, IQueryFilter filter) {
        return QueryInterpretor.executeFilter(elements, filter, null);
    }

    private static Set<IQuery> getQuerySetForQueryIdentifier(String queryIdentifier) {
        HashSet<IQuery> res = new HashSet<IQuery>();
        if (identifier2QueryDef == null) {
            QueryInterpretor.loadQueries();
        }
        if (!identifier2QueryDef.containsKey(queryIdentifier)) {
            throw new NonExistingQuery(queryIdentifier);
        }
        String currentQueryIdentifier = queryIdentifier;
        while (currentQueryIdentifier != null) {
            IQuery query = QueryInterpretor.getQuery(currentQueryIdentifier);
            if (query == null || res.contains(query)) continue;
            res.add(query);
            for (String extendingQueryId : query.getExtendingQueryIdentifiers()) {
                IQuery extendingQuery = QueryInterpretor.getQuery(extendingQueryId);
                if (extendingQuery == null || res.contains(extendingQuery)) continue;
                res.add(extendingQuery);
            }
            currentQueryIdentifier = query.getExtendedQueryIdentifier();
        }
        return res;
    }

    private static IQuery getQuery(String queryIdentifier) {
        IQuery query = identifier2Query.get(queryIdentifier);
        if (query == null) {
            try {
                IConfigurationElement queryDef = identifier2QueryDef.get(queryIdentifier);
                if (queryDef != null) {
                    query = (IQuery)queryDef.createExecutableExtension("algorithm");
                    query.setIdentifier(queryIdentifier);
                    query.setExtendedQueryIdentifier(queryIdentifier2ExtendedQueryIdentifier.get(queryIdentifier));
                    identifier2Query.put(queryIdentifier, query);
                    queryToId.put(query, queryIdCounter++);
                }
            }
            catch (CoreException exception) {
                exception.printStackTrace();
            }
        }
        return query;
    }

    private static void loadQueries() {
        IConfigurationElement[] querySpecifications;
        identifier2QueryDef = new Hashtable();
        identifier2QueryFilters = new Hashtable();
        identifier2Query = new Hashtable();
        queryIdentifier2ExtendedQueryIdentifier = new Hashtable();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = querySpecifications = registry.getConfigurationElementsFor("org.polarsys.capella.common.queries.query");
        int n = querySpecifications.length;
        int n2 = 0;
        while (n2 < n) {
            String queryIdentifier;
            IConfigurationElement querySpecification = iConfigurationElementArray[n2];
            if ("querySpecification".equals(querySpecification.getName())) {
                queryIdentifier = querySpecification.getAttribute("queryIdentifier");
                String extendedQueryIdentifier = querySpecification.getAttribute("extendedQueryIdentifier");
                IConfigurationElement[] queryConfs = querySpecification.getChildren("queryAlgorithm");
                IConfigurationElement queryDef = identifier2QueryDef.get(queryIdentifier);
                if (queryDef != null) {
                    logger.error((Object)new EmbeddedMessage("Query Engine : At least two query has been defined with identifier " + queryIdentifier + ". Identifier shall be unique !", "Model Management"));
                } else {
                    identifier2QueryDef.put(queryIdentifier, queryConfs[0]);
                    if (extendedQueryIdentifier != null) {
                        queryIdentifier2ExtendedQueryIdentifier.put(queryIdentifier, extendedQueryIdentifier);
                    }
                }
            } else if ("queryFilter".equals(querySpecification.getName())) {
                queryIdentifier = querySpecification.getAttribute("queryIdentifier");
                try {
                    IQueryFilter filter = (IQueryFilter)querySpecification.createExecutableExtension("filter");
                    Set<IQueryFilter> filters = identifier2QueryFilters.get(queryIdentifier);
                    if (filters == null) {
                        filters = new HashSet<IQueryFilter>();
                        identifier2QueryFilters.put(queryIdentifier, filters);
                    }
                    filters.add(filter);
                }
                catch (CoreException ex) {
                    ex.printStackTrace();
                }
            }
            ++n2;
        }
        for (Map.Entry<String, String> entry : queryIdentifier2ExtendedQueryIdentifier.entrySet()) {
            IQuery extendedQuery;
            String extendedQueryId = entry.getValue();
            IQuery iQuery = extendedQuery = extendedQueryId != null && !"".equals(extendedQueryId) ? QueryInterpretor.getQuery(extendedQueryId) : null;
            if (!(extendedQuery instanceof AbstractQuery)) continue;
            ((AbstractQuery)extendedQuery).addExtendingQueryIdentifier(entry.getKey());
        }
    }

    public static boolean doesQueryExist(String queryIdentifier) {
        try {
            QueryInterpretor.getQuerySetForQueryIdentifier(queryIdentifier);
        }
        catch (NonExistingQuery e) {
            return false;
        }
        return true;
    }
}

