/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellacommon.CapellacommonPackage;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.Constraint;
import org.polarsys.capella.core.data.capellacore.Structure;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.ArchitectureAllocation;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.ctx.CtxFactory;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.Mission;
import org.polarsys.capella.core.data.ctx.OperationalAnalysisRealization;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.ctx.SystemComponentPkg;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.data.ctx.SystemFunctionPkg;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.epbs.ConfigurationItemPkg;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.epbs.EpbsFactory;
import org.polarsys.capella.core.data.epbs.EpbsPackage;
import org.polarsys.capella.core.data.epbs.PhysicalArchitectureRealization;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.la.LaFactory;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.core.data.la.LogicalFunction;
import org.polarsys.capella.core.data.la.LogicalFunctionPkg;
import org.polarsys.capella.core.data.la.SystemAnalysisRealization;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.EntityPkg;
import org.polarsys.capella.core.data.oa.OaFactory;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.OperationalActivityPkg;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.oa.OperationalCapabilityPkg;
import org.polarsys.capella.core.data.pa.LogicalArchitectureRealization;
import org.polarsys.capella.core.data.pa.PaFactory;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentPkg;
import org.polarsys.capella.core.data.pa.PhysicalFunction;
import org.polarsys.capella.core.data.pa.PhysicalFunctionPkg;
import org.polarsys.capella.core.data.requirement.RequirementFactory;
import org.polarsys.capella.core.data.requirement.RequirementsPkg;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.ComponentPkgExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;
import org.polarsys.capella.core.model.helpers.naming.NamingConstants;
import org.polarsys.kitalpha.emde.model.ExtensibleElement;

public class BlockArchitectureExt {
    private BlockArchitectureExt() {
    }

    public static Type getBlockArchitectureType(BlockArchitecture block) {
        if (block instanceof OperationalAnalysis) {
            return Type.OA;
        }
        if (block instanceof SystemAnalysis) {
            return Type.SA;
        }
        if (block instanceof LogicalArchitecture) {
            return Type.LA;
        }
        if (block instanceof PhysicalArchitecture) {
            return Type.PA;
        }
        if (block instanceof EPBSArchitecture) {
            return Type.EPBS;
        }
        return null;
    }

    public static BlockArchitecture getBlockArchitecture(Type type, Project project) {
        SystemEngineering system = SystemEngineeringExt.getSystemEngineering(project);
        switch (type) {
            case OA: {
                return SystemEngineeringExt.getOperationalAnalysis(system);
            }
            case SA: {
                return SystemEngineeringExt.getSystemAnalysis(system);
            }
            case LA: {
                return SystemEngineeringExt.getLogicalArchitecture(system);
            }
            case PA: {
                return SystemEngineeringExt.getPhysicalArchitecture(system);
            }
            case EPBS: {
                return SystemEngineeringExt.getEPBSArchitecture(system);
            }
        }
        return null;
    }

    public static BlockArchitecture getBlockArchitecture(EClass clazz, Project project) {
        SystemEngineering system = SystemEngineeringExt.getSystemEngineering(project);
        if (OaPackage.Literals.OPERATIONAL_ANALYSIS.equals(clazz)) {
            return SystemEngineeringExt.getOperationalAnalysis(system);
        }
        if (CtxPackage.Literals.SYSTEM_ANALYSIS.equals(clazz)) {
            return SystemEngineeringExt.getSystemAnalysis(system);
        }
        if (LaPackage.Literals.LOGICAL_ARCHITECTURE.equals(clazz)) {
            return SystemEngineeringExt.getLogicalArchitecture(system);
        }
        if (PaPackage.Literals.PHYSICAL_ARCHITECTURE.equals(clazz)) {
            return SystemEngineeringExt.getPhysicalArchitecture(system);
        }
        if (EpbsPackage.Literals.EPBS_ARCHITECTURE.equals(clazz)) {
            return SystemEngineeringExt.getEPBSArchitecture(system);
        }
        return null;
    }

    public static Collection<BlockArchitecture> getAllAllocatedArchitectures(BlockArchitecture architecture) {
        LinkedList<BlockArchitecture> listArchitectures = new LinkedList<BlockArchitecture>();
        HashSet<BlockArchitecture> allocatedArchitectures = new HashSet<BlockArchitecture>();
        if (architecture != null) {
            listArchitectures.add(architecture);
            while (!listArchitectures.isEmpty()) {
                BlockArchitecture current = (BlockArchitecture)listArchitectures.removeFirst();
                allocatedArchitectures.add(current);
                for (BlockArchitecture allocated : current.getAllocatedArchitectures()) {
                    if (allocated == null || allocatedArchitectures.contains(allocated)) continue;
                    listArchitectures.addLast(allocated);
                }
            }
        }
        return allocatedArchitectures;
    }

    public static Collection<BlockArchitecture> getAllAllocatingArchitectures(BlockArchitecture architecture) {
        LinkedList<BlockArchitecture> listArchitectures = new LinkedList<BlockArchitecture>();
        HashSet<BlockArchitecture> allocatingArchitectures = new HashSet<BlockArchitecture>();
        if (architecture != null) {
            listArchitectures.add(architecture);
            while (!listArchitectures.isEmpty()) {
                BlockArchitecture current = (BlockArchitecture)listArchitectures.removeFirst();
                allocatingArchitectures.add(current);
                for (BlockArchitecture allocated : current.getAllocatingArchitectures()) {
                    if (allocated == null || allocatingArchitectures.contains(allocated)) continue;
                    listArchitectures.addLast(allocated);
                }
            }
        }
        return allocatingArchitectures;
    }

    public static List<ExchangeItem> getAllExchangeItems(BlockArchitecture architecture) {
        ArrayList<ExchangeItem> result = new ArrayList<ExchangeItem>();
        SystemEngineering se = SystemEngineeringExt.getSystemEngineering((ExtensibleElement)architecture);
        TreeIterator allContents = se.eAllContents();
        while (allContents.hasNext()) {
            EObject object = (EObject)allContents.next();
            if (object instanceof ExchangeItem) {
                result.add((ExchangeItem)object);
            }
            if (!(object instanceof BlockArchitecture) || se.getOwnedArchitectures().indexOf((Object)object) <= se.getOwnedArchitectures().indexOf((Object)architecture)) continue;
            return result;
        }
        return result;
    }

    public static List<ComponentExchange> getAllComponentExchanges(BlockArchitecture architecture) {
        ArrayList<ComponentExchange> instList = new ArrayList<ComponentExchange>();
        for (EObject obj : EObjectExt.getAll((EObject)architecture, (EClass)FaPackage.Literals.COMPONENT_EXCHANGE)) {
            instList.add((ComponentExchange)obj);
        }
        return instList;
    }

    public static BlockArchitecture getRootBlockArchitecture(EObject context) {
        EObject currentElement = context;
        while (currentElement != null) {
            if (currentElement instanceof BlockArchitecture) {
                return (BlockArchitecture)currentElement;
            }
            currentElement = currentElement.eContainer();
        }
        return null;
    }

    public static List<BlockArchitecture> getPreviousBlockArchitectures(BlockArchitecture anArchitecture) {
        PhysicalArchitecture pa;
        LogicalArchitecture la;
        SystemAnalysis sa;
        ArrayList<BlockArchitecture> returnedList = new ArrayList<BlockArchitecture>();
        SystemEngineering sysEng = SystemEngineeringExt.getSystemEngineering((ExtensibleElement)anArchitecture);
        OperationalAnalysis oa = SystemEngineeringExt.getOwnedOperationalAnalysis(sysEng);
        if (oa != null && anArchitecture.equals(oa)) {
            return returnedList;
        }
        if (oa != null) {
            returnedList.add((BlockArchitecture)oa);
        }
        if ((sa = SystemEngineeringExt.getOwnedSystemAnalysis(sysEng)) != null && anArchitecture.equals(sa)) {
            return returnedList;
        }
        if (sa != null) {
            returnedList.add((BlockArchitecture)sa);
        }
        if ((la = SystemEngineeringExt.getOwnedLogicalArchitecture(sysEng)) != null && anArchitecture.equals(la)) {
            return returnedList;
        }
        if (la != null) {
            returnedList.add((BlockArchitecture)la);
        }
        if ((pa = SystemEngineeringExt.getOwnedPhysicalArchitecture(sysEng)) != null && anArchitecture.equals(pa)) {
            return returnedList;
        }
        if (pa != null) {
            returnedList.add((BlockArchitecture)pa);
        }
        return returnedList;
    }

    public static List<BlockArchitecture> getRootAndPreviousBlockArchitectures(EObject context) {
        ArrayList<BlockArchitecture> returnedList = new ArrayList<BlockArchitecture>();
        BlockArchitecture root = BlockArchitectureExt.getRootBlockArchitecture(context);
        if (root == null) {
            return returnedList;
        }
        returnedList.add(root);
        returnedList.addAll(BlockArchitectureExt.getPreviousBlockArchitectures(root));
        return returnedList;
    }

    public static Structure getActorPkg(BlockArchitecture architecture) {
        return BlockArchitectureExt.getActorPkg(architecture, true);
    }

    public static ComponentPkg getActorPkg(BlockArchitecture architecture, boolean create) {
        return BlockArchitectureExt.getComponentPkg(architecture, create);
    }

    public static ComponentPkg getComponentPkg(BlockArchitecture blockArchitecture) {
        return BlockArchitectureExt.getComponentPkg(blockArchitecture, true);
    }

    public static ComponentPkg getComponentPkg(BlockArchitecture blockArchitecture, boolean create) {
        if (blockArchitecture instanceof OperationalAnalysis) {
            OperationalAnalysis architecture = (OperationalAnalysis)blockArchitecture;
            if (architecture.getOwnedEntityPkg() == null && create) {
                EntityPkg pkg = OaFactory.eINSTANCE.createEntityPkg(NamingConstants.CreateOpAnalysisCmd_operationalEntities_pkg_name);
                architecture.setOwnedEntityPkg(pkg);
            }
            return architecture.getOwnedEntityPkg();
        }
        if (blockArchitecture instanceof SystemAnalysis) {
            SystemAnalysis architecture = (SystemAnalysis)blockArchitecture;
            if (architecture.getOwnedSystemComponentPkg() == null && create) {
                SystemComponentPkg pkg = CtxFactory.eINSTANCE.createSystemComponentPkg(NamingConstants.CreateSysAnalysisCmd_actors_pkg_name);
                architecture.setOwnedSystemComponentPkg(pkg);
            }
            return architecture.getOwnedSystemComponentPkg();
        }
        if (blockArchitecture instanceof LogicalArchitecture) {
            LogicalArchitecture architecture = (LogicalArchitecture)blockArchitecture;
            if (architecture.getOwnedLogicalComponentPkg() == null && create) {
                LogicalComponentPkg pkg = LaFactory.eINSTANCE.createLogicalComponentPkg(NamingConstants.CreateLogicalArchCmd_actors_pkg_name);
                architecture.setOwnedLogicalComponentPkg(pkg);
            }
            return architecture.getOwnedLogicalComponentPkg();
        }
        if (blockArchitecture instanceof PhysicalArchitecture) {
            PhysicalArchitecture architecture = (PhysicalArchitecture)blockArchitecture;
            if (architecture.getOwnedPhysicalComponentPkg() == null && create) {
                PhysicalComponentPkg pkg = PaFactory.eINSTANCE.createPhysicalComponentPkg(NamingConstants.CreatePhysicalArchCmd_actors_pkg_name);
                architecture.setOwnedPhysicalComponentPkg(pkg);
            }
            return architecture.getOwnedPhysicalComponentPkg();
        }
        if (blockArchitecture instanceof EPBSArchitecture) {
            EPBSArchitecture architecture = (EPBSArchitecture)blockArchitecture;
            if (architecture.getOwnedConfigurationItemPkg() == null && create) {
                ConfigurationItemPkg pkg = EpbsFactory.eINSTANCE.createConfigurationItemPkg(NamingConstants.CreateEPBSArchCmd_configurationItemPkg_name);
                architecture.setOwnedConfigurationItemPkg(pkg);
            }
            return architecture.getOwnedConfigurationItemPkg();
        }
        return null;
    }

    public static boolean isDefaultNameComponentPkg(AbstractNamedElement pkg) {
        return NamingConstants.CreateSysAnalysisCmd_actors_pkg_name.equals(pkg.getName()) || NamingConstants.CreateLogicalArchCmd_actors_pkg_name.equals(pkg.getName()) || NamingConstants.CreatePhysicalArchCmd_actors_pkg_name.equals(pkg.getName()) || NamingConstants.CreateEPBSArchCmd_configurationItemPkg_name.equals(pkg.getName());
    }

    public static DataPkg getDataPkg(BlockArchitecture architecture, boolean create) {
        if (architecture.getOwnedDataPkg() == null && create) {
            DataPkg pkg = InformationFactory.eINSTANCE.createDataPkg(NamingConstants.CreateCommonCmd_data_pkg_name);
            architecture.setOwnedDataPkg(pkg);
        }
        return architecture.getOwnedDataPkg();
    }

    public static boolean isDefaultNameDataPkg(AbstractNamedElement pkg) {
        return NamingConstants.CreateCommonCmd_data_pkg_name.equals(pkg.getName());
    }

    public static DataPkg getDataPkg(BlockArchitecture architecture) {
        return BlockArchitectureExt.getDataPkg(architecture, true);
    }

    public static Structure getRequirementsPkg(BlockArchitecture architecture, boolean create) {
        if (architecture.getOwnedRequirementPkgs().isEmpty() && create) {
            RequirementsPkg pkg = RequirementFactory.eINSTANCE.createRequirementsPkg(NamingConstants.CreateCommonCmd_requirements_pkg_name);
            architecture.getOwnedRequirementPkgs().add((Object)pkg);
        }
        if (architecture.getOwnedRequirementPkgs().isEmpty()) {
            return null;
        }
        return (Structure)architecture.getOwnedRequirementPkgs().get(0);
    }

    public static boolean isDefaultNameRequirementsPkg(AbstractNamedElement pkg) {
        return NamingConstants.CreateCommonCmd_requirements_pkg_name.equals(pkg.getName());
    }

    public static Structure getRequirementsPkg(BlockArchitecture architecture) {
        return BlockArchitectureExt.getRequirementsPkg(architecture, true);
    }

    public static AbstractCapabilityPkg getAbstractCapabilityPkg(BlockArchitecture architecture) {
        return BlockArchitectureExt.getAbstractCapabilityPkg(architecture, true);
    }

    public static AbstractCapabilityPkg getAbstractCapabilityPkg(BlockArchitecture architecture, boolean create) {
        if (architecture.getOwnedAbstractCapabilityPkg() == null && create) {
            OperationalCapabilityPkg pkg = null;
            if (architecture instanceof OperationalAnalysis) {
                pkg = OaFactory.eINSTANCE.createOperationalCapabilityPkg(NamingConstants.CreateOpAnalysisCmd_operationalCapabilities_pkg_name);
            } else if (architecture instanceof SystemAnalysis) {
                pkg = CtxFactory.eINSTANCE.createCapabilityPkg(NamingConstants.CreateSysAnalysisCmd_capabilities_pkg_name);
            } else if (architecture instanceof LogicalArchitecture) {
                pkg = LaFactory.eINSTANCE.createCapabilityRealizationPkg(NamingConstants.CreateCommonCmd_capability_realisation_pkg_name);
            } else if (architecture instanceof PhysicalArchitecture) {
                pkg = LaFactory.eINSTANCE.createCapabilityRealizationPkg(NamingConstants.CreateCommonCmd_capability_realisation_pkg_name);
            } else if (architecture instanceof EPBSArchitecture) {
                pkg = LaFactory.eINSTANCE.createCapabilityRealizationPkg(NamingConstants.CreateCommonCmd_capability_realisation_pkg_name);
            }
            architecture.setOwnedAbstractCapabilityPkg((AbstractCapabilityPkg)pkg);
        }
        return architecture.getOwnedAbstractCapabilityPkg();
    }

    public static boolean isDefaultNameAbstractCapabilityPkg(AbstractNamedElement pkg) {
        return NamingConstants.CreateOpAnalysisCmd_operationalCapabilities_pkg_name.equals(pkg.getName()) || NamingConstants.CreateSysAnalysisCmd_capabilities_pkg_name.equals(pkg.getName()) || NamingConstants.CreateCommonCmd_capability_realisation_pkg_name.equals(pkg.getName());
    }

    public static InterfacePkg getInterfacePkg(BlockArchitecture architecture) {
        return BlockArchitectureExt.getInterfacePkg(architecture, true);
    }

    public static boolean isDefaultNameInterfacePkg(AbstractNamedElement pkg) {
        return NamingConstants.CreateCommonCmd_interfaces_pkg_name.equals(pkg.getName());
    }

    public static InterfacePkg getInterfacePkg(BlockArchitecture architecture, boolean create) {
        if (architecture.getOwnedInterfacePkg() == null && create) {
            InterfacePkg pkg = CsFactory.eINSTANCE.createInterfacePkg(NamingConstants.CreateCommonCmd_interfaces_pkg_name);
            architecture.setOwnedInterfacePkg(pkg);
        }
        return architecture.getOwnedInterfacePkg();
    }

    public static ComponentPkg getContext(BlockArchitecture architecture) {
        return BlockArchitectureExt.getContext(architecture, true);
    }

    public static ComponentPkg getContext(BlockArchitecture architecture, boolean create) {
        return BlockArchitectureExt.getComponentPkg(architecture, create);
    }

    public static FunctionPkg getFunctionPkg(BlockArchitecture architecture) {
        return BlockArchitectureExt.getFunctionPkg(architecture, true);
    }

    public static FunctionPkg getFunctionPkg(BlockArchitecture architecture, boolean create) {
        if (architecture.getOwnedFunctionPkg() == null && create) {
            OperationalActivityPkg pkg = null;
            if (architecture instanceof OperationalAnalysis) {
                pkg = OaFactory.eINSTANCE.createOperationalActivityPkg(NamingConstants.CreateOpAnalysisCmd_operationalActivities_pkg_name);
            } else if (architecture instanceof SystemAnalysis) {
                pkg = CtxFactory.eINSTANCE.createSystemFunctionPkg(NamingConstants.CreateSysAnalysisCmd_system_functions_pkg_name);
            } else if (architecture instanceof LogicalArchitecture) {
                pkg = LaFactory.eINSTANCE.createLogicalFunctionPkg(NamingConstants.CreateLogicalArchCmd_logicalFunctions_pkg_name);
            } else if (architecture instanceof PhysicalArchitecture) {
                pkg = PaFactory.eINSTANCE.createPhysicalFunctionPkg(NamingConstants.CreatePhysicalArchCmd_physicalFunctions_pkg_name);
            }
            architecture.setOwnedFunctionPkg((FunctionPkg)pkg);
        }
        return architecture.getOwnedFunctionPkg();
    }

    public static boolean isDefaultNameFunctionPkg(AbstractNamedElement pkg) {
        return NamingConstants.CreateOpAnalysisCmd_operationalActivities_pkg_name.equals(pkg.getName()) || NamingConstants.CreateSysAnalysisCmd_system_functions_pkg_name.equals(pkg.getName()) || NamingConstants.CreateLogicalArchCmd_logicalFunctions_pkg_name.equals(pkg.getName()) || NamingConstants.CreatePhysicalArchCmd_physicalFunctions_pkg_name.equals(pkg.getName());
    }

    public static AbstractFunction getRootFunction(BlockArchitecture architecture) {
        return BlockArchitectureExt.getRootFunction(architecture, true);
    }

    public static AbstractFunction getRootFunction(BlockArchitecture architecture, boolean create) {
        AbstractFunction function = null;
        if (architecture != null) {
            FunctionPkg pkg = BlockArchitectureExt.getFunctionPkg(architecture, create);
            if (pkg == null) {
                return function;
            }
            if (architecture instanceof OperationalAnalysis) {
                OperationalActivityPkg spkg = (OperationalActivityPkg)pkg;
                if (!spkg.getOwnedOperationalActivities().isEmpty()) {
                    function = (AbstractFunction)spkg.getOwnedOperationalActivities().get(0);
                } else if (create) {
                    function = OaFactory.eINSTANCE.createOperationalActivity(NamingConstants.CreateOpAnalysisCmd_operationalActivity_root_name);
                    spkg.getOwnedOperationalActivities().add((Object)((OperationalActivity)function));
                }
            } else if (architecture instanceof SystemAnalysis) {
                SystemFunctionPkg spkg = (SystemFunctionPkg)pkg;
                if (!spkg.getOwnedSystemFunctions().isEmpty()) {
                    function = (AbstractFunction)spkg.getOwnedSystemFunctions().get(0);
                } else if (create) {
                    function = CtxFactory.eINSTANCE.createSystemFunction(NamingConstants.CreateSysAnalysisCmd_system_function_root_name);
                    spkg.getOwnedSystemFunctions().add((Object)((SystemFunction)function));
                }
            } else if (architecture instanceof LogicalArchitecture) {
                LogicalFunctionPkg spkg = (LogicalFunctionPkg)pkg;
                if (!spkg.getOwnedLogicalFunctions().isEmpty()) {
                    function = (AbstractFunction)spkg.getOwnedLogicalFunctions().get(0);
                } else if (create) {
                    function = LaFactory.eINSTANCE.createLogicalFunction(NamingConstants.CreateLogicalArchCmd_logicalFunction_root_name);
                    spkg.getOwnedLogicalFunctions().add((Object)((LogicalFunction)function));
                }
            } else if (architecture instanceof PhysicalArchitecture) {
                PhysicalFunctionPkg spkg = (PhysicalFunctionPkg)pkg;
                if (!spkg.getOwnedPhysicalFunctions().isEmpty()) {
                    function = (AbstractFunction)spkg.getOwnedPhysicalFunctions().get(0);
                } else if (create) {
                    function = PaFactory.eINSTANCE.createPhysicalFunction(NamingConstants.CreatePhysicalArchCmd_physicalFunction_root_name);
                    spkg.getOwnedPhysicalFunctions().add((Object)((PhysicalFunction)function));
                }
            }
        }
        return function;
    }

    public static boolean isDefaultNameRootFunction(AbstractNamedElement element) {
        return NamingConstants.CreateOpAnalysisCmd_operationalActivity_root_name.equals(element.getName()) || NamingConstants.CreateSysAnalysisCmd_system_function_root_name.equals(element.getName()) || NamingConstants.CreateLogicalArchCmd_logicalFunction_root_name.equals(element.getName()) || NamingConstants.CreatePhysicalArchCmd_physicalFunction_root_name.equals(element.getName());
    }

    @Deprecated
    public static Component getFirstComponent(BlockArchitecture architecture, boolean create) {
        Component first = null;
        if (architecture instanceof OperationalAnalysis) {
            EntityPkg entityPkg = (EntityPkg)BlockArchitectureExt.getComponentPkg(architecture, true);
            EList ownedEntities = entityPkg.getOwnedEntities();
            first = ownedEntities.stream().filter(x -> !x.isActor()).findFirst().orElse(null);
            if (first == null && create) {
                first = OaFactory.eINSTANCE.createEntity(NamingConstants.CreateOaAnalysisCmd_entity_name);
                ownedEntities.add((Object)((Entity)first));
                CapellaElementExt.creationService((EObject)first);
            }
        } else if (architecture instanceof SystemAnalysis) {
            first = ((SystemAnalysis)architecture).getSystem();
            if (first == null && create) {
                first = CtxFactory.eINSTANCE.createSystemComponent(NamingConstants.CreateSysAnalysisCmd_system_name);
                ((SystemComponentPkg)BlockArchitectureExt.getComponentPkg(architecture, true)).getOwnedSystemComponents().add((Object)((SystemComponent)first));
            }
        } else if (architecture instanceof LogicalArchitecture) {
            first = ((LogicalArchitecture)architecture).getSystem();
            if (first == null && create) {
                first = LaFactory.eINSTANCE.createLogicalComponent(NamingConstants.CreateLogicalArchCmd_logicalComponent_name);
                ((LogicalComponentPkg)BlockArchitectureExt.getComponentPkg(architecture, true)).getOwnedLogicalComponents().add((Object)((LogicalComponent)first));
            }
        } else if (architecture instanceof PhysicalArchitecture) {
            first = ((PhysicalArchitecture)architecture).getSystem();
            if (first == null && create) {
                first = PaFactory.eINSTANCE.createPhysicalComponent(NamingConstants.CreatePhysicalArchCmd_physicalComponent_name);
                ((PhysicalComponentPkg)BlockArchitectureExt.getComponentPkg(architecture, true)).getOwnedPhysicalComponents().add((Object)((PhysicalComponent)first));
            }
        } else if (architecture instanceof EPBSArchitecture && (first = ((EPBSArchitecture)architecture).getSystem()) == null && create) {
            first = EpbsFactory.eINSTANCE.createConfigurationItem(NamingConstants.CreateEPBSArchCmd_configurationItem_name);
            ((ConfigurationItemPkg)BlockArchitectureExt.getComponentPkg(architecture, true)).getOwnedConfigurationItems().add((Object)((ConfigurationItem)first));
        }
        return first;
    }

    public static boolean isDefaultNameFirstComponent(AbstractNamedElement element) {
        return NamingConstants.CreateSysAnalysisCmd_system_name.equals(element.getName()) || NamingConstants.CreateLogicalArchCmd_logicalComponent_name.equals(element.getName()) || NamingConstants.CreatePhysicalArchCmd_physicalComponent_name.equals(element.getName()) || NamingConstants.CreateEPBSArchCmd_configurationItem_name.equals(element.getName());
    }

    public static Component getOrCreateSystem(BlockArchitecture architecture) {
        return BlockArchitectureExt.getFirstComponent(architecture, true);
    }

    public static boolean isRootComponent(Component component) {
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)component);
        if (architecture != null) {
            return component.equals(architecture.getSystem());
        }
        return false;
    }

    public static void getAllStatesAndModes(BlockArchitecture blockArch, List<CapellaElement> availableElements) {
        availableElements.addAll((List)((Object)EObjectExt.getAll((EObject)blockArch, (EClass)CapellacommonPackage.Literals.STATE)));
    }

    public static List<EObject> getAllStatesAndModes(BlockArchitecture blockArch) {
        ArrayList<EObject> availableElements = new ArrayList<EObject>();
        availableElements.addAll(EObjectExt.getAll((EObject)blockArch, (EClass)CapellacommonPackage.Literals.STATE));
        return availableElements;
    }

    public static Collection<Component> getAllComponents(BlockArchitecture blockArch) {
        ArrayList<Component> result = new ArrayList<Component>();
        if (blockArch != null) {
            for (EObject cp : EObjectExt.getAll((EObject)blockArch, (EClass)CsPackage.Literals.COMPONENT)) {
                result.add((Component)cp);
            }
        }
        return result;
    }

    public static List<Component> getFirstComponents(BlockArchitecture architecture) {
        return ComponentPkgExt.getSubDefinedComponents(BlockArchitectureExt.getComponentPkg(architecture, false));
    }

    public static BlockArchitecture getPreviousBlockArchitecture(BlockArchitecture anArchitecture) {
        ArrayList<BlockArchitecture> architectureList = new ArrayList<BlockArchitecture>();
        BlockArchitecture result = null;
        if (anArchitecture != null) {
            architectureList.addAll(BlockArchitectureExt.getPreviousBlockArchitectureByFunctinoalWay(anArchitecture));
            if (architectureList.isEmpty()) {
                architectureList.addAll(BlockArchitectureExt.getPreviousBlockArchitectureByClassicWay(anArchitecture));
            }
            if (!architectureList.isEmpty()) {
                result = (BlockArchitecture)architectureList.get(0);
            }
        }
        return result;
    }

    private static List<BlockArchitecture> getPreviousBlockArchitectureByFunctinoalWay(BlockArchitecture anArchitecture) {
        ArrayList<BlockArchitecture> result;
        block5: {
            block7: {
                block6: {
                    block4: {
                        result = new ArrayList<BlockArchitecture>();
                        if (!(anArchitecture instanceof SystemAnalysis)) break block4;
                        SystemAnalysis sa = (SystemAnalysis)anArchitecture;
                        EList allocatedOperationalAnalysisRealizations = sa.getAllocatedOperationalAnalysisRealizations();
                        for (OperationalAnalysisRealization oaRealization : allocatedOperationalAnalysisRealizations) {
                            BlockArchitectureExt.addAllocatedArchitecture(result, (ArchitectureAllocation)oaRealization);
                        }
                        break block5;
                    }
                    if (!(anArchitecture instanceof LogicalArchitecture)) break block6;
                    LogicalArchitecture la = (LogicalArchitecture)anArchitecture;
                    EList saRealizations = la.getAllocatedSystemAnalysisRealizations();
                    for (SystemAnalysisRealization saRealization : saRealizations) {
                        BlockArchitectureExt.addAllocatedArchitecture(result, (ArchitectureAllocation)saRealization);
                    }
                    break block5;
                }
                if (!(anArchitecture instanceof PhysicalArchitecture)) break block7;
                PhysicalArchitecture pa = (PhysicalArchitecture)anArchitecture;
                EList laRealizations = pa.getAllocatedLogicalArchitectureRealizations();
                for (LogicalArchitectureRealization laRealization : laRealizations) {
                    BlockArchitectureExt.addAllocatedArchitecture(result, (ArchitectureAllocation)laRealization);
                }
                break block5;
            }
            if (!(anArchitecture instanceof EPBSArchitecture)) break block5;
            EPBSArchitecture pa = (EPBSArchitecture)anArchitecture;
            EList paRealizations = pa.getAllocatedPhysicalArchitectureRealizations();
            for (PhysicalArchitectureRealization paRealization : paRealizations) {
                BlockArchitectureExt.addAllocatedArchitecture(result, (ArchitectureAllocation)paRealization);
            }
        }
        return result;
    }

    private static void addAllocatedArchitecture(List<BlockArchitecture> returnedList, ArchitectureAllocation archAllocation) {
        BlockArchitecture allocatedArch = archAllocation.getAllocatedArchitecture();
        if (allocatedArch != null) {
            returnedList.add(allocatedArch);
        }
    }

    private static List<BlockArchitecture> getPreviousBlockArchitectureByClassicWay(BlockArchitecture anArchitecture) {
        ArrayList<BlockArchitecture> result = new ArrayList<BlockArchitecture>();
        if (anArchitecture != null) {
            PhysicalArchitecture pa;
            SystemEngineering sysEng = SystemEngineeringExt.getSystemEngineering((ExtensibleElement)anArchitecture);
            if (anArchitecture instanceof SystemAnalysis) {
                OperationalAnalysis oa = SystemEngineeringExt.getOwnedOperationalAnalysis(sysEng);
                if (oa != null) {
                    result.add((BlockArchitecture)oa);
                }
            } else if (anArchitecture instanceof LogicalArchitecture) {
                SystemAnalysis sa = SystemEngineeringExt.getOwnedSystemAnalysis(sysEng);
                if (sa != null) {
                    result.add((BlockArchitecture)sa);
                }
            } else if (anArchitecture instanceof PhysicalArchitecture) {
                LogicalArchitecture la = SystemEngineeringExt.getOwnedLogicalArchitecture(sysEng);
                if (la != null) {
                    result.add((BlockArchitecture)la);
                }
            } else if (anArchitecture instanceof EPBSArchitecture && (pa = SystemEngineeringExt.getOwnedPhysicalArchitecture(sysEng)) != null) {
                result.add((BlockArchitecture)pa);
            }
        }
        return result;
    }

    public static List<AbstractCapability> getAllCapabilities(BlockArchitecture element) {
        ArrayList<AbstractCapability> result = new ArrayList<AbstractCapability>();
        if (element != null) {
            Set capabilities = EObjectExt.getAll((EObject)element, (EClass)InteractionPackage.Literals.ABSTRACT_CAPABILITY);
            for (EObject obj : capabilities) {
                result.add((AbstractCapability)obj);
            }
        }
        return result;
    }

    public static List<Mission> getAllMissions(SystemAnalysis element) {
        ArrayList<Mission> result = new ArrayList<Mission>();
        if (element != null) {
            Set missions = EObjectExt.getAll((EObject)element, (EClass)CtxPackage.Literals.MISSION);
            for (EObject obj : missions) {
                result.add((Mission)obj);
            }
        }
        return result;
    }

    public static List<Constraint> getAllConstraints(EObject anElement) {
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        if (anElement == null) {
            return result;
        }
        for (EObject obj : EObjectExt.getAll((EObject)anElement, (EClass)CapellacorePackage.Literals.CONSTRAINT)) {
            if (!(obj instanceof Constraint)) continue;
            result.add((Constraint)obj);
        }
        return result;
    }

    public static List<Interface> getAllInterfaces(BlockArchitecture anElement) {
        ArrayList<Interface> result = new ArrayList<Interface>();
        if (anElement == null) {
            return result;
        }
        for (EObject obj : EObjectExt.getAll((EObject)anElement, (EClass)CsPackage.Literals.INTERFACE)) {
            if (!(obj instanceof Interface)) continue;
            result.add((Interface)obj);
        }
        return result;
    }

    public static Collection<Component> getRootComponents(BlockArchitecture element) {
        ConfigurationItemPkg ownedConfigurationItemPkg;
        if (element instanceof OperationalAnalysis) {
            EntityPkg ownedEntityPkg = ((OperationalAnalysis)element).getOwnedEntityPkg();
            if (ownedEntityPkg != null && !ownedEntityPkg.getOwnedEntities().isEmpty()) {
                return ownedEntityPkg.getOwnedEntities().stream().filter(x -> !x.isActor()).collect(Collectors.toSet());
            }
        } else if (element instanceof SystemAnalysis) {
            SystemComponentPkg ownedSystemComponentPkg = ((SystemAnalysis)element).getOwnedSystemComponentPkg();
            if (ownedSystemComponentPkg != null && !ownedSystemComponentPkg.getOwnedSystemComponents().isEmpty()) {
                return ownedSystemComponentPkg.getOwnedSystemComponents().stream().filter(x -> !x.isActor()).collect(Collectors.toSet());
            }
        } else if (element instanceof LogicalArchitecture) {
            LogicalComponentPkg ownedLogicalComponentPkg = ((LogicalArchitecture)element).getOwnedLogicalComponentPkg();
            if (ownedLogicalComponentPkg != null && !ownedLogicalComponentPkg.getOwnedLogicalComponents().isEmpty()) {
                return ownedLogicalComponentPkg.getOwnedLogicalComponents().stream().filter(x -> !x.isActor()).collect(Collectors.toSet());
            }
        } else if (element instanceof PhysicalArchitecture) {
            PhysicalComponentPkg ownedPhysicalComponentPkg = ((PhysicalArchitecture)element).getOwnedPhysicalComponentPkg();
            if (ownedPhysicalComponentPkg != null && !ownedPhysicalComponentPkg.getOwnedPhysicalComponents().isEmpty()) {
                return ownedPhysicalComponentPkg.getOwnedPhysicalComponents().stream().filter(x -> !x.isActor()).collect(Collectors.toSet());
            }
        } else if (element instanceof EPBSArchitecture && (ownedConfigurationItemPkg = ((EPBSArchitecture)element).getOwnedConfigurationItemPkg()) != null && !ownedConfigurationItemPkg.getOwnedConfigurationItems().isEmpty()) {
            return ownedConfigurationItemPkg.getOwnedConfigurationItems().stream().filter(x -> !x.isActor()).collect(Collectors.toSet());
        }
        return null;
    }

    public static enum ComponentPortType {
        IN_FLOW_PORT,
        OUT_FLOW_PORT,
        IN_OUT_FLOW_PORT,
        STANDARD_PORT,
        PHYSICAL_PORT;

    }

    public static enum ConfigurationItemType {
        COTS,
        CS,
        HW,
        INTERFACE,
        NDI,
        PRIME_ITEM,
        SYSTEM;

    }

    public static enum FunctionPortType {
        IN_FUNCTION_PORT,
        OUT_FUNCTION_PORT;

    }

    public static enum FunctionType {
        SYSTEM_FUNCTION,
        DUPLICATE,
        GATHER,
        ROUTE,
        SELECT,
        SPLIT;

    }

    public static enum LinkDirection {
        SOURCE,
        TARGET;

    }

    public static enum Type {
        OA,
        SA,
        LA,
        PA,
        EPBS;

    }
}

