/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacommon.CapabilityRealizationInvolvedElement;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalArchitecturePkg;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.InterfacePkgExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;

public class PhysicalArchitectureExt {
    public static List<CapellaElement> getAllInterfaces(BlockArchitecture blockArchitecture, PhysicalComponent currentPC, boolean usedFlag) {
        ArrayList<CapellaElement> list = new ArrayList<CapellaElement>();
        if (blockArchitecture != null) {
            list.addAll(InterfacePkgExt.getAllInterfacesFiltered(blockArchitecture.getOwnedInterfacePkg(), (Component)currentPC, usedFlag));
        }
        return list;
    }

    public static List<PhysicalLink> getAllPhysicalLinks(PhysicalArchitecture architecture) {
        ArrayList<PhysicalLink> instList = new ArrayList<PhysicalLink>();
        for (EObject obj : EObjectExt.getAll((EObject)architecture, (EClass)CsPackage.Literals.PHYSICAL_LINK)) {
            instList.add((PhysicalLink)obj);
        }
        return instList;
    }

    public static List<CapellaElement> getCapabilityRealizationUseCasesFromPhysicalLayerFiltered(SystemEngineering systemEngineering, PhysicalComponent currentPC, boolean isFilterRequired) {
        PhysicalArchitecture physicalArch2;
        ArrayList<CapellaElement> list = new ArrayList<CapellaElement>(1);
        PhysicalArchitecturePkg physicalArchPkg = SystemEngineeringExt.getOwnedPhysicalArchitecturePkg(systemEngineering);
        if (physicalArchPkg != null) {
            for (PhysicalArchitecture physicalArch2 : physicalArchPkg.getOwnedPhysicalArchitectures()) {
                if (physicalArch2 == null) continue;
                if (isFilterRequired) {
                    list.addAll(ComponentExt.getCapabilityRealizationUseCasesFiltered((CapabilityRealizationInvolvedElement)currentPC, (CapellaElement)physicalArch2));
                    continue;
                }
                list.addAll(CapellaElementExt.getAllCapabilityRealizationInvolvedWith((CapellaElement)physicalArch2));
            }
        }
        if ((physicalArch2 = SystemEngineeringExt.getOwnedPhysicalArchitecture(systemEngineering)) != null) {
            if (isFilterRequired) {
                list.addAll(ComponentExt.getCapabilityRealizationUseCasesFiltered((CapabilityRealizationInvolvedElement)currentPC, (CapellaElement)physicalArch2));
            } else {
                list.addAll(CapellaElementExt.getAllCapabilityRealizationInvolvedWith((CapellaElement)physicalArch2));
            }
        }
        return list;
    }
}

