/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers.graph;

import java.util.Collection;
import java.util.stream.Collectors;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ControlNode;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementFunction;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementLink;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.fa.ReferenceHierarchyContext;
import org.polarsys.capella.core.data.fa.SequenceLink;
import org.polarsys.capella.core.data.fa.SequenceLinkEnd;
import org.polarsys.capella.core.model.helpers.FunctionalChainExt;
import org.polarsys.capella.core.model.helpers.graph.Graph;
import org.polarsys.capella.core.model.helpers.graph.GraphEdge;
import org.polarsys.capella.core.model.helpers.graph.GraphNode;

public class InvolvementGraph
extends Graph<FunctionalChain, SequenceLinkEnd, ReferenceHierarchyContext, InvolvementNode, InvolvementEdge> {
    public InvolvementGraph(FunctionalChain chain) {
        super(chain);
        for (FunctionalChainInvolvement inv : FunctionalChainExt.getFlatInvolvements(chain)) {
            if (inv instanceof FunctionalChainInvolvementFunction) {
                this.getOrCreateNode((FunctionalChainInvolvementFunction)inv);
                continue;
            }
            if (!(inv instanceof FunctionalChainInvolvementLink)) continue;
            FunctionalChainInvolvementLink link = (FunctionalChainInvolvementLink)inv;
            InvolvementEdge info = (InvolvementEdge)this.getOrCreateEdge(link);
            info.setSource((InvolvementNode)this.getOrCreateNode(link.getSource()));
            info.setTarget((InvolvementNode)this.getOrCreateNode(link.getTarget()));
        }
        Collection edges = this.getEdges().values().stream().filter(this::isInvolvingFunction).collect(Collectors.toList());
        for (InvolvementEdge edge : edges) {
            this.mergeNodes((InvolvementNode)edge.getSource(), (InvolvementNode)edge.getTarget(), (SequenceLinkEnd)((InvolvementNode)edge.getSource()).getSemantic());
            this.removeEdge(edge);
        }
        for (ControlNode controlNode : FunctionalChainExt.getFlatControlNodes(chain)) {
            this.getOrCreateNode(controlNode);
        }
        for (SequenceLink sequenceLink : FunctionalChainExt.getFlatSequenceLinks(chain)) {
            InvolvementEdge info = (InvolvementEdge)this.getOrCreateEdge(sequenceLink);
            info.setSource((InvolvementNode)this.getOrCreateNode(sequenceLink.getSource()));
            info.setTarget((InvolvementNode)this.getOrCreateNode(sequenceLink.getTarget()));
        }
    }

    public boolean isInvolvingFunction(InvolvementNode node) {
        SequenceLinkEnd semantic = (SequenceLinkEnd)node.getSemantic();
        return semantic instanceof FunctionalChainInvolvementFunction && ((FunctionalChainInvolvementFunction)semantic).getInvolved() instanceof AbstractFunction;
    }

    public boolean isInvolvingFunction(InvolvementEdge edge) {
        ReferenceHierarchyContext semantic = (ReferenceHierarchyContext)edge.getSemantic();
        return semantic instanceof FunctionalChainInvolvementLink && ((FunctionalChainInvolvementLink)semantic).getInvolved() instanceof AbstractFunction;
    }

    public boolean isControlNode(InvolvementNode node) {
        return node.getSemantic() instanceof ControlNode;
    }

    public boolean isInvolvingFunctionalExchange(InvolvementEdge edge) {
        ReferenceHierarchyContext semantic = (ReferenceHierarchyContext)edge.getSemantic();
        return semantic instanceof FunctionalChainInvolvementLink && ((FunctionalChainInvolvementLink)semantic).getInvolved() instanceof FunctionalExchange;
    }

    public boolean isSequenceLink(InvolvementEdge edge) {
        return edge.getSemantic() instanceof SequenceLink;
    }

    public boolean isStartingFunction(InvolvementNode node) {
        return node.getIncomingEdges().stream().allMatch(this::isSequenceLink);
    }

    public boolean isEndingFunction(InvolvementNode node) {
        return node.getOutgoingEdges().stream().allMatch(this::isSequenceLink);
    }

    public ControlNode getControlNode(InvolvementNode node) {
        return (ControlNode)node.getSemantic();
    }

    public AbstractFunction getInvolvedFunction(InvolvementNode node) {
        SequenceLinkEnd semantic = (SequenceLinkEnd)node.getSemantic();
        if (semantic instanceof FunctionalChainInvolvementFunction) {
            FunctionalChainInvolvementFunction function = (FunctionalChainInvolvementFunction)semantic;
            return (AbstractFunction)function.getInvolved();
        }
        return null;
    }

    public FunctionalExchange getInvolvedFunctionalExchange(InvolvementEdge edge) {
        ReferenceHierarchyContext semantic = (ReferenceHierarchyContext)edge.getSemantic();
        if (semantic instanceof FunctionalChainInvolvementLink) {
            FunctionalChainInvolvementLink link = (FunctionalChainInvolvementLink)semantic;
            return (FunctionalExchange)link.getInvolved();
        }
        return null;
    }

    public SequenceLink getSequenceLink(InvolvementEdge edge) {
        return (SequenceLink)edge.getSemantic();
    }

    @Override
    public InvolvementNode createNode(SequenceLinkEnd semantic) {
        return new InvolvementNode(semantic);
    }

    @Override
    public InvolvementEdge createEdge(ReferenceHierarchyContext semantic) {
        return new InvolvementEdge(semantic);
    }

    public class InvolvementEdge
    extends GraphEdge<ReferenceHierarchyContext, InvolvementNode> {
        public InvolvementEdge(ReferenceHierarchyContext semantic) {
            super(semantic);
        }
    }

    public class InvolvementNode
    extends GraphNode<SequenceLinkEnd, InvolvementEdge> {
        public InvolvementNode(SequenceLinkEnd semantic) {
            super(semantic);
        }
    }
}

