/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.polarsys.capella.core.data.capellacore.AbstractDependenciesPkg;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.Classifier;
import org.polarsys.capella.core.data.interaction.CombinedFragment;
import org.polarsys.capella.core.data.interaction.InteractionOperand;
import org.polarsys.capella.core.data.requirement.RequirementsPkg;
import org.polarsys.capella.docgen.Messages;
import org.polarsys.capella.docgen.util.CapellaLabelProviderHelper;
import org.polarsys.capella.docgen.util.DocGenHtmlCapellaControl;
import org.polarsys.capella.docgen.util.DocGenHtmlCapellaUtil;
import org.polarsys.capella.docgen.util.Logger;
import org.polarsys.kitalpha.doc.gen.business.core.scope.GenerationGlobalScope;
import org.polarsys.kitalpha.doc.gen.business.core.sirius.util.session.DiagramSessionHelper;
import org.polarsys.kitalpha.doc.gen.business.core.util.DocGenHtmlUtil;
import org.polarsys.kitalpha.doc.gen.business.core.util.EscapeChars;

public class CapellaServices {
    public static final String BOLD_BEGIN = "<b>";
    public static final String BOLD_END = "</b>";
    public static final String ITALIC_BEGIN = "<i>";
    public static final String ITALIC_END = "</i>";
    public static final String SPAN_BEGIN_LABEL = "<span class=\"label\">";
    public static final String SPAN_END = "</span>";
    public static final String NEW_LINE = "<br/>";
    public static final String LI_OPEN = "<li>";
    public static final String LI_CLOSE = "</li>";
    public static final String UL_OPEN = "<ul class=\"generatedList\">";
    public static final String UL_OPEN_WITH_BORDER = "<ul class=\"generatedListWithBorder\">";
    public static final String UL_OPEN_SIMPLE = "<ul>";
    public static final String UL_CLOSE = "</ul>";
    public static final String TD_OPEN = "<td>";
    public static final String TD_CLOSE = "</td>";
    public static final String TD_STYLE_MAX_WIDTH_100_BORDER_0PX = "<td style=\"max-width:100%; border:0px\">";
    public static final String TR_OPEN = "<tr>";
    public static final String TR_CLOSE = "</tr>";
    public static final String NONE = "None";
    public static final String NO_NAME = "<i>[No Name]</i>";
    public static final String SPACE = " ";
    public static final String EMPTY = "";
    public static final String VALUE_PRESENTER = " : ";
    public static final String VALUE_EQUAL = " = ";
    public static final String IS_ABSTRACT = "Is Abstract\t:\t";
    public static final String IS_PRIMITIVE = "Is Primitive\t:\t";
    public static final String IS_DISCRETE = "Is Discrete\t:\t";
    public static final String IS_HUMAN = "Is Human\t:\t";
    public static final String IS_ACTOR = "Is Actor\t:\t";
    public static final String PATTERN = "Pattern\t:\t";
    public static final String DEFAULT_FEATURE = "Default\t:\t";
    public static final String MIN_FEATURE = "Min\t:\t";
    public static final String MAX_FEATURE = "Max\t:\t";
    public static final String NULL_FEATURE = "Null\t:\t";
    public static final String MINLENGTH_FEATURE = "Min. length\t:\t";
    public static final String MAXLENGTH_FEATURE = "Max. length\t:\t";
    public static final String PROP_ABSTRACT = "abstract  ";
    public static final String PROP_STATIC = "static  ";
    public static final String PROP_KEY = "key  ";
    public static final String PROP_DERIVED = "derived  ";
    public static final String PROP_READONLY = "readonly  ";
    public static final String PROP_ORDERED = "ordered  ";
    public static final String PROP_UNIQUE = "unique  ";
    public static final String PROP_GENERATED = "generated  ";
    public static final String PROP_CHANGEABLE = "changeable  ";
    public static final String PROP_CRO_ABSTRACT = "{abstract}  ";
    public static final String PROP_CRO_STATIC = "{static}  ";
    public static final String PROP_CRO_KEY = "{key}  ";
    public static final String PROP_CRO_DERIVED = "{derived}  ";
    public static final String PROP_CRO_READONLY = "{readonly}  ";
    public static final String PROP_CRO_ORDERED = "{ordered}  ";
    public static final String PROP_CRO_UNIQUE = "{unique}  ";
    public static final String PROP_CRO_GENERATED = "{generated}  ";
    public static final String PROP_CRO_CHANGEABLE = "{changeable}  ";
    public static final String MIN = "MIN  ";
    public static final String MAX = "MAX  ";
    public static final String DEFAULT = "DEFAULT  ";
    public static final String NULL = "NULL  ";
    public static final String UNDEFINED = "undefined";
    public static final String UNDEFINED_CHEVRON = "&lt;undefined&gt;";
    public static final String PAR_OPEN = "(  ";
    public static final String PAR_CLOSE = " )";
    public static final String CRO_OPEN = "[";
    public static final String CRO_CLOSE = "]";
    public static final String COMMA = ", ";
    public static final String CHEV_OPEN = "&lt";
    public static final String CHEV_CLOSE = "&gt";
    protected static final String HYPERLINK_OPEN = "<a href=\"";
    protected static final String HYPERLINK_SEPARATOR = "/";
    protected static final String HYPERLINK_COMPLETE = "\">";
    protected static final String HYPERLINK_CLOSE = "</a>";
    private static final Object PATH_OPEN = "../";
    private static final Object PATH_COMPLETE = ".html";

    private CapellaServices() {
    }

    public static String getHyperlinkFromElement(EObject element, String label) {
        if (element instanceof DSemanticDiagram) {
            return CapellaServices.getHyperlinkFromDiagram((DSemanticDiagram)element);
        }
        int linked = CapellaServices.isLinkable(element);
        String text = label;
        text = EscapeChars.forHTML((String)text);
        StringBuilder stringBuilder = new StringBuilder();
        if (linked != -1) {
            stringBuilder.append(HYPERLINK_OPEN);
            if (linked == 1) {
                stringBuilder.append(CapellaServices.getPathFromElement(element.eContainer()));
                stringBuilder.append("#");
                stringBuilder.append(CapellaServices.getAnchorId(element));
            } else {
                stringBuilder.append(CapellaServices.getPathFromElement(element));
            }
            stringBuilder.append(HYPERLINK_COMPLETE);
        }
        stringBuilder.append(text);
        if (linked != -1) {
            stringBuilder.append(HYPERLINK_CLOSE);
        }
        return stringBuilder.toString();
    }

    public static String getIndexHyperlinkFromElement(EObject element, String label) {
        int linked = CapellaServices.isLinkable(element);
        String text = label;
        text = EscapeChars.forHTML((String)text);
        StringBuilder stringBuilder = new StringBuilder();
        if (linked != -1) {
            stringBuilder.append(HYPERLINK_OPEN);
            if (linked == 1) {
                stringBuilder.append(CapellaServices.getIndexPathFromElement(element.eContainer()));
                stringBuilder.append("#");
                stringBuilder.append(CapellaServices.getAnchorId(element));
            } else {
                stringBuilder.append(CapellaServices.getIndexPathFromElement(element));
            }
            stringBuilder.append(HYPERLINK_COMPLETE);
        }
        stringBuilder.append(text);
        if (linked != -1) {
            stringBuilder.append(HYPERLINK_CLOSE);
        }
        return stringBuilder.toString();
    }

    public static String getHyperlinkFromElement(EObject element) {
        return CapellaServices.getHyperlinkFromElement(element, CapellaLabelProviderHelper.getText((EObject)element));
    }

    public static String getIndexHyperlinkFromElement(EObject element) {
        return CapellaServices.getIndexHyperlinkFromElement(element, CapellaLabelProviderHelper.getText((EObject)element));
    }

    public static boolean isElementLinkable(EObject element) {
        return CapellaServices.isLinkable(element) >= 0;
    }

    public static int isLinkable(EObject element) {
        EObject parent;
        if (!GenerationGlobalScope.getInstance().inScope(element, true) || !(element instanceof CapellaElement)) {
            return -1;
        }
        if (DocGenHtmlCapellaControl.isPageCandidate((CapellaElement)element)) {
            return 0;
        }
        if (!DocGenHtmlCapellaControl.isPageOptional((CapellaElement)element) && (parent = element.eContainer()) instanceof CapellaElement && DocGenHtmlCapellaControl.isPageCandidate((CapellaElement)parent)) {
            return 1;
        }
        return -1;
    }

    public static int isLinkableWithoutScope(EObject element) {
        EObject parent;
        if (element instanceof CombinedFragment || element instanceof InteractionOperand || !(element instanceof CapellaElement)) {
            return -1;
        }
        if (DocGenHtmlCapellaControl.isPageCandidate((CapellaElement)element)) {
            return 0;
        }
        if (!DocGenHtmlCapellaControl.isPageOptional((CapellaElement)element) && (parent = element.eContainer()) instanceof CapellaElement && DocGenHtmlCapellaControl.isPageCandidate((CapellaElement)parent)) {
            return 1;
        }
        return -1;
    }

    public static String getPathFromElement(EObject element) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(PATH_OPEN);
        stringBuilder.append(DocGenHtmlUtil.getModelName((EObject)element));
        stringBuilder.append(HYPERLINK_SEPARATOR);
        stringBuilder.append(DocGenHtmlCapellaUtil.SERVICE.getFileName(element));
        stringBuilder.append(PATH_COMPLETE);
        return stringBuilder.toString();
    }

    public static String getIndexPathFromElement(EObject element) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(PATH_OPEN).append(PATH_OPEN);
        stringBuilder.append(DocGenHtmlUtil.getModelName((EObject)element));
        stringBuilder.append(HYPERLINK_SEPARATOR);
        stringBuilder.append(DocGenHtmlCapellaUtil.SERVICE.getFileName(element));
        stringBuilder.append(PATH_COMPLETE);
        return stringBuilder.toString();
    }

    private static String getHyperlinkFromDiagram(DSemanticDiagram diagram) {
        String text = CapellaLabelProviderHelper.getText((EObject)diagram);
        text = EscapeChars.forHTML((String)text);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(HYPERLINK_OPEN);
        stringBuilder.append(CapellaServices.getPathFromElement(CapellaServices.getRepresentationTarget((DRepresentation)diagram)));
        stringBuilder.append("#");
        stringBuilder.append(CapellaServices.getDiagramUid(diagram));
        stringBuilder.append(HYPERLINK_COMPLETE);
        stringBuilder.append(text);
        stringBuilder.append(HYPERLINK_CLOSE);
        return stringBuilder.toString();
    }

    public static String getAnchorId(EObject element) {
        return "id" + EcoreUtil.getURI((EObject)element).fragment();
    }

    @Deprecated
    public static String getDiagramId(DSemanticDiagram diagram) {
        return CapellaServices.getDiagramUid(diagram);
    }

    public static String getDiagramUid(DSemanticDiagram diagram) {
        return diagram.getUid();
    }

    public static String getImageLinkFromElement(EObject element, String projectName, String outputFolder) {
        String imageFileName = CapellaLabelProviderHelper.getImageFileName((EObject)element, (String)projectName, (String)outputFolder);
        StringBuilder stringBuilder = new StringBuilder();
        return CapellaServices.appendRelativePath(element, imageFileName, stringBuilder, "../icon/");
    }

    public static String getIndexImageLinkFromElement(EObject element, String projectName, String outputFolder) {
        String imageFileName = CapellaLabelProviderHelper.getImageFileName((EObject)element, (String)projectName, (String)outputFolder);
        StringBuilder stringBuilder = new StringBuilder();
        return CapellaServices.appendRelativePath(element, imageFileName, stringBuilder, "../../icon/");
    }

    private static String appendRelativePath(EObject element, String imageFileName, StringBuilder stringBuilder, String relativePath) {
        stringBuilder.append("<img src=\"");
        stringBuilder.append(relativePath);
        stringBuilder.append(imageFileName);
        stringBuilder.append("\" alt=\"");
        stringBuilder.append(element.eClass().getName());
        stringBuilder.append("\" />");
        return stringBuilder.toString();
    }

    public static String getImageLinkForDiagram(String generatedFolder, DSemanticDiagram diagram) {
        StringBuilder stringBuilder = new StringBuilder();
        String fileName = DocGenHtmlCapellaUtil.getCapellaElementFileName((CapellaElement)diagram.getTarget());
        stringBuilder.append(HYPERLINK_OPEN);
        stringBuilder.append(fileName);
        stringBuilder.append("#");
        stringBuilder.append(DiagramSessionHelper.getID((EObject)diagram));
        stringBuilder.append(HYPERLINK_COMPLETE);
        stringBuilder.append("<img src=\"");
        stringBuilder.append(generatedFolder);
        stringBuilder.append(HYPERLINK_SEPARATOR);
        String validFileName = DocGenHtmlUtil.getValidFileName((String)DiagramSessionHelper.getID((EObject)diagram));
        stringBuilder.append(validFileName);
        stringBuilder.append(".jpg\" alt=\"").append(validFileName).append("\"/>");
        stringBuilder.append(HYPERLINK_CLOSE);
        return stringBuilder.toString();
    }

    public static String getFullDataPkgHierarchyLink(EObject elt) {
        return CapellaServices.getFullDataPkgHierarchyLink(elt, true);
    }

    public static String getFullDataPkgHierarchyLink(EObject elt, boolean linkedLastElement) {
        StringBuilder stringBuilder = new StringBuilder();
        for (EObject pkg : CapellaServices.getPackageElementPath(elt)) {
            stringBuilder.append(CapellaServices.getHyperlinkFromElement(pkg));
            stringBuilder.append(".");
        }
        if (linkedLastElement) {
            stringBuilder.append(CapellaServices.getHyperlinkFromElement(elt));
        } else {
            stringBuilder.append(CapellaLabelProviderHelper.getText((EObject)elt));
        }
        return stringBuilder.toString();
    }

    public static String getElementPath(EObject element) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<EObject> iterator = CapellaServices.getFullElementPath(element).iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(CapellaServices.getHyperlinkFromElement(iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(" > ");
        }
        return stringBuilder.toString();
    }

    private static List<EObject> getFullElementPath(EObject element) {
        ArrayList<EObject> eObjects = new ArrayList<EObject>();
        EObject parent = element.eContainer();
        if (parent instanceof EObject) {
            eObjects.addAll(CapellaServices.getFullElementPath(parent));
        }
        eObjects.add(element);
        return eObjects;
    }

    private static List<EObject> getPackageElementPath(EObject element) {
        EObject parent = element.eContainer();
        if (parent instanceof AbstractDependenciesPkg || parent instanceof Classifier) {
            return CapellaServices.getPkgTree(parent);
        }
        return Collections.emptyList();
    }

    private static List<EObject> getPkgTree(EObject pkg) {
        ArrayList<EObject> pkgs = new ArrayList<EObject>();
        pkgs.add(pkg);
        EObject parent = pkg.eContainer();
        if (parent instanceof AbstractDependenciesPkg) {
            pkgs.addAll(0, CapellaServices.getPkgTree(parent));
        }
        return pkgs;
    }

    public static List<EObject> removeDuplicates(List<EObject> list) {
        HashSet<EObject> set = new HashSet<EObject>(list);
        list.clear();
        list.addAll(set);
        return list;
    }

    public static String buildHyperlinkWithIcon(String projectName, String outputFolder, EObject object) {
        StringBuilder hyperLinkStringBuilder = new StringBuilder();
        hyperLinkStringBuilder.append(CapellaServices.getImageLinkFromElement(object, projectName, outputFolder));
        hyperLinkStringBuilder.append(SPACE);
        hyperLinkStringBuilder.append(CapellaServices.getHyperlinkFromElement(object));
        return hyperLinkStringBuilder.toString();
    }

    public static String buildNameWithIcon(String projectName, String outputFolder, CapellaElement object) {
        StringBuilder hyperLinkStringBuilder = new StringBuilder();
        hyperLinkStringBuilder.append(CapellaServices.getImageLinkFromElement((EObject)object, projectName, outputFolder));
        hyperLinkStringBuilder.append(SPACE);
        hyperLinkStringBuilder.append(object.getLabel());
        return hyperLinkStringBuilder.toString();
    }

    public static String getRequirementPathHyperLinkWithIcon(String projectName, String outputFolder, EObject element) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<EObject> iterator = CapellaServices.getFullRequirementPath(element).iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(CapellaLabelProviderHelper.getText((EObject)iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(" > ");
        }
        StringBuilder hyperLinkStringBuilder = new StringBuilder();
        hyperLinkStringBuilder.append(CapellaServices.getImageLinkFromElement(element, projectName, outputFolder));
        hyperLinkStringBuilder.append(SPACE);
        hyperLinkStringBuilder.append(CapellaServices.getHyperlinkFromElement(element, stringBuilder.toString()));
        return hyperLinkStringBuilder.toString();
    }

    public static String getRequirementPath(EObject element) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<EObject> iterator = CapellaServices.getFullRequirementPath(element).iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(CapellaLabelProviderHelper.getText((EObject)iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(" > ");
        }
        return stringBuilder.toString();
    }

    private static List<EObject> getFullRequirementPath(EObject element) {
        ArrayList<EObject> eObjects = new ArrayList<EObject>();
        EObject parent = element.eContainer();
        if (parent instanceof RequirementsPkg) {
            eObjects.addAll(CapellaServices.getFullRequirementPath(parent));
        }
        eObjects.add(element);
        return eObjects;
    }

    public static EObject getRepresentationTarget(DRepresentation representation) {
        Session session;
        Optional<DRepresentationDescriptor> optDesc;
        EObject target = ((DSemanticDiagram)representation).getTarget();
        if (target == null && (optDesc = DialectManager.INSTANCE.getAllRepresentationDescriptors(session = SessionManager.INSTANCE.getSession((EObject)representation)).stream().filter(repDesc -> repDesc.getRepresentation().equals(representation)).findFirst()).isPresent()) {
            target = optDesc.get().getTarget();
        }
        if (target == null) {
            Logger.logWarning(NLS.bind((String)Messages.docgenDiagramTargetNull, (Object)representation), null);
        }
        return target;
    }
}

