/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.common;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.polarsys.capella.core.model.handler.helpers.HoldingResourceHelper;
import org.polarsys.capella.core.projection.common.ITransform;
import org.polarsys.capella.core.projection.common.ProjectionEngine;
import org.polarsys.capella.core.projection.common.ProjectionRuleBase;
import org.polarsys.capella.core.tiger.ITransfo;
import org.polarsys.capella.core.tiger.ITransfoEngine;
import org.polarsys.capella.core.tiger.ITransfoRuleBase;
import org.polarsys.capella.core.tiger.TransfoException;

public abstract class AbstractTransform
implements ITransform {
    public static final String START_ELEMENT_TRANSFORMATION = "startElementTransormation";
    protected List<EObject> _context = new ArrayList<EObject>(0);

    @Override
    public void execute() {
        try {
            ITransfoRuleBase ruleBase = this.createTransfoRuleBase();
            ITransfoEngine engine = this.createTransfoEngine();
            ITransfo transfo = this.createTransfo(ruleBase);
            for (EObject contextElement : this._context) {
                if (!this.retainContextElement(contextElement, transfo)) continue;
                this.doExecuteTransformation(contextElement, engine, transfo);
            }
        }
        catch (OperationCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    protected abstract boolean retainContextElement(EObject var1, ITransfo var2);

    protected void doExecuteTransformation(EObject modelElement_p, ITransfoEngine engine_p, ITransfo transfo_p) throws TransfoException {
        try {
            engine_p.execute(transfo_p);
        }
        finally {
            HoldingResourceHelper.flushHoldingResource((TransactionalEditingDomain)TransactionUtil.getEditingDomain((EObject)modelElement_p));
        }
    }

    protected abstract ITransfo createTransfo(ITransfoRuleBase var1) throws Exception;

    protected ITransfoEngine createTransfoEngine() {
        return new ProjectionEngine();
    }

    protected ITransfoRuleBase createTransfoRuleBase() {
        return new ProjectionRuleBase();
    }
}

