/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.semantic.browser.sirius.handlers;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.ui.IWorkbenchPart;
import org.polarsys.capella.common.ui.toolkit.browser.content.provider.wrapper.EObjectWrapper;
import org.polarsys.capella.core.commands.preferences.ui.sirius.DoubleClickBehaviourUtil;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.OpenRelatedDiagramAction;
import org.polarsys.capella.core.ui.semantic.browser.handler.DefaultSemanticBrowserDoubleClickHandler;
import org.polarsys.capella.core.ui.semantic.browser.sirius.actions.DiagramOpenAction;
import org.polarsys.capella.core.ui.semantic.browser.view.SemanticBrowserView;

public class NavigationSemanticBrowserDoubleClickHandler
extends DefaultSemanticBrowserDoubleClickHandler {
    public void handle(SemanticBrowserView view, DoubleClickEvent event, Object selectedElement) {
        IStructuredSelection selection = (IStructuredSelection)view.getSite().getSelectionProvider().getSelection();
        if (!selection.isEmpty()) {
            if (selection.size() == 1) {
                if (this.isCtrlKeyPressed()) {
                    super.handle(view, event, selectedElement);
                } else {
                    this.runAction(view, event, selectedElement);
                }
            } else {
                for (Object element : selection.toList()) {
                    this.runAction(view, event, element);
                }
            }
        }
    }

    protected void runAction(SemanticBrowserView view, DoubleClickEvent event, Object selectedElement) {
        if (selectedElement instanceof EObjectWrapper) {
            selectedElement = ((EObjectWrapper)selectedElement).getElement();
        }
        if (!(selectedElement instanceof EObject)) {
            return;
        }
        EObject elementAsEObject = (EObject)selectedElement;
        if (this.shouldOpenDiagram(elementAsEObject)) {
            this.openDiagram(view, (DRepresentationDescriptor)elementAsEObject);
        } else if (this.shouldNavigate(elementAsEObject)) {
            this.openRelatedDiagrams(elementAsEObject);
        } else {
            super.runAction(view, event, (Object)elementAsEObject);
        }
    }

    public boolean shouldNavigate(EObject selectedElement) {
        return DoubleClickBehaviourUtil.INSTANCE.shouldOpenRelatedDiagramsOnDoubleClick(selectedElement);
    }

    public boolean shouldOpenPropertyWizard(EObject selectedElement) {
        if (this.shouldOpenDiagram(selectedElement)) {
            return false;
        }
        return !this.shouldNavigate(selectedElement);
    }

    public boolean shouldOpenDiagram(EObject selectedElement) {
        return selectedElement instanceof DRepresentationDescriptor;
    }

    protected void openDiagram(SemanticBrowserView view, DRepresentationDescriptor diagramToOpen) {
        DiagramOpenAction action = new DiagramOpenAction();
        action.init((IWorkbenchPart)view);
        action.selectionChanged(null, (ISelection)new StructuredSelection((Object)diagramToOpen));
        action.run(null);
    }

    protected void openRelatedDiagrams(EObject selectedElement) {
        OpenRelatedDiagramAction action = new OpenRelatedDiagramAction(selectedElement);
        action.run();
    }
}

