/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.ui.quickfix.generator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.ui.IMarkerResolution;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewHelper;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeKind;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.OrientationPortKind;
import org.polarsys.capella.core.data.fa.ui.quickfix.resolver.command.InvertComponentExchangeDirection;
import org.polarsys.capella.core.data.fa.ui.quickfix.resolver.command.InvertComponentExchangePortOrientations;
import org.polarsys.capella.core.data.fa.ui.quickfix.resolver.command.SetComponentPortOrientation;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.validation.ui.ide.quickfix.AbstractMarkerResolutionGenerator;
import org.polarsys.capella.core.validation.ui.ide.quickfix.CommandMarkerResolution;

public class ComponentPortOrientationResolutions
extends AbstractMarkerResolutionGenerator {
    protected IMarkerResolution[] doGetResolutions(IMarker marker) {
        List<Object> resolutions = Collections.emptyList();
        List objects = MarkerViewHelper.getModelElementsFromMarker((IMarker)marker);
        if (objects.size() > 0 && objects.get(0) instanceof ComponentExchange) {
            ComponentExchange exchange = (ComponentExchange)objects.get(0);
            ComponentPort sourceCompPort = null;
            ComponentPort targetCompPort = null;
            Port sourcePort = exchange.getSourcePort();
            Port targetPort = exchange.getTargetPort();
            if (sourcePort instanceof ComponentPort) {
                sourceCompPort = (ComponentPort)sourcePort;
            }
            if (targetPort instanceof ComponentPort) {
                targetCompPort = (ComponentPort)targetPort;
            }
            if (sourceCompPort != null && targetCompPort != null) {
                OrientationPortKind source = sourceCompPort.getOrientation();
                OrientationPortKind target = targetCompPort.getOrientation();
                if (source != null && target != null) {
                    resolutions = this.generateResolutions(exchange, sourceCompPort, targetCompPort, source, target);
                }
            }
        }
        return resolutions.toArray(new IMarkerResolution[0]);
    }

    private List<? extends IMarkerResolution> generateResolutions(ComponentExchange exchange, ComponentPort sourcePort, ComponentPort targetPort, OrientationPortKind source, OrientationPortKind target) {
        ArrayList<CommandMarkerResolution> resolutions = new ArrayList<CommandMarkerResolution>();
        ComponentExchangeKind kind = exchange.getKind();
        if (!kind.equals((Object)ComponentExchangeKind.DELEGATION)) {
            if (source == OrientationPortKind.IN && target == OrientationPortKind.OUT) {
                resolutions.add(new CommandMarkerResolution((ICommand)new InvertComponentExchangeDirection(exchange)));
                resolutions.add(new CommandMarkerResolution((ICommand)new InvertComponentExchangePortOrientations(exchange)));
            } else if (source == OrientationPortKind.IN) {
                resolutions.add(new CommandMarkerResolution((ICommand)new SetComponentPortOrientation(sourcePort, OrientationPortKind.OUT)));
                resolutions.add(new CommandMarkerResolution((ICommand)new SetComponentPortOrientation(sourcePort, OrientationPortKind.INOUT)));
                resolutions.add(new CommandMarkerResolution((ICommand)new SetComponentPortOrientation(sourcePort, OrientationPortKind.UNSET)));
            } else if (target == OrientationPortKind.OUT) {
                resolutions.add(new CommandMarkerResolution((ICommand)new SetComponentPortOrientation(targetPort, OrientationPortKind.IN)));
                resolutions.add(new CommandMarkerResolution((ICommand)new SetComponentPortOrientation(targetPort, OrientationPortKind.INOUT)));
                resolutions.add(new CommandMarkerResolution((ICommand)new SetComponentPortOrientation(targetPort, OrientationPortKind.UNSET)));
            }
        } else {
            resolutions.add(new CommandMarkerResolution((ICommand)new SetComponentPortOrientation(targetPort, source)));
            resolutions.add(new CommandMarkerResolution((ICommand)new SetComponentPortOrientation(targetPort, OrientationPortKind.INOUT)));
            resolutions.add(new CommandMarkerResolution((ICommand)new SetComponentPortOrientation(targetPort, OrientationPortKind.UNSET)));
        }
        return resolutions;
    }

    protected String getRuleId() {
        return "org.polarsys.capella.core.data.fa.validation.I_20";
    }
}

